define(["modules/app_registry",
		"jQuery",
		"Backbone",
		"modules/options/wsimple",
		"modules/options/wiconic",
		"modules/options/wspeaking",
		"modules/options/share/imgur",
		"modules/options/share/simple",
		"modules/options/share/download"],
			function(
				AppRegistry,
				$,
				Backbone,
				wSimple,
				wIconic,
				wSpeaking,
				ImgurShare,
				SimpleShare,
				DownloadShare) {
	return {
		routing : function() {
			var Router = Backbone.Router.extend({
				routes: {
					'edit-photo-page#w-simple': 'wsimple',
					'edit-photo-page#w-iconic': 'wiconic',
					'edit-photo-page#w-speaking': 'wspeaking',
					'edit-photo-page#imgur-share': 'imgurshare',
					'edit-photo-page#simple-share': 'simpleshare',
					'edit-photo-page#download-share': 'downloadshare',
					'edit-photo-page#aftereffects': 'aftereffects'
				},
				wsimple: function() {
					$("#content").html("");
					$("#slider-holder").hide();
					$("#select-mode ul > li").removeClass("ui-btn-active-override");
					$("#panel-simple").addClass("ui-btn-active-override");
					$("#edit-header > h1").text("← 1 →");
					AppRegistry.resetPatterns('simple');
					
					wSimple.render();
				},
				wiconic: function() {
					$("#content").html("");
					$("#slider-holder").hide();
					$("#select-mode ul > li").removeClass("ui-btn-active-override");
					$("#panel-iconic").addClass("ui-btn-active-override");
					$("#edit-header > h1").text("← 1 →");
					AppRegistry.resetPatterns('iconic');
					
					wIconic.render();
				},
				wspeaking: function() {
					$("#content").html("");
					$("#slider-holder").hide();
					$("#select-mode ul > li").removeClass("ui-btn-active-override");
					$("#panel-speaking").addClass("ui-btn-active-override");
					$("#edit-header > h1").text("← 1 →");
					AppRegistry.resetPatterns('speaking');
					
					wSpeaking.render();
				},
				imgurshare: function() {
					$("#slider-holder").hide();
					
					ImgurShare.share("#picked-photo");
				},
				simpleshare: function() {
					$("#slider-holder").hide();
					
					SimpleShare.share("#picked-photo");
				},
				downloadshare: function() {
					$("#slider-holder").hide();
					
					DownloadShare.share("#picked-photo");
				},
				aftereffects: function() {
					$("#slider-holder").hide();
					window.open("https://marketplace.firefox.com/app/aftereffects");
				}
			});

			var Router = new Router();
			try {
				Backbone.history.start();
			} catch(err) {
				Backbone.history.loadUrl();
			}
		
			return Router;
		}
	};
});