// Generated by CoffeeScript 1.6.3
(function() {
  App.service('Storage', [
    (function() {
      function _Class() {}

      _Class.prototype.get = function(key, json) {
        var value;
        if (json == null) {
          json = true;
        }
        value = localStorage.getItem(key);
        if (!json) {
          return value;
        } else {
          return JSON.parse(value);
        }
      };

      _Class.prototype.set = function(key, value) {
        if (typeof value === 'object') {
          value = JSON.stringify(value);
        }
        return localStorage.setItem(key, value);
      };

      _Class.prototype.remove = function(key) {
        return this.set(key, null);
      };

      return _Class;

    })()
  ]);

  App.service('City', [
    'Storage', (function() {
      function _Class(Storage) {
        this.cities = Storage.get('cities') || [];
        this.save = function() {
          return Storage.set('cities', this.cities.map(function(city) {
            delete city['$$hashKey'];
            return city;
          }));
        };
      }

      _Class.prototype.get = function(name) {
        var result;
        result = null;
        this.cities.forEach(function(city) {
          if (name === city.name) {
            return result = city;
          }
        });
        return result;
      };

      _Class.prototype.getAll = function() {
        return this.cities;
      };

      _Class.prototype.add = function(data) {
        this.cities.push(data);
        return this.save();
      };

      _Class.prototype.has = function(name) {
        return this.get(name) != null;
      };

      _Class.prototype.remove = function(name) {
        this.cities = this.cities.filter(function(city) {
          return city.name !== name;
        });
        return this.save();
      };

      _Class.prototype.touch = function(name) {
        return this.update(name, 'lastUpdate', +(new Date));
      };

      _Class.prototype.needForUpdate = function(name) {
        var city;
        city = this.get(name);
        return !city.lastUpdate || +(new Date) - city.lastUpdate > 10 * 60 * 1000;
      };

      _Class.prototype.update = function(name, key, value) {
        return this.cities = this.cities.map(function(city) {
          if (city.name === name) {
            city[key] = value;
          }
          return city;
        });
      };

      return _Class;

    })()
  ]);

  App.service('Weather', [
    'Rest', 'City', (function() {
      function _Class(Rest, City) {
        this.Rest = Rest;
        this.City = City;
      }

      _Class.prototype.get = function(name, callback) {
        var city,
          _this = this;
        if (callback == null) {
          callback = angular.noop;
        }
        city = this.City.get(name).searchQuery || name;
        if (this.City.needForUpdate(name)) {
          return this.Rest.getWeather(city, function(res) {
            _this.City.update(name, 'weather', res);
            _this.City.touch(name);
            return callback(res);
          });
        } else {
          return callback(this.City.get(name).weather);
        }
      };

      return _Class;

    })()
  ]);

  App.service('Rest', [
    '$resource', (function() {
      var defaultQuery, resourceOptions, restUrl;

      restUrl = 'http://api.worldweatheronline.com/free/v1/';

      resourceOptions = {
        get: {
          method: 'JSONP',
          params: {
            callback: 'JSON_CALLBACK'
          }
        }
      };

      defaultQuery = {
        num_of_results: 5,
        key: 'xqxeawkvwdcbrqr7qxtdhxp2',
        format: 'json',
        num_of_days: 5
      };

      function _Class($resource) {
        this.rest = {};
        this.rest.weather = $resource(restUrl + 'weather.ashx', defaultQuery, resourceOptions);
        this.rest.city = $resource(restUrl + 'search.ashx', defaultQuery, resourceOptions);
      }

      _Class.prototype.getCityByGeoLocation = function(lat, lon, callback) {
        if (callback == null) {
          callback = angular.noop;
        }
        return this.rest.city.get({
          q: "" + lat + "," + lon
        }, callback);
      };

      _Class.prototype.getCity = function(city, callback) {
        if (callback == null) {
          callback = angular.noop;
        }
        return this.rest.city.get({
          q: city
        }, callback);
      };

      _Class.prototype.getWeather = function(cityName, callback) {
        if (callback == null) {
          callback = angular.noop;
        }
        return this.rest.weather.get({
          q: cityName
        }, callback);
      };

      return _Class;

    })()
  ]);

  App.service('Options', [
    'Storage', (function() {
      function _Class(Storage) {
        this.options = Storage.get('options') || {
          temp: 'C'
        };
        this.save = function() {
          return Storage.set('options', this.options);
        };
      }

      _Class.prototype.get = function() {
        return this.options;
      };

      _Class.prototype.set = function(key, value) {
        this.options[key] = value;
        return this.save();
      };

      return _Class;

    })()
  ]);

}).call(this);
