var placeHistoryName = new Array(5);
var placHistoryLocLat = new Array(5);
$(document).ready(function()
{
	key_ID = "c474e75f85e07374";
	initialize();
	function initialize()
	{
			updateUIList();
			if(typeof(Storage)!=="undefined")
			{
				if(localStorage.getItem('myPlace'))
				{
					var myplace = JSON.parse( localStorage.getItem( 'myPlace' ) );
					myPlaceName = myplace['name'];
					myPlaceLat = myplace['lat'];
					myPLaceLong = myplace['long'];
					locationURL = "http://api.wunderground.com/api/"+key_ID+"/geolookup/conditions/q/"+myPlaceLat+","+myPLaceLong+".json";
					fetchPdata();
				}
				else
				{
					locationURL = "http://api.wunderground.com/api/"+key_ID+"/geolookup/conditions/q/autoip.json";
					fetchPdata();	
				}
		   }
		else
		  {
			locationURL = "http://api.wunderground.com/api/"+key_ID+"/geolookup/conditions/q/autoip.json";
			fetchPdata();
		  }
		
	}
function showPosition(position)
{
	console.log(position.coords.latitude,position.coords.longitude);
	locationURL = "http://api.wunderground.com/api/"+key_ID+"/geolookup/conditions/q/"+position.coords.latitude+","+position.coords.longitude+".json";
	fetchPdata();
}

$("#refresh").click(function(){
	fetchPdata(); 
	var interval = null;
	var counter = 0;
	var $this = $(this).find('img');
	clearInterval(interval);

	interval = setInterval(function(){
		if (counter != -360) {
			counter -= 2;
			$this.css({
				MozTransform: 'rotate(-' + -counter + 'deg)',
				WebkitTransform: 'rotate(' + -counter + 'deg)',
				transform: 'rotate(' + -counter + 'deg)'
			});
		}
	}, 0.5);
	});	
	
$("#trigger_location").click(function(event){
		event.stopPropagation();
		$("#sidePanel_location").animate({left:'0px'});
	});

$("#panel_mainWindow").click(function(){
		$("#sidePanel_location").animate({left:'-255px'});
	});
$("#tloc_hide").click(function(){
		$("#sidePanel_location").animate({left:'-255px'});
	});


$("#c2f").click(function(){
		$(this).toggleClass("f_active");
		$(this).find("li").toggleClass("color_white");
		$(".c_shown").toggleClass("c_hidden");
		$(".f_hidden").toggleClass("f_shown");
		$(".forecast").focus();
		
	});
$("#triggerEinfo").click(function(){
		$(".extra_info").slideToggle(300);
	});

$("#fav_loc_list ul li").click(function(){
	$(".forecast").focus();
	$("#sidePanel_location").animate({left:'-255px'});
	codeAddress($(this).html());
	});	
});

function storeLoc(myLocationName,myLocationLat,myLocationlong){
	var store=confirm("Save "+myLocationName+" as your default location ?")
	if (store==true)
	  {
	  		var myPlc = {};
			myPlc.name = myLocationName;
			myPlc.lat = myLocationLat;
			myPlc.long = myLocationlong;
			localStorage.setItem( 'myPlace', JSON.stringify(myPlc) );
			return true;

	  }
	else
	  {
	 	return false;
	  }

}

function fetchPdata()
{
	  $("#ajaxLoader").show();
	  console.log(locationURL);
	  $.ajax({
	  url:locationURL,
	  dataType : "jsonp",
	  success : function(parsed_json) {
		  today = new day();
		  myLocationName = parsed_json['location']['city'];
		  myLocationName = myLocationName+","+ parsed_json['location']['country_name'];
		  myLocationLat = parsed_json['location']['lat'];
		  myLocationlong = parsed_json['location']['lon'];
		  today.currTemp= parsed_json['current_observation']['temp_c'];
		  today.currTemp_f= parsed_json['current_observation']['temp_f'];
		  l_url = parsed_json['location']['l'];
		  console.log(myLocationLat,myLocationlong);
		  if(!(localStorage.getItem('myPlace'))){storeLoc(myLocationName,myLocationLat,myLocationlong);}
		  if(l_url){forecast();}
		  $("#place_name").html(myLocationName);
	  	}
	  });
}
function forecast()
  {
	  
	  var forecast_url ="http://api.wunderground.com/api/"+key_ID+"/forecast"+l_url+".json";
	  $.ajax({
	  url:forecast_url,
	  dataType : "jsonp",
	  complete: function(){
     		$("#ajaxLoader").hide();
   		},
	  success : function(parsed_json) {
		  
		  today.icon = parsed_json['forecast']['simpleforecast']['forecastday']['0']['icon'];
		  today.dayName = parsed_json['forecast']['simpleforecast']['forecastday']['0']['date']['weekday'];
		  today.chigh = parsed_json['forecast']['simpleforecast']['forecastday']['0']['high']['celsius'];
		  today.clow = parsed_json['forecast']['simpleforecast']['forecastday']['0']['low']['celsius'];
		  today.fhigh = parsed_json['forecast']['simpleforecast']['forecastday']['0']['high']['fahrenheit'];
		  today.flow = parsed_json['forecast']['simpleforecast']['forecastday']['0']['low']['fahrenheit'];
		  today.monthName =  parsed_json['forecast']['simpleforecast']['forecastday']['0']['date']['monthname']+", "
		  +parsed_json['forecast']['simpleforecast']['forecastday']['0']['date']['day'];
		  var today_icon_path = '<img src="images/weather_icons/'+ today.icon+'.png" width="90" height"90"/>';
		  windData = parsed_json['forecast']['simpleforecast']['forecastday']['0']['avewind']['kph'];
		  windData = windData+"KPH"+parsed_json['forecast']['simpleforecast']['forecastday']['0']['avewind']['dir'];
		  avgHumidity = parsed_json['forecast']['simpleforecast']['forecastday']['0']['avehumidity'];
		  
		  $("#curr_temp").html(today.currTemp+"&nbsp;&#8451;");
		  $("#curr_temp_f").html(today.currTemp_f+"&nbsp;&#8457");
		  $("#tempHLspan").html("<ul><li>"+today.chigh+"&nbsp;&#8451;</li><li>"+today.clow+"&nbsp;&#8451;</li></ul>");
		  $("#tempHLspan_f").html("<ul><li>"+today.fhigh+"&nbsp;&#8457;</li><li>"+today.flow+"&nbsp;&#8457;</li></ul>");
		  $("#dayName").html(today.dayName);
		  $("#date").html(today.monthName);
		  $(".large_weather_icon").html(today_icon_path);
		  $("#windData").html(windData);
		  $("#precipData").html(avgHumidity+"%"); 
		  
		  var day_1 = new day();
		  day_1.icon = parsed_json['forecast']['simpleforecast']['forecastday']['1']['icon'];
		  day_1.dayName = parsed_json['forecast']['simpleforecast']['forecastday']['1']['date']['weekday'];
		  day_1.chigh = parsed_json['forecast']['simpleforecast']['forecastday']['1']['high']['celsius'];
		  day_1.clow = parsed_json['forecast']['simpleforecast']['forecastday']['1']['low']['celsius'];
		  day_1.fhigh = parsed_json['forecast']['simpleforecast']['forecastday']['1']['high']['fahrenheit'];
		  day_1.flow = parsed_json['forecast']['simpleforecast']['forecastday']['1']['low']['fahrenheit'];
		  var day_1_icon_path = '<img src="images/weather_icons/small/'+day_1.icon+'.png"  width="30" height"30"/>';
		  
		  $("#day1").html(day_1.dayName);
		  $("#day1HL").html(day_1.chigh+"/"+day_1.clow+"&nbsp;&#8451;");
		  $("#day1HL_f").html(day_1.fhigh+"/"+day_1.flow+"&nbsp;&#8457;");
		  $("#small_wIcon_1").html(day_1_icon_path);
		  
		  var day_2 = new day();
		  day_2.icon = parsed_json['forecast']['simpleforecast']['forecastday']['2']['icon'];
		  day_2.dayName = parsed_json['forecast']['simpleforecast']['forecastday']['2']['date']['weekday'];
		  day_2.chigh = parsed_json['forecast']['simpleforecast']['forecastday']['2']['high']['celsius'];
		  day_2.clow = parsed_json['forecast']['simpleforecast']['forecastday']['2']['low']['celsius'];
		  day_2.fhigh = parsed_json['forecast']['simpleforecast']['forecastday']['2']['high']['fahrenheit'];
		  day_2.flow = parsed_json['forecast']['simpleforecast']['forecastday']['2']['low']['fahrenheit'];
		  var day_2_icon_path = '<img src="images/weather_icons/small/'+day_2.icon+'.png"  width="30" height"30"/>';
		  
		  $("#day2").html(day_2.dayName);
		  $("#day2HL").html(day_2.chigh+"/"+day_2.clow+"&nbsp;&#8451;");
		  $("#day2HL_f").html(day_2.fhigh+"/"+day_2.flow+"&nbsp;&#8457;");
		  $("#small_wIcon_2").html(day_2_icon_path);
		  
		  var day_3 = new day();
		  day_3.icon = parsed_json['forecast']['simpleforecast']['forecastday']['3']['icon'];
		  day_3.dayName = parsed_json['forecast']['simpleforecast']['forecastday']['3']['date']['weekday'];
		  day_3.chigh = parsed_json['forecast']['simpleforecast']['forecastday']['3']['high']['celsius'];
		  day_3.clow = parsed_json['forecast']['simpleforecast']['forecastday']['3']['low']['celsius'];
		  day_3.fhigh = parsed_json['forecast']['simpleforecast']['forecastday']['3']['high']['fahrenheit'];
		  day_3.flow = parsed_json['forecast']['simpleforecast']['forecastday']['3']['low']['fahrenheit'];
		  var day_3_icon_path = '<img src="images/weather_icons/small/'+day_3.icon+'.png"  width="30" height"30"/>';
		  
		  $("#day3").html(day_3.dayName);
		  $("#day3HL").html(day_3.chigh+"/"+day_3.clow+"&nbsp;&#8451;");
		  $("#day3HL_f").html(day_3.fhigh+"/"+day_3.flow+"&nbsp;&#8457;");
		  $("#small_wIcon_3").html(day_3_icon_path);
	  }
	  });
	  
	  var sunPhase_url ="http://api.wunderground.com/api/40e8155fff795621/astronomy"+l_url+".json";
	  $.ajax({
	  url:sunPhase_url,
	  dataType : "jsonp",
	  success : function(parsed_json) {
		    var sunriseTime = parsed_json['moon_phase']['sunrise']['hour'];
			sunriseTime = sunriseTime +": "+parsed_json['moon_phase']['sunrise']['minute'];
			var sunsetTime=parsed_json['moon_phase']['sunset']['hour'];
			sunsetTime = sunsetTime +": "+parsed_json['moon_phase']['sunset']['minute'];
			$("#sunData").html(sunriseTime+" - "+sunsetTime);
	  	}
	  });
	 
}

function srch_city(lat,long)
{
	locationURL = "http://api.wunderground.com/api/"+key_ID+"/geolookup/conditions/q/"+lat+","+long+".json";
	fetchPdata();
}

function day(icon,dayName,monthName,flow,fhigh,clow,chigh,currTemp,currTemp_f)
{
	this.icon = icon;
	this.dayName = dayName;
	this.monthName = monthName;
	this.flow = flow;
	this.fhigh = fhigh;
	this.clow = clow;
	this.chigh = chigh;
	this.currTemp = currTemp;
	this.currTemp_f = currTemp_f;
}
