/*global $:false */
var soc;  // TCPSocket
var host;
var port;

var flag = 0;  // success 1
var now = 0;   // wait reponse 1
var flagTimeout = 0;

var loop;
var count = 0; // count ping
var timeoutVal;
var intervalVal;

var rttTotal = 0;
var rttCount = 0;
var rttAve = 0;
var rttMin;
var rttMax = 0;
var rttStdDev = 0;
var rttArray;
var rttLoss = 0;

var flagButton = 0;
var flagCancel = 0;
var flagError = 0;

// check input - begin
function showInputErrorDialog(str){
  "use strict";
  $("#errorMessage").html(str);
  $.mobile.changePage('#inputErrorDialog', {transition: 'pop', role: 'dialog'});
}

function isDomain(str){
  "use strict";
  var patternDomain = /([a-z0-9]+)\.([a-z0-9\-]+)\.[a-z]+/;
  if(patternDomain.test(str)){
    return true;
  }else{
    return false;
  }
}

function isFqdn(str){
  "use strict";
  var patternFqdn = /^[a-z0-9-_]+(\.[a-z0-9-_]+)*\.([a-z]{2,4})$/;
  if(patternFqdn.test(str)){
    return true;
  }else{
    return false;
  }
}

function isIPv4(str){
  "use strict";
  //var patternIPv4 = /((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])[.]){3}(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])/;
  var patternIPv4 = /^(\d|[01]?\d\d|2[0-4]\d|25[0-5])\.(\d|[01]?\d\d|2[0-4]\d|25[0-5])\.(\d|[01]?\d\d|2[0-4]\d|25[0-5])\.(\d|[01]?\d\d|2[0-4]\d|25[0-5])$/;
  if(patternIPv4.test(str)){
    return true;
  }else{
    return false;
  }
}

function isIPv6(str){
  "use strict";
  var patternIPv6 =
/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
  if(patternIPv6.test(str)){
    return true;
  }else{
    return false;
  }
}
// check input - end

/*
$(document).ready(function(){
  $("#ping").bind("tap", function(){
   alert('goo'); 
  });
});
*/

// ms timer, T is ms
function sleep(T){
  "use strict";
  var d1 = new Date().getTime(); 
  var d2 = new Date().getTime(); 
  while(d2 < (d1 + T)){
    d2 = new Date().getTime();
  }
} 

// detect timeout
function timeout(){
  "use strict";
  console.log('timeout()');
  //alert('timeout()');
  //if(now == 1 && flagError == 0){
  if(now === 1){
    //alert('timeout()2');
    flagTimeout = 1;
    soc.close();
  }
}

function ping(){
  "use strict";
  try{   

    soc = navigator.mozTCPSocket.open(host, port);
    var begin = new Date().getTime();
    console.log('open');
    now = 1;

    var timeoutID = window.setTimeout(timeout, timeoutVal);
 
  // 3 ウェイハンドシェイクが正常に完了すると呼ばれる．
  soc.onopen = function(){
    window.clearTimeout(timeoutID);
    console.log('soc.onopen');
    var end = new Date().getTime();
    var rtt = end - begin;
    console.log('RTT : ' + rtt + ' [ms]');

    if(count !== 0){

    if(flagButton === 1 && flagCancel === 0){
      var tmpOnopen = 'ping_req = ' + (count) + ', time = ' + rtt + ' ms<br>' +  $("#result").html();
      $("#result").html(tmpOnopen);
    }

    rttCount = rttCount + 1;
    rttTotal = rttTotal + rtt;

    rttArray[count] = rtt;

    if(rttMin >= rtt){
      rttMin = rtt;
    }
    if(rtt >= rttMax){
      rttMax = rtt;
    }

    }

    flag = 1;
    now = 0;
    soc.close();
  };

  // 
  soc.onclose = function(){
    console.log('onclose');

    // now == 0 is ping success
    if(now === 0){
      if(flag !== 1){
        flag = 0;
      }else{
        flag = 0;
      }
    // now == 1 is (timeout() is called)
    }else{
      // flag == 0, now == 1 is timeout
      if(flag === 0){
        if(flagTimeout === 1){
          var tmpOnerro2 = '  ping_req = ' + (count) + ', time = ' + ' timeout<br>' +  $("#result").html();
          if(flagButton === 1 && flagCancel === 0){
            if(count !== 0){
              $("#result").html(tmpOnerro2);
            }
          }
          flag = 0;
          now = 0;
          flagTimeout = 0;
          rttArray[count] = 0;
        }else{
          var tmpOnerro1 = '  ping_req = ' + (count) + ', time = ' + 'fail (DNS/RST)<br>' +  $("#result").html();
          if(flagButton === 1 && flagCancel === 0){
            if(count !== 0){
              $("#result").html(tmpOnerro1);
            }
          }
          flag = 0;
          now = 0;
          rttArray[count] = 0;
        }
      }
    }
      
    count = count + 1;
    if(count < loop){
      if(flagButton === 1 && flagCancel === 0){
        sleep(intervalVal);
        ping();
      }
    }else{
      if(flagButton === 1 && flagCancel === 0){
        if(rttCount !== 0){
          var rttAveTmp = Math.round((rttTotal / rttCount) * 10); 
          rttAve = rttAveTmp / 10;
          var i;
          var rttStdDevTmp = 0;
          for(i = 1; i < rttArray.length; i++){        
            if(rttArray[i] !== 0){
              rttStdDevTmp = ((rttArray[i] - rttAve) * (rttArray[i] - rttAve)) + rttStdDevTmp; 
            }
          }
          var rttStdDevTmp2 = Math.round(Math.sqrt(rttStdDevTmp / rttCount) * 10);
          rttStdDev = rttStdDevTmp2 / 10;
          rttLoss = 100 * (((loop-1) - rttCount) / (loop-1));
        }else{
          rttAve = '-';
          rttMin = '-';
          rttMax = '-';
          rttStdDev = '-';
          rttLoss = 100 * (((loop-1) - rttCount) / (loop-1));
        }
        console.log(rttAve + ', ' + rttMin + ', ' + rttMax + ', ' + rttStdDev + ', ' + rttLoss);
        console.log(rttArray.length);
        var resultStr = '--- ping statistics ---<br>' + (loop-1) + ' segment transmitted,<br>' + rttCount + ' received, ' + rttLoss + '% segment loss,<br>' + 'rtt min/ave/max/mdev =<br>     ' + rttMin + ' / ' + rttAve + ' / ' + rttMax + ' / ' + rttStdDev + ' ms<br>' + $("#result").html();
        $("#result").html(resultStr);
        $("#ping").text('ping').button('refresh');
        flagButton = 0;
        $("#host").textinput('enable');
        $("#port").textinput('enable');
        $("#sliderNumber").slider('enable');
        $("#sliderTimeout").slider('enable');
        $("#sliderInterval").slider('enable');
      }
    }

  };
 
  // 3 ウェイハンドシェイクにおける SYN に対して RST が返ってくると呼ばれる．
  // 名前解決に失敗 (No such name) しても呼ばれる．
  // 上記 2 つを識別する方法がわからないので，SYN に対する RST の RTT は測定するのはやめる．
  soc.onerror = function(){
    //console.log('soc.onerror');
    //alert('soc.onerror');
    // var end = new Date().getTime();
    // var rtt = end - begin;
    // console.log('RTT (RST) : ' + rtt + ' [ms]');
   
    window.clearTimeout(timeoutID);
    //flagError = 1; // TODO OK?
    soc.close();
  };
                  
  }catch(err){ 
    alert('Could not create a TCP socket: ' + err.name);
  } 
}



//
$(document).ready(function(){
  "use strict";

  //alert('$(document).ready()');

  $("#sliderNumber").bind("change", function(){
    loop = parseInt($("#sliderNumber").val(), 10) + 1;
  });
  $("#sliderInterval").bind("change", function(){
    intervalVal = parseInt($("#sliderInterval").val(), 10);
  });
  $("#sliderTimeout").bind("change", function(){
    timeoutVal = parseInt($("#sliderTimeout").val(), 10);
  });

  loop = parseInt($("#sliderNumber").val(), 10) + 1;
  //alert('$("#sliderNumber").val() ' + $("#sliderNumber").val());
  //alert('loop ' + loop);
  intervalVal = parseInt($("#sliderInterval").val(), 10);
  //alert('intervalVal ' + intervalVal);
  timeoutVal = parseInt($("#sliderTimeout").val(), 10);
  //alert('timeoutVal ' + timeoutVal);
  rttMin = timeoutVal;
  //alert('loop ' + loop + ', intervalVal ' + intervalVal + ', timeoutVal' + timeoutVal);

  $("#ping").on("tap", function(){

    //alert('$("#ping").on("tap", function()');

    if(($("#port").val() !== '') && isFinite($("#port").val()) && $("#port").val().match(/^(0|[1-9]\d*)$/) && ($("#port").val() >= 0) && ($("#port").val() <= 65535) && ($("#host").val() !== '') && (isFqdn($("#host").val()) || isIPv4($("#host").val()) || isIPv6($("#host").val()))){
    
    //alert('$("#ping").on("tap", function()2');

    if(flagButton === 0){
      $("#ping").text('cancel').button('refresh'); 
      flagButton = 1;

      $("#result").html('');
      flag = 0;
      now = 0;
      flagTimeout = 0;
      count = 0;

      rttTotal = 0;
      rttCount = 0;
      rttAve = 0;
      rttMin = timeoutVal;
      rttMax = 0;
      rttStdDev = 0;
      rttArray = new Array(loop);
      rttLoss = 0;

      flagCancel = 0;
      flagError = 0;

      host = $("#host").val();
      console.log(host);
      port = $("#port").val();
      console.log(port);

      $("#host").textinput('disable');
      $("#port").textinput('disable');
      $("#sliderNumber").slider('disable');
      $("#sliderTimeout").slider('disable');
      $("#sliderInterval").slider('disable');

      ping();
    }else{
      $("#ping").text('ping').button('refresh');
      flagButton = 0;
      flagCancel = 1;
      count = loop;
      soc.close();
      $("#result").html('');

      $("#host").textinput('enable');
      $("#port").textinput('enable');
      $("#sliderNumber").slider('enable');
      $("#sliderTimeout").slider('enable');
      $("#sliderInterval").slider('enable');
    }

    // input error
    }else{
      if($("#port").val() === ''){
        showInputErrorDialog('TCP port is blank.');
        //alert('TCP port is blank.');
        //$("#errorMessage").html('TCP port is blank.');
        //$.mobile.changePage('#inputErrorDialog', {transition: 'pop', role: 'dialog'});
        ////$.mobile.changePage('#messagebox', 'pop', false, true);
      }else if(!isFinite($("#port").val())){
        showInputErrorDialog('TCP port is invalid.');
      }else if(!$("#port").val().match(/^(0|[1-9]\d*)$/)){
        showInputErrorDialog('TCP port is positive integer or zero.');
      }else if($("#port").val() < 0){
        showInputErrorDialog('TCP port is 0 - 65535.');
      }else if($("#port").val() > 65535){
        showInputErrorDialog('TCP port is 0 - 65535.');
      }else if($("#host").val() === ''){
        showInputErrorDialog('Destination is blank.');
      }else if(!isFqdn($("#host").val()) && !isIPv4($("#host").val()) && !isIPv6($("#host").val())){
        showInputErrorDialog('Destination is invalid.');
      }
    }

  });

});


