﻿//shows the info page for webchemy. used as an iframe in the app
//requires: lib.js, ui.js

(function() {
	var aboutPage, helpPage, feedbackPage, boxSize, aboutCloseFunc, tabBar, content,
		closed, boxPx, div, activeTab, tabs;
	
	var isProVersion = true;//localStorage.getItem('isProVersion') === "true";
	
	
	function getQueryVariable(variable) {
		   var query = window.location.search.substring(1);
		   var vars = query.split("&");
		   for (var i=0;i<vars.length;i++) {
				   var pair = vars[i].split("=");
				   if(pair[0] == variable){return pair[1];}
		   }
		   return(false);
	}
	var halfBoxSizeGET = Math.min(40, Math.max(22, parseInt(getQueryVariable("halfBoxSize"), 10)));
	UI.theme.halfBoxSize = halfBoxSizeGET;
	
	window.loadUrl = function(url) {
		e.preventDefault();
		var activity = new MozActivity({
		name: "view",
		data: {
				  type: "url",
				   url: url
			  }
		});
	};	
	
	boxSize = UI.theme.halfBoxSize * 2;
	closed = false;
	boxPx = boxSize / 44;
	div = document.createElement("div");

	helpPage = (function () {
		var div, content, page, pages, pageDots, dotContainer, i, nextButton, previousButton, pageElements;
		div = document.createElement("div");
		content = document.createElement("div");
		page = 0;
		pages = [];
		pageDots = [];
		dotContainer = document.createElement("div");
		function updatePages() {
			var i;
			for (i = 0; i < pages.length; i += 1) {
				if (i === page) {
					pages[i].style.display = "block";
					LIB.css(pageDots[i], {
						background: "rgba(255,255,255, 0.8)",
						cursor: "default"
					});
				} else {
					pages[i].style.display = "none";
					LIB.css(pageDots[i], {
						background: "rgba(255, 255, 255, 0.1)",
						cursor: "pointer"
					});
				}
			}
			nextButton.enable(page < pages.length - 1);
			previousButton.enable(page > 0);
		}
		dotContainer.onclick = function (event) {
			var offset, x;
			offset = LIB.getGlobalOff(dotContainer);
			x = event.pageX - offset.x;
			page = parseInt(x / boxSize, 10);
			updatePages();
			return false;
		};
		dotContainer.ontouchstart = function (event) {
			var offset, x;
			if (event.touches.length > 1) {
				return;
			}
			offset = LIB.getGlobalOff(dotContainer);
			x = event.touches[0].pageX - offset.x;
			page = parseInt(x / boxSize, 10);
			updatePages();
			return false;
		};
		LIB.css(dotContainer, {
			position: "absolute",
			left: (boxSize * 1.5) + "px",
			top: (boxSize * 4) + "px",
			width: (4 * boxSize) + "px",
			height: boxSize + "px"
		});
		//page1
		pageElements = [
			[],
			[],
			[],
			[]
		];
		pageElements[0].push(UI.div({
			innerHTML: "Webchemy is for creating sketches",
			fontSize: (boxSize / 2.8) + "px",
			width: "100%",
			textAlign: "center",
			paddingTop: (boxSize / 8) + "px",
			color: "#bbb",
			fontFamily: "Lucida Sans Unicode, Lucida Grande, sans-serif"
		}));
		pageElements[0].push(UI.div({
			innerHTML: "Tool Bar<br/>Canvas",
			lineHeight: (boxSize * 1.4) + "px",
			position: "absolute",
			left: (boxSize * 5) + "px",
			top: (boxSize * 0.4) + "px",
			fontSize: (boxSize * 0.4) + "px",
			color: "#fff"
		}));
		pageElements[0].push(UI.div({
			width: (3.5 * boxSize) + "px",
			height: (2.6 * boxSize) + "px",
			backgroundColor: "#fff",
			boxShadow: (boxSize / 11) + "px " + (boxSize / 11) + "px " + (boxSize / 3) + "px rgba(0,0,0,0.5)",
			position: "absolute",
			left: (boxSize * 0.6) + "px",
			top: (boxSize * 0.9) + "px"
		}));
		pageElements[0].push(UI.div({
			width: (2.5 * boxSize) + "px",
			height: (0.45 * boxSize) + "px",
			backgroundColor: "#555",
			position: "absolute",
			left: (boxSize * 1.1) + "px",
			top: (boxSize * 0.9) + "px",
			borderBottomLeftRadius: (boxSize / 6) + "px",
			borderBottomRightRadius: (boxSize / 6) + "px"
		}));
		pageElements[0].push(UI.div({
			type: "image",
			src: "help01.png",
			width: (boxPx * 135) + "px",
			height: (boxPx * 90) + "px",
			position: "absolute",
			left: (boxSize * 0.6) + "px",
			top: (boxSize * 0.9) + "px"
		}));
		pageElements[0].push(UI.div({
			width: (1.4 * boxSize) + "px",
			height: boxPx + "px",
			backgroundColor: "#fff",
			borderBottom: boxPx + "px solid #000",
			position: "absolute",
			left: (boxSize * 3.5) + "px",
			top: (boxSize * 1.1) + "px"
		}));
		pageElements[0].push(UI.div({
			width: (1.4 * boxSize) + "px",
			height: boxPx + "px",
			backgroundColor: "#fff",
			borderBottom: boxPx + "px solid #000",
			position: "absolute",
			left: (boxSize * 3.5) + "px",
			top: (boxSize * 2.5) + "px"
		}));
		//page 2
		pageElements[1].push(UI.div({
			innerHTML: "The Tool Bar",
			fontSize: (boxSize / 2.8) + "px",
			width: "100%",
			textAlign: "center",
			paddingTop: (boxSize / 8) + "px",
			color: "#bbb",
			fontFamily: "Lucida Sans Unicode, Lucida Grande, sans-serif"
		}));
		pageElements[1].push(UI.div({
			position: "absolute",
			backgroundColor: "#bbb",
			width: (boxSize / 22) + "px",
			height: (boxPx * 20) + "px",
			left: (boxPx * 91) + "px",
			top: (boxPx * 68) + "px"
		}));
		pageElements[1].push(UI.div({
			position: "absolute",
			backgroundColor: "#bbb",
			width: (boxSize / 22) + "px",
			height: (boxPx * 20) + "px",
			left: (boxPx * 142) + "px",
			top: (boxPx * 68) + "px"
		}));
		pageElements[1].push(UI.div({
			position: "absolute",
			backgroundColor: "#bbb",
			width: (boxSize / 22) + "px",
			height: (boxPx * 55) + "px",
			left: (boxPx * 177) + "px",
			top: (boxPx * 68) + "px"
		}));
		pageElements[1].push(UI.div({
			position: "absolute",
			backgroundColor: "#bbb",
			width: (boxSize / 22) + "px",
			height: (boxPx * 30) + "px",
			left: (boxPx * 202) + "px",
			top: (boxPx * 68) + "px",
			transformOrigin: "0 0",
			transform: "rotate(-45deg)"
		}));
		pageElements[1].push(UI.div({
			width: (3.7 * boxSize) + "px",
			height: (0.65 * boxSize) + "px",
			backgroundColor: "#555",
			backgroundImage: "url(help02.png)",
			backgroundRepeat: "no-repeat",
			backgroundSize: (boxPx * 161) + "px " + (boxPx * 24) + "px",
			position: "absolute",
			left: (boxSize * 1.65) + "px",
			top: (boxSize * 0.9) + "px",
			borderBottomLeftRadius: (boxSize / 6) + "px",
			borderBottomRightRadius: (boxSize / 6) + "px"
		}));
		pageElements[1].push(UI.div({
			innerHTML: "Color",
			position: "absolute",
			color: "#fff",
			left: (boxPx * 60) + "px",
			top: (boxPx * 95) + "px",
			fontSize: (boxPx * 18) + "px"
		}));
		pageElements[1].push(UI.div({
			innerHTML: "<b>Click twice for<br/>more colors</b>",
			position: "absolute",
			color: "#aaa",
			left: (boxPx * 43) + "px",
			top: (boxPx * 115) + "px",
			fontSize: (boxPx * 12) + "px"
		}));
		pageElements[1].push(UI.div({
			innerHTML: "Brush",
			position: "absolute",
			color: "#fff",
			left: (boxPx * 120) + "px",
			top: (boxPx * 95) + "px",
			fontSize: (boxPx * 18) + "px"
		}));
		pageElements[1].push(UI.div({
			innerHTML: "More Tools",
			position: "absolute",
			color: "#fff",
			left: (boxPx * 130) + "px",
			top: (boxPx * 130) + "px",
			fontSize: (boxPx * 18) + "px"
		}));
		pageElements[1].push(UI.div({
			innerHTML: "Undo, Zoom, Hand Tool",
			position: "absolute",
			color: "#aaa",
			left: (boxPx * 110) + "px",
			top: (boxPx * 150) + "px",
			fontSize: (boxPx * 12) + "px"
		}));
		pageElements[1].push(UI.div({
			innerHTML: "Save / Clear",
			position: "absolute",
			color: "#fff",
			left: (boxPx * 190) + "px",
			top: (boxPx * 95) + "px",
			fontSize: (boxPx * 18) + "px"
		}));

		pageElements[2].push(UI.div({
			innerHTML: "Gestures & Shortcuts",
			fontSize: (boxSize / 2.8) + "px",
			width: "100%",
			textAlign: "center",
			paddingTop: (boxSize / 8) + "px",
			color: "#bbb",
			fontFamily: "Lucida Sans Unicode, Lucida Grande, sans-serif"
		}));
		pageElements[2].push(UI.div({
			//innerHTML: "Hide / Show Bar<br/>Reset View<br/>Panning / Zoom<br/><br/>Pick Color<br/>Undo",
			innerHTML: "Hide / Show Bar<br/>Reset View<br/>Panning / Zoom",
			fontSize: (boxPx * 15) + "px",
			lineHeight: (boxPx * 23) + "px",
			position: "absolute",
			left: (boxPx * 30) + "px",
			top: (boxPx * 32) + "px",
			color: "#eee"
		}));
		pageElements[2].push(UI.div({
			//innerHTML: "<b>single</b> tap / click<br/><b>double</b> tap / click<br /><b>two fingers</b> (pinch),<br/><br/>alt + mouse<br/>ctrl + z",
			innerHTML: "<b>single</b> tap<br/><b>double</b> tap<br /><b>two finger</b> pinch",
			fontSize: (boxPx * 12) + "px",
			lineHeight: (boxPx * 23) + "px",
			position: "absolute",
			left: (boxPx * 170) + "px",
			top: (boxPx * 32) + "px",
			color: "#eee"
		}));
		/*pageElements[2].push(UI.div({
			innerHTML: "middle mouse, scroll,<br/>spacebar + mouse",
			fontSize: (boxPx * 11) + "px",
			lineHeight: (boxPx * 12) + "px",
			position: "absolute",
			left: (boxPx * 170) + "px",
			top: (boxPx * 98) + "px",
			color: "#bbb"
		}));*/
		pageElements[2].push(UI.div({
			position: "absolute",
			background: "rgba(255,255,255, 0.2)",
			width: (boxSize * 6) + "px",
			height: boxPx + "px",
			left: (boxPx * 20) + "px",
			top: (boxPx * 54) + "px",
			color: "#eee"
		}));
		pageElements[2].push(UI.div({
			position: "absolute",
			background: "rgba(255,255,255, 0.2)",
			width: (boxSize * 6) + "px",
			height: boxPx + "px",
			left: (boxPx * 20) + "px",
			top: (boxPx * 77) + "px",
			color: "#eee"
		}));
		/*pageElements[2].push(UI.div({
			position: "absolute",
			background: "rgba(255,255,255, 0.2)",
			width: (boxSize * 6) + "px",
			height: boxPx + "px",
			left: (boxPx * 20) + "px",
			top: (boxPx * 124) + "px",
			color: "#eee"
		}));*/
		/*pageElements[2].push(UI.div({
			position: "absolute",
			background: "rgba(255,255,255, 0.2)",
			width: (boxSize * 6) + "px",
			height: boxPx + "px",
			left: (boxPx * 20) + "px",
			top: (boxPx * 146) + "px",
			color: "#eee"
		}));*/
		pageElements[3].push(UI.div({
			innerHTML: 'More Resources<br/><br/><a href="http://www.youtube.com/playlist?list=PLEwyLb78MLYn0Tj1b6F37uwOCOAanTD7X" target="_blank">Youtube Videos about Webchemy</a></br></br><a target="_blank" href="http://bitbof.com/forum/viewforum.php?f=5">Webchemy Forum</a><br/><br/><a target="_blank" href="http://webchemy.org/gallery/">User Gallery</a>',
			paddingTop: (boxSize / 2) + "px",
			textAlign: "center",
			width: "100%"
		}));
		function createPage(i) {
			var e;
			pages[i] = document.createElement("div");
			for (e = 0; e < pageElements[i].length; e += 1) {
				pages[i].appendChild(pageElements[i][e]);
			}
			pages[i].style.display = "none";
			pages[i].style.cursor = "default";
			/*pages[i].ontouchstart = function () {
				return false;
			};*/
			content.appendChild(pages[i]);
			pageDots[i] = document.createElement("div");
			LIB.css(pageDots[i], {
				position: "absolute",
				top: (boxSize / 2) + "px",
				left: (boxSize * i + boxSize / 2) + "px",
				width: (boxSize / 3) + "px",
				height: (boxSize / 3) + "px",
				marginLeft: -(boxSize / 6) + "px",
				marginTop: -(boxSize / 6) + "px",
				borderRadius: (boxSize / 6) + "px",
				background: "rgba(255, 255, 255, 0.1)",
				cursor: "pointer"
			});
			if (i === 0) {
				pages[i].style.display = "block";
				LIB.css(pageDots[i], {
					background: "rgba(255,255,255, 0.8)",
					cursor: "default"
				});
			}
			dotContainer.appendChild(pageDots[i]);
		}
		for (i = 0; i < 4; i += 1) {
			createPage(i);
		}

		nextButton = new UI.Button({
			im: "btn_next.svg",
			animated: true,
			touchGlow: true,
			callback: function () {
				page += 1;
				updatePages();
			}
		});
		LIB.css(nextButton.getDiv(), {
			position: "absolute",
			left: (boxSize * 6) + "px",
			top: (boxSize * 4) + "px"
		});
		previousButton = new UI.Button({
			im: "btn_previous.svg",
			animated: true,
			touchGlow: true,
			disabled: true,
			callback: function () {
				page -= 1;
				updatePages();
			}
		});
		LIB.css(previousButton.getDiv(), {
			position: "absolute",
			left: 0,
			top: (boxSize * 4) + "px"
		});
		div.appendChild(content);
		div.appendChild(previousButton.getDiv());
		div.appendChild(dotContainer);
		div.appendChild(nextButton.getDiv());
		LIB.css(div, {
			fontSize: (boxSize / 3.0) + "px",
			lineHeight: (boxSize / 2.5) + "px",
			color: UI.theme.labelColor
		});
		return div;
	}());
	feedbackPage = (function () { //NOT PUBLIC
		var div, inputDescription, send, inputWrapper, sendWrapper, aniToggle, isSending, sending;
		div = document.createElement("div");
		inputDescription = document.createElement("textarea");
		inputDescription.placeholder = "Send suggestions about Webchemy. Problem reports, feature ideas and general comments are welcome.";
		LIB.css(inputDescription, {
			fontSize: (boxSize / 3.0) + "px",
			resize: "none",
			border: "1px solid black",
			boxSizing: "border-box",
			boxShadow: "inset 0px 3px 8px rgba(0, 0, 0, 0.4)",
			width: "100%",
			height: "100%",
			padding: boxSize / 4.0 + "px",
			marginBottom: boxSize / 4.0 + "px"
		});
		inputDescription.onkeyup = function () {
			if (inputDescription.value !== "") {
				send.disabled = false;
			} else {
				send.disabled = true;
			}
		};
		send = document.createElement("button");
		send.disabled = true;
		LIB.css(send, {
			display: "block",
			marginLeft: "auto",
			marginRight: "auto",
			width: "100%",
			height: "100%",
			boxSizing: "border-box"
		});
		send.innerHTML = "Submit";
		LIB.css(div, {
			fontSize: (boxSize / 3.0) + "px",
			color: UI.theme.labelColor,
			display: "none"
		});

		inputWrapper = document.createElement("div");
		sendWrapper = document.createElement("div");
		LIB.css(inputWrapper, {
			width: "100%",
			height: (boxSize * 4) + "px",
			paddingBottom: boxSize / 4.0 + "px",
			boxSizing: "border-box"
		});
		LIB.css(sendWrapper, {
			width: "100%",
			height: boxSize + "px",
			paddingBottom: boxSize / 4.0 + "px",
			boxSizing: "border-box"
		});
		inputWrapper.appendChild(inputDescription);
		sendWrapper.appendChild(send);
		div.appendChild(inputWrapper);
		div.appendChild(sendWrapper);
		inputDescription.onclick = function () {
			inputDescription.focus();
		};
		aniToggle = true;
		sending = document.createElement("div");
		sending.innerHTML = "Submitting...";
		LIB.css(sending, {
			transition: "opacity 0.2s linear",
			width: "100%",
			marginTop: (boxSize * 2) + "px",
			fontSize: (boxSize / 2.0) + "px",
			textAlign: "center"
		});

		function sendingAnimation() {
			if (!isSending || closed) {
				return;
			}
			if (aniToggle) {
				sending.style.opacity = 1;
			} else {
				sending.style.opacity = 0.2;
			}
			aniToggle = !aniToggle;
			setTimeout(sendingAnimation, 201);
		}
		send.onclick = function () {
			div.removeChild(inputWrapper);
			div.removeChild(sendWrapper);
			
			if(!navigator.onLine) {
				sending.innerHTML = "<b>Error: No Internet Connection</b><br/>Sorry, try again later.";
				return;
			}
			
			
			var xmlhttp, timedOut, msg;
			//xmlhttp = new XMLHttpRequest();
			//timedOut = false;
			/*xmlhttp.onreadystatechange = function () {
				if (timedOut) {
					return;
				}
				console.log(xmlhttp.readyState);
				if (xmlhttp.readyState === 4 && xmlhttp.status === 200) {
					isSending = false;
					LIB.css(sending, {
						transition: "",
						opacity: 1,
						marginTop: (boxSize * 1.8) + "px",
						fontSize: (boxSize / 3.0) + "px"
					});
					sending.innerHTML = "<b>Success.</b><br/>Thank you very much for your feedback.";
				}
			};*/
			msg = encodeURIComponent(inputDescription.value);
			//xmlhttp.open("GET", "http://webchemy.org/sendFeedback.php?msg=" + msg, true);
			
			
			var iframe = document.createElement("iframe");
			LIB.css(iframe, {
				position: "absolute",
				left: 0,
				top: 0,
				width: 0,
				height: 0,
				opacity: 0,
				pointerEvents: "none"
			});
			iframe.onload = function(e) {
				console.log("IFRAME LOADED");
				console.log(e);
				document.body.removeChild(iframe);
				iframe = undefined;
				isSending = false;
				 LIB.css(sending, {
					transition: "",
					opacity: 1,
					marginTop: (boxSize * 1.8) + "px",
					fontSize: (boxSize / 3.0) + "px"
				});
				sending.innerHTML = "<b>Success.</b><br/>Thank you very much for your feedback.";
			};
			iframe.src = "http://webchemy.org/sendFeedback.php?firefoxApp=1&msg=" + msg;
			document.body.appendChild(iframe);
			
			
			div.appendChild(sending);
			isSending = true;
			sendingAnimation();
			setTimeout(function () {
				/*if(!isSending) {
					return;
				}
				timedOut = true;
				isSending = false;
				LIB.css(sending, {
					transition: "",
					opacity: 1,
					marginTop: (boxSize * 1.8) + "px",
					fontSize: (boxSize / 3.0) + "px"
				});*/
				if(iframe) {
					document.body.removeChild(iframe);
					sending.innerHTML = "<b>Error: Timeout</b><br/>Sorry, try again later.";
				}
			}, 6000);
		};
		return div;
	}());
	aboutPage = (function () {
		var div = document.createElement("div");
		div.innerHTML = '<i>Webchemy for Firefox OS</i><br/><br/>';
		div.innerHTML += 'Webchemy started as an attempt to recreate parts of Alchemy on the web, with support for mobile platforms.<br/>by <a target="_blank" href="http://bitbof.com/">bitbof</a>' + '<br /><br/><b><a target="_blank" href="http://webchemy.org/about/">Learn more about Webchemy</a></b><br/><br/>' + '<a target="_blank" href="https://github.com/bitbof/webchemy/">The web-app on Github</a><br/><br/>' + '<a target="_blank" href="http://al.chemy.org/">Alchemy Homepage</a>';
		LIB.css(div, {
			fontSize: (boxSize / 3.0) + "px",
			color: UI.theme.labelColor,
			display: "none",
			textAlign: "justify",
			lineHeight: (17 / 44 * boxSize) + "px"
		});
		return div;
	}());
	var discoverPage = (function () {
		var div = document.createElement("div");
		

		var outString = "";
		outString = "<center><div style=\"padding-top:10px;font-family:'Lucida Sans Unicode', 'Lucida Grande', sans-serif;\">" + ' Thanks for using Webchemy. Here are some more apps by bitbof:</div></center>';
		outString += '<br/><a target="_blank" href="http://kleki.com/">Kleki</a><br/>A more painterly oriented drawing tool. Features: layers, filters, import, upload, pressure sensitivity, ...';
		outString += '</br></br><a target="_blank" href="http://bitbof.com/doodler/">Doodler</a><br/>A web-app that helps you get better at sketching by challenging you in an unusual way.';
		UI.div({
			parent: div,
			innerHTML: outString
		});
		
		LIB.css(div, {
			fontSize: (boxSize / 3.3) + "px",
			color: UI.theme.labelColor,
			display: "none",
			textAlign: "justify",
			lineHeight: (16 / 44 * boxSize) + "px"
		});
		
		return div;
	}());
	//div.className = "WebchemyAppShadedPopupBG";
	backButton = document.createElement("div");
	tabBar = document.createElement("div");
	content = document.createElement("div");
	aboutCloseFunc = function () {};

	LIB.css(div, {
		width: (7 * boxSize) + "px",
		height: (6 * boxSize) + "px"
	});
	
	activeTab = 0;
	tabs = [{
		div: helpPage,
		label: "Help"
	}, {
		div: aboutPage,
		label: "About"
	}];
	if(!isProVersion) {
		tabs.push({
			div: discoverPage,
			label: "Upgrade"
		});
	} else {
		tabs.push({
			div: discoverPage,
			label: "More"
		});
	}
	tabs.push({
		div: feedbackPage,
		label: "Feedback"
	});
	
	function tabClick(p) {
		var i;
		activeTab = p;
		for (i = 0; i < tabs.length; i += 1) {
			if (i !== activeTab) {
				LIB.css(tabs[i].button, {
					borderBottom: (boxSize / 22) + "px solid rgba(0,0,0,0)",
					cursor: "pointer"
				});
				tabs[i].div.style.display = "none";
			} else {
				LIB.css(tabs[i].button, {
					borderBottom: (boxSize / 22) + "px solid #fff",
					cursor: "default"
				});
				tabs[i].div.style.display = "block";
			}
		}
	}

	function createTabButton(p) {
		tabs[p].button = document.createElement("div");
		tabs[p].button.innerHTML = tabs[p].label;
		LIB.css(tabs[p].button, {
			padding: (boxSize / 8) + "px",
			paddingTop: (boxSize / 3) + "px",
			boxSizing: "border-box",
			width: (100 / tabs.length) + "%",
			borderBottom: (boxSize / 22) + "px solid #fff",
			cursor: "default",
			cssFloat: "left"
		});
		if (activeTab !== p) {
			LIB.css(tabs[p].button, {
				borderBottom: (boxSize / 22) + "px solid rgba(0, 0, 0, 0)",
				cursor: "pointer"
			});
		}
		LIB.setClickListener({
			el: tabs[p].button,
			glowPos: {
				x: boxSize,
				y: boxSize / 2
			},
			callback: function () {
				if (activeTab === p) {
					return false;
				}
				tabClick(p);
			}
		});
		tabBar.appendChild(tabs[p].button);
	}
	
	for(var i = 0; i < tabs.length; i++) {
		createTabButton(i);
	}
	LIB.css(tabBar, {
		fontSize: (boxSize / 3.0) + "px",
		paddingLeft: (boxSize / 3.0) + "px",
		paddingRight: (boxSize / 3.0) + "px",
		width: "100%",
		boxSizing: "border-box",
		height: boxSize + "px",
		color: "#fff",
		textAlign: "center"
	});
	LIB.css(content, {
		fontSize: (boxSize / 3.0) + "px",
		paddingLeft: (boxSize / 3.5) + "px",
		paddingRight: (boxSize / 3.5) + "px",
		color: UI.theme.labelColor,
		clear: "both",
		position: "relative"
	});
	div.appendChild(tabBar);
	div.appendChild(content);
	for(var i = 0; i < tabs.length; i++) {
		content.appendChild(tabs[i].div);
	}
	
	/*//sharing
	var sharingDiv = document.createElement("div");
	 LIB.css(sharingDiv, {
		width: (boxSize * 7) + "px",
		height: boxSize + "px",
		position: "absolute",
		top: (boxSize * 7) + "px",
		left: (boxSize / 5) + "px"
	});
	sharingDiv.innerHTML = '<div id="WebchemyAppSharingDiv2"><div id="share_fbook"><iframe id="iframefbook" src="http://www.facebook.com/plugins/like.php?href=http%3A%2F%2Fwebchemy.org&amp;layout=button_count&amp;show_faces=false&amp;width=55&amp;action=like&amp;colorscheme=light&amp;locale=en_US" style="width:90px; height:20px;" allowtransparency="true" frameborder="0" scrolling="no"></iframe></div>	<div id="share_twitter">		<iframe id="iframetwitter" src="http://platform.twitter.com/widgets/tweet_button.html?url=http%3A%2F%2Fwebchemy.org&amp;text=Check%20this%20out!&amp;count=count" style="width:110px; height:20px;" allowtransparency="true" frameborder="0" scrolling="no"></iframe>	</div>	<div id="share_gplus">		<iframe id="iframeplusone" src="https://plusone.google.com/u/0/_/+1/fastbutton?url=http%3A%2F%2Fwebchemy.org&amp;size=medium&amp;lang=de" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:74px; height:20px;" align="left"></iframe>	</div></div>';
	div.appendChild(sharingDiv);*/
	
	
	
	window.onload = function() {
		LIB.css(document.body, {
			fontFamily: "arial",
			margin: 0,
			overflow: "hidden"
		});
		
		LIB.addCssRule("body", "color: " + UI.theme.textColor + "; font-family: arial;");
		LIB.addCssRule("a", "color: " + UI.theme.linkColor + "; text-decoration: none; text-shadow: 1px 1px 1px #000; padding-right: 13px; background: url(linkim.svg) center right no-repeat; cursor: pointer;");
		LIB.addCssRule("a:hover", "color: " + UI.theme.linkHoverColor + ";");
		
		
		LIB.addCssRule("button", "font-size: " + (UI.theme.halfBoxSize * 2 / 3) + "px; padding: 5px; background: " + UI.theme.barCol + "; color: #fff; border: 1px solid #fff; border-radius: 5px; cursor: pointer;");
		LIB.addCssRule("button:active", "background: " + UI.theme.expandCol + ";");
		LIB.addCssRule("button:disabled", "opacity: 0.5");
		
		document.body.appendChild(div);
	};
})();