'use strict';

var Connection = function Connection() {

  var cpt = 0;
  var operationEnCours = false;
  
  var init = function init() {
    //On vérifie que l'url webdav a bien été renseigné avant de tenter la connexion
    if(localStorage.getItem('url') === null || localStorage.getItem('url')=== '') {
      alert(navigator.mozL10n.get('app_msg_emptyurl'));
    }
    else{
      //On récupère les informations de connexion
      var accountData = {
          url: localStorage.getItem('url'),
          user: localStorage.getItem('user'),
          password: localStorage.getItem('passwd')
      };
      localStorage.setItem('back',null);
      
      //On se connecte au serveur webdav pour effectuer les traitements (asynchrone)
      var connection = jsDAVlib.getConnection(accountData);
      connection.onready = function() {
        //On récupère toutes les ressources qui sont à la racine
        $( "#loading" ).show();
        $("#folder-input-btn").attr('value', navigator.mozL10n.get('app_newfolder_value')) ;
        $("#folder-input-txt").attr('placeholder', navigator.mozL10n.get('app_newfolder_placeholder'));
        affichageResource(connection,null);
        
        //Event sur le bouton Back permettant de remonter l'arborescence d'un niveau
        $('#back-btn').on('click', function (e) {
          $( "#loading" ).show();
          localStorage.setItem("current",localStorage.getItem('back'));
          parentBackward(localStorage.getItem('back'));
          affichageResource(connection,localStorage.getItem('back'));
        });
        
        //Evenements sur le bouton de création de dossier et le formulaire
        $('#create-folder').on('click', function (e) {
          //Affiche ou cache le formulaire de création du dossier
          if($( "#folderdiv" ).attr('style') == "display: none;"){
            $( "#folderdiv" ).show();
          }
          else{
            $( "#folderdiv" ).hide();
          }
        });
        $('#folder-input-btn').on('click', function (e) {
         //alert($("folder-input-txt").attr('value'));
          if(document.getElementById("folder-input-txt").value != ""){
            connection.createFolder(document.getElementById("folder-input-txt").value, function(res, error) {
               $("#folderdiv").hide();
               document.getElementById("folder-input-txt").value = "";
               affichageResource(connection, localStorage.getItem('current'));
            });
          }
        });
        
        //Evenement sur le bouton d'upload
        $('#upload-btn').on('click', function (e) {
          $('#monInputFile').click();
        });
        $('#monInputFile').on('change', function (e) {
          operationEnCours = true;
          connection.uploadResource(connection, function(res, error) {
            operationEnCours = false;
            alert(navigator.mozL10n.get('app_msg_uploadend'));
            $("#progressdiv").hide();
            affichageResource(connection, localStorage.getItem('current'));
          });
        });
        
      };
    }
  };

  //Fonction permettant d'afficher la liste des ressources du dossier courant
  function affichageResource(connection,href){
    
    $("#listFiles thead").remove();
    $("#listFiles tbody").remove();
    connection.getResource(href, function(rootResource, error) {
     if (error) {
       console.log('Error getting main resource - ' + error);
       return;
     }
     var List = rootResource.get().data;
     localStorage.setItem('current',rootResource.get().meta.href);
     var size, fileNameV;
     var content="";
     content = content +"<thead><tr><th>"+navigator.mozL10n.get('app_files_column_name')+"</th><th>"+navigator.mozL10n.get('app_files_column_size')+"</th><th>"+navigator.mozL10n.get('app_files_column_event')+"</th></tr></thead><tbody id=filescontent>";
     for (var i = 0; i < List.length; i++) {
        //console.log(List[i]);
        size = FileConvertSize(List[i].size);
        fileNameV = fileName(List[i].href,List[i].type, List[i].mime);
        if(size == undefined) size = "";

          content = content + "<tr href=\""+List[i].href+"\" mime=\""+List[i].mime+"\" size=\""+List[i].size+"\" lastModified=\""+List[i].lastModified+"\" type=\""+List[i].type+"\"><td class=\"name-column\">"+ fileNameV + "</td>";
        if(List[i].type == 'file'){
           //Dans le cas d'un file
           content = content + "<td>"+size+"</td>"
                                  +"<td>"
                                  +"<div class=\"dropdown pull-right\"><button class=\"btn btn-default dropdown-toggle\" type=\"button\" id=\"dropdownMenu1\" data-toggle=\"dropdown\" aria-expanded=\"true\">"
                                  +"<span class=\"caret\"></span>"
                                  +"</button>"
                                  +"<ul class=\"dropdown-menu\" role=\"menu\" aria-labelledby=\"dropdownMenu1\">"
                                  +"  <li role=\"presentation\"><a class=\"menu-open\" role=\"menuitem\" tabindex=\"-1\" href=\"#\">Ouvrir</a></li>"
                                  +"  <li role=\"presentation\"><a class=\"menu-download\" role=\"menuitem\" tabindex=\"-1\" href=\"#\">Télécharger</a></li>"
                                  +"  <li role=\"presentation\"><a class=\"menu-delete\" role=\"menuitem\" tabindex=\"-1\" href=\"#\">Supprimer</a></li>"
                                  +"</ul></div>"
                                  +"</td></tr>";
        }else{
          //Dans le cas d'un dossier
          content = content + "<td></td>"
                                  +"<td>"
                                  +"<div class=\"dropdown pull-right\"><button class=\"btn btn-default dropdown-toggle\" type=\"button\" id=\"dropdownMenu1\" data-toggle=\"dropdown\" aria-expanded=\"true\">"
                                  +"<span class=\"caret\"></span>"
                                  +"</button>"
                                  +"<ul class=\"dropdown-menu\" role=\"menu\" aria-labelledby=\"dropdownMenu1\">"
                                  +"  <li role=\"presentation\"><a class=\"folder-open\" role=\"menuitem\" tabindex=\"-1\" href=\"#\">Ouvrir</a></li>"
                                  //+"  <li role=\"presentation\"><a class=\"folder-download\" role=\"menuitem\" tabindex=\"-1\" href=\"#\">Télécharger</a></li>"
                                  +"  <li role=\"presentation\"><a class=\"folder-delete\" role=\"menuitem\" tabindex=\"-1\" href=\"#\">Supprimer</a></li>"
                                  +"</ul></div>"
                                  +"</td></tr>";
        }
     }
     content = content + "</tbody>";
     $("#listFiles").append(content);
     /*$(".nomDrag").draggable({
       axis : 'x'
     });
     $(".nomDrag").droppable({drop : function(){

        alert('Action terminée !');

    }});*/
      
     $("#loading").hide();
      
     //Type d'évènement pour les téléphones
     /*var documentClick;
     $(document).on('touchstart', function() {
      documentClick = true;
     });
     $(document).on('touchmove', function() {
      documentClick = false;
     });*/

     //Evenement sur la dernière colonne pour le menu des actions      
      $('#listFiles tbody td a').on('click', function (e) {
        switch ($(this).attr('class')) {
            case 'menu-open':
                if(!operationEnCours){
                  operationEnCours = true;
                  connection.getResource($(this).closest('tr').attr('href'), function(res, error) {
                      if(res !== null){
                      var open = new MozActivity({
                      name: "open",
                      data: {
                        type: res.get().meta.mime,
                        blob : res.get().data
                      }
                      });
                      open.onsuccess = function (tmp) {
                        operationEnCours = false;
                        console.log("Fichier ouvert avec succès");
                      };
                      open.onerror = function (tmp) {
                        operationEnCours = false;
                        if((""+this.error.name) == 'NO_PROVIDER'){
                          console.log("ERROR : " + this.error.name);
                          alert(navigator.mozL10n.get('app_msg_noprovider'));
                        }else{
                          console.log("ERROR : " + this.error.name);
                          alert("ERROR : " + this.error.name);
                        }
                      };
                    }
                    else{
                      operationEnCours = false;
                      alert(error);
                    }
                  });
                }
                else{
                  alert(navigator.mozL10n.get('app_msg_operation'));
                }
                break;
            case 'menu-download':
                if(!operationEnCours){
                  operationEnCours = true;
                  connection.getResource($(this).closest('tr').attr('href'), function(res, error) {
                    var sdcard = navigator.getDeviceStorage("sdcard");
                    var tab = res.get().meta.href.split("/");
                    var fileName = decodeURIComponent(tab[(tab.length)-1]);
                    var request = sdcard.addNamed(res.get().data, fileName);
                    request.onsuccess = function () {
                      operationEnCours = false;
                      alert(fileName +" "+ navigator.mozL10n.get('app_msg_successwrote'));
                      var name = this.result;                  
                      console.log('File "' + name + '" successfully wrote on the sdcard storage area');
                    }

                    // An error typically occur if a file with the same name already exist
                    request.onerror = function () {
                      operationEnCours = false;
                      alert(navigator.mozL10n.get('app_msg_errorwrote')+ "("+this.error+")");
                      console.warn('Unable to write the file: ' + this.error);
                    }
                  });
                }
                else{
                  alert(navigator.mozL10n.get('app_msg_operation'));
                }
                break;
            case 'menu-delete':
                var tab = $(this).closest('tr').attr('href').split("/");
                var fileName = decodeURIComponent(tab[(tab.length)-1]);
                //console.log(fileName);
                if (confirm(navigator.mozL10n.get('app_msg_confirmdel')+" "+fileName+"?")) {
                  //console.log($(this).closest('tr').attr('href'));
                  connection.delResource($(this).closest('tr').attr('href'), function(res, error) {
                    if(error === undefined){
                      //Pour régler le cas où on est à la racine et que le href est null
                      if(href === null){
                        affichageResource(connection,null);
                        alert(navigator.mozL10n.get('app_msg_filedelete'));  
                      }else{
                        var tab = href.split("/");
                        var result="";
                        for(var i=0; i<(tab.length)-1; i++){
                          result = result+tab[i]+"/";
                        }
                        affichageResource(connection,result);
                        alert(navigator.mozL10n.get('app_msg_filedelete'));  
                      }
                      
                    }else{
                      alert("error : " + error);
                    }
                  });
                }
                break;
            case 'folder-open':
                parentForward($(this).closest('tr').attr('href'));
                affichageResource(connection,$(this).closest('tr').attr('href'));
                break;
            case 'folder-download':
                /*
                //see jszip.js
                var zip = new JSZip();
                zip.file("Hello.txt", "Hello World\n");
                var content = zip.generate({type:"blob"});
                // see FileSaver.js
                saveAs(content, "example.zip");*/
                alert("folder-download");
                break;
            case 'folder-delete':
                var tab = $(this).closest('tr').attr('href').split("/");
                var folderName = decodeURIComponent(tab[(tab.length)-2]);
                //console.log(fileName);
                if (confirm(navigator.mozL10n.get('app_msg_confirmdel')+" "+folderName+"?")) {
                  //console.log($(this).closest('tr').attr('href'));
                  connection.delResource($(this).closest('tr').attr('href'), function(res, error) {
                    if(error === undefined){
                      //Pour régler le cas où on est à la racine et que le href est null
                      if(href === null){
                        affichageResource(connection,null);
                        alert(navigator.mozL10n.get('app_msg_folderdelete'));  
                      }else{
                        var tab = href.split("/");
                        var result="";
                        for(var i=0; i<(tab.length)-1; i++){
                          result = result+tab[i]+"/";
                        }
                        affichageResource(connection,result);
                        alert(navigator.mozL10n.get('app_msg_folderdelete'));  
                      }
                      
                    }else{
                      alert("error : " + error);
                    }
                  });
                }
                break;
        }
      });
 
      //Evenement sur la colonne des noms de fichiers/dossiers
      $('.name-column').on('click', function (e) {

          //Traitement dans le cas d'un dossier
          if($(this).closest('tr').attr('type') == "dir"){
            parentForward($(this).closest('tr').attr('href'));
            affichageResource(connection,$(this).closest('tr').attr('href'));         
          }else{
            //Traitement dans le cas d'un fichier, on récupère ce fichier et on effectue un traitement selon son type
            if(!operationEnCours){
              operationEnCours = true;
              connection.getResource($(this).closest('tr').attr('href'), function(res, error) {
                  if(res !== null){
                    var open = new MozActivity({
                    name: "open",
                    data: {
                      type: res.get().meta.mime,
                      blob : res.get().data
                    }
                    });
                    open.onsuccess = function (tmp) {
                      operationEnCours = false;
                      console.log("Fichier ouvert avec succès");
                    };
                    open.onerror = function (tmp) {
                      operationEnCours = false;
                      if((""+this.error.name) == 'NO_PROVIDER'){
                        console.log("ERROR : " + this.error.name);
                        alert(navigator.mozL10n.get('app_msg_noprovider'));
                      }else{
                        console.log("ERROR : " + this.error.name);
                        alert("ERROR : " + this.error.name);
                      }
                    };
                  }
                  else{
                    operationEnCours = false;
                    alert(error);
                  }
                  
              });
            }
            else{
              alert(navigator.mozL10n.get('app_msg_operation'));
            }
          }
      });
    });
  }
  
  //Fonction pour l'affichage des noms de dossiers/fichiers
  function fileName(chaineBrute,type, mime){
    
    var n, img;
    
    //Décalage pour le split car les dossiers ont un "/" en plus
    if(type == "dir"){
      n=2;   
    }else{
      n=1;
    }
    
    //Choix de l'image selon le type de fichier
    if(type == "dir"){
      img="<img src=\"img/files/directory.png\"></img> ";
    }else if(mime.split("/")[0] == "audio"){
      img="<img src=\"img/files/music.png\"></img> ";
    }else if(mime.split("/")[0] == "video"){
      img="<img src=\"img/files/film.png\"></img> ";
    }else if(mime == "application/pdf"){
      img="<img src=\"img/files/pdf.png\"></img> ";
    }else if(mime.split("/")[0] == "image"){
      img="<img src=\"img/files/picture.png\"></img> ";
    }else if(mime.split("/")[0] == "text"){
      img="<img src=\"img/files/txt.png\"></img> ";
    }else{
      img="<img src=\"img/files/file.png\"></img> ";
    }
    
    //Construction du nom
    var tab=chaineBrute.split("/");
    var chaine = decodeURIComponent(tab[(tab.length)-n]);
    
    return img+chaine;
  }
  
  
  //Fonction qui convertie un nombre d'octets en ko, Mo, Go, To
  function FileConvertSize(aSize){
    if(aSize == 0){
      return "0 ko"
    }
    else{
      aSize = Math.abs(parseInt(aSize, 10));
      var def = [[1, 'octets'], [1024, 'ko'], [1024*1024, 'Mo'], [1024*1024*1024, 'Go'], [1024*1024*1024*1024, 'To']];
      for(var i=0; i<def.length; i++){
        if(aSize<def[i][0]) return (aSize/def[i-1][0]).toFixed(2)+' '+def[i-1][1];
      }
    }
  }
  
  function parentForward(href){
    cpt++;
    var tab = href.split("/");
    var result="";
    for(var i=0; i<(tab.length)-1; i++){
      result = result+tab[i]+"/";
    }
    localStorage.setItem('back',result);
  }
  
  function parentBackward(href){
    if(cpt != 0){
      cpt--;
      var tab = href.split("/");
      var result="";
      for(var i=0; i<(tab.length)-2; i++){
        result = result+tab[i]+"/";
      }
      localStorage.setItem('back',result);
    }
  }

  return {
    init: init
  };

}();

Connection.init();
