'use strict';

var Settings = function Settings() {
  
  
  var init = function init() {
    
    //Affichage de la liste des servers existant
    if(localStorage.getItem("servers") === null){
      var content = "<p>no server</p>";
      $("#serversList").append(content);
    }
    else{
      //On affiche les serveurs sauvegardés dans le localStorage
      var servers = JSON.parse(localStorage.getItem("servers"));
      if(servers.length == 0){
        var content = "<p>no servers</p>";
        $("#serversList").append(content);
      }
      else{
        var content = "";
        content = content + "<table id=\"tabServers\">";
        for (var i = 0; i < servers.length; i++) {
          content = content + "<tr><td>" + servers[i].name + "</td>"+"<td>"+servers[i].user+"</td><td class=\"modif-column\" serverName=\""+servers[i].name+"\"><a href=\"#\" class=\"btn btn-default\"><span class=\"glyphicon glyphicon-pencil\"></span>  </a></td><td class=\"del-column\" serverName=\""+servers[i].name+"\"><a href=\"#\" class=\"btn btn-default\"><span class=\"glyphicon glyphicon-trash\"></span>  </a></td></tr>";
        }
        
        content = content + "</table>";
        $("#serversList").append(content);
      }
    }
    
    //Bouton qui permet de sauvegarder ou modifier une configuration de serveur
    $('#save').on('click', function (e) {
      //On récupère la liste des serveues ou on initialise un Array si la liste n'existe pas
      var servers;
      if(localStorage.getItem("servers") === null){
         servers = new Array();
       }
       else{
         servers = JSON.parse(localStorage.getItem("servers"));
       }
      
       //On parcourt les serveurs pour vérifier s'il existe ou pas, si oui on le modifie
       var ajouter = true;
       for(i=0;i<servers.length;i++){
          if(servers[i].name == document.getElementById('name').value){
            servers[i].name = document.getElementById('name').value;
            servers[i].url = document.getElementById('url').value;
            servers[i].user = document.getElementById('user').value;
            servers[i].password = document.getElementById('passwd').value;  
            ajouter = false;
            break;
          }
        }
      
       //Si le nom de serveur  n'existe pas on le crée et on le push dans le Array
       if(ajouter){
         var ajout = {
            name : document.getElementById('name').value,
            url : document.getElementById('url').value,
            user : document.getElementById('user').value,
            password : document.getElementById('passwd').value
         };
         servers.push(ajout);
       }   
       localStorage.setItem("servers",JSON.stringify(servers));
       alert(navigator.mozL10n.get('app_msg_configsave'));
    });
    
    //Bouton qui efface les éléments dans le formulaire
    $('#clear').on('click', function (e) {
      document.getElementById('name').value = "";
      document.getElementById('url').value = "";
      document.getElementById('user').value = "";
      document.getElementById('passwd').value = "";
    });
    
    //Bouton qui supprime les informations du server en question
    $('.del-column').on('click', function (e) {
      var serverName = $(this).attr('serverName');
      
      if(confirm(navigator.mozL10n.get('app_settings_delserver')+" "+$(this).attr('serverName') + " ?")){
        var servers = JSON.parse(localStorage.getItem("servers"));
        var i,indice;
        for(i=0;i<servers.length;i++){
          if(servers[i].name == serverName){
            indice = i;
            break;
          }
        }
        servers.splice(indice,1);
        localStorage.setItem("servers",JSON.stringify(servers));
        location.reload();
      }
      
    });
    
    //Bouton qui permet de copier les informations d'un server de la liste pour le modifier ou ajouter un autre serveur du même type
    $('.modif-column').on('click', function (e) {
      var serverName = $(this).attr('serverName');
      for(i=0;i<servers.length;i++){
          if(servers[i].name == serverName){
            document.getElementById('name').value = servers[i].name;
            document.getElementById('url').value = servers[i].url;
            document.getElementById('user').value = servers[i].user;
            document.getElementById('passwd').value = servers[i].password;
            break;
          }
        }
    });
    
  }

  return {
    init: init
  };

}();

Settings.init();