//published by Thorsten Zahn unter the terms of the Mozilla Public License (MPL) v2.0

var stream_list_db_name;
var zoom=1;
var actual_stream_edit_name;
var track_name_width;
var track_name_timer_id;
var stream_error_timer_id;
var track_name_tick=0;
var track_name_per_tick=0.25;
var track_name_still_ticks=100;
var actual_stream="";
var global_stream=false;
var box_shadow_color ="";

var wifi_lock = null;

var error_count = 0;
var error_time = 0;
var error_semikolon = false;

var list_size=20;

var change_page_time = 0;


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onload
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onload(){
  console.log("Webradio Player startet");
  
  //Language
  localize();
  
  //Streams
  try{
    localStorage;
  } catch (e) {
    alert(lang_localstorage_not_available);
  }
  var stream_list = document.getElementById("stream_list");
  
  stream_list_db_name = localStorage.getItem("stream_list_db_name");
  if(stream_list_db_name==null || stream_list_db_name=="")
    stream_list_db_name=new Array();
  else
    stream_list_db_name = stream_list_db_name.split('#|#');
  
  for (var i = 0; i < stream_list_db_name.length; i++){
    var name = stream_list_db_name[i];
    var URL = localStorage.getItem("stream_list_db_"+name);
    add_URL(URL, name);
  }
  
  zoom = localStorage.getItem("db_zoom");
  if(zoom==null || zoom=="")
    zoom=1;
  
  var version = localStorage.getItem("db_version");
  if(version != "4"){
    localStorage.setItem("db_version","4");
    onclick_button_whats_new();
  }
  
  
  list_size = localStorage.getItem("db_list_size");
  if(list_size==null || list_size=="")
    list_size = 20;
  else
    list_size*=1;
  
  
  onresize();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_play_URL
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_play_URL(URL,name) {
  if(document.getElementById("stream_list_button_"+name).textContent==lang_play){
    global_stream=false;
    
    actual_stream = name;
    
    manage_play(URL);
    
    for(var i = 0; i < stream_list_db_name.length; i++){
      document.getElementById("stream_list_button_"+stream_list_db_name[i]).textContent=lang_play;
      document.getElementById("stream_list_button_"+stream_list_db_name[i]).style.boxShadow = "";
    }
    document.getElementById("stream_list_button_"+name).textContent=lang_pause;
  }
  else{
    manage_pause();
    
    document.getElementById("stream_list_button_"+name).style.boxShadow = "";
    document.getElementById("stream_list_button_"+name).textContent=lang_play;
  }
}

function manage_play(URL){
    clearTimeout(stream_error_timer_id);
    
    var audio = document.getElementById("audio");
    audio.src = URL;
    audio.play();
    
    error_count = 0;
    error_semikolon = false;
    
    if(window.navigator.requestWakeLock){
      if(wifi_lock != null)
        wifi_lock.unlock();
      wifi_lock = window.navigator.requestWakeLock("wifi");
    }
}

function manage_pause(){
    clearTimeout(stream_error_timer_id);
  
    actual_stream = "";
    
    document.getElementById("audio").pause();
    document.getElementById("audio").src = null;
    if(window.navigator.requestWakeLock){
      wifi_lock.unlock();
      wifi_lock = null;
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_add_URL
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_add_URL() {
  var URL  = document.getElementById("stream_URL").value;
  var name = document.getElementById("stream_name").value;
  
  if(name=="" || URL == "")
    alert(lang_empty_input);
  else{
    if(!document.getElementById("stream_URL").validity.valid || !document.getElementById("stream_name").validity.valid)
      alert(lang_stream_invalid);
    else{
      var error = false;
      for(var i=0; i<stream_list_db_name.length; i++){
        if(name == stream_list_db_name[i])
          error = true;
        if(localStorage.getItem("stream_list_db_"+stream_list_db_name[i]) == URL)
          error = true;
      }
      
      if(error)
        alert(lang_stream_existing);
      else{
        if(check_m3u(URL, "add") || check_xspf(URL, "add"))
          return;
        
        finish_add_URL(URL, name);
      }
    }
  }
}

function finish_add_URL(URL, name){
  add_URL(URL, name);

  onresize();

  stream_list_db_name.push(name);
  localStorage.setItem("stream_list_db_name",dbArrayToString(stream_list_db_name));
  localStorage.setItem("stream_list_db_"+name,URL);

  document.getElementById("table_menu").style.display="inline-table";
  document.getElementById("table_add") .style.display="none";
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//dbArrayToString
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function dbArrayToString(dbArray){
  var result = "";
  
  if(dbArray.length >0)
    result+=dbArray[0];
  
  for (var i = 1; i < dbArray.length; i++)
    result+="#|#"+dbArray[i];
  
  return result;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//add_URL
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function add_URL(URL, name){
  var stream_list = document.getElementById("stream_list");
    var tr = document.createElement("tr");
    tr.setAttribute("id","stream_list_"+name);
      var td1 = document.createElement("td");
      td1.textContent = name;
      td1.setAttribute("class","stream_list_td_stream_name");
    tr.appendChild(td1);
      var td2 = document.createElement("td");
      td2.setAttribute("class","stream_list_td_play");
        var button1 = document.createElement("button");
        button1.setAttribute("id","stream_list_button_"+name);
        button1.setAttribute("class","stream_list_button_play");
        button1.textContent = lang_play;
        button1.addEventListener("click", function(){ onclick_play_URL(URL, name) });
      td2.appendChild(button1);
    tr.appendChild(td2);
      var td3 = document.createElement("td");
      td3.setAttribute("class","stream_list_td_delete_inv");
        var button2 = document.createElement("button");
        button2.textContent = lang_delete;
        button2.addEventListener("click", function(){ onclick_delete_list_item(name) });
        button2.setAttribute("class","stream_list_button_delete");
      td3.appendChild(button2);
    tr.appendChild(td3);
      var td4 = document.createElement("td");
      td4.setAttribute("class","stream_list_td_move_inv");
        var button3 = document.createElement("button");
        button3.textContent = "▲";
        button3.addEventListener("click", function(){ onclick_move_list_item_up(name) });
        button3.setAttribute("class","stream_list_button_move");
      td4.appendChild(button3);
    tr.appendChild(td4);
      var td5 = document.createElement("td");
      td5.setAttribute("class","stream_list_td_move_inv");
        var button4 = document.createElement("button");
        button4.textContent = "▼";
        button4.addEventListener("click", function(){ onclick_move_list_item_down(name) });
        button4.setAttribute("class","stream_list_button_move");
      td5.appendChild(button4);
    tr.appendChild(td5);
      var td6 = document.createElement("td");
      td6.setAttribute("class","stream_list_td_edit_inv");
        var button5 = document.createElement("button");
        button5.textContent = lang_edit;
        button5.addEventListener("click", function(){ onclick_edit_list_item(name) });
        button5.setAttribute("class","stream_list_button_edit");
      td6.appendChild(button5);
    tr.appendChild(td6);
      var td7 = document.createElement("td");
      td7.setAttribute("class","stream_list_td_share_inv");
        var div = document.createElement("div");
        div.setAttribute("class","stream_list_checkbox_share_div");
          var input = document.createElement("input");
          input.textContent = "";
          input.setAttribute("class","stream_list_checkbox_share");
          input.setAttribute("type","checkbox");
          input.setAttribute("checked","true");
          input.setAttribute("id","stream_list_checkbox_share_"+name);
        div.appendChild(input);
          var label = document.createElement("label");
          label.setAttribute("for","stream_list_checkbox_share_"+name);
          label.setAttribute("class","stream_list_checkbox_share_label");
        div.appendChild(label);
      td7.appendChild(div);
    tr.appendChild(td7);
      var td8 = document.createElement("td");
      td8.setAttribute("class","stream_list_td_share_global_inv");
        var button6 = document.createElement("button");
        button6.textContent = lang_share_global;
        button6.addEventListener("click", function(){ onclick_upload_global_list_item(name) });
        button6.setAttribute("class","stream_list_button_upload_global");
      td8.appendChild(button6);
    tr.appendChild(td8);
  stream_list.appendChild(tr);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_delete_list_item
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_delete_list_item(name){
  if(confirm(lang_stream_confirm_delete.replace("%STREAM%",name))){
    document.getElementById("stream_list").removeChild(document.getElementById("stream_list_"+name));
    
    var index = stream_list_db_name.indexOf(name);
    var newdb = stream_list_db_name.slice(0,index) . concat(stream_list_db_name.slice(index+1,stream_list_db_name.length));    
    stream_list_db_name = newdb;
    localStorage.setItem("stream_list_db_name",dbArrayToString(stream_list_db_name));
    localStorage.removeItem("stream_list_db_"+name);
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_move_list_item_up
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_move_list_item_up(name){
  var index = stream_list_db_name.indexOf(name);
  if(index==0)
    return;
  var newdb = stream_list_db_name.slice(0,index-1) . concat(stream_list_db_name[index]) . concat(stream_list_db_name[index-1]) . concat(stream_list_db_name.slice(index+1,stream_list_db_name.length));    
  stream_list_db_name = newdb;
  localStorage.setItem("stream_list_db_name",dbArrayToString(stream_list_db_name));
  
  rebuild_list_item_after_move();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_move_list_item_down
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_move_list_item_down(name){
  var index = stream_list_db_name.indexOf(name);
  if(index==stream_list_db_name.length-1)
    return;
  var newdb = stream_list_db_name.slice(0,index) . concat(stream_list_db_name[index+1]) . concat(stream_list_db_name[index]) . concat(stream_list_db_name.slice(index+2,stream_list_db_name.length));    
  stream_list_db_name = newdb;
  localStorage.setItem("stream_list_db_name",dbArrayToString(stream_list_db_name));
  
  rebuild_list_item_after_move();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//rebuild_list_item_after_move
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function rebuild_list_item_after_move(){
  while(document.getElementById("stream_list").hasChildNodes())
    document.getElementById("stream_list").removeChild(document.getElementById("stream_list").firstChild);
  
  for (var i = 0; i < stream_list_db_name.length; i++){
    var name = stream_list_db_name[i];
    var URL = localStorage.getItem("stream_list_db_"+name);
    add_URL(URL, name);
  }
  
  onresize();

  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_move_inv")
      element.setAttribute("class","stream_list_td_move");
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_edit_list_item
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_edit_list_item(name){
  document.getElementById("table_edit").style.display="none";
  document.getElementById("table_do_edit").style.display="inline-table";
  
  document.getElementById("stream_name_edit").value = name;
  document.getElementById("stream_URL_edit") .value = localStorage.getItem("stream_list_db_"+name);
  actual_stream_edit_name = name;
}

//onclick_edit_URL
function onclick_edit_URL(){  
  var index = stream_list_db_name.indexOf(actual_stream_edit_name);
  var URL   = document.getElementById("stream_URL_edit").value;
  var name  = document.getElementById("stream_name_edit").value;
  
  if(name=="" || URL=="")
    alert(lang_empty_input);
  else{
  if(!document.getElementById("stream_URL_edit").validity.valid || !document.getElementById("stream_name_edit").validity.valid)
    alert(lang_stream_invalid);
  else{
    var error = false;
    for(var i=0; i<stream_list_db_name.length; i++)
      if(name == stream_list_db_name[i] && i!=index)
        error = true;
      if(error)
        alert(lang_stream_existing);
      else{
        if(check_m3u(URL, "edit") || check_xspf(URL, "edit"))
          return;
        
        finish_edit_URL(URL, name, index);
      }
    }
  }
}

function finish_edit_URL(URL, name, index){
  document.getElementById("table_edit")   .style.display="inline-table";
  document.getElementById("table_do_edit").style.display="none";

  stream_list_db_name[index]=name;
  localStorage.setItem   ("stream_list_db_name",dbArrayToString(stream_list_db_name));
  localStorage.removeItem("stream_list_db_"+actual_stream_edit_name);
  localStorage.setItem   ("stream_list_db_"+name,URL);

  while(document.getElementById("stream_list").hasChildNodes())
    document.getElementById("stream_list").removeChild(document.getElementById("stream_list").firstChild);


  for (var i = 0; i < stream_list_db_name.length; i++){
    var name = stream_list_db_name[i];
    var URL = localStorage.getItem("stream_list_db_"+name);
    add_URL(URL, name);
  }

  onresize();

  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_edit_inv")
      element.setAttribute("class","stream_list_td_edit");
    if (element.className == "stream_list_td_play")
      element.setAttribute("class","stream_list_td_play_inv");
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_zoom
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_zoom_in(){
  zoom*=0.9;  
  localStorage.setItem("db_zoom", zoom);  
  onresize();
}
function onclick_button_zoom_out(){
  zoom*=1.1111111111111111111;  
  localStorage.setItem("db_zoom", zoom);  
  onresize();
}
function onclick_button_zoom_100(){
  zoom=1;  
  localStorage.setItem("db_zoom", zoom);  
  onresize();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_add_URL
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_add_URL(){
  document.getElementById("table_menu").style.display="none";
  document.getElementById("table_add") .style.display="inline-table";
  document.getElementById("stream_URL").value = "";
  document.getElementById("stream_name").value = "";
}
//onclick_cancel_add
function onclick_cancel_add(){
  document.getElementById("table_menu")  .style.display="inline-table";
  document.getElementById("table_add")   .style.display="none";
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_delete_URL
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_delete_URL(){
  document.getElementById("table_menu")  .style.display="none";
  document.getElementById("table_delete").style.display="inline-table";  
  //stream_list_td_delete
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_delete_inv")
      element.setAttribute("class","stream_list_td_delete");
  }
  hide_play();
}
//onclick_close_delete
function onclick_close_delete(){
  document.getElementById("table_menu")  .style.display="inline-table";
  document.getElementById("table_delete").style.display="none";
  //stream_list_td_delete
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_delete")
      element.setAttribute("class","stream_list_td_delete_inv");
  }
  show_play();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_move_URL
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_move_URL(){
  document.getElementById("table_menu").style.display="none";
  document.getElementById("table_move").style.display="inline-table";  
  //stream_list_td_move
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_move_inv")
      element.setAttribute("class","stream_list_td_move");
  }
  hide_play();
}
//onclick_close_move
function onclick_close_move(){
  document.getElementById("table_menu")  .style.display="inline-table";
  document.getElementById("table_move").style.display="none";
  //stream_list_td_move
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_move")
      element.setAttribute("class","stream_list_td_move_inv");
  }
  show_play();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_edit_URL
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_edit_URL(){
  document.getElementById("table_menu").style.display="none";
  document.getElementById("table_edit").style.display="inline-table";
  //stream_list_td_edit
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_edit_inv")
      element.setAttribute("class","stream_list_td_edit");
  }
  hide_play();
}
//onclick_close_edit
function onclick_close_edit(){
  document.getElementById("table_menu").style.display="inline-table";
  document.getElementById("table_edit").style.display="none";
  //stream_list_td_edit
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_edit")
      element.setAttribute("class","stream_list_td_edit_inv");
  }
  show_play();
}
//onclick_cancel_edit
function onclick_cancel_edit(){
  document.getElementById("table_edit")   .style.display="inline-table";
  document.getElementById("table_do_edit").style.display="none";
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//hide_play
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function hide_play(){
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_play")
      element.setAttribute("class","stream_list_td_play_inv");
  }  
}
function show_play(){
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_play_inv")
      element.setAttribute("class","stream_list_td_play");
  }  
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_about
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_about(){
  document.getElementById("table_about")  .style.display="inline-table";
  document.getElementById("table_menu")   .style.display="none";
  
  if(window.navigator.language.indexOf('de')!=-1){
    document.getElementById("about_content_de").style.display="inline-table";
    document.getElementById("stream_list")     .style.display="none";
    document.getElementById("guide_de")        .style.display="none";
    document.getElementById("whats_new_de")    .style.display="none";
  }
  else{
    document.getElementById("about_content_en").style.display="inline-table";
    document.getElementById("stream_list")     .style.display="none";
    document.getElementById("guide_en")        .style.display="none";
    document.getElementById("whats_new_en")    .style.display="none";
  }
}
//onclick_close_about
function onclick_close_about(){
  document.getElementById("table_menu")   .style.display="inline-table";
  document.getElementById("table_about")  .style.display="none";
  
  if(window.navigator.language.indexOf('de')!=-1){
    document.getElementById("stream_list")     .style.display="inline-table";
    document.getElementById("about_content_de").style.display="none";
    
    document.getElementById("whats_new_de")    .style.display="none";
    document.getElementById("guide_de")        .style.display="none";
  }
  else{
    document.getElementById("stream_list")     .style.display="inline-table";
    document.getElementById("about_content_en").style.display="none";
    
    document.getElementById("whats_new_en")    .style.display="none";
    document.getElementById("guide_en")        .style.display="none";
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_zoom
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_zoom(){
  document.getElementById("table_zoom").style.display="inline-table";
  document.getElementById("table_menu").style.display="none";
  
  lang = localStorage.getItem("db_app_language");
  if(lang==null)
    if(window.navigator.language.indexOf('de')!=-1)
      lang = "De";
    else
      lang = "En";
  
  document.getElementById("select_app_language").value = lang;
  document.getElementById("select_list_size").value = list_size;
  if(localStorage.getItem("db_allow_m3u")=="true")
    document.getElementById("cb_allow_m3u").checked = true;
  if(localStorage.getItem("db_allow_share")=="true")
    document.getElementById("cb_allow_share").checked = true;
}

function onclick_close_zoom(){
  document.getElementById("table_menu").style.display="inline-table";
  document.getElementById("table_zoom").style.display="none";
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_share
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_share(){
  document.getElementById("table_share").style.display="inline-table";
  document.getElementById("table_menu") .style.display="none";
  
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
  var element = elements[i];
  if (element.className == "stream_list_td_share_inv")
    element.setAttribute("class","stream_list_td_share");
  }
  
  hide_play();
  
  var remote_share_id = localStorage.getItem("db_remote_share_id");
  if(remote_share_id == null)
    remote_share_id = "";
  document.getElementById("remote_share_id").value=remote_share_id;
}

function onclick_close_share(){
  document.getElementById("table_menu").style.display="inline-table";
  document.getElementById("table_share").style.display="none";
  
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
  var element = elements[i];
  if (element.className == "stream_list_td_share")
    element.setAttribute("class","stream_list_td_share_inv");
  }
  
  show_play();  
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_share_global
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_share_global(){
  document.getElementById("table_share_global").style.display="inline-table";
  document.getElementById("table_menu").style.display="none";
  
  init_global_list();
  
  document.getElementById("stream_list_global").style.display="inline-table";
  document.getElementById("stream_list_global_loading").style.display="inline-table";
  document.getElementById("stream_list_global_menu").style.display="inline-table";
  document.getElementById("stream_list").style.display="none";
}

function onclick_close_share_global(){
  document.getElementById("table_menu").style.display="inline-table";
  document.getElementById("table_share_global").style.display="none"; 
  
  document.getElementById("stream_list").style.display="inline-table";
  document.getElementById("stream_list_global").style.display="none";
  document.getElementById("stream_list_global_loading").style.display="none";
  document.getElementById("stream_list_global_menu").style.display="none";
}



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_upload_share
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_upload_share(){
  
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_download_share
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_download_share(){
  localStorage.setItem("db_remote_share_id",document.getElementById("remote_share_id").value);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_whats_new
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_whats_new(){
  document.getElementById("table_menu")   .style.display="none";
  document.getElementById("table_about")  .style.display="inline-table";
  
  if(window.navigator.language.indexOf('de')!=-1){
    document.getElementById("stream_list")     .style.display="none";
    document.getElementById("about_content_de").style.display="none";
    document.getElementById("guide_de")        .style.display="none";
    document.getElementById("whats_new_de")    .style.display="inline-table";
  }
  else {
    document.getElementById("stream_list")     .style.display="none";
    document.getElementById("about_content_en").style.display="none";
    document.getElementById("guide_en")        .style.display="none";
    document.getElementById("whats_new_en")    .style.display="inline-table";
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_guide
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_button_guide(){
  document.getElementById("table_menu")   .style.display="none";
  document.getElementById("table_about")  .style.display="inline-table";
  
  if(window.navigator.language.indexOf('de')!=-1){
    document.getElementById("stream_list")     .style.display="none";
    document.getElementById("about_content_de").style.display="none";
    document.getElementById("whats_new_de")    .style.display="none";
    document.getElementById("guide_de")        .style.display="inline-table";
  }
  else {
    document.getElementById("stream_list")     .style.display="none";
    document.getElementById("about_content_en").style.display="none";
    document.getElementById("whats_new_en")    .style.display="none";
    document.getElementById("guide_en")        .style.display="inline-table";
  }
}



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//getMetadata
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function getMetadata(){
  console.log("mozGetMetadata():");
  var meta = document.getElementById("audio").mozGetMetadata();
  if(meta.title)
    document.getElementById("div_track").textContent = lang_title+": " + meta.title;
  else if(meta.TITLE)
    document.getElementById("div_track").textContent = lang_title+": " + meta.TITLE;
  else
    document.getElementById("div_track").textContent = lang_title+": " + lang_unknown;
  console.log(meta);
  
  var mText = document.getElementById("messureText");
  mText.textContent    = document.getElementById("div_track").textContent;
  mText.style.fontSize = document.getElementById("div_track").style.fontSize;
  track_name_width = mText.clientWidth;
  
  clearTimeout(track_name_timer_id);
  track_name_tick=0;
  if(track_name_width > document.getElementById("div_track").clientWidth){
    animate_track_name();
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//stream_error
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function stream_error(){
  var URL = document.getElementById("audio").src;
  var newURL = false;
  
  if(!error_semikolon){
    if((new Date()).getTime() - error_time > 5000){
      error_count = 0;
    }
    error_time = (new Date()).getTime();

    if(error_count == 0){
      if(URL.indexOf(";")!=-1)
        error_semikolon = true;
      else{
        if(URL[URL.length-1] == "/")
          URL += ";";
        else
          URL += "/;";
        document.getElementById("audio").src = URL;
        document.getElementById("audio").play();
        newURL = true;
      }
    }
    else{
      if(URL.indexOf(";")!=-1){
        URL = URL.replace(";","");
        document.getElementById("audio").src = URL;
        document.getElementById("audio").play();
      newURL = true;
      }
    }
  }
  
  if(!newURL && error_count<6000)
    stream_error_timer_id = window.setTimeout(handle_stream_error,1000);

  error_count++;
}

function handle_stream_error(){
  var src = document.getElementById("audio").src;
  document.getElementById("audio").src = 'data:audio/wav;base64,UklGRiQAAABXQVZFZm10IBAAAAABAAEAVFYAAFRWAAABAAgAZGF0YQAAAAA=';
  document.getElementById("audio").src = src;
  document.getElementById("audio").play();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//stream_loadstart
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function stream_loadstart(){
  if(actual_stream!=""){
    var shadow_width = 5*zoom*window.innerWidth/320;
    box_shadow_color = "rgba(255, 128, 0, 0.5)";
    if(global_stream)
        document.getElementById("stream_list_global_button_"+actual_stream).style.boxShadow = "0px 0px "+shadow_width+"px "+shadow_width+"px "+box_shadow_color;
    else
        document.getElementById("stream_list_button_"+actual_stream).style.boxShadow = "0px 0px "+shadow_width+"px "+shadow_width+"px "+box_shadow_color;
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//stream_canplay
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function stream_canplay(){
  if(actual_stream!=""){
    var shadow_width = 5*zoom*window.innerWidth/320;
    box_shadow_color = "rgba(0, 255, 0, 0.5)";
    if(global_stream)
        document.getElementById("stream_list_global_button_"+actual_stream).style.boxShadow = "0px 0px "+shadow_width+"px "+shadow_width+"px "+box_shadow_color;
    else
        document.getElementById("stream_list_button_"+actual_stream).style.boxShadow = "0px 0px "+shadow_width+"px "+shadow_width+"px "+box_shadow_color;
  }
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//animate_track_name
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function animate_track_name(){
  track_name_timer_id = window.setTimeout(animate_track_name,20);
  
  var div = document.getElementById("div_track");
  var max = track_name_width-div.clientWidth;
  var maxtick = max / (track_name_per_tick * (zoom*window.innerWidth/320)) + 2 * track_name_still_ticks;
  
  var x;
  if      (track_name_tick <= track_name_still_ticks) x = 0;
  else if (track_name_tick > (track_name_still_ticks + max / (track_name_per_tick * (zoom*window.innerWidth/320))) )x = max;
  else x = (track_name_tick - track_name_still_ticks) * track_name_per_tick * ( zoom*window.innerWidth/320);
  
  div.style.textIndent = -x + "px";
  
  track_name_tick++;
  if(track_name_tick>maxtick)
    track_name_tick = 0;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//check_input
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function check_input(element, min_length){
  if(element.validity.typeMismatch){
    element.setCustomValidity("typeMismatch");
    return;
  }
  var text = element.value;
  if(text.length<min_length)
    element.setCustomValidity("Invalid Length (<"+min_length+")");
  //else if(text.indexOf(";")!=-1)
  //  element.setCustomValidity("Invalid Character: ;");
  else if(text.indexOf("'")!=-1)
    element.setCustomValidity("Invalid Character: '");
  else if(text.indexOf("\"")!=-1)
    element.setCustomValidity("Invalid Character: \"");
  else if(text.indexOf("<")!=-1)
    element.setCustomValidity("Invalid Character: <");
  else if(text.indexOf(">")!=-1)
    element.setCustomValidity("Invalid Character: >");
  else if(text.indexOf("=")!=-1)
    element.setCustomValidity("Invalid Character: =");
  else if(text.indexOf("?")!=-1)
    element.setCustomValidity("Invalid Character: ?");
  else if(text.indexOf("$")!=-1)
    element.setCustomValidity("Invalid Character: $");
  else if(text.indexOf("&")!=-1)
    element.setCustomValidity("Invalid Character: &");
  else
    element.setCustomValidity("");
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//check_input_share_id
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function check_input_share_id(element, min_length, words=0){
  var text = element.value;
  if(text.length<min_length)
    element.setCustomValidity("Invalid Length (<"+min_length+")");
  else{
    element.setCustomValidity("");
    var valid_chars = "0123456789abcdef";
    for(var i1=0; i1<10; i1++){
      var invalid = true;
      for(var i2=0; i2<16; i2++)
        if(text[i1] == valid_chars[i2])
          invalid = false;
      if(invalid)
        element.setCustomValidity("Invalid Character: "+text[i1]);
    }
    if(text.split(' ').length <words)
      element.setCustomValidity("Not enough words");
  }
}



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_upload_share_global
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_upload_share_global(){
  document.getElementById("table_upload_share_global").style.display="inline-table";
  document.getElementById("table_share_global").style.display="none"; 
  
  //stream_list_td_edit
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_share_global_inv")
      element.setAttribute("class","stream_list_td_share_global");
  }
  hide_play();
  
  document.getElementById("stream_list").style.display="inline-table";
  document.getElementById("stream_list_global") .style.display="none";
  document.getElementById("stream_list_global_loading") .style.display="none";
  document.getElementById("stream_list_global_menu") .style.display="none";
}

function onclick_abort_upload_share_global(){
  document.getElementById("table_share_global").style.display="inline-table";
  document.getElementById("table_upload_share_global").style.display="none";
  
  //stream_list_td_edit
  var elements = document.getElementsByTagName("td");
  for(var i=0; i<elements.length; i++){
    var element = elements[i];
    if (element.className == "stream_list_td_share_global")
      element.setAttribute("class","stream_list_td_share_global_inv");
  }
  show_play();
  
  document.getElementById("button_upload_share_global_upload").disabled = true;
  document.getElementById("upload_share_global_tag").disabled = true;
  document.getElementById("upload_share_global_language").disabled = true;
  
  document.getElementById("stream_list_global").style.display="inline-table";
  document.getElementById("stream_list_global_menu") .style.display="inline-table";
  document.getElementById("stream_list") .style.display="none";
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_global_share_options_close
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_global_share_options_close(){
  document.getElementById("table_global_share_options").style.display="none";
  document.getElementById("table_share_global").style.display="inline-table";
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_global_share_options_edit_close
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_global_share_options_edit_close(){
  document.getElementById("table_global_share_options_edit").style.display="none";
  document.getElementById("table_global_share_options").style.display="inline-table";
}


//onclick_global_share_options_report_cancel
function onclick_global_share_options_report_cancel(){
  document.getElementById("table_global_share_options_report").style.display="none";
  document.getElementById("table_global_share_options").style.display="inline-table";
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_upload_global_list_item
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_upload_global_list_item(name){
  document.getElementById("button_upload_share_global_upload").disabled = false;
  document.getElementById("upload_share_global_tag").disabled = false;
  document.getElementById("upload_share_global_language").disabled = false;
  document.getElementById("upload_share_global_name").value = name;
  document.getElementById("upload_share_global_tag").value = "";
  document.getElementById("upload_share_global_language").value = "other";
  
  update_language_list(document.getElementById("upload_share_global_language"),[["other",lang_other]])
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_upload_share_global_upload
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_upload_share_global_upload(){
  upload_stream_global();
  
  document.getElementById("button_upload_share_global_upload").disabled = true;
  document.getElementById("upload_share_global_tag").disabled = true;
  document.getElementById("upload_share_global_language").disabled = true;
  document.getElementById("upload_share_global_name").value = "";
  document.getElementById("upload_share_global_tag").value = "";
  document.getElementById("upload_share_global_language").value = "other";
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//check_m3u
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function check_m3u(URL, type, args){
  var allow_m3u = localStorage.getItem("db_allow_m3u");
  if(allow_m3u == "true")
    allow_m3u = true;
  else if(allow_m3u != null)
    allow_m3u = false;
  
  if(URL.toLowerCase().indexOf('.m3u')!=-1 || URL.toLowerCase().indexOf('.pls')!=-1){
    if(!allow_m3u && !confirm(lang_m3u_confirm)){
      return true;
    }
    if(allow_m3u==null)
      if(confirm(lang_save_allow_share))
        localStorage.setItem("db_allow_m3u","true");
      else
        localStorage.setItem("db_allow_m3u","false");
      
    //m3u abrufen
    var req = null;
    try {
      req = new XMLHttpRequest({mozSystem: true});
    }
    catch (e) {
      try {
        req = new ActiveXObject("Msxml2.XMLHTTP");
      }
      catch (e) {
        try {
          req = new ActiveXObject("Microsoft.XMLHTTP");
        }
        catch (failed) {
          req = null;
        }
      }
    }

    if (req == null){
      alert("Error creating request object!");
      return null;
    }

    req.open("GET", URL, true);

    req.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
    
    req.onreadystatechange = function(){handle_get_m3u(req, type, args)};
    req.send(null);
    
    return true;
  }
  return false;
}

function handle_get_m3u(req, type, args){
  switch (req.readyState) {
    case 2:
      return;
      break;
    case 3:
      return;
      break;
    case 4:
      if (req.status != 200) {
        alert(lang_error_status + req.status + "!");
      } else {
        var m3u = req.responseText;
        
        var lines = m3u.split("\n");
        
        var nlines = [];
        for(var i=0; i<lines.length; i++)
          if(lines[i].indexOf('://')!=-1)
            nlines.push(lines[i].replace(/file.=/i, ""));
        
        var URL;
        if(nlines.length==0){
          alert(lang_no_m3u);
          return;
        }
        else if(nlines.length==1)
          URL = nlines[0];
        else{  
          var question = lang_m3u_select;
          for(var i=0; i<nlines.length; i++)
            question+=i+": "+nlines[i]+"\n";
          
          var i = prompt(question);
          if(i == null)
            return;
          i*=1;
          if( isNaN(i) || i<0 || i>= nlines.length){
            alert(lang_m3u_out_of_range);
            return;
          }
          else
            URL = nlines[i];
        }
        
        if(type=="add"){
          var name = document.getElementById("stream_name").value;
          
          finish_add_URL(URL, name);
        }
        
        if(type=="edit"){
          var index = stream_list_db_name.indexOf(actual_stream_edit_name);
          var name  = document.getElementById("stream_name_edit").value;
          
          finish_edit_URL(URL, name, index);
        }
        if(type=="edit_global"){
          finish_edit_stream_global(args.old_name, args.old_url, URL);
        }
      }
      break;
    default:
      alert(lang_error_readyState + req.readyState + "!");
      return;
      break;
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//check_xsfp
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function check_xspf(URL, type, args){
  var allow_m3u = localStorage.getItem("db_allow_m3u");
  if(allow_m3u == "true")
    allow_m3u = true;
  else if(allow_m3u != null)
    allow_m3u = false;
  
  if(URL.toLowerCase().indexOf('.xspf')!=-1 || URL.toLowerCase().indexOf('.asx')!=-1){
    if(!allow_m3u && !confirm(lang_m3u_confirm)){
      return true;
    }
    if(allow_m3u==null)
      if(confirm(lang_save_allow_share))
        localStorage.setItem("db_allow_m3u","true");
      else
        localStorage.setItem("db_allow_m3u","false");
      
    //m3u abrufen
    var req = null;
    try {
      req = new XMLHttpRequest({mozSystem: true});
    }
    catch (e) {
      try {
        req = new ActiveXObject("Msxml2.XMLHTTP");
      }
      catch (e) {
        try {
          req = new ActiveXObject("Microsoft.XMLHTTP");
        }
        catch (failed) {
          req = null;
        }
      }
    }

    if (req == null){
      alert("Error creating request object!");
      return null;
    }

    req.open("GET", URL, true);

    req.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
    
    req.onreadystatechange = function(){handle_get_xspf(req, type, args)};
    req.send(null);
    
    return true;
  }
  return false;
}

function handle_get_xspf(req, type, args){
  switch (req.readyState) {
    case 2:
      return;
      break;
    case 3:
      return;
      break;
    case 4:
      if (req.status != 200) {
        alert(lang_error_status + req.status + "!");
      } else {
        var xml = req.responseXML;
        
        var streams = [];
        
        var elements = xml.getElementsByTagName("location");
        for(var i=0; i<elements.length; i++)
          streams.push(elements[i].textContent);
        
        var elements = xml.getElementsByTagName("ref");
        for(var i=0; i<elements.length; i++)
          streams.push(elements[i].getAttribute("href"));
        
        
        var URL;
        if(nlines.length==0){
          alert(lang_no_m3u);
          return;
        }
        else if(streams.length==1)
          URL = streams[0];
        else{  
          var question = lang_m3u_select;
          for(var i=0; i<streams.length; i++)
            question+=i+": "+streams[i]+"\n";
          
          var i = prompt(question);
          if(i == null)
            return;
          i*=1;
          if( isNaN(i) || i<0 || i>= streams.length){
            alert(lang_m3u_out_of_range);
            return;
          }
          else
            URL = streams[i];
        }
        
        if(type=="add"){
          var name = document.getElementById("stream_name").value;
          
          finish_add_URL(URL, name);
        }
        
        if(type=="edit"){
          var index = stream_list_db_name.indexOf(actual_stream_edit_name);
          var name  = document.getElementById("stream_name_edit").value;
          
          finish_edit_URL(URL, name, index);
        }
        if(type=="edit_global"){
          finish_edit_stream_global(args.old_name, args.old_url, URL);
        }
      }
      break;
    default:
      alert(lang_error_readyState + req.readyState + "!");
      return;
      break;
  }
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Einstellungen onchange
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onchange_select_app_language(){
  var value = document.getElementById("select_app_language").value;
  localStorage.setItem("db_app_language", value);
  alert(lang_restart_app);
}
function onchange_select_list_size(){
  list_size = document.getElementById("select_list_size").value;
  localStorage.setItem("db_list_size", list_size);
}
function onchange_cb_allow_m3u(){
  var value = document.getElementById("cb_allow_m3u").checked;
  localStorage.setItem("db_allow_m3u", value);
}
function onchange_cb_allow_share(){
  var bool_allow_share = document.getElementById("cb_allow_share").checked;
  localStorage.setItem("db_allow_share", bool_allow_share);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//stream_list_page
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_stream_list_page_prev(){
  loaded_global_streams_page-=1;
  change_page();
}
function onclick_stream_list_page_next(){
  loaded_global_streams_page+=1;
  change_page();
}
function onchange_stream_list_page(){
  var value = document.getElementById("stream_list_page").value*1;
  if(isNaN(value))
    document.getElementById("stream_list_page").setCustomValidity("NaN");
  else if(value<=0 || ( global_streams_xml_elements != null && (value-1)*list_size+list_size > global_streams_xml_elements.length ) ){
    document.getElementById("stream_list_page").setCustomValidity("OutOfRange");
  }
  else{
    document.getElementById("stream_list_page").setCustomValidity("");
    loaded_global_streams_page = value-1;
    change_page_time = (new Date()).getTime();
    change_page();
  }
}

function change_page(){
  document.getElementById("stream_list_page").value = loaded_global_streams_page+1;
  
  while(document.getElementById("stream_list_global").hasChildNodes())
    document.getElementById("stream_list_global").removeChild(document.getElementById("stream_list_global").firstChild);
  load_global_streams_section();
}

function check_page_min_max(){
  if(loaded_global_streams_page==0)
    document.getElementById("stream_list_page_prev").setAttribute("disabled", true);
  else
    document.getElementById("stream_list_page_prev").removeAttribute("disabled");
  
  if(global_streams_xml_elements != null && loaded_global_streams_page*list_size+list_size > global_streams_xml_elements.length)
    document.getElementById("stream_list_page_next").setAttribute("disabled", true);
  else
    document.getElementById("stream_list_page_next").removeAttribute("disabled");
}

window.addEventListener("load"  , onload  );

document.getElementById("add_URL")              .addEventListener("click", onclick_add_URL);
document.getElementById("button_cancel_add")    .addEventListener("click", onclick_cancel_add);
document.getElementById("button_close_delete")  .addEventListener("click", onclick_close_delete);
document.getElementById("button_close_move")    .addEventListener("click", onclick_close_move);
document.getElementById("button_close_edit")    .addEventListener("click", onclick_close_edit);
document.getElementById("edit_URL")             .addEventListener("click", onclick_edit_URL);
document.getElementById("button_cancel_edit")   .addEventListener("click", onclick_cancel_edit);

document.getElementById("button_about_about")   .addEventListener("click", onclick_button_about);
document.getElementById("button_whats_new")     .addEventListener("click", onclick_button_whats_new);
document.getElementById("button_guide")         .addEventListener("click", onclick_button_guide);
document.getElementById("button_close_about")   .addEventListener("click", onclick_close_about);

document.getElementById("button_add_URL")       .addEventListener("click", onclick_button_add_URL);
document.getElementById("button_delete_URL")    .addEventListener("click", onclick_button_delete_URL);
document.getElementById("button_move_URL")      .addEventListener("click", onclick_button_move_URL);
document.getElementById("button_edit_URL")      .addEventListener("click", onclick_button_edit_URL);

document.getElementById("button_zoom_in")       .addEventListener("click", onclick_button_zoom_in);
document.getElementById("button_zoom_out")      .addEventListener("click", onclick_button_zoom_out);
document.getElementById("button_zoom_100")      .addEventListener("click", onclick_button_zoom_100);
document.getElementById("button_close_zoom")    .addEventListener("click", onclick_close_zoom);

document.getElementById("button_zoom")          .addEventListener("click", onclick_button_zoom);
document.getElementById("button_share")         .addEventListener("click", onclick_button_share);
document.getElementById("button_share_global")  .addEventListener("click", onclick_button_share_global);
document.getElementById("button_about")         .addEventListener("click", onclick_button_about);

document.getElementById("button_upload_share")  .addEventListener("click", onclick_upload_share);
document.getElementById("button_download_share").addEventListener("click", onclick_download_share);
document.getElementById("button_close_share")   .addEventListener("click", onclick_close_share);

document.getElementById("button_upload_share_global")       .addEventListener("click", onclick_upload_share_global);
document.getElementById("button_close_share_global")        .addEventListener("click", onclick_close_share_global);

document.getElementById("button_upload_share_global_upload").addEventListener("click", onclick_upload_share_global_upload);
document.getElementById("button_abort_upload_share_global") .addEventListener("click", onclick_abort_upload_share_global);

document.getElementById("button_global_share_options_close")        .addEventListener("click", onclick_global_share_options_close);
document.getElementById("button_global_share_options_edit_close")   .addEventListener("click", onclick_global_share_options_edit_close);
document.getElementById("button_global_share_options_report_cancel").addEventListener("click", onclick_global_share_options_report_cancel);

document.getElementById("audio")                .addEventListener("loadedmetadata", getMetadata);
document.getElementById("audio")                .addEventListener("error", stream_error);
document.getElementById("audio")                .addEventListener("loadstart", stream_loadstart);
document.getElementById("audio")                .addEventListener("canplay", stream_canplay);

document.getElementById("stream_name")          .addEventListener("input", function(){check_input(document.getElementById("stream_name")     ,3)});
document.getElementById("stream_URL")           .addEventListener("input", function(){check_input(document.getElementById("stream_URL")      ,0)});
document.getElementById("stream_name_edit")     .addEventListener("input", function(){check_input(document.getElementById("stream_name_edit"),3)});
document.getElementById("stream_URL_edit")      .addEventListener("input", function(){check_input(document.getElementById("stream_URL_edit") ,0)});

document.getElementById("remote_share_id")      .addEventListener("input", function(){check_input_share_id(document.getElementById("remote_share_id") ,10)});

document.getElementById("input_tag_share_global") .addEventListener("input", function(){check_input(document.getElementById("input_tag_share_global") ,0)});
document.getElementById("upload_share_global_tag").addEventListener("input", function(){check_input(document.getElementById("upload_share_global_tag"),0)});
document.getElementById("input_name_share_global").addEventListener("input", function(){check_input(document.getElementById("input_name_share_global"),0)});

document.getElementById("global_share_options_edit_url" ).addEventListener("input", function(){check_input(document.getElementById("global_share_options_edit_url" ) ,0)});
document.getElementById("global_share_options_edit_name").addEventListener("input", function(){check_input(document.getElementById("global_share_options_edit_name") ,3)});
document.getElementById("global_share_options_edit_tags").addEventListener("input", function(){check_input(document.getElementById("global_share_options_edit_tags") ,0)});

document.getElementById("global_share_options_report_reason").addEventListener("input", function(){check_input(document.getElementById("global_share_options_report_reason") ,25,3)});

document.getElementById("select_app_language").addEventListener("change", onchange_select_app_language);
document.getElementById("select_list_size"   ).addEventListener("change", onchange_select_list_size   );
document.getElementById("cb_allow_m3u"       ).addEventListener("change", onchange_cb_allow_m3u       );
document.getElementById("cb_allow_share"     ).addEventListener("change", onchange_cb_allow_share     );

document.getElementById("stream_list_page_prev"  ).addEventListener("click", onclick_stream_list_page_prev);
document.getElementById("stream_list_page_next"  ).addEventListener("click", onclick_stream_list_page_next);
document.getElementById("stream_list_page"       ).addEventListener("change", onchange_stream_list_page);
