//published by Thorsten Zahn unter the terms of the Mozilla Public License (MPL) v2.0

var share_url = "http://zahn.rootsta.de";

var lang_title   = "Title";
var lang_unknown = "Unknown";
var lang_play    = "Play";
var lang_pause   = "Stop";
var lang_delete  = "Delete";
var lang_edit    = "Edit";
var lang_stream_existing = "This stream is already existing!";
var lang_stream_invalid = "Invaid URL, name or tags!";
var lang_empty_input = "Input for URL or name empty!";
var lang_stream_confirm_delete = "Do you really want to delete the entry for \"%STREAM%\"?";
var lang_localstorage_not_available = "The localStorage isn't available - the app isn't possible to run correct!\nPlease check if cookies are disabled for this domain / app!";
var lang_allow_share = "Do you want to communicate with the server "+share_url+" to share your streams?";
var lang_save_allow_share = "Don't you want to be asked again?";
var lang_upload_share_error = "An error occured while uploading the strems: ";
var lang_download_share_error = "An error occured while downloading the strems: ";
var lang_email_subject = "Webradio-App Share-Id: ";
var lang_email_body = "I'm' sending my Share-Id of the web-app Webradio to you.\n\nThis is my Share-Id: %id%\n\nYou can add my publiched streams to your streamlist.\nYou can download the app at https://marketplace.firefox.com/app/webradio/.";
var lang_error_status = "Error: status = ";
var lang_error_readyState = "Error: readyState = ";
var lang_error_id_spam = "Error: You requested too many Share-Ids in short time! Please wait more than one hour!";
var lang_uploaded = "your streams have been uploaded";
var lang_downloaded = "the streams have been downloaded";
var lang_share_global = "Upload";
var lang_other = "Other";
var lang_all = "All";
var lang_prompt_language = "Please input the Language of the stream!";
var lang_prompt_language_error = "Invaild input! Your input is shorter then 2 or longer then 3 characters or contains an invalid character!";
var lang_add_global_to_local_done = "The stream was added!";
var lang_upload_share_error_global = "An error occured while uploading the strem: ";
var lang_uploaded_global = "Your stream has been uploaded. Thanks!";
var lang_error_build_global_list = "An error occured while downloading the global list: ";
var lang_button_global_options = "Options";
var lang_edit_share_error_global = "An error occured while editing the strem: ";
var lang_edited_global = "The stream has been edited. Thanks!";
var lang_report_global_share_error = "An error occured while reporting the strem: ";
var lang_reported_global_share = "The stream has been reported.";
var lang_no_m3u = "The playlist-file contains no stream!";
var lang_m3u_select = "Please select the stream by typing in his Number!\n";
var lang_m3u_out_of_range = "The selected stream number is out of range!";
var lang_m3u_confirm = "Do you want to download the playlist-file? This might be a security issue!";
var lang_restart_app = "Restart the app to apply the setting!";
var lang_stream_checked = "Please don't upload streams aren't working!\nDid you check the stream (is it playing)?";
var lang_please_dont_spam = "Please don't spam me!\nPlease write German or English!\nKeep in mind: I've to understand you!\nDo you want to continue?";

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//localize
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function localize(){
  var lang = localStorage.getItem("db_app_language");
  
  if(lang==null){
    if(window.navigator.language.indexOf('de')!=-1){
      console.log("localization \""+window.navigator.language + "\" is supported");
      localizeDE();
    }
    else if(window.navigator.language.indexOf('en')!=-1){
      console.log("localization \""+window.navigator.language + "\" is supported");
      //default - nothing to do
    }
    else{
      console.log("localization \""+window.navigator.language + "\" is not supported - fallback to English");
    }
  }
  else
    if(lang=="De")
      localizeDE();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//localizeDE
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function localizeDE(){
  lang_title   = "Titel";
  lang_unknown = "Unbekannt";
  lang_play    = "Spielen";
  lang_pause   = "Stop";
  lang_delete  = "Löschen";
  lang_edit    = "Ändern";
  lang_stream_existing = "Dieser Stream existiert bereits!";
  lang_stream_invalid = "Die URL, der Name oder die Tags sind nicht korrekt!";
  lang_empty_input = "Mindestens ein Eingabefeld ist leer!";
  lang_stream_confirm_delete = "Willst du wirklich den Stream \"%STREAM%\" löschen?";
  lang_localstorage_not_available = "Der localStorage ist nicht verfügbar - die App wird nicht korrekt ausgeführt werden!\n Bitte prüfen Sie ob die Cookies für diese Domain / App deaktiviert sind!";

  lang_allow_share = "Möchtest du mit dem Server "+share_url+" kommunizieren um deine Streams auszutauschen?";
  lang_save_allow_share = "Möchtest du nicht noch einmal gefragt werden?";
  lang_upload_share_error = "Beim Hochladen der Streams trat ein Fehler auf: ";
  lang_download_share_error = "Beim Herunterladen der Streams trat ein Fehler auf: ";
  lang_email_subject = "Webradio-App Share-Id: ";
  lang_email_body = "Ich habe dir meine Share-Id der Web-App Webradio gesendet.\n\nDies ist meine Share-Id: %id%\n\nDu kannst nun meine veroeffentlichten Streams zu deiner Streamliste hinzufuegen.\nDu kannst die App unter https://marketplace.firefox.com/app/webradio/ herunterladen.";
  
  lang_error_status     = "Fehler: status = ";
  lang_error_readyState = "Fehler: readyState = ";
  lang_error_id_spam    = "Fehler: Du hast zu viele Share-Ids in kurzer Zeit angefordert! Bitte warte mindestens eine Stunde!";
  
  lang_uploaded = "Deine Streams wurden hochgeladen";
  lang_downloaded = "Die Streams wurden heruntergeladen";
  
  lang_share_global = "Auswählen";
  lang_other = "Andere";
  lang_all = "Alle";
  lang_prompt_language = "Bitte geben Sie die Sprache des Streams ein!";
  lang_prompt_language_error = "Fehlerhafte Eingabe! Sie haben weniger als 2 oder mehr als 3 Buchstaben oder einen ungültigen Buchstaben eingegeben!";
  
  lang_add_global_to_local_done = "Der Stream wurde hinzugefügt";
  lang_upload_share_error_global = "Beim Hochladen des Streams trat ein Fehler auf: ";
  lang_uploaded_global = "Dein Stream wurde hochgeladen. Danke!";
  
  lang_error_build_global_list = "Beim herunterladen der globalen Liste trat ein Fehler auf: ";

  lang_button_global_options = "Optionen";
  lang_edit_share_error_global = "Beim Bearbeiten des Streams trat ein Fehler auf: ";
  lang_edited_global = "Der Stream wurde bearbeitet. Danke!";
  lang_report_global_share_error = "Beim Melden des Streams trat ein Fehler auf: ";
  lang_reported_global_share = "Der Stream wurde gemeldet.";

  lang_no_m3u = "Die Playlist-Datei enthält keinen Stream!";
  lang_m3u_select = "Bitte wählen Sie den Stream indem sie seine Nummer eingeben!\n";
  lang_m3u_out_of_range = "Die ausgewählte Stream-Nummer ist außerhalb des zulässigen Bereichs!";
  lang_m3u_confirm = "Möchtest du die Playlist-Datei herunterladen? Dies kann ein Sicherheitsrisiko sein!";
  
  lang_restart_app = "Bitte starten Sie die App neu um die Änderung der Sprache anzuwenden!";
  
  lang_stream_checked = "Bitte lade keine Streams hoch, die nicht funktionieren!\nhast du den Stream getestet (kann er abgespielt werden)?";
  lang_please_dont_spam = "Bitte spamme mich nicht zu!\nbitte schreibe in Deutsch oder Englisch!\nBedenke: Ich muss dich verstehen können!\nMöchtest du fortfahren?";
  
  document.getElementById("add_URL")            .textContent = "Stream hinzufügen";
  document.getElementById("button_cancel_add")  .textContent = "Abbruch";
  document.getElementById("button_close_delete").textContent = "Schließen";
  document.getElementById("button_close_move")  .textContent = "Schließen";
  document.getElementById("button_close_edit")  .textContent = "Schließen";
  document.getElementById("edit_URL")           .textContent = "Stream bearbeiten";
  document.getElementById("button_cancel_edit") .textContent = "Abbruch";
  document.getElementById("button_close_zoom")  .textContent = "Schließen";
  document.getElementById("button_close_share") .textContent = "Schließen";
  document.getElementById("button_close_about") .textContent = "Schließen";
  document.getElementById("button_whats_new")   .textContent = "Was ist neu?";
  document.getElementById("button_guide")       .textContent = "Anleitung";
  document.getElementById("button_about_about") .textContent = "Über";
    
  document.getElementById("button_add_URL")     .textContent = "Stream hinzufügen";
  document.getElementById("button_delete_URL")  .textContent = "Stream löschen";
  document.getElementById("button_move_URL")    .textContent = "Streams ordnen";
  document.getElementById("button_edit_URL")    .textContent = "Stream ändern";
  
  document.getElementById("button_email_share") .textContent = "Share-Id per E-Mail senden";
  
  document.getElementById("div_track")          .textContent = lang_title+": " + lang_unknown;
  
  document.getElementById("button_zoom")        .textContent = "Einstell.";
  document.getElementById("button_share")       .textContent = "Teilen";
  document.getElementById("button_share_global").textContent = "g. Liste";
  document.getElementById("button_about")       .textContent = "Über";
  
  document.getElementById("select_language_share_global_td"  ).textContent = "Sprache:";
  document.getElementById("button_search_share_global"       ).textContent = "Suchen";
  document.getElementById("button_upload_share_global"       ).textContent = "Hochladen";
  document.getElementById("button_close_share_global"        ).textContent = "Schließen";
  
  document.getElementById("upload_share_global_language_td"  ).textContent = "Sprache:";
  document.getElementById("button_upload_share_global_upload").textContent = "Hochladen";
  document.getElementById("button_abort_upload_share_global" ).textContent = "Abbrechen";
  
  document.getElementById("upload_share_global_language").firstChild.nextSibling.textContent = "Andere";
  
  document.getElementById("td_global_share_options_selected"         ).textContent = "Ausgewählt:";
  document.getElementById("button_global_share_options_tomylist"     ).textContent = "Auf meine Liste";
  document.getElementById("button_global_share_options_report"       ).textContent = "Stream melden";
  document.getElementById("button_global_share_options_edit"         ).textContent = "Stream ändern";
  document.getElementById("button_global_share_options_close"        ).textContent = "Schließen";
  
  document.getElementById("global_share_options_edit_language_td"    ).textContent = "Sprache:";
  document.getElementById("button_global_share_options_edit_close"   ).textContent = "Abbrechen";
  
  document.getElementById("global_share_options_report_reason_td"    ).textContent = "Grund:";
  document.getElementById("button_global_share_options_report_cancel").textContent = "Abbrechen";
  
  document.getElementById("stream_list_global_loading").getElementsByTagName("h1")[0].textContent = "Lädt ...";
  
  document.getElementById("td_select_app_language").textContent = "Sprache:";
  document.getElementById("td_select_list_size"   ).textContent = "G. Liste:";
  document.getElementById("lb_allow_m3u"          ).textContent = "\u00a0\u00a0Playlists erlauben";
  document.getElementById("lb_allow_share"        ).textContent = "\u00a0\u00a0Teilen erlauben";
}
