//published by Thorsten Zahn unter the terms of the Mozilla Public License (MPL) v2.0

var id;
var bool_allow_share = false;

function request(type, url){
  var req = null;
  try {
    req = new XMLHttpRequest();
  }
  catch (e) {
    try {
      req = new ActiveXObject("Msxml2.XMLHTTP");
    }
    catch (e) {
      try {
        req = new ActiveXObject("Microsoft.XMLHTTP");
      }
      catch (failed) {
        req = null;
      }
    }
  }
  
  if (req == null){
    alert("Error creating request object!");
    return null;
  }
  
  req.open(type, url, true);
  
  req.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
  
  return req;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//init_share
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function init_share(){
  var allow_share = localStorage.getItem("db_allow_share");
  if(allow_share!="true"){
    if(!confirm(lang_allow_share)){
      window.setTimeout(
        function() {
          onclick_close_share();
          onclick_close_share_global();
          clearTimeout(timer_build_global_list);
          clearTimeout(update_language_list_timer_id);
        }
        ,10);
      return;
    }
    else{
      bool_allow_share = true;
      if(confirm(lang_save_allow_share))
        localStorage.setItem("db_allow_share","true");
    }
  }
  else
    bool_allow_share = true;
  
  id = localStorage.getItem("db_share_id");
  if(id==null || id==""){
    get_new_share_id();
  }
  else
    document.getElementById("own_share_id").value = id;
}

var req_get_new_share_id = null;

function get_new_share_id(){
  req_get_new_share_id = request("GET", share_url+"/php/get_new_share_id.php");
  req_get_new_share_id.onreadystatechange = handle_get_new_share_id;
  req_get_new_share_id.send(null);
}

function handle_get_new_share_id(){
  switch (req_get_new_share_id.readyState) {
    case 2:
      return false;
      break;
    case 3:
      return false;
      break;
    case 4:
      if (req_get_new_share_id.status != 200) {
        alert(lang_error_status + req_get_new_share_id.status + "!");
      } else {
        var xml = req_get_new_share_id.responseXML;
        var tmpid = xml.getElementsByTagName("share_id")[0].firstChild.nodeValue;
        
        if(tmpid == -1){
          alert(lang_error_id_spam);
        }
        else{
          id = tmpid;
          localStorage.setItem("db_share_id", id);
          document.getElementById("own_share_id").value = id;
        }
      }
      break;
    default:
      alert(lang_error_readyState + req_get_new_share_id.readyState + "!");
      return false;
      break;
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//upload_share
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var req_upload_share = null;

function upload_share(){
  //XML Initialisieren
  var xml = null;
  if (window.DOMParser) {
    var parser = new DOMParser ();
    xml = parser.parseFromString ("<xml></xml>", "text/xml");
  } else if (window.ActiveXObject) {
    xml = new ActiveXObject ("Microsoft.XMLDOM");
    xml.async = false;
    xml.loadXML ("<xml></xml>");
  } else {
    alert("Error creating xml object!");
    return null;
  }
  
  //xml bauen
  
  var share_id = xml.createElement("share_id");
  share_id.textContent = id;
  xml.getElementsByTagName("xml")[0].appendChild(share_id);

  var streams = xml.createElement("streams");
    for (var i = 0; i < stream_list_db_name.length; i++){
      var name = stream_list_db_name[i];
      if(document.getElementById("stream_list_checkbox_share_"+name).checked){
        var URL = localStorage.getItem("stream_list_db_"+name);
        var stream = xml.createElement("stream");
          var tname = xml.createElement("name");
          tname.textContent = name;
          stream.appendChild(tname);
          
          var turl = xml.createElement("url");
          turl.textContent = URL;
          stream.appendChild(turl);
        streams.appendChild(stream);
      }
    }
  xml.getElementsByTagName("xml")[0].appendChild(streams);
  
  //xml senden
  var xmlstring = new XMLSerializer().serializeToString(xml.documentElement);
  xmlstring = "xml=" + xmlstring;
  
  req_upload_share = request("POST",share_url+"/php/upload_streams.php");
  req_upload_share.setRequestHeader("Content-length", xmlstring.length);
  req_upload_share.setRequestHeader("Connection", "close");
  req_upload_share.onreadystatechange = handle_upload_share;
  req_upload_share.send(xmlstring);
}

function handle_upload_share(){
  switch (req_upload_share.readyState) {
    case 2:
      return false;
      break;
    case 3:
      return false;
      break;
    case 4:
      if (req_upload_share.status != 200) {
        alert(lang_error_status + req_upload_share.status + "!");
      } else {
        var xml = req_upload_share.responseXML;
        var error = xml.getElementsByTagName("error")[0].firstChild.nodeValue;
        
        if(error!="false")
          alert(lang_upload_share_error+error);
        else
          alert(lang_uploaded);
      }
      break;
    default:
      alert(lang_error_readyState + req_upload_share.readyState + "!");
      return false;
      break;
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//download_share
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var req_download_share = null;

function download_share(){
  if(!document.getElementById("remote_share_id").validity.valid)
    return;
  var share_id = document.getElementById("remote_share_id").value;
  share_id = "share_id=" + share_id;
  req_download_share = request("POST", share_url+"/php/download_streams.php");
  req_download_share.setRequestHeader("Content-length", share_id.length);
  req_download_share.setRequestHeader("Connection", "close");
  //req_download_share.withCredentials = "true";
  req_download_share.onreadystatechange = handle_download_share;
  req_download_share.send(share_id);
}

function handle_download_share(){
  switch (req_download_share.readyState) {
    case 2:
      return false;
      break;
    case 3:
      return false;
      break;
    case 4:
      if (req_download_share.status != 200) {
        alert(lang_error_status + req_download_share.status + "!");
      } else {
        var xml = req_download_share.responseXML;
        var error = xml.getElementsByTagName("error")[0].firstChild.nodeValue;
        
        if(error!="false")
          alert(lang_download_share_error+error);
        else{
          for(var i=0; i<xml.getElementsByTagName("stream").length; i++){
            var name = xml.getElementsByTagName("name")[i].firstChild.nodeValue;
            var URL  = xml.getElementsByTagName("url") [i].firstChild.nodeValue;
            var contained = false;
            
            for(var i2=0; i2<stream_list_db_name.length; i2++){
              if(name == stream_list_db_name[i2]){
                contained = true;
                break;
              }
              if(URL == localStorage.getItem("stream_list_db_"+stream_list_db_name[i2])){
                contained = true;
                break;
              }
            }
            
            if(!contained){
              add_URL(URL, name);
              
              onresize();
              onclick_button_share();
              
              stream_list_db_name.push(name);
              localStorage.setItem("stream_list_db_name",dbArrayToString(stream_list_db_name));
              localStorage.setItem("stream_list_db_"+name,URL);
            }
          }
          alert(lang_downloaded);
        }
      }
      break;
    default:
      alert(lang_error_readyState + req_download_share.readyState + "!");
      return false;
      break;
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//sendMail
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function sendMail(){
  var link = "mailto:"
           + "?subject=" + escape(lang_email_subject+id)
           + "&body=" + escape(lang_email_body.replace("%id%",id))
  ;
  window.location.href = link;
}


document.getElementById("button_share")         .addEventListener("click", init_share);
document.getElementById("button_upload_share")  .addEventListener("click", upload_share);
document.getElementById("button_email_share")   .addEventListener("click", sendMail);
document.getElementById("button_download_share").addEventListener("click", download_share);
