//published by Thorsten Zahn unter the terms of the Mozilla Public License (MPL) v2.0
var global_streams = [];
var global_streams_xml_elements = null;
var loaded_global_streams_page = 0;
var global_streams_td_width;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//init_global_list
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var init_global_list_timer_id = null;
function init_global_list(){
  if(!bool_allow_share){
    init_global_list_timer_id = window.setTimeout(init_global_list, 200);
    return;
  }
  
  update_language_list(document.getElementById("select_language_share_global"), [["all",lang_all]], build_global_list);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//build_global_list
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var build_global_list_timer_id = null;
function build_global_list(){
  if(!bool_allow_share){
    build_global_list_timer_id = window.setTimeout(build_global_list, 200);
    return;
  }
  
  if(!document.getElementById("input_tag_share_global" ).validity.valid)
    return;
  if(!document.getElementById("input_name_share_global").validity.valid)
    return;
  
  document.getElementById("stream_list_page").value = 1;
  check_page_min_max();
  
  if(document.getElementById("stream_list_global").style.display == "inline-table"){
    document.getElementById("stream_list_global_loading").style.display="inline-table";
  }
  while(document.getElementById("stream_list_global").hasChildNodes())
    document.getElementById("stream_list_global").removeChild(document.getElementById("stream_list_global").firstChild);
  
  var name = document.getElementById("input_name_share_global")     .value;
  var tags = document.getElementById("input_tag_share_global")      .value;
  var lang = document.getElementById("select_language_share_global").value;
  if(lang == "all")
    lang = "";
  
  var req = null;
  req = request("GET", share_url+"/php/get_global_streams.php?name="+name+"&tags="+tags+"&lang="+lang+"&share_id="+id);
  req.onreadystatechange = function(){ handle_build_global_list(req) };
  req.send(null);
}

function handle_build_global_list(req){
  switch (req.readyState) {
    case 2:
      return false;
      break;
    case 3:
      return false;
      break;
    case 4:
      if (req.status != 200) {
        alert(lang_error_status + req.status + "!");
      } else {
        var xml = req.responseXML;
        
        var error = xml.getElementsByTagName("error")[0].textContent;
        if(error != "false")
          alert(lang_error_build_global_list+error);
        else{
          while(document.getElementById("stream_list_global").hasChildNodes())
            document.getElementById("stream_list_global").removeChild(document.getElementById("stream_list_global").firstChild);
          
          global_streams = [];
          
          global_streams_xml_elements = xml.getElementsByTagName("stream");
          loaded_global_streams_page = 0;
          load_global_streams_section();
        }
      }
      break;
    default:
      alert(lang_error_readyState + req.readyState + "!");
      return false;
      break;
  }
}
function load_global_streams_section(){
  var streams = global_streams_xml_elements;
  var offset = loaded_global_streams_page*list_size;
  var istream = 0;
  
  var max = offset+list_size;
    
  if(max>streams.length)
    max = streams.length;
  
  document.getElementById("stream_list_global").style.fontSize = (18*zoom*window.innerWidth/320) +"px";
  
  for(i=offset; i<max; i++){
    var name = streams[i].getElementsByTagName("name"    )[0].textContent;
    var url  = streams[i].getElementsByTagName("url"     )[0].textContent;
    var tags = streams[i].getElementsByTagName("tags"    )[0].textContent;
    var lang = streams[i].getElementsByTagName("lang"    )[0].textContent;
    var edit = streams[i].getElementsByTagName("editable")[0].textContent;

    if(edit=="true" || edit==true)
      edit=true;
    else
      edit=false;

    global_streams.push(name);

    add_global_URL(name, url, tags, lang, istream, edit);
    
    istream++;
  }
  
  document.getElementById("stream_list_global_loading").style.display="none";
  
  check_page_min_max();
}

function add_global_URL(name, url, tags, lang, index, edit){
  var fwidth=zoom*window.innerWidth/320;
  
  var tags_array = tags.split(" ");
  
  var stream_list = document.getElementById("stream_list_global");
    var tr = document.createElement("tr");
      var td = document.createElement("td");
        var table = document.createElement("table");
        table.setAttribute("class","stream_list_global_table_"+ (index % 2));
          var tr0 = document.createElement("tr");
            var td0 = document.createElement("td");
            td0.setAttribute("class","stream_list_global_td_stream_name");
              var div = document.createElement("div");
              div.textContent = name;
              div.setAttribute("class","stream_list_global_div_stream_name");
              if(index==0)
                div.style.width = "1px";
            td0.appendChild(div);
            td0.style.padding=(5*fwidth)+"px";
          tr0.appendChild(td0);
            var td1 = document.createElement("td");
            td1.textContent = "["+lang+"]";
            td1.style.padding=(5*fwidth)+"px";
          tr0.appendChild(td1);
            var td2 = document.createElement("td");
            td2.setAttribute("class","stream_list_td_play");
              var button0 = document.createElement("button");
              button0.setAttribute("id","stream_list_global_button_"+name);
              button0.setAttribute("class","stream_list_button_play");
              button0.textContent = lang_play;
              button0.addEventListener("click", function(){ onclick_play_URL_global(url, name) });
              button0.style.fontSize = (18*fwidth) +"px";
            td2.appendChild(button0);
            td2.style.padding=(5*fwidth)+"px";
          tr0.appendChild(td2);
        table.appendChild(tr0);
          var tr1 = document.createElement("tr");
            var td3 = document.createElement("td");
            td3.setAttribute("class","stream_list_global_tags_td");
            td3.style.paddingLeft  = (1*fwidth) +"px";
            td3.style.paddingRight = (1*fwidth) +"px";
              var div0 = document.createElement("div");
              div0.setAttribute("class","stream_list_global_tags_div");
              div0.style.fontSize = (13*fwidth) +"px";
                for(var i=0; i<tags_array.length; i++){
                  if(tags_array[i]=="")
                    continue;
                  var span = document.createElement("span");
                  span.textContent = tags_array[i];
                  span.setAttribute("class","stream_list_global_tags_span_"+ (index % 2));

                  span.style.marginLeft   = (3 *fwidth) +"px";
                  span.style.marginRight  = (3 *fwidth) +"px";
                  span.style.padding      = (1 *fwidth) +"px";
                  span.style.paddingLeft  = (4 *fwidth) +"px";
                  span.style.paddingRight = (4 *fwidth) +"px";
                  span.style.borderRadius = (5 *fwidth) +"px";

                  div0.appendChild(span);
                }
              if(index==0)
                div0.style.width = "1px";
            td3.appendChild(div0);
            td3.style.padding=(5*fwidth)+"px";
          tr1.appendChild(td3);
            var td5 = document.createElement("td");
            td5.setAttribute("colspan","2");
              var button1 = document.createElement("button");
              button1.setAttribute("id","stream_list_global_button_add_"+name);
              button1.setAttribute("class","stream_list_button_add");
              button1.textContent = lang_button_global_options;
              button1.addEventListener("click", function(){ onclick_button_global_options(url, name, tags, lang, edit) });
              button1.style.fontSize = (18*fwidth) +"px";
            td5.appendChild(button1);
            td5.style.padding=(5*fwidth)+"px";
          tr1.appendChild(td5);
        table.appendChild(tr1);
      td.appendChild(table);
    tr.appendChild(td);
  stream_list.appendChild(tr);
  
  if(index==0)
    global_streams_td_width = td0.clientWidth;
  
  div .style.width  = (global_streams_td_width-10*fwidth) +"px";
  div0.style.width  = (global_streams_td_width-10*fwidth) +"px";
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_play_URL_global
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_play_URL_global(URL, name){
  if(document.getElementById("stream_list_global_button_"+name).textContent==lang_play){
    global_stream=true;
    
    actual_stream = name;
    
    manage_play(URL);
    
    for(var i = 0; i < stream_list_db_name.length; i++){
      document.getElementById("stream_list_button_"+stream_list_db_name[i]).textContent=lang_play;
      document.getElementById("stream_list_button_"+stream_list_db_name[i]).style.boxShadow = "";
    }
    for(var i = 0; i < global_streams.length; i++){
      document.getElementById("stream_list_global_button_"+global_streams[i]).textContent=lang_play;
      document.getElementById("stream_list_global_button_"+global_streams[i]).style.boxShadow = "";
    }
    document.getElementById("stream_list_global_button_"+name).textContent=lang_pause;
  }
  else{
    manage_pause();
    
    document.getElementById("stream_list_global_button_"+name).style.boxShadow = "";
    document.getElementById("stream_list_global_button_"+name).textContent=lang_play;
  }
  
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_add_global_to_local
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_add_global_to_local(url, name){
  var error = false;
  for(var i=0; i<stream_list_db_name.length; i++){
    if(name == stream_list_db_name[i])
      error = true;
    if(localStorage.getItem("stream_list_db_"+stream_list_db_name[i]) == url)
      error = true;
  }

  if(error)
    alert(lang_stream_existing);
  else{
    add_URL(url, name);

    onresize();

    stream_list_db_name.push(name);
    localStorage.setItem("stream_list_db_name",dbArrayToString(stream_list_db_name));
    localStorage.setItem("stream_list_db_"+name,url);
    
    alert(lang_add_global_to_local_done);
  }
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_button_global_options
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var button_global_share_options_tomylist_event_listener = null;
var button_global_share_options_edit_event_listener = null;
var button_global_share_options_edit_upload_event_listener = null;
var button_global_share_options_report_event_listener = null;
var button_global_share_options_report_ok_event_listener = null;
function onclick_button_global_options(url, name, tags, lang, edit){
  document.getElementById("table_global_share_options").style.display="inline-table";
  document.getElementById("table_global_share_options_edit").style.display="none";
  document.getElementById("table_global_share_options_report").style.display="none";
  document.getElementById("table_share_global").style.display="none";
  
  
  document.getElementById("input_global_share_options_selected").value = name;
  
  
  if(button_global_share_options_tomylist_event_listener!= null)
    document.getElementById("button_global_share_options_tomylist").removeEventListener("click", button_global_share_options_tomylist_event_listener);
  
  button_global_share_options_tomylist_event_listener = function(){ onclick_add_global_to_local(url, name) };
  document.getElementById("button_global_share_options_tomylist").addEventListener("click", button_global_share_options_tomylist_event_listener);
  
  
  if(edit)
    document.getElementById("button_global_share_options_edit").removeAttribute("disabled");
  else
    document.getElementById("button_global_share_options_edit").setAttribute("disabled", true);
  
  
  if(button_global_share_options_edit_event_listener!= null)
    document.getElementById("button_global_share_options_edit").removeEventListener("click", button_global_share_options_edit_event_listener);
  
  button_global_share_options_edit_event_listener = function(){ onclick_global_share_options_edit(url, name, tags, lang) };
  document.getElementById("button_global_share_options_edit").addEventListener("click", button_global_share_options_edit_event_listener);
  
  
  if(button_global_share_options_edit_upload_event_listener!= null)
    document.getElementById("button_global_share_options_edit_upload").removeEventListener("click", button_global_share_options_edit_upload_event_listener);
  
  button_global_share_options_edit_upload_event_listener = function(){ edit_stream_global(name, url) };
  document.getElementById("button_global_share_options_edit_upload").addEventListener("click", button_global_share_options_edit_upload_event_listener);
  
  
  if(button_global_share_options_report_event_listener!= null)
    document.getElementById("button_global_share_options_report").removeEventListener("click", button_global_share_options_report_event_listener);
  
  button_global_share_options_report_event_listener = function(){ onclick_report_global_stream(name) };
  document.getElementById("button_global_share_options_report").addEventListener("click", button_global_share_options_report_event_listener);
  
  
  if(button_global_share_options_report_ok_event_listener!= null)
    document.getElementById("button_global_share_options_report_ok").removeEventListener("click", button_global_share_options_report_ok_event_listener);
  
  button_global_share_options_report_ok_event_listener = function(){ onclick_report_global_stream_ok(name, url) };
  document.getElementById("button_global_share_options_report_ok").addEventListener("click", button_global_share_options_report_ok_event_listener);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_global_share_options_edit
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_global_share_options_edit(url, name, tags, lang){
  document.getElementById("table_global_share_options_edit").style.display="inline-table";
  document.getElementById("table_global_share_options").style.display="none";
  
  update_language_list(document.getElementById("global_share_options_edit_language"), [["other","Other"]], function(){ callback_global_share_options_edit_set_lang(lang); });
  
  document.getElementById("global_share_options_edit_url"     ).value = url ;
  document.getElementById("global_share_options_edit_name"    ).value = name;
  document.getElementById("global_share_options_edit_tags"    ).value = tags;
}
function callback_global_share_options_edit_set_lang(lang){
  document.getElementById("global_share_options_edit_language").value = lang;
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_report_global_stream
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_report_global_stream(name){
  document.getElementById("table_global_share_options_report").style.display="inline-table";
  document.getElementById("table_global_share_options").style.display="none";
  
  document.getElementById("global_share_options_report_name"  ).value = name;
  document.getElementById("global_share_options_report_reason").value = "";
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//onclick_report_global_stream_ok
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function onclick_report_global_stream_ok(name, url){
  document.getElementById("table_global_share_options_report").style.display="none";
  document.getElementById("table_share_global").style.display="inline-table";
  
  //Check
  if(!document.getElementById("global_share_options_report_reason").validity.valid)
    return;
  
  if(!confirm(lang_please_dont_spam))
    return;
  
  //XML Initialisieren
  var xml = null;
  if (window.DOMParser) {
    var parser = new DOMParser ();
    xml = parser.parseFromString ("<xml></xml>", "text/xml");
  } else if (window.ActiveXObject) {
    xml = new ActiveXObject ("Microsoft.XMLDOM");
    xml.async = false;
    xml.loadXML ("<xml></xml>");
  } else {
    alert("Error creating xml object!");
    return null;
  }
  
  //xml bauen
  
  var tname = xml.createElement("name");
  tname.textContent = name;
  xml.getElementsByTagName("xml")[0].appendChild(tname);
  
  var turl = xml.createElement("url");
  turl.textContent = url;
  xml.getElementsByTagName("xml")[0].appendChild(turl);
  
  var reason = xml.createElement("reason");
  reason.textContent = document.getElementById("global_share_options_report_reason").value;
  xml.getElementsByTagName("xml")[0].appendChild(reason);
  
  var share_id = xml.createElement("share_id");
  share_id.textContent = id;
  xml.getElementsByTagName("xml")[0].appendChild(share_id);
  
  //xml senden
  var xmlstring = new XMLSerializer().serializeToString(xml.documentElement);
  xmlstring = "xml=" + xmlstring;
  
  var req = null;
  req = request("POST", share_url+"/php/report_global_stream.php");
  req.setRequestHeader("Content-length", xmlstring.length);
  req.setRequestHeader("Connection", "close");
  req.onreadystatechange = function(){ handle_report_global_stream(req) };
  req.send(xmlstring);
}
function handle_report_global_stream(req){
  switch (req.readyState) {
    case 2:
      return false;
      break;
    case 3:
      return false;
      break;
    case 4:
      if (req.status != 200) {
        alert(lang_error_status + req.status + "!");
      } else {
        var xml = req.responseXML;
        
        var error = xml.getElementsByTagName("error")[0].textContent;
        if(error != "false")
          alert(lang_report_global_share_error+error); 
        else
          alert(lang_reported_global_share);
      }
      break;
    default:
      alert(lang_error_readyState + req.readyState + "!");
      return false;
      break;
  }
  
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//update_language_list
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var update_language_list_timer_id = null;
function update_language_list(element, default_languages, callback=null){
  if(!bool_allow_share){
    update_language_list_timer_id = window.setTimeout( function(){ update_language_list(element, default_languages) }, 200);
    return;
  }
  
  var req = null;
  req = request("GET", share_url+"/php/get_language_list.php");
  req.onreadystatechange = function(){ handle_get_language_list(req, element, default_languages, callback) };
  req.send(null);
}

function handle_get_language_list(req, element, languages, callback){
  switch (req.readyState) {
    case 2:
      return false;
      break;
    case 3:
      return false;
      break;
    case 4:
      if (req.status != 200) {
        alert(lang_error_status + req.status + "!");
      } else {
        var xml = req.responseXML;
        
        array_langs = [];
        langs = xml.getElementsByTagName("xml");
        for(i=0; i<langs[0].getElementsByTagName("lang").length; i++){
          var lang  = langs[0].getElementsByTagName("lang")[i].firstChild.nodeValue;
          var bLang = lang[0].toUpperCase() + lang.substr(1, lang.length-1);
          array_langs.push([lang, bLang]);
        }
        array_langs.sort();
        languages = languages.concat(array_langs);
            
        do{
          element.removeChild(element.firstChild);
        } while (element.hasChildNodes())
        
        var own_lang = window.navigator.language.substr(0,2).toLowerCase();
            
        for(var i = 0; i < languages.length; i++){
          var option = document.createElement("option");
            option.setAttribute("value",languages[i][0]);
            option.textContent = languages[i][1];
          element.appendChild(option);
          if(languages[i][0].indexOf(own_lang)!=-1)
            element.value = languages[i][0];
        }
        
        if(callback != null)
          callback();
      
      }
      break;
    default:
      alert(lang_error_readyState + req.readyState + "!");
      return false;
      break;
  }
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//upload_stream_global
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function upload_stream_global(){
  //Check
  if(!document.getElementById("upload_share_global_tag").validity.valid)
    return;
  
  //XML Initialisieren
  var xml = null;
  if (window.DOMParser) {
    var parser = new DOMParser ();
    xml = parser.parseFromString ("<xml></xml>", "text/xml");
  } else if (window.ActiveXObject) {
    xml = new ActiveXObject ("Microsoft.XMLDOM");
    xml.async = false;
    xml.loadXML ("<xml></xml>");
  } else {
    alert("Error creating xml object!");
    return null;
  }
  
  //xml bauen
  
  var share_id = xml.createElement("share_id");
  share_id.textContent = id;
  xml.getElementsByTagName("xml")[0].appendChild(share_id);
  
  var name = document.getElementById("upload_share_global_name").value;
  var URL  = localStorage.getItem("stream_list_db_"+name);
  var tags = document.getElementById("upload_share_global_tag").value;
  var lang = document.getElementById("upload_share_global_language").value;
  
  if(lang == "other"){
  var error = true;
    while(error){
      lang = prompt(lang_prompt_language,"");
      
      error = false;
      if(lang==null || lang.length<2 || lang.length>3)
        error = true;
      else if(lang.indexOf(";")!=-1)
        error = true;
      else if(lang.indexOf("'")!=-1)
        error = true;
      else if(lang.indexOf("\"")!=-1)
        error = true;
      else if(lang.indexOf("<")!=-1)
        error = true;
      else if(lang.indexOf(">")!=-1)
        error = true;
      else if(lang.indexOf("=")!=-1)
        error = true;
      else if(lang.indexOf("?")!=-1)
        error = true;
      else if(lang.indexOf("$")!=-1)
        error = true;
      else if(lang.indexOf("&")!=-1)
        error = true;
      
      if(error)
        alert(lang_prompt_language_error);
    }
  }
  
  if(!confirm(lang_stream_checked))
    return;
  
  var stream = xml.createElement("stream");
    var tname = xml.createElement("name");
      tname.textContent = name;
    stream.appendChild(tname);
    
    var turl = xml.createElement("url");
      turl.textContent = URL;
    stream.appendChild(turl);
    
    var ttags = xml.createElement("tags");
      ttags.textContent = tags.toLowerCase();
    stream.appendChild(ttags);
    
    var tlang = xml.createElement("lang");
      tlang.textContent = lang.toLowerCase();
    stream.appendChild(tlang);
  xml.getElementsByTagName("xml")[0].appendChild(stream);
  
  //xml senden
  var xmlstring = new XMLSerializer().serializeToString(xml.documentElement);
  xmlstring = "xml=" + xmlstring;
  
  var req = null;
  req = request("POST",share_url+"/php/upload_stream_global.php");
  req.setRequestHeader("Content-length", xmlstring.length);
  req.setRequestHeader("Connection", "close");
  req.onreadystatechange = function(){ handle_upload_stream_global(req); }
  req.send(xmlstring);
}

function handle_upload_stream_global(req){
  switch (req.readyState) {
    case 2:
      return false;
      break;
    case 3:
      return false;
      break;
    case 4:
      if (req.status != 200) {
        alert(lang_error_status + req.status + "!");
      } else {
        var xml = req.responseXML;
        
        var error = xml.getElementsByTagName("error")[0].textContent;
        if(error != "false")
          alert(lang_upload_share_error_global+error);
        else
          alert(lang_uploaded_global);
      }
      break;
    default:
      alert(lang_error_readyState + req.readyState + "!");
      return false;
      break;
  }
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//edit_stream_global
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function edit_stream_global(old_name, old_url){
  //Check
  if(!document.getElementById("global_share_options_edit_url" ).validity.valid || !document.getElementById("global_share_options_edit_name").validity.valid || !document.getElementById("global_share_options_edit_tags").validity.valid){
    alert(lang_stream_invalid);
    return;
  }
  
  var args = {"old_name":old_name, "old_url":old_url};
  var URL  = document.getElementById("global_share_options_edit_url").value;
  if(check_m3u(URL, "edit_global", args) || check_xspf(URL, "edit_global", args))
    return;
  
  finish_edit_stream_global(old_name, old_url, URL);
}
  
function finish_edit_stream_global(old_name, old_url, URL){
  //XML Initialisieren
  var xml = null;
  if (window.DOMParser) {
    var parser = new DOMParser ();
    xml = parser.parseFromString ("<xml></xml>", "text/xml");
  } else if (window.ActiveXObject) {
    xml = new ActiveXObject ("Microsoft.XMLDOM");
    xml.async = false;
    xml.loadXML ("<xml></xml>");
  } else {
    alert("Error creating xml object!");
    return null;
  }
  
  //xml bauen
  
  var share_id = xml.createElement("share_id");
  share_id.textContent = id;
  xml.getElementsByTagName("xml")[0].appendChild(share_id);
  
  var name = document.getElementById("global_share_options_edit_name"    ).value;
  var tags = document.getElementById("global_share_options_edit_tags"    ).value;
  var lang = document.getElementById("global_share_options_edit_language").value;
  
  if(lang == "other"){
  var error = true;
    while(error){
      lang = prompt(lang_prompt_language,"");
      
      error = false;
      if(lang==null || lang.length<2 || lang.length>3)
        error = true;
      else if(lang.indexOf(";")!=-1)
        error = true;
      else if(lang.indexOf("'")!=-1)
        error = true;
      else if(lang.indexOf("\"")!=-1)
        error = true;
      else if(lang.indexOf("<")!=-1)
        error = true;
      else if(lang.indexOf(">")!=-1)
        error = true;
      else if(lang.indexOf("=")!=-1)
        error = true;
      else if(lang.indexOf("?")!=-1)
        error = true;
      else if(lang.indexOf("$")!=-1)
        error = true;
      else if(lang.indexOf("&")!=-1)
        error = true;
      
      if(error)
        alert(lang_prompt_language_error);
    }
  }
  
  var stream = xml.createElement("stream");
    var tname = xml.createElement("name");
      tname.textContent = name;
    stream.appendChild(tname);
    
    var turl = xml.createElement("url");
      turl.textContent = URL;
    stream.appendChild(turl);
    
    var ttags = xml.createElement("tags");
      ttags.textContent = tags.toLowerCase();
    stream.appendChild(ttags);
    
    var tlang = xml.createElement("lang");
      tlang.textContent = lang.toLowerCase();
    stream.appendChild(tlang);
  
    var told_name = xml.createElement("old_name");
      told_name.textContent = old_name;
    stream.appendChild(told_name);
  
    var told_url = xml.createElement("old_url");
      told_url.textContent = old_url;
    stream.appendChild(told_url);
  xml.getElementsByTagName("xml")[0].appendChild(stream);
  
  //xml senden
  var xmlstring = new XMLSerializer().serializeToString(xml.documentElement);
  xmlstring = "xml=" + xmlstring;
  
  var req = null;
  req = request("POST",share_url+"/php/edit_stream_global.php");
  req.setRequestHeader("Content-length", xmlstring.length);
  req.setRequestHeader("Connection", "close");
  req.onreadystatechange = function(){ handle_edit_stream_global(req); }
  req.send(xmlstring);
}

function handle_edit_stream_global(req){
  switch (req.readyState) {
    case 2:
      return false;
      break;
    case 3:
      return false;
      break;
    case 4:
      if (req.status != 200) {
        alert(lang_error_status + req.status + "!");
      } else {
        var xml = req.responseXML;
        
        var error = xml.getElementsByTagName("error")[0].textContent;
        if(error != "false")
          alert(lang_edit_share_error_global+error); 
        else{
          alert(lang_edited_global);
          build_global_list();
        }
        
        document.getElementById("table_share_global").style.display="inline-table";
        document.getElementById("table_global_share_options_edit").style.display="none";
      }
      break;
    default:
      alert(lang_error_readyState + req.readyState + "!");
      return false;
      break;
  }
}




document.getElementById("button_share_global"         ).addEventListener("click"  , init_share);
document.getElementById("button_search_share_global"  ).addEventListener("click"  , build_global_list);
document.getElementById("select_language_share_global").addEventListener("change" , build_global_list);
/*function onscroll_stream_list_global(){
  if(document.getElementById("stream_list_div").scrollTop > (document.getElementById("stream_list_global").clientHeight - document.getElementById("stream_list_div").clientHeight - 100)){
    loaded_global_streams_offset += 24;
    load_global_streams_section();
  }
}
document.getElementById("stream_list_div"           ).addEventListener("scroll", onscroll_stream_list_global);
*/
