/*jshint onevar: false, quotmark: double*/
/*global webserver, MozActivity*/
window.onload = function () {
	"use strict";

	var carriage = document.querySelector(".carriage");
	var main = document.querySelector("section.main");
	var header = main.querySelectorAll("header")[0];
	var requestCountSpan = header.querySelectorAll(".title .request-count")[0];
	var article = main.querySelectorAll("article")[0];
	var footer = main.querySelectorAll("footer")[0];
	var options = document.querySelector("section.options");
	var portInput = options.querySelectorAll("li.port input")[0];
	var documentRootInput = options.querySelectorAll("li.document-root input")[0];
	var logLevelText = options.querySelectorAll("li.log-level .text")[0];
	var logLevelSelect = options.querySelectorAll("li.log-level select")[0];
	var binaryTypeText = options.querySelectorAll("li.binary-type .text")[0];
	var binaryTypeSelect = options.querySelectorAll("li.binary-type select")[0];
	var persistentConnectionCheckbox = options.querySelectorAll("li.persistent-connection input")[0];
	var helpDialog = document.querySelector(".dialog.help");

	function slideTo(node) {
		var index = Array.prototype.indexOf.call(carriage.childNodes, node);
		carriage.style.transform = "translateX(-" + 50 * index + "%)";
	}

	var logLevelValues = [];
	var binaryTypeValues = [];
	var i;
	for (i = 0; i < logLevelSelect.options.length; i++) {
		logLevelValues.push(logLevelSelect.options[i].textContent);
	}
	for (i = 0; i < binaryTypeSelect.options.length; i++) {
		binaryTypeValues.push(binaryTypeSelect.options[i].textContent);
	}

	if (!localStorage.documentRoot) {
		localStorage.port = 8080;
		localStorage.documentRoot = "/";
		localStorage.logLevel = "Info";
		localStorage.binaryType = "string";
		localStorage.persistentConnection = 1;
	}
	
	persistentConnectionCheckbox.addEventListener("change", function() {
		localStorage.persistentConnection = persistentConnectionCheckbox.checked ? 1 : 0;
	}, false);
	persistentConnectionCheckbox.checked = localStorage.persistentConnection !== "0";

	portInput.value = localStorage.port;
	documentRootInput.value = localStorage.documentRoot;
	var index = logLevelValues.indexOf(localStorage.logLevel);
	if (index >= 0 && index !== logLevelSelect.selectedIndex) {
		logLevelSelect.options[logLevelSelect.selectedIndex].selected = false;
		logLevelSelect.options[index].selected = true;
	}
	logLevelText.textContent = localStorage.logLevel;
	index = binaryTypeValues.indexOf(localStorage.binaryType);
	if (index >= 0 && index !== binaryTypeSelect.selectedIndex) {
		binaryTypeSelect.options[binaryTypeSelect.selectedIndex].selected = false;
		binaryTypeSelect.options[index].selected = true;
	}
	binaryTypeText.textContent = localStorage.binaryType;

	logLevelSelect.addEventListener("change", function() {
		logLevelText.textContent = logLevelValues[logLevelSelect.selectedIndex];

	}, false);

	binaryTypeSelect.addEventListener("change", function() {
		binaryTypeText.textContent = binaryTypeValues[binaryTypeSelect.selectedIndex];
	}, false);

	header.querySelectorAll("button.options")[0].addEventListener("click", function () {
		slideTo(options);
	}, false);

	function numericVal(node, defaultValue, min, max) {
		var value = node.value;
		value = (value && isFinite(value)) ? Number(value) : defaultValue;
		return Math.max(min, Math.min(max, value));
	}

	options.querySelectorAll("header button.back")[0].addEventListener("click", function () {
		portInput.value = localStorage.port = numericVal(portInput, localStorage.port, 1, 65535);
		var documentRoot = documentRootInput.value;
		if (documentRoot.charAt(documentRoot.length - 1) === "/") {
			documentRoot = documentRoot.substring(0, documentRoot.length - 1);
		}
		if (documentRoot.charAt(0) !== "/") {
			documentRoot = "/" + documentRoot;
		}
		documentRootInput.value = localStorage.documentRoot = documentRoot;
		localStorage.logLevel = logLevelValues[logLevelSelect.selectedIndex];
		updateLogLevel();
		localStorage.binaryType = binaryTypeValues[binaryTypeSelect.selectedIndex];
		slideTo(main);
	}, false);

	var logLevels;
	var logLevel;
	function updateLogLevel() {
		logLevels = {};
		logLevel = logLevels[logLevelSelect.selectedIndex];
		for (var i = logLevelSelect.selectedIndex; i < logLevelValues.length; i++) {
			logLevels[logLevelValues[i]] = true;
		}
	}
	updateLogLevel();

	function log(level, obj, msg) {
		if (logLevels[level]) {
			var lastVisible;
			var lastChild = article.lastChild;
			if (lastChild) {
				lastVisible = lastChild.offsetTop <= article.scrollTop + article.clientHeight;
			}
			if (article.childNodes.length > 2000) {
				while (article.childNodes.length > 2000 - 100) {
					article.removeChild(article.firstChild);
				}
			}
			var div = document.createElement("div");
			var span = document.createElement("span");
			span.className = "icon " + level.toLowerCase();
			div.appendChild(span);
			var text = document.createTextNode(" [" + obj + "] " + msg);
			div.appendChild(text);
			article.appendChild(div);
			if (lastVisible) {
				var lastBottom = div.offsetTop + div.offsetHeight;
				var diff = lastBottom - (article.scrollTop + article.clientHeight);
				if (diff > 0) {
					article.scrollTop += diff;
				}
			}
		}
	}

	webserver.debug = function(obj, msg) {
		log("Debug", obj, msg);
	};

	webserver.info = function(obj, msg) {
		log("Info", obj, msg);
	};

	webserver.warn = function(obj, msg) {
		log("Warn", obj, msg);
	};

	webserver.error = function(obj, msg) {
		log("Error", obj, msg);
	};

	webserver.sdcards = {};
	if (!navigator.getDeviceStorages) {
		webserver.error("Main", "No DeviceStorages implemented");
	} else {
		try {
			var sdcards = navigator.getDeviceStorages("sdcard");
			for (i = 0; i < sdcards.length; i++) {
				var sdcard = sdcards[i];
				webserver.sdcards[sdcard.storageName] = sdcard;
				webserver.info("Main", "Detected device storage: " + sdcard.storageName);
			}
		} catch (e) {
			webserver.error("Main", "DeviceStorages: " + (e.message || e));
		}
	}
	
	function forseUserPermission() {
		for (var sdcard in sdcards) {
			sdcards[sdcard].enumerate();
			break;
		}
	}

	var server = new webserver.Server();
	
	var playButton = footer.querySelectorAll(".play")[0];
	var browseButton = footer.querySelectorAll(".browse")[0];

	webserver.updateServerStatus = function() {
		playButton.textContent = server.isRunning() ? "\ue686" : "\ue67c";
		browseButton.disabled = !server.isRunning();
	};
	
	var requestCount = 0;
	function updateTitle() {
		requestCountSpan.textContent = requestCount ? "(" + requestCount + ")" : "";
	}
	webserver.incRequestCount = function() {
		++requestCount;
		updateTitle();
	};
		
	playButton.addEventListener("click", function () {
		if (server.isRunning()) {
			server.stop();
		} else {
			requestCount = 0;
			updateTitle();
			forseUserPermission();
			server.start();
		}
		webserver.updateServerStatus();
	}, false);
	
	webserver.updateServerStatus();

	browseButton.addEventListener("click", function () {
		try {
			var activity = new MozActivity({
				name: "view",
				data: {
					type: "url",
					url: "http://localhost:" + server.port + "/"
				}
			});
			activity.onerror = function () {
				webserver.warn("Main", "Browse: " + this.error.name);
			};
		} catch (e) {
			webserver.warn("Main", "Browse: " + (e.message || e));
			if (server) {
				server.close();
				server = null;
			}
		}
	}, false);

	footer.querySelectorAll(".clear")[0].addEventListener("click", function () {
		while (article.hasChildNodes()) {
			article.removeChild(article.lastChild);
		}
	}, false);

	footer.querySelectorAll(".help")[0].addEventListener("click", function () {
		if (server.isRunning() && logLevels.Debug) {
			server.dumpState();
		} else {
			helpDialog.classList.add("open");
		}
	}, false);

	helpDialog.querySelectorAll("header button.close")[0].addEventListener("click", function() {
		helpDialog.classList.remove("open");
	}, false);
};
