/*jshint onevar: false, quotmark: double*/
/*global webserver*/
webserver.Server = function () {
	"use strict";

	var sockets = [];
	var serverSocket;
	
	this.start = function () {
		try {
			var documentRoot = localStorage.documentRoot;
			var binaryType = localStorage.binaryType;
			var persistentConnection = localStorage.persistentConnection === "1";
			this.port = Number(localStorage.port);
			if (documentRoot === "/") {
				documentRoot = "";
			}
			if (!navigator.mozTCPSocket) {
				throw "No TCPSocket implemented";
			}
			serverSocket = navigator.mozTCPSocket.listen(this.port, { binaryType: binaryType });
			serverSocket.onerror = function (e) {
				webserver.error("Server", e.data || e.message || e);
			};
			serverSocket.onconnect = function (e) {
				try {
					var id = "Socket-" + (sockets.length + 1);
					webserver.debug("Server", "Connected " + id);
					var socket = new webserver.Socket(id, e.socket || e, documentRoot, persistentConnection);
					sockets.push(socket);
				} catch (e) {
					webserver.error("Server", e.message || e);
				}
			};
			webserver.info("Server", "Started on port " + this.port);
		} catch (e) {
			webserver.error("Server", e.message || e);
		}
	};
	
	this.stop = function () {
		try {
			serverSocket.close();
			for (var i = 0; i < sockets.length; i++) {
				sockets[i].close();
			}
			sockets = [];
			serverSocket = null;
			webserver.info("Server", "Stopped");
		} catch (e) {
			webserver.error("Server", e.message || e);
		}
	};
	
	this.isRunning = function() {
		return Boolean(serverSocket);
	};
	
	this.dumpState = function() {
		for (var i = 0; i < sockets.length; i++) {
			sockets[i].dumpState();
		}
	};

};
