function renderEntry(entry) {
	// CREATE RENDER HTML
	var date = new Date(parseInt(entry.created_on));
	console.log(entry.created_on);
	var date_string = date.format("dddd, mmmm dS");
	var html = '';
	html += '<li rel="entry" class="entry" data-entryid="'+entry.created_on+'">';
	html += '<span class="weight">'+entry.weight+'</span> ';
	html += '<span class="date">'+date_string+'</span>';
	html += '<button class="btn button-remove"><i class="glyphicon glyphicon-trash"></i></button>'
	html += '</li>';
	// RETURN RENDER HTML
	return html;
}

function renderNewEntry(entry) {
	var list = $("#weight-list");
	list.html(""+renderEntry(entry)+list.html());
}

function removeEntry(event) {
	var ele = $(event.target).parent();
	var entryId = $(ele).attr("data-entryid");

	// REMOVE ENTRY
	var request = window.db.transaction(["records"], "readwrite")
                .objectStore("records")
                .delete(entryId);
	request.onsuccess = function(event) {
	  	hideRenderedEntry(ele);
	};
	request.onerror = function(event) {
		alert("Error: Entry was not removed.");
	};
}

function hideRenderedEntry(ele) {
	ele.slideUp(200);
	// NOTE: ELEMENT IS NOT ACTUALLY REMOVED
} 

function writeEntry(weight_val) {
	// INITIALIZE NECESSARY DATA
	var date = new Date();
	var created_on = date.getTime();

	// CREATE RECORD
	var entry = {created_on: ""+created_on, weight: ""+weight_val}; 

	// OPEN TRANSACTION
	var transaction = window.db.transaction(["records"], "readwrite");
	transaction.oncomplete = function(event) {
		console.log("IndexedDB Transaction Complete");
	}
	transaction.onerror = function(event) {
		alert("Error: " + event);
	}
	// OPEN OBJECTSTORE
	var objectStore = transaction.objectStore("records");
	var request = objectStore.add(entry);
	request.onsuccess = function(event) {
		renderNewEntry(entry);
	}

	// ADD ENTRY TO THE CHART
	// CREATE CHART ENTRY
	var chartEntry = new Array();
	chartEntry[0] = parseInt(entry.created_on);
	chartEntry[1] = parseFloat(entry.weight);
	window.weights[window.weights.length] = chartEntry;
	renderChart();
}

function renderChart() {
	$.plot("#chart", [window.weights], {
		xaxis: { 
			mode: "time",
			minTickSize: [1, "day"]
		}
	});
}

$(document).ready(function() {

	window.screen.onmozorientationchange = function() { 
		$("#body").toggleClass("portrait-primary", false);
		$("#body").toggleClass("portrait-secondary", false);
		$("#body").toggleClass("landscape-primary", false);
		$("#body").toggleClass("landscape-secondary", false);
		$("#body").toggleClass(screen.mozOrientation, true);
	}
	$("#body").toggleClass(screen.mozOrientation);

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////
	// INITIALIZE STORAGE HANDLER
	/////////////////////////////////////////////////////////////////////////////////////////
	window.weights = new Array();
	var request = indexedDB.open("Weight", 1);
	// ERROR
	request.onerror = function(event) {
		alert("Weight needs local storage to store your weight information");
	};
	// UPGRADE
	request.onupgradeneeded = function(event) {
		window.db = event.target.result;
		var objectStore = window.db.createObjectStore("records", { keyPath: "created_on" });
	}
	// SUCCESS
	request.onsuccess = function(event) {
	  	window.db = request.result;

	  	// LOAD ALL EXISING ENTRIES
		var entries = [];

		var objectStore = window.db.transaction("records").objectStore("records");
		objectStore.openCursor().onsuccess = function(event) {
		  	var cursor = event.target.result;
		  	if (cursor) {
		    	entries.push(cursor.value);
		    	cursor.continue();
		  	}
		  	else {
		    	// RENDER ALL ENTRIES
		    	var html = ''
		    	for(var i=0; i<entries.length; i++) {
		    		// ADD DATA ENTRY TO LIST
		    		var dataEntry = new Array();
		    		dataEntry[0] = parseInt(entries[i].created_on);
		    		dataEntry[1] = parseFloat(entries[i].weight);
		    		window.weights[window.weights.length] = dataEntry;
		    		// RENDER HTML
		    		html = renderEntry(entries[i])+html;
		    	}
		    	$("#weight-list").html(html);
		    	renderChart();
		  	}
		};
	};
	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////
	

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////
  	// ADD BUTTON INTERACTION
  	/////////////////////////////////////////////////////////////////////////////////////////
  	$("#btn-add").on("click", function() {

  		var input = $("#input-weight");
  		var weight = input.val();
  		input.val('');

  		if(weight) {
  			writeEntry(weight);
  		}
  		else {
  			alert("Please enter a weight.");
  		}

  	});
  	/////////////////////////////////////////////////////////////////////////////////////////
  	/////////////////////////////////////////////////////////////////////////////////////////

  	/////////////////////////////////////////////////////////////////////////////////////////
  	/////////////////////////////////////////////////////////////////////////////////////////
  	// EDIT BUTTON INTERACTION
  	/////////////////////////////////////////////////////////////////////////////////////////
  	window.editmode = false;
  	$("#btn-edit").on("click", function() {
  		var list = $("#weight-list");
  		if(window.editmode) {
  			// REMOVE EDIT
  			$(this).toggleClass("mode-edit", false);
  			list.toggleClass("mode-edit", false);
  		}
  		else {
  			// SHOW EDIT
  			$(this).toggleClass("mode-edit", true);
  			list.toggleClass("mode-edit", true);
  			$(".button-remove").on("click", function(event) { removeEntry(event); });
  		}
  		window.editmode = !window.editmode;
  	});
  	/////////////////////////////////////////////////////////////////////////////////////////
  	/////////////////////////////////////////////////////////////////////////////////////////
  	
});
