var serverTime;
var secret="n80RslQFDSxtnlAPcBYrEAQt4Y0Zk3Gn";
var date;
var dateObj;
var localDateObj;
var localDate;
var jForecast;
var jHSForecast;
var rRConfig;
var rRData;
var db;
var locations=new Array();
var bev=5;

var weekday=new Array(7);
weekday[0]="Sonntag";
weekday[1]="Montag";
weekday[2]="Dienstag";
weekday[3]="Mittwoch";
weekday[4]="Donnerstag";
weekday[5]="Freitag";
weekday[6]="Samstag";

var interval=new Array(4);
interval[0]="Nacht";
interval[1]="Vormittag";
interval[2]="Nachmittag";
interval[3]="Abend";

var tempHSArray=new Array();

var inLoop = false;
var infiniteLoop;

Date.prototype.addHours= function(h){
    this.setHours(this.getHours()+h);
    return this;
}

window.onload = getServerTime;


function addMenuListener(menuIdx, btnIdx){
	var menuEntry = document.getElementById('menuEntry'+menuIdx+'_'+btnIdx);
	menuEntry .onclick = function() { 
		if(btnIdx!=2){
			killRadarLoop();
		}else{
			displayRegenRadar();
		}
	}
}

function initializeDB() {
    if (window.indexedDB) {
    
    }
    else {
     alert("Indexed DB is not supported. Where are you trying to run this ? ");
        }
 
        // open the database
    // 1st parameter : Database name. We are using the name 'locationDB'
    // 2nd parameter is the version of the database.
    var request = indexedDB.open('locationDB', 1);
    
    request.onsuccess = function (e) {
     // e.target.result has the connection to the database
     db = e.target.result;
     loadLastLocations();
     //Alternately, if you want - you can retrieve all the items
    }
    
    request.onerror = function (e) {
     //console.log(e);
    };
    
    // this will fire when the version of the database changes
    // We can only create Object stores in a versionchange transaction.
    request.onupgradeneeded = function (e) {
     // e.target.result holds the connection to database
     db = e.target.result;
    
     if (db.objectStoreNames.contains("locations")) {
     db.deleteObjectStore("locations");
     }
            
     // create a store named 'locations'
     // 1st parameter is the store name
     // 2nd parameter is the key field that we can specify here. Here we have opted for autoIncrement but it could be your
     // own provided value also.
     var objectStore = db.createObjectStore('locations', { keyPath: 'id', autoIncrement: true });

    };
}

function addLocationToDB(location,gID)
{
     // create the transaction with 1st parameter is the list of stores and the second specifies
     // a flag for the readwrite option
     var transaction = db.transaction([ 'locations' ], 'readwrite');
    
     //Create the Object to be saved i.e. our Note
     var value = {};
     value.location = location;
     value.gID = gID;
    
     // add the location to the store
     var store = transaction.objectStore('locations');
     var request = store.add(value);
     request.onsuccess = function (e) {
        $('#lastResultsDB').html("");
        $('#results').css("height", "0px");
        loadLastLocations();
     };
     request.onerror = function (e) {
     	
     }
}

function loadLastLocations()
{
	$('#results').html("");
	$('#results').css("height", "0px");
	
	 var transaction = db.transaction([ 'locations' ]);
     var store = transaction.objectStore('locations');
     var counter=0;
       // open a cursor to retrieve all items from the 'locations' store
     store.openCursor().onsuccess = function (e) {
     var cursor = e.target.result;

     if (cursor) {
     var value = cursor.value;
    	locations[counter]=cursor.value;	
    	counter++;
        cursor.continue();
     }
     else
     {
         getForecastHomeScreen()
     }
    };
}

function deleteLocationFromDB(id)
{
	var location=$('#'+id).attr('locationName');
	var geoID=$('#'+id).attr('geoID');

	 var transaction = db.transaction([ 'locations' ], "readwrite");
     var store = transaction.objectStore('locations');
     var counter=0;
       // open a cursor to retrieve all items from the 'locations' store
     store.openCursor().onsuccess = function (e) {
     var cursor = e.target.result;

     if (cursor) {
     	var value = cursor.value;

        if(value.location==location && value.gID==geoID)
        {
        	cursor.delete();
        }
        else
        {
        	cursor.continue();
        } 
     }
    };	
}

function getForecastHomeScreen()
{
	var url="http://api.wetteronline.de/wetterapp?bev="+bev+"&sid=current&gid_list=";
	var string=bev+"|";
     var startIdx=locations.length-10;
     var endIdx=startIdx+10;
     if (startIdx<0)
     {
     	startIdx=0;
     }
     if(endIdx>locations.length)
     {
     	endIdx=locations.length;
     }
     
     var tempLocations=new Array();
     var tempCount=0;

     for(var i=endIdx-1; i>=startIdx; i--)
     {
     	var value =locations[i];
		if(i==startIdx)
		{
			string+=value.gID;
			url+=value.gID;
			tempLocations[tempCount]=value.location;
			tempCount++;
		}
		else
		{
			string+=value.gID+",";
			url+=value.gID+",";
			tempLocations[tempCount]=value.location;
			tempCount++;
		}	
     }  

     string+="|current|"+date+"|"+secret;
     var checksumHomeScreen=MD5.base64(string)+"==";


	
	var xhr = new XMLHttpRequest({mozSystem: true});
	xhr.open("GET", url+"&checksum="+checksumHomeScreen, true);
	xhr.onreadystatechange = function () {
	      if (xhr.status === 200 && xhr.readyState === 4) {
	    	  
	    	  jHSForecast=JSON.parse(xhr.response);
	    	  var htmlString="";
	    	  for(var i=0; i<jHSForecast.length;i++)
    		  {
//	    		  console.log("location: "+tempLocations[i]);
    		  	  tempHSArray[i]=jHSForecast[i]["gid"];
	    		  htmlString+="<li data-icon='false' id='hsLocation"+i+"' locationName='"+tempLocations[i]+"' geoID='"+jHSForecast[i]["gid"]+"'><a href='#weatherPage'>"+tempLocations[i];
	    		  
	    		  if(jHSForecast[i]["tt"] > 25){
						htmlString+="<div class='tempListLocation tempg25'>";
					}
					else if(jHSForecast[i]["tt"] > 20 && jHSForecast[i]["tt"] <= 25){
						htmlString+="<div class='tempListLocation tempg20'>";
					}
					else if(jHSForecast[i]["tt"] > 15 && jHSForecast[i]["tt"] <= 20){
						htmlString+="<div class='tempListLocation tempg15'>";
					}
					else if(jHSForecast[i]["tt"] > 0 && jHSForecast[i]["tt"] <= 15){
						htmlString+="<div class='tempListLocation tempg0'>";
					}
					else if(jHSForecast[i]["tt"] > -10 && jHSForecast[i]["tt"] <= 0){
						htmlString+="<div class='tempListLocation tempgm10'>";
					}
					else if(jHSForecast[i]["tt"] <= -10){
						htmlString+="<div class='tempListLocation tempkgm10'>";
					}
	    		  
	    		  htmlString+=+jHSForecast[i]["tt"]+"°<img class='imgListLocation' alt='"+jHSForecast[i]["wm"]+".png' src='img/"+jHSForecast[i]["wm"]+".png'></div></a></li>";
    		  }
	    	  
	    	  $("#lastResultsDB").html(""+htmlString);
	    	  $('#lastResultsDB').listview('refresh');

			  var hsLocation;
	    	  for(var i=0; i<jHSForecast.length;i++)
    		  {
    		  	addlistenerFunc(i,jHSForecast[i]["gid"], tempLocations[i]);
    		  }
	      }
	  }

	xhr.onerror = function () {
	     alert(xhr.response);
	};
	xhr.send();	
}

function addlistenerFunc( i, gID, location ) 
{
	
   	var hsLocation=document.getElementById('hsLocation'+i);
   	hsLocation.addEventListener("click", function(e){
        
        getForecast(location, gID,8,"forecast",0);
    }, false)
}

function getLocationByGeoID(gid)
{
    var startIdx=locations.length-5;
    var endIdx=startIdx+5;
    if (startIdx<0)
    {
    	startIdx=0;
    }
    if(endIdx>locations.length)
    {
    	endIdx=locations.length;
    }

    for(var i=endIdx-1; i>=startIdx; i--)
    {
		 var value =locations[i];	
	     if(value.gID==gid)
    	 {
    	 	return value.location
    	 }
    }
    return gid;
}

function getForecast(location, geoID, days, sid, type)
{	
	
	$("#radar").show();
	$("#radarPic").show();
	
	var temp = serverTime.split(" ");
	date= temp[0];
	
	
	var string=bev+"|"+days+"|"+geoID+"|"+sid+"|"+date+"|"+secret;
	var checkSum=MD5.base64(string)+"==";

	var url="";
	
	
	switch (type)
	{
		case 0:
			url="http://api.wetteronline.de/wetterapp?bev="+bev+"&sid="+sid+"&gid="+geoID+"&days="+days+"&checksum="+checkSum;
			break;
		default:
			
			break;
	}

	var xhr = new XMLHttpRequest({mozSystem: true});
	xhr.open("GET", url, true);
	xhr.onreadystatechange = function () {
	      if (xhr.status === 200 && xhr.readyState === 4) {
	    	  jForecast=xhr.response;
	    	  	switch (type)
				{
					case 0:
						displayForecastMain(location, geoID);
						$('.weatherCurLoc').html("<img src='img/ic_flap_60x60.png' class='ui-li-icon-flap'><img src='img/wo_ic_wetter.png' class='ui-li-icon'>Wetter " +location);
						$('.weatherCurLoc_active').html("<img src='img/ic_flap_60x60.png' class='ui-li-icon-flap'><img src='img/wo_ic_wetter_active.png' class='ui-li-icon'>Wetter " +location);
						break;
					default:
						
						break;
				}
	      }
	  }

	xhr.onerror = function () {
	     alert(xhr.response);
	};
	xhr.send();
}

function getLocalDate(localDateString) {
	var dateArray = localDateString.split(' ');
    var year = dateArray[0].split('-');
    var time = dateArray[1].split(':');
    if((time[1]*1)>45)
	{
    	time[1]=0;
    	localDateObj = new Date(year[0]*1, year[1]-1, year[2]*1, time[0]*1, time[1]*1, time[2]*1).addHours(1);
	}
    else
    {
    	localDateObj = new Date(year[0]*1, year[1]-1, year[2]*1, time[0]*1, time[1]*1, time[2]*1)
    }   	
    localDate=dateArray[0];
}




function displayForecastMain(location, gid)
{
	
	var weatherData=JSON.parse(jForecast);
	$('#results').html("");
	
	getLocalDate(weatherData["local_date"]);
	
	var htmlString="";
	
	var dayCounter=0;
	var hoursFirstDay=0;

	var tempDate=new Date(localDateObj);
	tempDate.setHours(tempDate.getHours());
	hoursFirstDay=24-tempDate.getHours();
	var tempIdx=0;
	var dayID=new Array();
	var dayTimeID=new Array();
	dayTimeID[0]="dayTime0";
	for(var i=0;i<weatherData["intervals"].length;i++)
	{
		
		dayID[i]="day"+dayCounter;
		if(i>(23+hoursFirstDay))
		{
			htmlString+="<li id='dayTime"+i+"' day='"+dayCounter+"'><div class='list-hour-weatherText'><div class='list-hour-top'>"+interval[tempIdx]+"</div><div class='list-hour-bottom'>";
				
			if(weatherData["intervals"][i]["tt"] > 25){
					htmlString+="<div class='temp-hour tempg25'>";
				}
				else if(weatherData["intervals"][i]["tt"] > 20 && weatherData["intervals"][i]["tt"] <= 25){
					htmlString+="<div class='temp-hour tempg20'>";
				}
				else if(weatherData["intervals"][i]["tt"] > 15 && weatherData["intervals"][i]["tt"] <= 20){
					htmlString+="<div class='temp-hour tempg15'>";
				}
				else if(weatherData["intervals"][i]["tt"] > 0 && weatherData["intervals"][i]["tt"] <= 15){
					htmlString+="<div class='temp-hour tempg0'>";
				}
				else if(weatherData["intervals"][i]["tt"] > -10 && weatherData["intervals"][i]["tt"] <= 0){
					htmlString+="<div class='temp-hour tempgm10'>";
				}
				else if(weatherData["intervals"][i]["tt"] <= -10){
					htmlString+="<div class='temp-hour tempkgm10'>";
				}
			htmlString+=+weatherData["intervals"][i]["tt"]+"°</div><img class='weatherIcon-hour' alt='"+weatherData["intervals"][i]["wm"]+".png' src='img/"+weatherData["intervals"][i]["wm"]+".png'><div class='rain-hour'>";
			
			if(weatherData["intervals"][i]["pop"] < 50) {
					htmlString+="<img src='img/wo_icn_umbrella_close.png'> ";
				}
				else {
					htmlString+="<img src='img/wo_icn_umbrella_open.png'> ";
				}
			htmlString+=+weatherData["intervals"][i]["pop"]+"%</div></div></div></li>";
			
			
			if(tempIdx>=3)
			{
				dayTimeID[dayCounter+1]="dayTime"+(i+1);
				dayCounter++;
				tempIdx=0;
			}
			else
			{
				tempIdx++;
			}
		}
		else
		{
			
			htmlString+="<li id='dayTime"+i+"' day='"+dayCounter+"'><div class='list-hour-weatherText'><div class='list-hour-top'>"+tempDate.getHours()+":00</div><div class='list-hour-bottom'>";
			
			if(weatherData["intervals"][i]["tt"] > 25){
					htmlString+="<div class='temp-hour tempg25'>";
				}
				else if(weatherData["intervals"][i]["tt"] > 20 && weatherData["intervals"][i]["tt"] <= 25){
					htmlString+="<div class='temp-hour tempg20'>";
				}
				else if(weatherData["intervals"][i]["tt"] > 15 && weatherData["intervals"][i]["tt"] <= 20){
					htmlString+="<div class='temp-hour tempg15'>";
				}
				else if(weatherData["intervals"][i]["tt"] > 0 && weatherData["intervals"][i]["tt"] <= 15){
					htmlString+="<div class='temp-hour tempg0'>";
				}
				else if(weatherData["intervals"][i]["tt"] > -10 && weatherData["intervals"][i]["tt"] <= 0){
					htmlString+="<div class='temp-hour tempgm10'>";
				}
				else if(weatherData["intervals"][i]["tt"] <= -10){
					htmlString+="<div class='temp-hour tempkgm10'>";
				}
			htmlString+=+weatherData["intervals"][i]["tt"]+"°</div><img class='weatherIcon-hour' alt='"+weatherData["intervals"][i]["wm"]+".png' src='img/"+weatherData["intervals"][i]["wm"]+".png'><div class='rain-hour'>";
			
			if(weatherData["intervals"][i]["pop"] < 50) {
				htmlString+="<img src='img/wo_icn_umbrella_close.png'> ";
			}
			else {
				htmlString+="<img src='img/wo_icn_umbrella_open.png'> ";
			}
			htmlString+=+weatherData["intervals"][i]["pop"]+"%</div></div></div></li>";
			
			
			if(tempDate.getHours()==23)
			{
				dayTimeID[dayCounter+1]="dayTime"+(i+1);
				dayCounter++;
			}

			tempDate=new Date(localDateObj);
			tempDate.setHours(tempDate.getHours()+(i+1));
		}
	}
	dayTimeID[1]="dayTime"+(hoursFirstDay+6);
	
	
	var divWidth=weatherData["intervals"].length*80;

	$('#scroller-hour').css("width", divWidth+"px");
	$('#list-hour').html(""+htmlString);

	for(var i=0;i<weatherData["intervals"].length;i++)
	{
		addlistenerFuncFC(i, "dayTime", dayID[i], dayID[i]);
	}

	
	$('#headerCur').html(location+" aktuell "+weatherData["current"]["tt"]+"°");

	
	var tempDate;
	
	htmlString="";
	for(var i=0;i<weatherData["days"].length;i++)
	{
		
		tempDate = new Date(localDateObj.getFullYear(), localDateObj.getMonth(), localDateObj.getDate()+i); 
		var label="";
		if(i==0)
		{
			label="heute";
		}
		if(i==1)
		{
			label="morgen";
		}
		if(i>1)
		{
			label=weekday[tempDate.getDay()];

		}
		var month = '0' + (tempDate.getMonth() + 1);
	    month = month.slice(-2, (month.length - 2) + 3);
	    var day = '0' + tempDate.getDate();
		day = day.slice(-2, (day.length - 2) + 3);
		var dateToDisplay=day+"."+month+".";
		
		if(i==0)
		{
			htmlString+="<li id='day"+i+"'><div class='list-day-weatherText'><div class='dayTop list-day-top-select'><div class='space'></div>"+label+"<br>"+dateToDisplay+"</div><div class='dayBottom list-day-bottom-select'><div class='temp-day'><span class='maxMin'>max</span>";
			
			if(weatherData["days"][i]["tx"] > 25){
				htmlString+="<div class='maxContent tempg25'>";
			}
			else if(weatherData["days"][i]["tx"] > 20 && weatherData["days"][i]["tx"] <= 25){
				htmlString+="<div class='maxContent tempg20'>";
			}
			else if(weatherData["days"][i]["tx"] > 15 && weatherData["days"][i]["tx"] <= 20){
				htmlString+="<div class='maxContent tempg15'>";
			}
			else if(weatherData["days"][i]["tx"] > 0 && weatherData["days"][i]["tx"] <= 15){
				htmlString+="<div class='maxContent tempg0'>";
			}
			else if(weatherData["days"][i]["tx"] > -10 && weatherData["days"][i]["tx"] <= 0){
				htmlString+="<div class='maxContent tempgm10'>";
			}
			else if(weatherData["days"][i]["tx"] <= -10){
				htmlString+="<div class='maxContent tempkgm10'>";
			}
			
			htmlString+=+weatherData["days"][i]["tx"]+"°</div><img id='divider' src='img/wo_bg_divider_20x2.9.png'><br><span class='maxMin'>min</span>";
			
			if(weatherData["days"][i]["tn"] > 25){
				htmlString+="<div class='minContent tempg25'>";
			}
			else if(weatherData["days"][i]["tn"] > 20 && weatherData["days"][i]["tn"] <= 25){
				htmlString+="<div class='minContent tempg20'>";
			}
			else if(weatherData["days"][i]["tn"] > 15 && weatherData["days"][i]["tn"] <= 20){
				htmlString+="<div class='minContent tempg15'>";
			}
			else if(weatherData["days"][i]["tn"] > 0 && weatherData["days"][i]["tn"] <= 15){
				htmlString+="<div class='minContent tempg0'>";
			}
			else if(weatherData["days"][i]["tn"] > -10 && weatherData["days"][i]["tn"] <= 0){
				htmlString+="<div class='minContent tempgm10'>";
			}
			else if(weatherData["days"][i]["tn"] <= -10){
				htmlString+="<div class='minContent tempkgm10'>";
			}
			
			htmlString+=+weatherData["days"][i]["tn"]+"°</div><img class='weatherIcon-day' alt='"+weatherData["days"][i]["wm"]+".png' src='img/"+weatherData["days"][i]["wm"]+".png'></div><div class='rain-sun-day'>";
			
			
			if(weatherData["days"][i]["pop"] < 50) {
				htmlString+="<img src='img/wo_icn_umbrella_close.png'> ";
			}
			else {
				htmlString+="<img src='img/wo_icn_umbrella_open.png'> ";
			}
			htmlString+=+weatherData["days"][i]["pop"]+"%<br><img src='img/wo_icn_sun.png'> "+weatherData["days"][i]["sd"]+"h</div></div></div></li>";
		}
		else
		{
			htmlString+="<li id='day"+i+"'><div class='list-day-weatherText'><div class='dayTop list-day-top-noneSelect'><div class='space'></div>"+label+"<br>"+dateToDisplay+"</div><div class='dayBottom list-day-bottom-noneSelect'><div class='temp-day'><span class='maxMin'>max</span>";
			
			if(weatherData["days"][i]["tx"] > 25){
				htmlString+="<div class='maxContent tempg25'>";
			}
			else if(weatherData["days"][i]["tx"] > 20 && weatherData["days"][i]["tx"] <= 25){
				htmlString+="<div class='maxContent tempg20'>";
			}
			else if(weatherData["days"][i]["tx"] > 15 && weatherData["days"][i]["tx"] <= 20){
				htmlString+="<div class='maxContent tempg15'>";
			}
			else if(weatherData["days"][i]["tx"] > 0 && weatherData["days"][i]["tx"] <= 15){
				htmlString+="<div class='maxContent tempg0'>";
			}
			else if(weatherData["days"][i]["tx"] > -10 && weatherData["days"][i]["tx"] <= 0){
				htmlString+="<div class='maxContent tempgm10'>";
			}
			else if(weatherData["days"][i]["tx"] <= -10){
				htmlString+="<div class='maxContent tempkgm10'>";
			}
			
			htmlString+=+weatherData["days"][i]["tx"]+"°</div><img id='divider' src='img/wo_bg_divider_20x2.9.png'><br><span class='maxMin'>min</span>";
			
			if(weatherData["days"][i]["tn"] > 25){
				htmlString+="<div class='minContent tempg25'>";
			}
			else if(weatherData["days"][i]["tn"] > 20 && weatherData["days"][i]["tn"] <= 25){
				htmlString+="<div class='minContent tempg20'>";
			}
			else if(weatherData["days"][i]["tn"] > 15 && weatherData["days"][i]["tn"] <= 20){
				htmlString+="<div class='minContent tempg15'>";
			}
			else if(weatherData["days"][i]["tn"] > 0 && weatherData["days"][i]["tn"] <= 15){
				htmlString+="<div class='minContent tempg0'>";
			}
			else if(weatherData["days"][i]["tn"] > -10 && weatherData["days"][i]["tn"] <= 0){
				htmlString+="<div class='minContent tempgm10'>";
			}
			else if(weatherData["days"][i]["tn"] <= -10){
				htmlString+="<div class='minContent tempkgm10'>";
			}
			
			htmlString+=+weatherData["days"][i]["tn"]+"°</div><img class='weatherIcon-day' alt='"+weatherData["days"][i]["wm"]+".png' src='img/"+weatherData["days"][i]["wm"]+".png'></div><div class='rain-sun-day'>";
			
			
			if(weatherData["days"][i]["pop"] < 50) {
				htmlString+="<img src='img/wo_icn_umbrella_close.png'> ";
			}
			else {
				htmlString+="<img src='img/wo_icn_umbrella_open.png'> ";
			}
			htmlString+=+weatherData["days"][i]["pop"]+"%<br><img src='img/wo_icn_sun.png'> "+weatherData["days"][i]["sd"]+"h</div></div></div></li>";
		}
	}
	$('#list-day').html(""+htmlString);

	for(var i=0;i<weatherData["days"].length;i++)
	{
		addlistenerFuncFC(i, "day", dayTimeID[i]);
	}
	
	divWidth=weatherData["days"].length*80;

	$('#scroller-day').css("width", divWidth+"px");
	
	
	var cordsData = new Array();
	
	jQuery.support.cors = true;

	var xhr = new XMLHttpRequest({mozSystem: true});
	xhr.open("GET", "http://api.wetteronline.de/search?name="+encodeURIComponent(getLocationByGeoID(gid))+"&format=app&area=cities", true);
	xhr.onreadystatechange = function () {
	    if (xhr.status === 200 && xhr.readyState === 4) {
	  	  var jData=JSON.parse(xhr.response);

	  	  for(var i=0;i<jData.length;i++)
	  	  {
	  	  	if(gid==jData[i]["geoID"])
	  	  	{
	  	  		cordsData["lat"]=jData[i]["latitude"];
	  	  		cordsData["lon"]=jData[i]["longitude"];
	  	  		break;
	  	  	}	
	  	  }
		  	if(46.940<cordsData["lat"] && cordsData["lat"]<55.30 && 4.20<cordsData["lon"] && cordsData["lon"]<16.80) {
		  		getRadar(getLocationByGeoID(gid),gid,320,173);
		  		//console.log("show radar");
	  		}
		  	else {
		  		$("#radar").hide();
  	  			$("#radarPic").hide();
		  		//console.log("hide radar");
		  	}
	    }
	}

	xhr.onerror = function () {
		alert(xhr.response);
	};
	xhr.send();
	
	$("#radar").click(function() {
        $.mobile.changePage("#regenRadar");
        //console.log("test click radarbtn");
        getRegenRadar();
    });
}

function addlistenerFuncFC( i, elementType, id ) 
{
	
   	var tempElement=document.getElementById(''+elementType+i);
   	tempElement.addEventListener("click", function(e){
        
        if(elementType=="day")
    	{
        	myScrollHour.scrollToElement(document.getElementById(''+id), 100);
        	
        	for(var j=0;j<8;j++){		
         			$("li div.dayTop").removeClass("list-day-top-Select");
        			$("li div.dayTop").addClass("list-day-top-noneSelect");
        			$("li div.dayBottom").removeClass("list-day-bottom-Select");
        			$("li div.dayBottom").addClass("list-day-bottom-noneSelect");	
        	}
        	var dayID = "day"+i;
 			$("li#"+dayID+" div.dayTop").removeClass("list-day-top-noneSelect");
			$("li#"+dayID+" div.dayTop").addClass("list-day-top-select");
			$("li#"+dayID+" div.dayBottom").removeClass("list-day-bottom-noneSelect");
			$("li#"+dayID+" div.dayBottom").addClass("list-day-bottom-select");
    	}
        else
    	{
        	myScrollDay.scrollToElement(document.getElementById(''+id), 100);
        	
        	for(var j=0;j<8;j++){
         			$("li div.dayTop").removeClass("list-day-top-Select");
        			$("li div.dayTop").addClass("list-day-top-noneSelect");
        			$("li div.dayBottom").removeClass("list-day-bottom-Select");
        			$("li div.dayBottom").addClass("list-day-bottom-noneSelect");
        	}
 			$("li#"+id+" div.dayTop").removeClass("list-day-top-noneSelect");
			$("li#"+id+" div.dayTop").addClass("list-day-top-select");
			$("li#"+id+" div.dayBottom").removeClass("list-day-bottom-noneSelect");
			$("li#"+id+" div.dayBottom").addClass("list-day-bottom-select");
    	}
    }, false)
}

function getServerTime()
{
	var gpsBtn=document.getElementById('gpsBtn');
	gpsBtn.onclick = function() { 
	        locateMe();
	   }
	 
	var searchInput=document.getElementById('searchString');
	searchInput.onkeyup = function() { 
	        getData('searchString');
	   }
	
	for(var i=0;i<9;i++)
	{
		addlistenerFuncPanel(i, "panelBtn", "panel-list");
	}
	
	
	for(var i=0;i<5;i++)
	{
		addlistenerFuncNews(i, "newsBtn");
	}
	
	for(var i=0;i<8;i++)
	{
		addlistenerFuncRegenRadar(i, "rRBtn");
	}
	
	for(var i=0;i<8;i++)
	{
		for(var j=0;j<6;j++)
		{
			addMenuListener(i,j);
		}
	}
		
	
	 
	  var xhr = new XMLHttpRequest({mozSystem: true});
	  xhr.open("GET", "http://api.wetteronline.de/wetterapp?sid=date", true);
	  xhr.onreadystatechange = function () {
	      if (xhr.status === 200 && xhr.readyState === 4) {
	    	  serverTime=xhr.response;

	    	    var dateArray = serverTime.split(' ');
		        var year = dateArray[0].split('-');
		        var time = dateArray[1].split(':');
		        if((time[1]*1)>45)
	        	{
		        	time[1]=0;
		        	dateObj = new Date(year[0]*1, year[1]-1, year[2]*1, time[0]*1, time[1]*1, time[2]*1).addHours(1);
	        	}
		        else
			    {
		        	dateObj = new Date(year[0]*1, year[1]-1, year[2]*1, time[0]*1, time[1]*1, time[2]*1)
			    }   	
	    		date=dateArray[0];
	    	  
	    	  initializeDB();
	      }
	  }

	  xhr.onerror = function () {
	      alert(xhr.response);
	  };
	  xhr.send();
}

function addlistenerFuncPanel(i, btn, list){	
	var panelBtn=document.getElementById(''+btn+i);
	panelBtn.onclick = function() { 
		 $('#'+list+i).listview('refresh');
	}
}

function addlistenerFuncNews(i, btn){
	var newsBtn=document.getElementById(''+btn+i);
	newsBtn.onclick = function() { 
        getWoTexte();
   }
}

function addlistenerFuncRegenRadar(i, btn){
	var rRBtn=document.getElementById(''+btn+i);
	rRBtn.onclick = function() { 
		getRegenRadar();
   }
}



function locateMe()
{
	var geoService = navigator.geolocation;
	if (geoService) {
		navigator.geolocation.getCurrentPosition(getLocationByCoords,errorHandler);
	} else {
		$("#searchResults").html("Your Browser does not support GeoLocation.");
	}
}

function getLocationByCoords(position){
	  var lat=(Math.round(position.coords.latitude * 1000)/1000).toFixed(3);
	  var lon=(Math.round(position.coords.longitude * 1000)/1000).toFixed(3);
	  var xhr = new XMLHttpRequest({mozSystem: true});
	  xhr.open("GET", "http://api.wetteronline.de/search?format=app&area=cities&lat="+position.coords.latitude+"&lon="+position.coords.longitude, true);
	  xhr.onreadystatechange = function () {
	      if (xhr.status === 200 && xhr.readyState === 4) {
	    	  displayLocationData(xhr.response);
	      }
	  }

	  xhr.onerror = function () {
	      alert(xhr.response);
	  };
	  xhr.send();
}

function displayLocationData(data)
{
	
	var jData=JSON.parse(data);
	
	 $('#results').css("height", "0px");

	if(jData[0]["match"]=="no")
	{
		
		$("#results").html("kein ort via gps gefunden");
	}
	else
	{
		var geoID=jData[0]["geoID"];
		addLocationToDB(jData[0]["geoName"],geoID);
		var sid="forecast";
		var days=8;
		var type=0;
		var htmlString="<a href='#weatherPage' id='"+geoID+jData[0]["geoName"]+"'>"+jData[0]["geoName"]+"</a>";
		
		
		$("#results").html(htmlString);
		var locationResult=document.getElementById(''+geoID+jData[0]["geoName"]);
		locationResult.onclick = function() { 
				getForecast(jData[0]["geoName"],geoID, days, sid, type);
		   }
		
	}
}

function errorHandler(error){
	  $("#results").html("Error while retrieving current position. Error code: " + error.code + ",Message: " + error.message);
}

function getData(id)
{
	var searchString = $('#'+id).val();
	
	if(searchString=="")
	{
		$('#results').html("");
		$('#results').css("height", "0px");
	}
	else
	{
		jQuery.support.cors = true;
	
		var xhr = new XMLHttpRequest({mozSystem: true});
		xhr.open("GET", "http://api.wetteronline.de/autosuggest?s="+searchString+"&format=app&area=cities&_=1384355948240", true);
		xhr.onreadystatechange = function () {
		    if (xhr.status === 200 && xhr.readyState === 4) {
		  	  
		  	  displayData(xhr.response);
		    }
		}
	
		xhr.onerror = function () {
			alert(xhr.response);
		};
		xhr.send();
	}
}


function getGeoID(id)
{
	
	var searchString = $('#'+id).html();
	
	if(searchString=="")
	{
		$('#results').html("");
		$('#results').css("height", "0px");
	}
	else
	{
		jQuery.support.cors = true;
	
		var xhr = new XMLHttpRequest({mozSystem: true});
		xhr.open("GET", "http://api.wetteronline.de/search?name="+searchString+"&format=app&area=cities", true);
		xhr.onreadystatechange = function () {
		    if (xhr.status === 200 && xhr.readyState === 4) {
		  	  var jData=JSON.parse(xhr.response);
		  	  	if(jData[0]["match"]=="no")
				{
					
				}
				else
				{
					var geoID=jData[0]["geoID"];
					$('#results').html("");
					$('#results').css("height", "50px");
					addLocationToDB(jData[0]["locationName"],geoID); 
					
				}
		    }
		}
	
		xhr.onerror = function () {
			alert(xhr.response);
		};
		xhr.send();
	}
} 

function displayData(data)
{
    
    var jData=JSON.parse(data);
    
    var resultString="<li class='ui-li ui-li-static ui-btn-up-c ui-first-child'>kein treffer</li>";
        $('#results').css("height", "50px");

    if(jData.length!=0)
	{
	    var resultString="<ul class='myList2'>";
	    
	    for(var i=0;i<jData.length;i++)
	    {
	    	resultString+="<li class='myList' id='result"+i+"'>"+jData[i]["n"]+"</li>";
	    }
	}
    $('#results').css("height", (jData.length*50)+"px");
    $('#results').html(resultString);
    for(var i=0;i<jData.length;i++)
    {
    	var searchResult=document.getElementById('result'+i);
    	searchResult.onclick = function() { 
	        getGeoID(this.id);
	   }

    }
}

function getRadar(locationName,gid,width,height)
{
	jQuery.support.cors = true;

	var xhr = new XMLHttpRequest({mozSystem: true});
	xhr.open("GET", "http://api.wetteronline.de/search?name="+encodeURIComponent(locationName)+"&format=app&area=cities", true);
	xhr.onreadystatechange = function () {
	    if (xhr.status === 200 && xhr.readyState === 4) {
	  	  var jData=JSON.parse(xhr.response);

	  	  for(var i=0;i<jData.length;i++)
	  	  {
	  	  	if(gid==jData[i]["geoID"])
	  	  	{
	  	  		
				var radarChecksum=MD5.base64(bev+"|png|"+height+"|"+jData[i]["latitude"]+"|"+jData[i]["longitude"]+"|high|snippet|"+width+"|"+secret)+"==";
				var url="http://api.wetteronline.de/radar?bev="+bev+"&sid=snippet&lat="+jData[i]["latitude"]+"&lon="+jData[i]["longitude"]+"&width="+width+"&height="+height+"&format=png&resolution=high&checksum="+radarChecksum;
					
					$("#radar").css({width: '320px', height: '173px'})
					$("#radarPic").attr("src",url);
	  	  	}	
	  	  }
	    }
	}

	xhr.onerror = function () {
		alert(xhr.response);
	};
	xhr.send();
}

function getWoTexte() {
	

	var typeWoTexte=new Array(4);
	
	typeWoTexte[0]="GermanyWeather";
	typeWoTexte[1]="GermanyTrend";
	typeWoTexte[2]="Weekend";
	typeWoTexte[3]="DailyTopics";
	
		for(var i=0;i<typeWoTexte.length;i++) {
			makeWoTexteRequest(typeWoTexte[i],i);
	}
	
}

function makeWoTexteRequest(typeWoTexte,i) {
	
	var url="http://api.wetteronline.de/wetterapp?sid=wotexte&type=";
	var string="";
	var checksumWoTexte="";
	
	string="3|wotexte|"+typeWoTexte+"|"+date+"|"+secret;
	checksumWoTexte=MD5.base64(string)+"==";
	
	var xhr = new XMLHttpRequest({mozSystem: true});
		xhr.open("GET", url+typeWoTexte+"&bev=3&checksum="+checksumWoTexte, true);
		xhr.onreadystatechange = function () {
			if (xhr.status === 200 && xhr.readyState === 4) {
				var xhtmlForecast=xhr.response;
				$("#newsContent"+i).html(""+xhtmlForecast);
			}
		}

		xhr.onerror = function () {
			alert(xhr.response);
		};
		xhr.send();
}

function getRegenRadar() {

	var url="http://api.wetteronline.de/radar?bev="+bev+"&sid=config&resolution=low&layer=radar";
	var string="";
	var checksumRegenRadar="";
	string=bev+"|radar|low|config|"+secret;
	checksumRegenRadar=MD5.base64(string)+"==";

	
	var xhr = new XMLHttpRequest({mozSystem: true});
	xhr.open("GET", url+"&checksum="+checksumRegenRadar, true);
	xhr.onreadystatechange = function () {
		if (xhr.status === 200 && xhr.readyState === 4) {
			rRConfig=xhr.response;

			displayRegenRadar();
		}
	}

	xhr.onerror = function () {
		alert(xhr.response);
	};
	xhr.send();
}

function killRadarLoop(){
	if(inLoop){
		clearInterval(infiniteLoop);
		inLoop=false;
	}
}

function regenradarLoop()
{
	inLoop = true;
	
	//initial fade-in time (in milliseconds)
	var initialFadeIn = 100;
	
	//interval between items (in milliseconds)
	var itemInterval = 1000;
	
	//cross-fade time (in milliseconds)
	var fadeTime = 100;
	
	//count number of items
	var numberOfItems = $('.rotating-item').length;

	//set current item
	var currentItem = 4;

	//show first item
	$('.rotating-item').eq(currentItem).fadeIn(initialFadeIn);
	$("#rRFooter").html(""+rRData["data"][currentItem]["time_view"]);

	//loop through the items		
	infiniteLoop = setInterval(function(){
		$('.rotating-item').eq(currentItem).fadeOut(fadeTime);
		

		if(currentItem == numberOfItems -1){
			currentItem = 0;
		}else{
			currentItem++;
		}
		$('.rotating-item').eq(currentItem).fadeIn(fadeTime);
		$("#rRFooter").html(""+rRData["data"][currentItem]["time_view"]);
		
	}, itemInterval);	
}	

function displayRegenRadar() {
	rRData=JSON.parse(rRConfig);
	for(var i=0;i<rRData["data"].length;i++) {
		getRRImage(rRData["data"][i]["name"],i);
	}
	
	if(!inLoop) {
		regenradarLoop();
	}
	
}

function getRRImage(name,i) {
	
	var url="http://api.wetteronline.de/radar?sid=image&name=";
	var string="";
	var checksumImage="";
	string="png|radar|"+name+"|low|image|"+secret;
	checksumImage=MD5.base64(string)+"==";

	url+=name+"&format=png&resolution=low&layer=radar&checksum="+checksumImage;
	$("#rRMitte"+i).attr("src",url);
}