var parkingTime;
var parkingTimerId;

function quit() {
    clearInterval(parkingTimerId);
    window.close();
}

$(document).ready(function () {
    var mainElement = $("div[role='main']");
    if (mainElement.length) {
        mainElement.css('height', "" + window.innerHeight - 50 + "px");
    }
    setPageLanguage();
});

function backToMainWindow() {
    window.location.href = "index.html";
}

function padTime(time) {
    var timeStr = "" + time;
    var padding = "00";
    return padding.substr(0, 2 - timeStr.length) + timeStr;
}

function updateL10nArg(elementId, argObject) {
    var element = $('#' + elementId);
    element.attr('data-l10n-args', JSON.stringify(argObject));
    document.webL10n.translate(element[0]);
}

function storeDataNetworkUsage(useNetwork) {
    localStorage.setItem('UseDataNetwork', useNetwork);
}

function readDataNetworkUsage() {
    var useDataNetwork = localStorage.getItem('UseDataNetwork');
    return (useDataNetwork === null) ? undefined : useDataNetwork;
}

function isNetworkUsageAllowed() {
    return readDataNetworkUsage() === "true";
}

function readSavedParkingData() {
    var savedParkingData = localStorage.getItem('ParkingData');
    if (savedParkingData === null) {
        return undefined;
    }
    var data = JSON.parse(savedParkingData);
    data.time = Date.parse(data.time);
    return data;
}

function removeParkingData() {
    removeImageFromDb();
    localStorage.removeItem('ParkingData');
    localStorage.removeItem('ParkingPhotoUrl');
    clearInterval(parkingTimerId);
    parkingTime = undefined;
}

function setPageLanguage() {
    var langCode = localStorage.getItem('Language');
    if (langCode !== null) {
        document.webL10n.setLanguage(langCode);
    }
}