function initializeApp() {
    setNetworkUsageIfUndefined();
    setRefreshTimerIfUndefinedAndParkingActive();
}

function setNetworkUsageIfUndefined() {
    var useDataNetwork = readDataNetworkUsage();
    if (useDataNetwork === undefined) {
        storeDataNetworkUsage(true);
        return true;
    } else {
        return useDataNetwork === "true";
    }
}

function setRefreshTimerIfUndefinedAndParkingActive() {
    var isActiveParking = updateDisplayedParkingTime();
    if (isActiveParking && parkingTimerId === undefined) {
        parkingTimerId = setInterval(updateDisplayedParkingTime, 1000);
    }
}

function refresh() {
    var isActiveParking = updateDisplayedParkingTime();
    $('#active_parking').css('display', isActiveParking ? 'block' : 'none');
    $('#no_parking').css('display', isActiveParking ? 'none' : 'block');
    $('#sidebar_compass').css('display', isActiveParking ? 'block' : 'none');
    $('#sidebar_photo').css('display', isActiveParking ? 'block' : 'none');
    $('#sidebar_map').css('display', (isActiveParking && isNetworkUsageAllowed()) ? 'block' : 'none');
}

function updateDisplayedParkingTime() {
    if (parkingTime === undefined) {
        updateParkingTimeFromLocalStorage();
    }
    if (parkingTime !== undefined) {
        var diff = new Date(new Date() - parkingTime);
        $('#parked_for_time').html(
            Math.floor(diff.getTime() / (3600 * 1000)) + ':' + padTime(diff.getMinutes()) + ':' + padTime(diff.getSeconds()));
        return true;
    }
    return false;
}

function updateParkingTimeFromLocalStorage() {
    var data = readSavedParkingData();
    if (data !== undefined) {
        parkingTime = data.time;
    } else {
        parkingTime = undefined;
    }
}

function startParking() {
    var now = new Date();
    if (navigator.geolocation) {
        $('#gps_acquire_status').css('display', 'block');
        $("#start_parking").prop('disabled', true);
        navigator.geolocation.getCurrentPosition(function (position) {
                var data = {
                    lat: position.coords.latitude,
                    long: position.coords.longitude,
                    time: now
                };
                localStorage.setItem('ParkingData', JSON.stringify(data));
                parkingTime = now;
                $('#gps_acquire_status').css('display', 'none');
                $("#start_parking").prop('disabled', false);
                parkingTimerId = setInterval(updateDisplayedParkingTime, 1000);

                //$('#weather_section').css('display', 'block');
                //weatherTimeoutId = window.setTimeout(hideWeather, 3000);
                refresh();
            }, function (error) {
                console.log('Nem sikerült lekérni a GPS pozíciót:', error.message);
                alert(document.webL10n.get('gps_error'));

                $('#gps_acquire_status').css('display', 'none');
                $("#start_parking").prop('disabled', false);
                stopParking();
            },
            {enableHighAccuracy: true, timeout: 60000});
    }
}

function stopParking() {
    removeParkingData();
    refresh();
}

function quitClicked() {
    var isActiveParking = updateDisplayedParkingTime();
    if (isActiveParking) {
        window.location.href = "quit.html";
    } else {
        quit();
    }
}
