var map;
var carMarker;
var posMarker;
var locWatchId;

function initialize() {

    var mapElement = $("#map-canvas");
    mapElement.css('height', "" + window.innerHeight - 50 + "px");

    var mapOptions = {
        zoom: 15
    };
    map = new google.maps.Map(mapElement[0],
        mapOptions);

    var parkingData = readSavedParkingData();
    if (parkingData !== undefined) {
        var carPos = new google.maps.LatLng(parkingData.lat, parkingData.long);
        //var carPos = new google.maps.LatLng('47.494707', '19.079388');
        carMarker = new google.maps.Marker({
            map: map,
            icon: 'style/map/car_pin.png',
            title: 'Car',
            position: carPos
        });
    }

    if (navigator.geolocation) {
        locWatchId = navigator.geolocation.watchPosition(function (position) {

            var pos = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
            if (posMarker !== undefined) {
                posMarker.setMap(null);
            }
            posMarker = new google.maps.Marker({
                map: map,
                position: pos
            });
            var bound = new google.maps.LatLngBounds();
            bound.extend(posMarker.getPosition());
            if (carMarker !== undefined) {
                bound.extend(carMarker.getPosition());
            }
            map.fitBounds(bound);

        }, function () {
        });
    }
}

function cleanUp() {
    navigator.geolocation.clearWatch(locWatchId);
}

function cleanUpAndBackToMainWindow() {
    cleanUp();
    backToMainWindow();
}

google.maps.event.addDomListener(window, 'load', initialize);