var locWatchId;
var myPos;
var carPos;
var currentCompassPosition = {property: 0};

$(document).ready(function () {
    loadGraphics();
    carPos = readSavedParkingData();
    if (navigator.geolocation) {
        locWatchId = navigator.geolocation.watchPosition(function (position) {
            if (myPos === undefined) {
                $('#gps_acquire_status').css('display', 'none');
                $('#compass_data').css('display', 'block');
            }
            myPos = position;
            refreshDistanceAndBearing();
        });
    }
});

function loadGraphics() {
    d3.xml("style/compass/compass.svg", "image/svg+xml", function (xml) {
        $('#compass_data').append(xml.documentElement);
    });
}

function refreshDistanceAndBearing() {
    if (myPos !== undefined && carPos !== undefined) {
        var directions = getDistanceFromLatLonInM(myPos.coords.latitude, myPos.coords.longitude, carPos.lat, carPos.long);
        //var directions = getDistanceFromLatLonInM(myPos.coords.latitude, myPos.coords.longitude, 47.494707, 19.079388);
        updateL10nArg('distance_data', {"distance": Math.floor(directions.distance)});
        rotateCompass(directions.bearing);
        return directions;
    }
    return null;
}

function getDistanceFromLatLonInM(myLat, myLon, carLat, carLon) {
    var result = {};

    var R = 6371000; // Radius of the earth in m
    var myLatRad = deg2rad(myLat);
    var carLatRad = deg2rad(carLat);
    var dLat = carLatRad - myLatRad;
    var dLon = deg2rad(carLon - myLon);

    var a =
        Math.sin(dLat / 2) * Math.sin(dLat / 2) +
        Math.cos(myLatRad) * Math.cos(carLatRad) *
        Math.sin(dLon / 2) * Math.sin(dLon / 2);
    var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
    result.distance = R * c;

    var dPhi = Math.log(Math.tan(carLatRad / 2.0 + Math.PI / 4.0) / Math.tan(myLatRad / 2.0 + Math.PI / 4.0));
    if (Math.abs(dLon) > Math.PI) {
        if (dLon > 0.0)
            dLon = -(2.0 * Math.PI - dLon);
        else
            dLon = (2.0 * Math.PI + dLon);
    }

    result.bearing = (rad2deg(Math.atan2(dLon, dPhi)) + 360.0) % 360.0;

    return result;
}

function deg2rad(deg) {
    return deg * (Math.PI / 180);
}

function rad2deg(rad) {
    return rad / (Math.PI / 180);
}


function rotateCompass(bearing) {
    var translateValue = "translate(225,231)";
    var to = {property: bearing};

    $(currentCompassPosition).stop().animate(to, {
        duration: 2000,
        step: function () {
            $("#compass").attr("transform", translateValue
            + " rotate(" + this.property + ")")
        }
    });
}

function cleanUp() {
    navigator.geolocation.clearWatch(locWatchId);
}

function cleanUpAndBackToMainWindow() {
    cleanUp();
    backToMainWindow();
}