var db;

function initDb(callback) {
    if (db !== undefined) {
        callback();
    } else {
        var request = window.indexedDB.open('parkingdb', 1);
        request.onsuccess = function (event) {
            db = event.target.result;
            callback();
        };
        request.onupgradeneeded = function (event) {
            var dbToUpgrade = event.target.result;
            dbToUpgrade.createObjectStore('photo');
        };
    }
}

function storeImageInDb(blob) {
    var transaction = db.transaction('photo', 'readwrite');
    transaction.objectStore("photo").put(blob, 'image');
}

function getImageUrlFromDb(callback) {
    var transaction = db.transaction('photo', 'readonly');
    var request = transaction.objectStore('photo').get('image');
    request.onsuccess = function (event) {
        if (event.target.result !== undefined) {
            var lofasz = event.target.result;
            var url = window.URL.createObjectURL(lofasz);
            callback(url);
        }
    };
    request.onerror = function () {
        callback(null);
    };
}

function removeImageFromInitializedDb() {
    var transaction = db.transaction('photo', 'readwrite');
    transaction.objectStore("photo").delete('image');
}
function removeImageFromDb() {
    initDb(removeImageFromInitializedDb);
}