var rootServiceUrl = "/MobiPost/";

var Utils = {
    store: function(namespace, data) {
        if (arguments.length > 1) {
            return localStorage.setItem(namespace, JSON.stringify(data));
        } else {
            var store = localStorage.getItem(namespace);
            return (store && JSON.parse(store)) || [];
        }
    },
    errorInfo: function(result, textStatus, errorThrown) {
        $.mobile.hidePageLoadingMsg();
        $.mobile.showPageLoadingMsg("a", "Wystąpił błąd przy pobieraniu danych. " + errorThrown, true);
    }
};

var MapPP = {
    init: function() {
        this.ENTER_KEY = 13;
        this.myLat = "undefined";
        this.myLon = "undefined";
        this.map = "";
        this.markersArray = [];
        this.infoWindow = "";
        this.directionsDisplay = "";
        this.serviceUrl = rootServiceUrl + "getpoints?action=getPosts&search=";
        this.cacheElements();
        this.bindEvents();
        this.initializeMap();
        this.render();
    },
    cacheElements: function() {
        this.$pointsList = $('#points-list');
        this.$searchOptionsButton = $("#search-options-button");
        this.$searchFormNear = $("#search-form-near");
        this.$searchButton = $("#search-btn");
        this.$searchNearMarkers = $("#search-near-markers");
        this.$searchCityField = $("#search-city-field");
        this.$mapContainer = $("map-container");
    },
    bindEvents: function() {
        $(window).bind('orientationchange', MapPP.onOrientationChange);
        var searchOptionsButton = this.$searchOptionsButton;
        var searchFormNear = this.$searchFormNear;
        var searchButton = this.$searchButton;
        var searchNearMarkers = this.$searchNearMarkers;
        var searchCityField = this.$searchCityField;
        searchOptionsButton.on("click", function() {
            if (MapPP.myLat !== "undefined" && MapPP.myLon !== "undefined") {
                searchFormNear.show();
            } else {
                searchFormNear.hide();
            }
        });
        searchButton.on("click", function() {
            MapPP.getNewPoints("city");
        });
        searchNearMarkers.on("click", function() {
            MapPP.getNewPoints("near");
        });
        searchCityField.on("keyup", function(e) {
            if (e.keyCode === MapPP.ENTER_KEY) {
                MapPP.getNewPoints("city");
            }
        });
    },
    render: function() {
        var list = this.$pointsList;
        var points_div;
        var marker;
        list.html("");
        if (MapPP.markersArray) {
            for (var i in MapPP.markersArray) {
                MapPP.markersArray[i].setMap(null);
            }
            MapPP.markersArray.length = 0;
        }
        MapPP.addMyLocationMarker();
        var points = JSON.parse(localStorage.getItem("map-pp")) || [];
        var l = points.length;
        if (l < 1) {
            list.html("<p>Lista placówek spełniających podane kryteria wyszukiwania:</p>");
        }
        while (l--) {
            points_div = $('<div data-role="collapsible" data-iconpos="bottom" data-collapsed-icon="arrow-d" data-expanded-icon="arrow-u">' +
                    '<h1>' + points[l].name + '</h1>' +
                    '<a class="show-direction-btn"'
                    + 'href="javascript:MapPP.showDirections(' +
                    points[l].lat + ',' + points[l].lon + ');' +
                    "MapPP.closePanel();" + '" ' +
                    'data-role="button" data-icon="arrow-l"  data-theme="b"' +
                    'data-inline="true">Idź do</a>' +
                    '<p>' + points[l].description + '</p></div>');
            points_div.appendTo(list);
            list.trigger("create");
            marker = new google.maps.Marker({
                title: points[l].name,
                description: points[l].description,
                position: new google.maps.LatLng(points[l].lat, points[l].lon),
                icon: "css/images/pp.png",
                animation: google.maps.Animation.DROP,
                map: MapPP.map
            });
            MapPP.addMarker(marker);
        }
    },
    onOrientationChange: function() {
        $('#map-container').css('height', $(window).height() + 40).resize();
    },
    initializeMap: function() {
        $('#map-container').css('height', $(window).height() + 40).resize();
        var mapOptions = {
            zoom: 6,
            center: new google.maps.LatLng(52.106505, 19.226074),
            mapTypeControl: false,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        };
        MapPP.map = new google.maps.Map(document.getElementById("map-container"), mapOptions);
        if (navigator.geolocation) {
            MapPP.addMyLocationMarker();
        }
    },
    addMyLocationMarker: function() {
        navigator.geolocation.getCurrentPosition(function(position) {
            MapPP.myLat = position.coords.latitude;
            MapPP.myLon = position.coords.longitude;
            MapPP.map.setCenter(new google.maps.LatLng(MapPP.myLat, MapPP.myLon));
            var marker = new google.maps.Marker({
                title: "Tutaj jesteś",
                description: "Tutaj się znajdujesz",
                position: new google.maps.LatLng(MapPP.myLat, MapPP.myLon),
                animation: google.maps.Animation.DROP,
                map: MapPP.map
            });
            var geocoder = new google.maps.Geocoder();
            geocoder.geocode({latLng: marker.getPosition()}, function(responses) {
                if (responses && responses.length > 0) {
                    marker.description = "<div class='place'>" + responses[0].formatted_address
                            + "<br /> <small>"
                            + "Szerokość: " + marker.getPosition().lat() + "<br>"
                            + "Długość: " + marker.getPosition().lng() + "</small></div>";
                    $('#current-place-address').html(responses[0].formatted_address);
                }
            });
            MapPP.addMarker(marker);
        });
    },
    addMarker: function(marker) {
        var bounds = new google.maps.LatLngBounds();
        MapPP.infoWindow = new google.maps.InfoWindow({maxWidth: 150, content: ""});
        google.maps.event.addListener(marker, 'click', function() {
            MapPP.infoWindow.close();
            MapPP.infoWindow.setContent('<div style="font-size: 12px">' + marker.description + '</div>');
            MapPP.infoWindow.open(MapPP.map, marker);
        });
        MapPP.markersArray.push(marker);
        if (MapPP.markersArray.length > 2) {
            for (var i in MapPP.markersArray) {
                bounds.extend(MapPP.markersArray[i].getPosition());
            }
            MapPP.map.fitBounds(bounds);
        }
    },
    showDirections: function(destLat, destLon) {
        if (MapPP.directionsDisplay) {
            MapPP.directionsDisplay.setMap(null);
        }
        var destination = new google.maps.LatLng(destLat, destLon);
        if (MapPP.myLat !== "undefined" && MapPP.myLon !== "undefined") {
            var directionsService = new google.maps.DirectionsService();
            MapPP.directionsDisplay = new google.maps.DirectionsRenderer({
                suppressMarkers: true,
                suppressInfoWindows: true,
                polylineOptions: {strokeColor: '#0093f0', strokeOpacity: 1},
                preserveViewport: true
            });
            MapPP.directionsDisplay.setMap(MapPP.map);
            var request = {
                origin: new google.maps.LatLng(MapPP.myLat, MapPP.myLon),
                destination: destination,
                travelMode: google.maps.DirectionsTravelMode.DRIVING
            };
            directionsService.route(request, function(response, status) {
                if (status === google.maps.DirectionsStatus.OK) {
                    MapPP.directionsDisplay.setDirections(response);
                    var bounds = response.routes[0].bounds;
                    MapPP.map.fitBounds(bounds);
                    MapPP.map.setCenter(bounds.getCenter());
                }
            });
        } else {
            MapPP.map.panTo(destination);
            MapPP.map.setZoom(12);
        }
    },
    closePanel: function() {
        $("#search-options-panel").panel("close");
    },
    getNewPoints: function(param) {
        var url;
        if (param === "near") {
            url = "undefined" + "&lat=" + MapPP.myLat + "&lon=" + MapPP.myLon;
            MapPP.doGetNewPoints(url);
        }
        else {
            //url = this.serviceUrl + place + "&lat=" + "undefined" + "&lon=" + "undefined";
            var place = $("#search-city-field").val();
            if (place.length < 1) {
                return;
            }
            var geocoder = new google.maps.Geocoder();
            geocoder.geocode({'address': place}, function(results, status) {
                if (status == google.maps.GeocoderStatus.OK) {
                    MapPP.map.setCenter(results[0].geometry.location);
                    var marker = new google.maps.Marker({
                        map: MapPP.map,
                        position: results[0].geometry.location
                    });
                    url = "undefined" + "&lat=" + results[0].geometry.location.lat() + "&lon=" + results[0].geometry.location.lng();
                    MapPP.doGetNewPoints(url);
                } else {
                    Utils.errorInfo(null, null, "Nie znaleziono adresu z powodu: " + status);
                }
            });
        }
    },
    doGetNewPoints: function(url) {
        $.mobile.showPageLoadingMsg("a", "Pobieranie aktualnych danych o placówkach. ");
        $.ajax({
            url: this.serviceUrl + url,
            dataType: "JSON",
            success: MapPP.prepareData,
            error: Utils.errorInfo
        });
    },
    prepareData: function(data) {
        localStorage.setItem("map-pp", JSON.stringify(data));
        MapPP.render();
        $.mobile.hidePageLoadingMsg();
    }

};

var NewsPP = {
    init: function() {
        this.serviceUrl = rootServiceUrl + "getnews";
        this.cacheElements();
        this.getNews();
    },
    cacheElements: function() {
        this.$newsList = $('#news-list');
    },
    render: function() {
        var list = this.$newsList;
        var news_div;
        list.html("");
        var n = localStorage.getItem("news-pp");
        if (n !== null) {
            var news = JSON.parse(n);
        } else {
            var news = [];
        }
        var l = news.length;
        if (l < 1) {
            list.html("<br><p>Najnowsze informacje.</p>");
        }
        while (l--) {
            var postDate = new Date(news[l].pubDate);
            var month = postDate.getMonth() + 1;
            var day = postDate.getDate();
            var hour = postDate.getHours();
            var minute = postDate.getMinutes();
            var second = postDate.getSeconds();
            var pubDate = postDate.getFullYear() + '-' + month + '-' + day + ' ' + hour + ':' + minute + ':' + second;
            news_div = $('<li>' +
                    '<a data-ajax="false" href="' + news[l].link + '"><p><strong>' + pubDate + '</strong></p>' +
                    '<h2>' + news[l].title + '</h2>' +
                    '<p id="' + news[l].id + '">' + news[l].description + '</p></a>' +
                    '</li>');
            news_div.appendTo(list);
        }
        list.listview("refresh");

        if (news.length > 1) {
            $('.carousel').jCarouselLite({
                vertical: true,
                visible: 3,
                auto: 0,
                speed: 0,
                circular: false,
                btnNext: ".next",
                btnPrev: ".prev",
                easing: null
            });
        }
    },
    getNews: function() {
        var url = this.serviceUrl;
        NewsPP.render();
        $.mobile.showPageLoadingMsg("a", "Pobieranie aktualnych informacji.");
        $.ajax({
            url: url,
            dataType: "JSON",
            success: NewsPP.prepareData,
            error: Utils.errorInfo
        });
    },
    prepareData: function(data) {
        if (data.length !== 0) {
            data.sort(function(a, b) {
                a = new Date(a.pubDate);
                b = new Date(b.pubDate);
                return a < b ? -1 : a > b ? 1 : 0;
            });
            localStorage.setItem("news-pp", JSON.stringify(data));
            NewsPP.render();
        }
        $.mobile.hidePageLoadingMsg();
    }
};
var TrackPP = {
    init: function() {
        this.ENTER_KEY = 13;
        this.serviceUrl = rootServiceUrl + "getpackage?action=getPackageData&search=";
        this.packages = Utils.store('track-pp');
        this.cacheElements();
        this.bindEvents();
        this.render();
    },
    cacheElements: function() {
        this.$searchPackageField = $('#search-package-field');
        this.$searchPackageButton = $("#search-package-btn");
        this.$packagesList = $("#packages-list");
        this.$packageData = $("#package-data");
    },
    bindEvents: function() {
        var searchPackageField = this.$searchPackageField;
        var searchPackageButton = this.$searchPackageButton;
        searchPackageButton.on("click", function() {
            TrackPP.getPackageinfo(searchPackageField.val());
        });
        searchPackageField.on("keyup", function(e) {
            if (e.keyCode === TrackPP.ENTER_KEY) {
                TrackPP.getPackageinfo(searchPackageField.val());
            }
        });
    },
    render: function() {
        var list = this.$packagesList;
        var table = this.$packageData;
        var packages_list;
        var packages_table;
        var events_table;
        var events_table_srt;
        list.html("");
        Utils.store('track-pp', this.packages);
        var l = this.packages.length;
        while (l--) {
            packages_list = $('<li><a href="javascript:TrackPP.getPackageinfo(' + "'" +
                    this.packages[l].id + "'" + ');TrackPP.closePanel();">' +
                    '<h5>' + this.packages[l].id + '</h5><p>' +
                    this.packages[l].date + '</p>' +
                    '</a> <a href="javascript:TrackPP.deletePackege(' +
                    "'" + this.packages[l].id + "'" + ');">' +
                    'Usuń z historii</a> </li>');
            packages_list.appendTo(list);
            list.listview("refresh");
        }

        l = this.packages.length;
        if (l > 0) {
            if (typeof this.packages[l - 1].data[0].kodRodzPrzes !== 'undefined') {
                table.html("");
                
                var dataNadania = (this.packages[l - 1].data[0].dataNadania=="null")?"":this.packages[l - 1].data[0].dataNadania;
                var rodzPrzes = (this.packages[l - 1].data[0].rodzPrzes=="null")?"":this.packages[l - 1].data[0].rodzPrzes;
                var krajNadania = (this.packages[l - 1].data[0].krajNadania=="null")?"":this.packages[l - 1].data[0].krajNadania;
                var krajPrzezn = (this.packages[l - 1].data[0].krajPrzezn=="null")?"":this.packages[l - 1].data[0].krajPrzezn;
                var jednstkaNadania = (this.packages[l - 1].data[0].jednstkaNadania=="null")?"":this.packages[l - 1].data[0].jednstkaNadania;
                var jednstkaPrzeznaczenia = (this.packages[l - 1].data[0].jednstkaPrzeznaczenia=="null")?"":this.packages[l - 1].data[0].jednstkaPrzeznaczenia;

                packages_table = $('<table data-role="table"  data-mode="columntoggle"' +
                        'class="ui-body-d ui-shadow table-stripe table-stroke" data-column-btn-text="kolumny...">' +
                        '<thead>' +
                        '<tr>' +
                        '<th>Dane przesyłki:</th>' +
                        '<th></th>' +
                        '</tr>' +
                        '</thead>' +
                        '<tbody>' +
                        '<tr>' +
                        '<td>Data nadania:</td>' +
                        '<td>' + dataNadania + '</td>' +  
                        '</tr>' +
                        '<tr>' +
                        '<td>Rodzaj przesyłki:</td>' +
                        '<td>' + rodzPrzes + '</td>' +
                        '</tr>' +
                        '<tr>' +
                        '<td>Kraj nadania:</td>' +
                        '<td>' + krajNadania + '</td>' +
                        '</tr>' +
                        '<tr>' +
                        '<td>Kraj przeznaczenia:</td>' +
                        '<td>' + krajPrzezn + '</td>' +
                        '</tr>' +
                        '<tr>' +
                        '<td>Urząd nadania:</td>' +
                        '<td>' + jednstkaNadania + '</td>' +
                        '</tr>' +
                        '<tr>' +
                        '<td>Urząd przeznaczenia:</td>' +
                        '<td nowrap="nowrap">' + jednstkaPrzeznaczenia + '</td>' +
                        '</tr>' +
                        '</tbody>' +
                        '</table>');

                events_table_srt = '<table data-role="table" id="events-table" data-mode="columntoggle"' +
                        'class="ui-body-d ui-shadow table-stripe table-stroke" data-column-btn-text="kolumny...">' +
                        '<thead>' +
                        '<tr class="ui-bar-d">' +
                        '<th>Nazwa zdarzenie</th>' +
                         '<th>Data i czas</th>' +
                        '<th>Jednostka pocztowa</th>' +
                        '<th data-priority="1">Przyczyna</th>' +
                        '</tr>' +
                        '</thead>' +
                        ' <tbody>';
                if (typeof this.packages[l - 1].data[0].zdarzenia !== 'undefined') {
                    var jednostka = "";
                    var zd = this.packages[l - 1].data[0].zdarzenia;
                    $.each(zd, function(e, val) {
                        if (val.daneSzczegJednostki.indexOf("UP") == 0 && val.nazwa.indexOf("Doręczenie") == 0) {
                            jednostka = '<a href="javascript:TrackPP.showUpOnMap(&apos;' + val.daneSzczegJednostki + 
                                        '&apos;)" data-role=button data-icon=home data-inline=true data-theme=b data-iconpos=notext></a>' + 
                                        val.daneSzczegJednostki;
                        } else {
                            jednostka = val.daneSzczegJednostki;
                        }
                        events_table_srt = events_table_srt +
                                '<tr>' +
                                '<td>' + val.nazwa + '</td>' +
                                '<td>' + val.czasZadrzenia + '</td>' +
                                '<td>' + jednostka + '</td>' +
                                '<td>' + val.przyczyna + '</td>' +
                                '</tr>';
                    });
                }
                events_table_srt = events_table_srt + '</tbody> </table>';
                events_table = $(events_table_srt);
                packages_table.appendTo(table);
                events_table.appendTo(table);
                table.trigger("create");
                $("#search-package-field").val(this.packages[l - 1].id);
            } else {
                $("#search-package-field").val(this.packages[l - 1].id);
                table.html("<p>brak informacji o przesyłce: <b>" + this.packages[l - 1].id + "</b></p>");
            }
        }
    },
    deletePackege: function(package_id) {
        for (var i = 0; i < TrackPP.packages.length; i++)
            if (TrackPP.packages[i].id && TrackPP.packages[i].id === package_id) {
                TrackPP.packages.splice(i, 1);
            }
        TrackPP.render();
    },
    closePanel: function() {
        $("#search-options-panel").panel("close");
    },
    showUpOnMap: function(up) {
        var url = rootServiceUrl + "getpoints?action=getPost&placemark=" + up;
        $.mobile.showPageLoadingMsg("a", "Pobieranie informacji o jednostce.");
        var up = $.ajax({
            url: url,
            dataType: "JSON",
            success: TrackPP.goToMap,
            error: Utils.errorInfo
        });
    },
    goToMap: function(data) {
        localStorage.setItem("map-pp", JSON.stringify(data));
        $.mobile.hidePageLoadingMsg();
        window.location.href = "map.html";
    },
    getPackageinfo: function(id) {
        if (id.length > 0) {
            id = id.replace(/\s/g, "").toUpperCase();
            $.mobile.showPageLoadingMsg("a", "Pobieranie aktualnych danych o przesyłce. ");
            var url = this.serviceUrl + id;
            var info = $.ajax({
                url: url,
                dataType: "JSON",
                success: TrackPP.prepareData,
                error: Utils.errorInfo
            });
        }
    },
    prepareData: function(data) {
        if (data.length !== 0) {
            var d = new Date();
            var month = d.getMonth() + 1;
            var day = d.getDate();
            var hour = d.getHours();
            var minute = d.getMinutes();
            var second = d.getSeconds();

            TrackPP.deletePackege(data[0].numer);
            TrackPP.packages.push({
                id: data[0].numer,
                date: d.getFullYear() + '-' + month + '-' + day + ' ' + hour + ':' + minute + ':' + second,
                data: data
            });
            TrackPP.render();
        }
        $.mobile.hidePageLoadingMsg();
    },
    processspeech: function(){
        $('#search-package-field').val($('#search-package-field').val().replace(/\s/g, ""));
    }
};