var rootServiceUrl = "http://mobilna.poczta-polska.pl/MobiPost/";
//var manifest_url = "http://192.168.2.8:8888/manifest.webapp";
var Utils = {
    store: function(namespace, data) {
        if (arguments.length > 1) {
            return localStorage.setItem(namespace, JSON.stringify(data));
        } else {
            var store = localStorage.getItem(namespace);
            return (store && JSON.parse(store)) || [];
        }
    },
    errorInfo: function(result, textStatus, errorThrown) {
        $.mobile.hidePageLoadingMsg();
        $.mobile.showPageLoadingMsg("a", "Wystąpił błąd przy pobieraniu danych. ", true);
        
        var button = $("<p/>", {class: "quit-button-icon",text: "x"});
        $(".ui-loader").append(button);
        $(".ui-loader").on("click", function() {
            $.mobile.hidePageLoadingMsg();
        });
    }
};

var TrackPP = {
    init: function() {
        this.ENTER_KEY = 13;
        this.serviceUrl = rootServiceUrl + "getpackage?action=getPackageData&search=";
        this.packages = Utils.store('track-pp');
        this.cacheElements();
        this.bindEvents();
        this.render();
        this.checkInstall();
    },
    cacheElements: function() {
        this.$searchPackageField = $('#search-package-field');
        this.$searchPackageButton = $("#search-package-btn");
        this.$packagesList = $("#packages-list");
        this.$packageData = $("#package-data");
    },
    bindEvents: function() {
        var searchPackageField = this.$searchPackageField;
        var searchPackageButton = this.$searchPackageButton;
        searchPackageButton.on("click", function() {
            TrackPP.getPackageinfo(searchPackageField.val());
        });
        searchPackageField.on("keyup", function(e) {
            if (e.keyCode === TrackPP.ENTER_KEY) {
                TrackPP.getPackageinfo(searchPackageField.val());
            }
        });
        var install_but = $('#install');
        install_but.on("click", function() {
            TrackPP.install();
        });
    },
     
    install: function() {
        var myapp = navigator.mozApps.install(manifest_url);
        myapp.onsuccess = function(data) {
            this.parentNode.removeChild(this);
        };
        myapp.onerror = function() {
            console.log('Install failed, error: ' + this.error.name);
        };
    },
    
    checkInstall: function() {
        $('#install').hide();
        /*try {
            var request = navigator.mozApps.checkInstalled(manifest_url);
            request.onsuccess = function() {
                if (request.result) {
                    $('#install').hide();
                } else {
                    $('#install').show();
                }
            };
            request.onerror = function() {
                alert('Error checking installation status: ' + this.error.message);
            };
        } 
        catch (err) {
            //no mozApps 
            $('#install').hide();
        }*/
    },
    
    render: function() {
        var list = this.$packagesList;
        var table = this.$packageData;
        var packages_list;
        var packages_table;
        var events_table;
        var events_table_srt;
        list.html("");
        Utils.store('track-pp', this.packages);
        var l = this.packages.length;
        while (l--) {
            packages_list = $('<li><a href="javascript:TrackPP.getPackageinfo(' + "'" + 
            this.packages[l].id + "'" + ');TrackPP.closePanel();">' + 
            '<h5>' + this.packages[l].id + '</h5><p>' + 
            this.packages[l].date + '</p>' + 
            '</a> <a class="blue-line" href="javascript:TrackPP.deletePackege(' + 
            "'" + this.packages[l].id + "'" + ');">' + 
            'Usuń z historii</a> </li>');
            packages_list.appendTo(list);
            list.listview("refresh");
        }
        
        l = this.packages.length;
        if (l > 0) {
            if (typeof this.packages[l - 1].data[0].kodRodzPrzes !== 'undefined') {
                table.html("");
                
                var dataNadania = (this.packages[l - 1].data[0].dataNadania == "null") ? "" : this.packages[l - 1].data[0].dataNadania;
                var rodzPrzes = (this.packages[l - 1].data[0].rodzPrzes == "null") ? "" : this.packages[l - 1].data[0].rodzPrzes;
                var krajNadania = (this.packages[l - 1].data[0].krajNadania == "null") ? "" : this.packages[l - 1].data[0].krajNadania;
                var krajPrzezn = (this.packages[l - 1].data[0].krajPrzezn == "null") ? "" : this.packages[l - 1].data[0].krajPrzezn;
                var jednstkaNadania = (this.packages[l - 1].data[0].jednstkaNadania == "null") ? "" : this.packages[l - 1].data[0].jednstkaNadania;
                var jednstkaPrzeznaczenia = (this.packages[l - 1].data[0].jednstkaPrzeznaczenia == "null") ? "" : this.packages[l - 1].data[0].jednstkaPrzeznaczenia;
                
                packages_table = $('<table data-role="table"  data-mode="columntoggle"' + 
                'class="ui-body-d ui-shadow table-stripe table-stroke" data-column-btn-text="">' + 
                '<thead>' + 
                '<tr>' + 
                '<th lang=pl>Informacje</th>' + 
                '<th></th>' + 
                '</tr>' + 
                '</thead>' + 
                '<tbody>' + 
                '<tr>' + 
                '<td lang=pl>Data nadania:</td>' + 
                '<td>' + dataNadania + '</td>' + 
                '</tr>' + 
                '<tr>' + 
                '<td lang=pl>Rodzaj przesyłki:</td>' + 
                '<td>' + rodzPrzes + '</td>' + 
                '</tr>' + 
                '<tr>' + 
                '<td lang=pl>Kraj nadania:</td>' + 
                '<td>' + krajNadania + '</td>' + 
                '</tr>' + 
                '<tr>' + 
                '<td lang=pl>Kraj przeznaczenia:</td>' + 
                '<td>' + krajPrzezn + '</td>' + 
                '</tr>' + 
                '<tr>' + 
                '<td lang=pl>Urząd nadania:</td>' + 
                '<td>' + jednstkaNadania + '</td>' + 
                '</tr>' + 
                '<tr>' + 
                '<td lang=pl>Urząd przeznaczenia:</td>' + 
                '<td nowrap="nowrap">' + jednstkaPrzeznaczenia + '</td>' + 
                '</tr>' + 
                '</tbody>' + 
                '</table>');
                
                events_table_srt = '<table data-role="table" id="events-table" data-mode="columntoggle"' + 
                'class="ui-body-d ui-shadow table-stripe table-stroke" data-column-btn-text="">' + 
                '<thead>' + 
                '<tr class="ui-bar-d">' + 
                '<th lang=pl>Nazwa</th>' + 
                '<th lang=pl>Czas</th>' + 
                '<th lang=pl>Miejsce</th>' + 
                '<th data-priority="1">Przyczyna</th>' + 
                '</tr>' + 
                '</thead>' + 
                ' <tbody>';
                if (typeof this.packages[l - 1].data[0].zdarzenia !== 'undefined') {
                    var jednostka = "";
                    var zd = this.packages[l - 1].data[0].zdarzenia;
                    $.each(zd, function(e, val) {
                        jednostka = val.daneSzczegJednostki;
                        events_table_srt = events_table_srt + 
                        '<tr>' + 
                        '<td lang=pl>' + val.nazwa + '</td>' + 
                        '<td>' + val.czasZadrzenia + '</td>' + 
                        '<td>' + jednostka + '</td>' + 
                        '<td>' + val.przyczyna + '</td>' + 
                        '</tr>';
                    });
                }
                events_table_srt = events_table_srt + '</tbody> </table>';
                events_table = $(events_table_srt);
                packages_table.appendTo(table);
                events_table.appendTo(table);
                table.trigger("create");
                $("#search-package-field").val(this.packages[l - 1].id);
            } else {
                $("#search-package-field").val(this.packages[l - 1].id);
                if ((navigator.language || navigator.userLanguage) === "pl-pl" || (navigator.language || navigator.userLanguage) === "pl"){
                    table.html("<p><span lang=pl>brak informacji o przesyłce:</span> <b>" + this.packages[l - 1].id + "</b></p>");
                }else{
                    table.html("<p><span lang=pl>no information about package:</span> <b>" + this.packages[l - 1].id + "</b></p>");
                }
            }
        }
    },
    deletePackege: function(package_id) {
        for (var i = 0; i < TrackPP.packages.length; i++)
            if (TrackPP.packages[i].id && TrackPP.packages[i].id === package_id) {
                TrackPP.packages.splice(i, 1);
            }
        TrackPP.render();
    },
 
    getPackageinfo: function(id) {
        $('#picture-canvas').html('');
        if (id.length > 0) {
            id = id.replace(/\s/g, "").toUpperCase().substring(0, 20);
            if ((navigator.language || navigator.userLanguage) === "pl-pl" || (navigator.language || navigator.userLanguage) === "pl"){
                 $.mobile.showPageLoadingMsg("a", "Pobieranie danych o przesyłce.");
             } else {
                  $.mobile.showPageLoadingMsg("a", "Retrieving information about the shipment.");
             }
            var url = this.serviceUrl + id;
            var info = $.ajax({
                url: url,
                dataType: "JSON",
                success: TrackPP.prepareData,
                error: Utils.errorInfo
            });
        }
    },
    prepareData: function(data) {
        if (data.length !== 0) {
            var d = new Date();
            var month = d.getMonth() + 1;
            var day = d.getDate();
            var hour = d.getHours();
            var minute = d.getMinutes();
            var second = d.getSeconds();
            
            TrackPP.deletePackege(data[0].numer);
            TrackPP.packages.push({
                id: data[0].numer,
                date: d.getFullYear() + '-' + month + '-' + day + ' ' + hour + ':' + minute + ':' + second,
                data: data
            });
            TrackPP.render();
        }
        $.mobile.hidePageLoadingMsg();
    },
    processspeech: function() {
        $('#search-package-field').val($('#search-package-field').val().replace(/\s/g, ""));
    }
};
