
var dbName = "wishes";
var dbVersion = 1;

var db;
var request = indexedDB.open(dbName, dbVersion);

request.onerror = function (event) {
    console.error("Can't open indexedDB!!!", event);
};
request.onsuccess = function (event) {
    console.log("Database opened ok");
    db = event.target.result;
};

request.onupgradeneeded = function (event) {

    console.log("Running onUpgradeNeeded");

    db = event.target.result;

    if (!db.objectStoreNames.contains("wishes")) {

        console.log("Creating objectStore for wishes");

        var objectStore = db.createObjectStore("wishes", {
            keyPath: "id",
            autoIncrement: true
        });
        objectStore.createIndex("title", "title", {
            unique: false
        });

        console.log("Adding sample wish");
        var sampleWish1 = new Wish();
        sampleWish1.title = "Welcome Wish";
        sampleWish1.mobile_number = "";
        sampleWish1.content = "This is a note taking app. Use the plus sign in the topleft corner of the main screen to add a create wish.";

        objectStore.add(sampleWish1);
    }
};

function Wish() {
    this.title = "Untitled Wish";
    this.mobile_number = "";
    this.content = "";
    this.created = Date.now();
    this.modified = Date.now();
}

function listAllWishTitles(inCallback) {
    var objectStore = db.transaction("wishes").objectStore("wishes");
    console.log("Listing wishes...");

    objectStore.openCursor().onsuccess = function (event) {
        var cursor = event.target.result;
        if (cursor) {
            console.log("Found wish #" + cursor.value.id + " - " + cursor.value.title);
            inCallback(null, cursor.value);
            cursor.continue();
        }
    };
}

function saveWishDB(inWish, inCallback) {
    var transaction = db.transaction(["wishes"], "readwrite");
    console.log("Saving wish");

    transaction.oncomplete = function (event) {
        console.log("All done");
    };

    transaction.onerror = function (event) {
        console.error("Error saving wish:", event);
        inCallback({
            error: event
        }, null);

    };

    var objectStore = transaction.objectStore("wishes");

    inWish.modified = Date.now();

    var request = objectStore.put(inWish);
    request.onsuccess = function (event) {
        console.log("Wish saved with id: " + request.result);
        inCallback(null, request.result);

    };
}

function deleteWish(inId, inCallback) {
    console.log("Deleting wish...");
    var request = db.transaction(["wishes"], "readwrite").objectStore("wishes").delete(inId);

    request.onsuccess = function (event) {
        console.log("wish deleted!");
        inCallback();
    };
}
