
var listView, detailView, currentWish, deleteWishDialog;
function showWishDetail(inWish) {
    currentWish = inWish;
    displayWish();
    listView.classList.add("hidden");
    detailView.classList.remove("hidden");
}

function shareWish() {
    var shareActivity = new MozActivity({
        name: "new",
        data: {
            type: "mail",
            body: currentWish.content,
            url: "mailto:?body=" + encodeURIComponent(currentWish.content) + "&subject=" + encodeURIComponent(currentWish.title+"\n"+currentWish.mobile_number+"\n"+currentWish.wishdatetime)

        }
    });
    shareActivity.onerror = function (e) {
        console.log("can't share wish", e);
    };
}


function displayWish() {
    document.getElementById("wish-title").value = currentWish.title;
    document.getElementById("wish-number-content").value = currentWish.mobile_number;
    document.getElementById("wish-content").value = currentWish.content;
}

function saveWish(e) {
    currentWish.title = document.getElementById("wish-title").value;
    currentWish.mobile_number = document.getElementById("wish-number-content").value;
    currentWish.wishdatetime = document.getElementById("wish-date").value;
    currentWish.content = document.getElementById("wish-content").value;
    saveWishDB(currentWish, function (err, succ) {
        console.log("save wish callback ", err, succ);
        if (!err) {
            currentWish.id = succ;
        }
    });
    alert("Wish saved.");
    //utils.status.show('Wish saved.');
    showWishList();
}

function newWish() {
    var myNewWish = new Wish();
    var deleteWishElement = document.getElementById("delete-wish");
    deleteWishElement.style.visibility = "hidden";
    showWishDetail(myNewWish);
}

function requestDeleteConfirmation() {
    deleteWishDialog.classList.remove("hidden");
}

function closeDeleteWishDialog() {
    deleteWishDialog.classList.add("hidden");
}

function deleteCurrentWish() {
    closeDeleteWishDialog();
    deleteWish(currentWish.id, function (err, succ) {
        console.log("callback from delete", err, succ);
        if (!err) {
            showWishList();
        }
    });
}

function showWishList() {
    currentWish = null;
    refreshWishList();
    listView.classList.remove("hidden");
    detailView.classList.add("hidden");
}


function refreshWishList() {
    if (!db) {
        console.warn("Database is not ready yet");
        setTimeout(refreshWishList, 1000);
        return;
    }
    console.log("Refreshing wish list");

    var wishListContainer = document.getElementById("WishesList");


    while (wishListContainer.hasChildNodes()) {
        wishListContainer.removeChild(wishListContainer.lastChild);
    }

    var wishList = document.createElement("ul");
    wishListContainer.appendChild(wishList);

    listAllWishTitles(function (err, value) {
        var wishItem = document.createElement("li");
        var wishP = document.createElement("p");
        var wishTitle = document.createTextNode(value.title);

        wishItem.addEventListener("click", function (e) {
            var deleteWishElement = document.getElementById("delete-wish");
            deleteWishElement.style.visibility = "visible";
            showWishDetail(value);
        });

        wishP.appendChild(wishTitle);
        wishItem.appendChild(wishP);
        wishList.appendChild(wishItem);


    });
}


window.onload = function () {
    listView = document.getElementById("wish-list");
    detailView = document.getElementById("wish-detail");
    deleteWishDialog = document.getElementById("delete-wish-dialog");

    document.getElementById("back-to-list").addEventListener("click", showWishList);
    document.getElementById("new-wish").addEventListener("click", newWish);
    document.getElementById("share-wish").addEventListener("click", shareWish);
    document.getElementById("delete-wish").addEventListener("click", requestDeleteConfirmation);
    document.getElementById("confirm-delete-action").addEventListener("click", deleteCurrentWish);
    document.getElementById("cancel-delete-action").addEventListener("click", closeDeleteWishDialog);
    document.getElementById("save-wish").addEventListener("click", saveWish);
    refreshWishList();
    setAlarm();
};

navigator.mozSetMessageHandler('alarm', function() {
    console.log('alarm');
    setAlarm();
    checkWishList();
});

function setAlarm(){
    var request = navigator.mozAlarms.add(new Date((+new Date()) + 10000), 'ignoreTimezone', {
        type: 'alarm'
    });
    request.onsuccess = function() {
        console.log('reload alarm');
    }

    request.onerror = function() {
        console.error('reload alarm err');
    }
}



var dbName = "wishes";
var dbVersion = 1;

var db;
var request = indexedDB.open(dbName, dbVersion);

request.onerror = function (event) {
    console.error("Can't open indexedDB!!!", event);
};
request.onsuccess = function (event) {
    console.log("Database opened ok");
    db = event.target.result;
};

request.onupgradeneeded = function (event) {

    console.log("Running onUpgradeNeeded");

    db = event.target.result;

    if (!db.objectStoreNames.contains("wishes")) {

        console.log("Creating objectStore for wishes");

        var objectStore = db.createObjectStore("wishes", {
            keyPath: "id",
            autoIncrement: true
        });
        objectStore.createIndex("title", "title", {
            unique: false
        });

        console.log("Adding sample wish");
        var sampleWish1 = new Wish();
        sampleWish1.title = "Welcome Wish";
        sampleWish1.mobile_number = "";
        sampleWish1.wishdatetime = Date.now();
        sampleWish1.content = "This is a wish sending app. Use the plus sign in the topleft corner of the main screen to create a new wish.";

        objectStore.add(sampleWish1);
    }
};


function checkWishList() {
    var objectStore = db.transaction("wishes").objectStore("wishes");
    console.log("Alarm Listing wishes...");

    objectStore.openCursor().onsuccess = function (event) {
        var cursor = event.target.result;
        if (cursor) {
            console.log("Alarm wish #" + " "+cursor.value.content+" "+cursor.value.mobile_number);
            var wishTargetDate = Date.parse(cursor.value.wishdatetime);
            console.log("DB date time "+wishTargetDate);
            var currentTime = Date.now();
            var diffTime = (currentTime - wishTargetDate)/60000;
            console.log(diffTime);

            if(cursor.value.mobile_number.length>2 && diffTime>=0 && diffTime<=60){
                var iconUrl = getURLResource("style/icons/icon_32.png");
                var bodyContent = "Wish message send to "+cursor.value.title+"("+cursor.value.mobile_number+")";
                var notification = new Notification("Wish Buddy", { body: bodyContent, icon: iconUrl });
            }
            cursor.continue();
        }
    };
}

function getURLResource(path)
{
    var url = window.location.href.replace("index.html", "");
    return url + path;

};