grammarClockClass = function() {
	instance = this;
	timeInterval = null;
	
	
	
	
	function padZero(n, width, z) {
		z = z || '0';
		n = n + '';
		return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
	}
	
	_hour2word = function(hour, minute) {
		//If we're past 30 mins then we move TO the hour rather than PAST the current one
		if(minute > 30){
			hour = hour + 1;
		}
		if(hour > 12){ hour = hour - 12; }

		var hourTiming = new Array();
		
		hourTiming[0] = "midnight";
		hourTiming[1] = "one";
		hourTiming[2] = "two";
		hourTiming[3] = "three";
		hourTiming[4] = "four";
		hourTiming[5] = "five";
		hourTiming[6] = "six";
		hourTiming[7] = "seven";
		hourTiming[8] = "eight";
		hourTiming[9] = "nine";
		hourTiming[10] = "ten";
		hourTiming[11] = "eleven";
		hourTiming[12] = "twelve";
		
		return hourTiming[hour];
	}
	
	_minute2word = function(minutes) {

		if(minutes > 30){
			minutes = 60 - minutes;
		}
		
		var minuteTiming = new Array();
	
		//minutes past the hour
		minuteTiming[0] = "exactly"
		minuteTiming[1] = "one"
		minuteTiming[2] = "two"
		minuteTiming[3] = "three"
		minuteTiming[4] = "four"
		minuteTiming[5] = "five"
		minuteTiming[6] = "six"
		minuteTiming[7] = "seven"
		minuteTiming[8] = "eight"
		minuteTiming[9] = "nine"
		minuteTiming[10] = "ten"
		minuteTiming[11] = "eleven"
		minuteTiming[12] = "twelve"
		minuteTiming[13] = "thirteen"
		minuteTiming[14] = "fourteen"
		minuteTiming[15] = "quarter"
		minuteTiming[16] = "sixteen"
		minuteTiming[17] = "seventeen"
		minuteTiming[18] = "eighteen"
		minuteTiming[19] = "nineteen"
		minuteTiming[20] = "twenty"
		minuteTiming[21] = "twenty-one"
		minuteTiming[22] = "twenty-two"
		minuteTiming[23] = "twenty-three"
		minuteTiming[24] = "twenty-four"
		minuteTiming[25] = "twenty-five"
		minuteTiming[26] = "twenty-six"
		minuteTiming[27] = "twenty-seven"
		minuteTiming[28] = "twenty-eight"
		minuteTiming[29] = "twenty-nine"
		minuteTiming[30] = "half"
		
		return minuteTiming[minutes];
	}
	
	_getPrefix = function(minutes) {
	   //decide if we're past the hour or to the next hour
	   
		var suffix = ( minutes < 30 ) ? " minutes past" : " minutes to";
		//The milestones
		switch(minutes){
		case 0:
			suffix = "";
		break;
		case 1:
			suffix = " minute past";
		break;
		case 59:
			suffix = " minute to";
		break; 
		//Past the hour
		case 5:
		case 10:
		case 15:
		case 20:
		case 25:
		case 30:
		   suffix = " past"; 
		break;
		//To the hour
		case 35:
		case 40:
		case 45:
		case 50:
		case 55:
		   suffix = " to"; 
		break;
		}
		return suffix;
	}
	
	this.init = function() {
		this.refreshClock();
		timeInterval = setInterval(this.refreshClock,1000);
	}
	
	this.refreshClock = function() {
		var result = [];
		var currentTime = new Date();
		result.seconds = padZero(currentTime.getSeconds(),2);		
		
		result.hour = _hour2word(currentTime.getHours(),currentTime.getMinutes());
		result.minutes = _minute2word(currentTime.getMinutes());
		result.prefix = _getPrefix(currentTime.getMinutes());

		instance.onRefresh(result);
	}
	
	this.onRefresh = function(result) {
		//refresh every second
	}
	
}

var indexTheme = 0;

$(document).ready(function() {
	//initiate app
	$('#viewPort').css({opacity: 0}); 
	$('#viewPort').transition({ scale: '1.2', opacity: 0}).transition({ scale: '1', opacity: 1});
	
	wordClock = new grammarClockClass();

	//refresh every second
	wordClock.onRefresh = function(result) {
		$('#minutes').html(result.minutes);
		$('#prefix').html(result.prefix);
		$('#hour').html(result.hour);
		$('#seconds').html(result.seconds);
	}
	
	//start clock
	wordClock.init();
	
	
	/*Main action buttons*/
	$('#textClock').on('swipe', function(event) {
		indexTheme++;if (indexTheme > 2) indexTheme = 0;
		
		if(indexTheme == 0)	$('body').attr('class', '').addClass('light-theme');
		if(indexTheme == 1)	$('body').attr('class', '').addClass('dark-theme');
		if(indexTheme == 2)	$('body').attr('class', '').addClass('night-theme');
	});
	
});