(function(){
	'use strict';

	angular
		.module('WordPress',[
			'ngSanitize', 
			'ui.router', 
			'common-elements', 
			'wp-home', 
			'wp-controllers', 
			'wp-services', 
			'mgcrea.pullToRefresh',
			'ngModal',
			'ngAnimate', 
			'ui.sortable'
		])/* , 'ngTouch' */
		.config(['$locationProvider', '$httpProvider', '$stateProvider', '$urlRouterProvider', '$sceProvider',function($locationProvider, $httpProvider, $stateProvider, $urlRouterProvider, $sceProvider) {
	
			$stateProvider
				.state('posts', {
					url: 'posts',
					template: "<posts-list data='postsData' state='postInfo' current-menu='currentMenu' show-loader='showLoader' view-title='viewTitle' add-post='addPost()' on-reload='onReload()' hide-menu='hideMenu(event)' show-drawer='showDrawer' post-toast='postToast' toast-message='toastMessage' next-page-data='nextPageData' load-more='loadMore()'></posts-list>",
					controller: 'postsController'
				})
				.state('postInfo', {
					//url: '/post_{id:[0-9]{1,4}}',
					url: 'post_:{id:[0-9]{1,4}}:editState:content',
					template: "<post-info></post-info>",
					//controller: 'singlePostController'
				})
				
				.state('pages', {
					url: 'pages',
					template: "<posts-list data='pagesData' state='pageInfo' current-menu='currentMenu' show-loader='showLoader' view-title='viewTitle' add-post='addPost()' on-reload='onReload()' hide-menu='hideMenu(event)' show-drawer='showDrawer' post-toast='postToast' toast-message='toastMessage' next-page-data='nextPageData' load-more='loadMore()'></posts-list>",
					controller: 'pagesController'
				})
				.state('pageInfo', {
					url: 'page_:{id:[0-9]{1,4}}',
					template: "<post-info></post-info>",
					controller: 'singlePostController'
				})
				
				.state('comments', {
					url: 'comments',
					templateUrl: "src/views/comments.html",
					controller: 'commentsController'
				})
				
				.state('commentInfo', {
					url: 'comment_:id:backTo:hideFooter:backToNoteID',
					templateUrl: "src/views/commentInfo.html",
					controller: 'commentInfoController'
				})
				
				.state('newPost', {
					url: 'newPost_?type&backTo&id&parentView&content&stateParams&selectedMedia&currentView&startDate&endDate&imageDetails&fromPost&mediaAttach',
					templateUrl: "src/views/newPost.html",
					//controller: 'newPostController'
				})

				.state('commentsWithPost', {
					url: 'commentsWithPost_:id:backTo:postID:mainView:site_ID:stringObject:viewScreen:postInfo:hideFooter:backToNoteID:likeView:returnObj',
					templateUrl: "src/views/commentsWithPost.html",
					controller: 'commentsWithPostController'
				})
				
				.state('notifications', {
					url: 'notifications',
					templateUrl: "src/views/notifications.html",
					controller: 'notificationsController'
				})

				.state('noteInfo', {
					url: 'note_:{id:[0-9]{1,4}}',
					templateUrl: "src/views/noteInfo.html",
					controller: 'noteInfoController'
				})
				
				.state('viewSite', {
					url: 'viewSite_?id&backTo&url&title&site_id&mainView&hideFooter&backToNoteID&stringObject',
					templateUrl: "src/views/wp-viewSite.html",
					controller: 'viewSiteController'
				})

				.state('reader', {
					url: 'reader_?itemObj',
					templateUrl: "src/views/reader.html",
					controller: 'readerController'
				})

				.state('readerSub', {
					url: 'readerSub_?id&backTo&postID&mainView&site_ID&stringObject&viewScreen&postInfo&blogTitle&dataUrl&itemObj',
					templateUrl: "src/views/readerSubView.html"
				})				

				.state('media', {
					url:'media_?currentView&startDate&endDate&searchText&selectedIds&fromPost&backTo&postId&stateParams&content&createGallery',
					templateUrl: "src/views/mediaLib.html",
					controller: 'mediaController'
				})

				.state('mediaInfo', {
					url: 'mediaInfo_:data:calledFromView:startDate:endDate:searchText',
					templateUrl: "src/views/mediaInfo.html",
					controller: 'mediaInfoController'
				})
				
				.state('themes', {
					url: 'themes_?currentTab',
					templateUrl: "src/views/themes.html",
					controller: 'themesController'
				})
                                
                .state('themeInfo', {
					url: 'themeInfo_?data&backToTab',
					templateUrl: "src/views/themeInfo.html",
					controller: 'themeInfoController'
				})
				
				.state('reblog', {
					//url: '/reblog_:backTo:postInfo:stringObject',
					url: 'reblog_?backTo&postInfo&stringObject&hideFooter&backToNoteID',
					template: "<reblog-template></reblog-template>",
					controller: 'reblogController'
				})

				.state('previewBlog', {
					url: '/previewblog?backTo&blogTitle&dataUrl&stringObject&itemObj',
					templateUrl: "src/views/previewBlog.html",
					controller: 'previewBlogController'
				})

				.state('redirector', {
					url: ':stringObject',
					//templateUrl: "src/views/previewBlog.html",
					controller: 'redirectorController'
				})
				
				.state('stats', {
					url: 'stats_?id&backTo',
					templateUrl: "src/views/stats.html",
					controller: 'statsController'
				})
				
				.state('quickPhoto', {
					controller: 'quickPhotoController'
				})
				
				.state('quickVideo', {
					controller: 'quickVideoController'
				})
				
				.state('settings', {
					url: 'settings_?returnObj',
					templateUrl: "src/views/settings.html",
					controller: 'settingsController'
				})

				.state('pinlock', {
					templateUrl: "src/views/pinLock.html",
					controller: 'pinlockController'
				})

				.state('signOut', {
					url: 'signout_?backTo',
					//templateUrl: "src/views/signOut.html",
					controller: 'signOutController'
				});

			$locationProvider.html5Mode(true);
			$httpProvider.defaults.useXDomain = true;
			delete $httpProvider.defaults.headers.common['X-Requested-With'];
			//$sceProvider.enabled(false);
		}]);
})();