(function() {
	'use strict';

	var controllers = {};

/***	Comments controller 	***/
	controllers.commentsController = function($scope, $http,  $log, $rootScope, APICaller, commonService) {
		localStorage.setItem('lastAccessedView', "comments");
		
		// ****************** initialization of variables starts *********************** //
		$scope.currentMenu = "comments";
		$scope.showDrawer = false;
		$scope.pageNo = 1;
		$scope.nextPageData = [];
		$scope.showLoader = true;//show loader icon till the data gets loaded from API call 

		// ****************** initialization of variables ends *********************** //
		
		// ************************ Methods for API calls and their response starts ***************************** //


			//-------------------------------- GET COMMENT STARTS ----------------------------------------//
			
			/*	Description => The method fetching the comments list for the logged in user
				Params => 1. pageNo : page number of the data.
			*/					
			$scope.getComments = function(pageNo){
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					var getCommentsUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/comments/?pretty=1&status=all&context=edit&number=100';
					var apiCaller = new APICaller('GET',getCommentsUrl, $scope.getComment_Success, $scope.getComment_Error);
						apiCaller.getResult();
					$scope.getSpamComments();
				}
				else{
					NProgress.done();
					$scope.toastMessage = "There is no network available";
					$scope.commentToast = true;
					$scope.showLoadSpinner = false;
				}
			};

				$scope.getComment_Success = function(e) {
							$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
							if (this.readyState === 4 && this.status === 200) {
								var jsonResponse = JSON.parse(this.response);
								$scope.commentsData = jsonResponse;
								
								if($scope.spamCommentsData){
									$.merge($scope.commentsData.comments, $scope.spamCommentsData.comments);
									$scope.commentsData.comments.sort(function(a, b){
										 var dateA=new Date(a.date), dateB=new Date(b.date);
										 return dateB-dateA //sort by date ascending
									});
								}

								$scope.$apply();
								NProgress.done();
							}
						};
				$scope.getComment_Error = function () {
					NProgress.done();					
					$scope.toastMessage = "Problem loading comments";
					$scope.commentToast = true;
					$scope.$apply();
				};


			//-------------------------------- GET COMMENT ENDS ----------------------------------------//
			//-------------------------------- GET Spam Comments STARTS ----------------------------//

			/*	Description => The method fetching the Spam Comments list
			*/

			
			$scope.getSpamComments = function(){
				var getSpamCommentsUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/comments/?pretty=1&status=spam&context=edit&number=100';
				var apiCaller = new APICaller('GET',getSpamCommentsUrl, $scope.getSpamComments_Success, $scope.getSpamComments_Error);
						apiCaller.getResult();
			};

				$scope.getSpamComments_Success = function(e) {
							if (this.readyState === 4 && this.status === 200) {
								var jsonResponse = JSON.parse(this.response);
								$scope.spamCommentsData = jsonResponse;
								$scope.$apply();
							}
						};
				$scope.getSpamComments_Error = function () {
					//$log.log("Problem loading spam comments!");
				};

			//-------------------------------- GET Spam Comments ENDS ----------------------------//

			//-------------------------------- GET Spam Comments STARTS ----------------------------//

			// ************************ Methods for view actions starts ***************************** //
			/*	Description => The method to hide the menu section.
				Params => 1. event : event object.
			*/
			$scope.hideMenu = function(event){
				if($scope.showDrawer === true){
					if ( event.target.className.indexOf( 'drawerIcon' ) == -1 )
						$scope.showDrawer = false;
				}
			};
			
			/*	Description => The function gets executed on pull to refresh
			*/
			$scope.onReload = function() {
				$scope.nextPageData = [];
				$scope.pageNo = 1;
				$scope.getComments(1);
			};

			/*	Description => The method to load next page data inside view.
			*/
			$scope.loadMore = function(){			
				if($scope.commentsData != undefined && $scope.nextPageData != undefined){
					$.merge($scope.commentsData.comments, $scope.nextPageData);
					$scope.showLoadSpinner = true;
				}
				$scope.pageNo = $scope.pageNo + 1;
				$scope.getComments($scope.pageNo);
			};

			// ************************ Methods for view actions ends ***************************** //

			$scope.getComments($scope.pageNo);
	};
	controllers.commentsController.$inject = ['$scope', '$http',  '$log', '$rootScope', 'APICaller', 'commonService'];	
	controllers.commentInfoController = function($scope, $http,  $log, $state, $stateParams, $rootScope, APICaller, commonService) {
			NProgress.remove();
			
			// ****************** initialization of variables starts *********************** //	
			localStorage.setItem('lastAccessedView', "comments");			
			$scope.replyComment = "";
			$scope.currentView = "commentInfo";			
			if($stateParams.backTo == "notifications" || $stateParams.backTo == "noteInfo"){
				$scope.viewTitle = "Notifications";
			}
			else{
				$scope.viewTitle = "Comments";
			}
			
			if($stateParams.hideFooter != null){
				$scope.hideFooter = $stateParams.hideFooter;
			}
			else{
				$scope.hideFooter = false;
			}
			$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
			// ****************** initialization of variables ends *********************** //
			//-------------------------------- Get Single Comment starts ----------------------------//

			/*	Description => The method fetching the SingleComment list
					Params => 1. commentID : commentID object.
			*/
			$scope.getSingleComment = function(commentID){
			$scope.isOnline = navigator.onLine;
				NProgress.start();
				if($scope.isOnline){
					var getSingleCommentUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/comments/'+ commentID + '?context=edit&pretty=1';
					var apiCaller = new APICaller('GET',getSingleCommentUrl, $scope.getSingleComment_Success, $scope.getSingleComment_Error);
						apiCaller.getResult();
				}
				else{
					NProgress.done();
					$scope.toastMessage = "There is no network available";
					$scope.commentToast = true;
				}
			};
			
				$scope.getSingleComment_Success = function(e) {
					$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
							if (this.readyState === 4 && this.status === 200) {
								$scope.commentInfo = JSON.parse(this.response);
								$scope.$apply();
								NProgress.done();
							}
						};
				$scope.getSingleComment_Error = function () {
					NProgress.done();
					$scope.toastMessage = "Problem loading comment";
					$scope.commentToast = true;
					$scope.$apply();
				};
			
			//-------------------------------- Get Single Comment ends ----------------------------//
			
			//-------------------------------- Get New Comment starts ----------------------------//
			/*	Description => The method fetching the new Comments list
					Params => 1. commentID : commentID object.
			*/


			$scope.newComment = function(commentID){
				$scope.isOnline = navigator.onLine;
				//NProgress.start();
				if($scope.isOnline){
					var commentInputText = $.trim(angular.element('#commentInput').val());
					if(commentInputText.length !== 0){
						$scope.loading = true;
						var newCommentUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/comments/'+commentID+'/replies/new';
						var payload = 'content='+ encodeURIComponent($scope.replyComment);
						var apiCaller = new APICaller('POST', newCommentUrl, $scope.newComment_success, $scope.newComment_error, payload);
						apiCaller.getResult();					
					}
					else{
						angular.element('#commentInput').val("");
					}

				}
				else{
					$scope.toastMessage = "There is no network available";
					$scope.commentToast = true;
				} 
			};
			
				$scope.newComment_success = function(e) {
								if (this.readyState === 4 && this.status === 200) {
									$scope.loading = false;
									$scope.toastMessage = "Reply published";
									$scope.commentToast = true;
									$scope.replyComment = "";
									$scope.$apply();
								}
				};

				$scope.newComment_error = function () {
					$scope.toastMessage = "Reply failed";
					$scope.commentToast = true;
					$scope.$apply();
				};
			//-------------------------------- Get New Comment ends ----------------------------//	

			//-------------------------------- Get Delete Comment starts ----------------------------//
			/*	Description => The method fetching the Delete Comment list
					Params => 1. commentID : commentID object.
			*/

			$scope.deleteComment = function(commentID){
			// ****************** initialization of variables starts *********************** //		
					$scope.showDelete = false;
					$scope.loaderMessage = "Sending to trash";
					$scope.commentLoader = true;
			// ****************** initialization of variables ends *********************** //		
					var deleteCommentUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/comments/'+commentID+'/delete';
					var apiCaller = new APICaller('POST', deleteCommentUrl, $scope.deleteComment_success, $scope.deleteComment_error);
					apiCaller.getResult();
			};
					
				$scope.deleteComment_success = function(e) {
					if (this.readyState === 4 && this.status === 200) {
						$scope.commentLoader = false;
						$scope.$apply();
						if($stateParams.backTo == "notifications"){
							$state.go($stateParams.backTo);
						}
						else{
							$state.go("comments");
						}
					}
				};

				$scope.deleteComment_error = function (e) {
					$scope.commentLoader = false;
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						$scope.toastMessage = "There is no network available";
						$scope.commentToast = true;
					}
					$scope.$apply();
				};

			//-------------------------------- Get Delete Comment ends ----------------------------//

			//-------------------------------- Get changeStatus Comment starts ----------------------------//
			/*	Description => The method fetching the changeStatus Comment list
					Params => 1. commentID : commentID object,
							  2. status : status object.
			*/

			$scope.changeStatus  = function(status , commentID){
				$scope.isOnline = navigator.onLine;
			// ****************** initialization of variables starts *********************** //	
				if($scope.isOnline){
					if(status === "approved")
						$scope.loaderMessage = "Approving";
					else if(status === "unapproved")
						$scope.loaderMessage = "Unapproving";
					else if(status === "spam")
						$scope.loaderMessage = "Marking as spam";
					else if(status === "unspam")
						$scope.loaderMessage = "Approving";
						
					$scope.loadingStatus = true;
					$scope.commentLoader = true;
			// ****************** initialization of variables ends *********************** //		

					var changeStatusUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/comments/'+commentID+'/?fields=status';
					var payload = 'status='+ encodeURIComponent(status) ;
					var apiCaller = new APICaller('POST', changeStatusUrl, $scope.changeStatus_success, $scope.changeStatus_error, payload);
					apiCaller.getResult();
				}
				else{
					$scope.toastMessage = "There is no network available";
					$scope.commentToast = true;
				} 
			};

				$scope.changeStatus_success = function(e) {
					if (this.readyState === 4 && this.status === 200) {
						$scope.loadingStatus = false;
						$scope.commentLoader = false;
						$scope.commentInfo.status = JSON.parse(this.responseText).status;
						$scope.$apply();
					}
				};
				$scope.changeStatus_error = function () {
					$scope.toastMessage = "Change status failed";
					$scope.commentToast = true;
					$scope.$apply();
				};
			//-------------------------------- Get changeStatus Comment ends ----------------------------//
			
			//-------------------------------- Get Update Comment starts ----------------------------//
			/*	Description => The method fetching the Update Comment list
			*/
			$scope.updateComment  = function(){			
				if ( $scope.authorName != $scope.commentInfo.author['name']
					 || $scope.authorURL != $scope.commentInfo.author['URL']
					 || $scope.commentText != $scope.commentInfo.content )
				{
					$scope.isOnline = navigator.onLine;
					//NProgress.start();
					if($scope.isOnline){
						var commentContent = $.trim(angular.element('#commentContent').val());
						if(commentContent.length !== 0){
							$scope.loaderMessage = "Saving changes";
							$scope.commentLoader = true;
							
							var updateCommentUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/comments/'+ $scope.commentInfo.ID +'/';
							var payload = 'date=' + encodeURIComponent($scope.commentInfo.date) +
										  '&content=' + encodeURIComponent($scope.commentText) +
										  '&status=' + $scope.commentInfo.status;
							var apiCaller = new APICaller('POST', updateCommentUrl, $scope.updateComment_success, $scope.updateComment_error, payload);
							apiCaller.getResult();
						}
						else{
							$scope.toastMessage = "Please enter some comment";
							$scope.commentToast = true;
							angular.element('#commentContent').val("");
						}
					}
					else{
						$scope.toastMessage = "There is no network available";
						$scope.commentToast = true;
					} 
				}
				else{
					$scope.toastMessage = "Comment hasn't changed";
					$scope.commentToast = true;
				}
			};

				$scope.updateComment_success = function(e) {
									if (this.readyState === 4 && this.status === 200) {
										$scope.commentLoader = false;
										$scope.commentInfo = JSON.parse(this.response);
										$scope.editing = false;
										$scope.getSingleComment($scope.commentInfo.ID);
										$scope.$apply();
									}
				};
				$scope.updateComment_error = function () {
					$scope.toastMessage = "Edited Comment could not be published";
					$scope.commentToast = true;
					$scope.$apply();
				};
			
			//-------------------------------- Get Update Comment ends ----------------------------//
			// ************************ Methods for API calls ends ***************************** //

			// ************************ Methods for view actions starts ***************************** //

			/*	Description => The method fetching the Edit Comment 
			*/
			$scope.editComment  = function(){
				$scope.editing = true;
				$scope.authorName = $scope.commentInfo.author['name'];
				$scope.authorURL = $scope.commentInfo.author['URL'];
				$scope.siteObject = localStorage.getItem('siteObject');
				$scope.siteObject = JSON.parse($scope.siteObject);
				$scope.commentText = $scope.commentInfo.content;
			};

			/*	Description => The method Cancel the edited commnet 
			*/
			$scope.editCancel  = function(){	
				NProgress.done();
				if ( $scope.authorName != $scope.commentInfo.author['name']
					 || $scope.authorURL != $scope.commentInfo.author['URL']
					 || $scope.commentText != $scope.commentInfo.content )
				{
					$scope.showCancelEdit = true;
				}
				else
					$scope.editing = false;
			};
			
			/*	Description => The method for Web Site view
			*/
			$scope.viewSite = function(viewType){	
				NProgress.remove();
				if (viewType == 'commentsWithPost'){
					$state.go("commentsWithPost", { id: $scope.commentInfo.ID, backTo: $scope.currentView, 
						postID: $scope.commentInfo.post['ID'], mainView: $stateParams.backTo, hideFooter: $scope.hideFooter, backToNoteID: $stateParams.backToNoteID});
				}
				else {
					$state.go("viewSite", { id : $scope.commentInfo.ID, backTo : $scope.currentView , 
						url: $scope.commentInfo.author['URL'], title: $scope.commentInfo.author['name'], site_id : $scope.commentInfo.author['site_ID'], mainView: $stateParams.backTo, hideFooter: $scope.hideFooter, backToNoteID: $stateParams.backToNoteID});
				}
			};
			/*	Description => The method that conditionally navigates back to previous manu.
			*/
			$scope.goBack = function(){			
				if($scope.editing)
					$scope.editCancel();
				else if($stateParams.backTo == "notifications"){
					NProgress.remove();
					$state.go($stateParams.backTo);
				}
				else if($stateParams.backTo == "noteInfo"){
					NProgress.remove();
					$state.go($stateParams.backTo, {id: $stateParams.backToNoteID});
				}
				else{
					NProgress.remove();
					$state.go('comments');
				}
			};
			// ************************ Methods for view actions ends ***************************** //
			
			$scope.getSingleComment($stateParams.id);
	};
	controllers.commentInfoController.$inject = ['$scope', '$http',  '$log', '$state', '$stateParams', '$rootScope', 'APICaller', 'commonService'];	
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

