(function() {
	'use strict';

	var controllers = {};


	controllers.commentsWithPostController = function($scope, $http, $log, $state, $stateParams, $rootScope, $filter, APICaller, commonService) {
	
	// ****************** initialization of variables starts *********************** //				
		if($stateParams.viewScreen == undefined || $stateParams.viewScreen == "commentsWithPost"){
			$scope.showCommentWithPostView = true;
		}else	{
			$scope.showCommentWithPostView = false;
			return;
		}
		
		var jsonObj=null;
		if($stateParams.returnObj){
			jsonObj = JSON.parse($stateParams.returnObj);
			$stateParams = jsonObj;
			$scope.likeView = jsonObj.likeView;
		}else{
			jsonObj = JSON.parse($stateParams.stringObject);
		}
		
		$scope.textComment = "";
		$scope.currentView = "commentsWithPost";
		$scope.showInput = false;
		$scope.strPlaceholder = "Add your comment";
		$scope.isFollowing = {};
		$scope.commentLikeStatus = {};
		$scope.commentLikesData = {};
		$scope.showLoader = true;//show loader icon till the data gets loaded from API call
		$scope.showIconLoader = false;//show loader icon till the data gets loaded from API call 
		//var jsonObj = JSON.parse($stateParams.stringObject);
		if($stateParams.mainView == "notifications" || $stateParams.mainView == "noteInfo" || $stateParams.backTo == "noteInfo"){
			$scope.viewTitle = "Notifications";
		}
		else if (jsonObj != null && (jsonObj.title || jsonObj.blogTitle) ) {
			$scope.viewTitle = jsonObj.title? jsonObj.title : jsonObj.blogTitle;
		}
		else{
			$scope.viewTitle = "Comments";
		}

	// ****************** initialization of variables ends *********************** //


	// ************************ Methods for API calls starts ***************************** //

		//-------------------------------- GET SiteInfo STARTS -----------------------//				
			/*	Description => The method gets the site info.
			*/
			$scope.getSiteInfo = function(siteID){
				var getSiteInfoUrl = commonService.APIBaseUrl + siteID +'/?pretty=1';
				
				var service = $http({method: 'GET', url: getSiteInfoUrl });
			
				service.success(function(data, status, headers, config){
					$scope.siteObject = { siteName: data.name, url: data.URL, siteID: data.ID };					
		   		});
		   		service.error(function(data, status, headers, config) {

		   		}); 
			};

		//-------------------------------- GET SiteInfo ENDS -----------------------------//

		/*	Description => The method fetching the comments for a given post
			Params => 1. postID : id of the post for which comments are to be fetched
		*/
		$scope.getCommentsforPost = function(postID){
		
			var getCommentsUrl = commonService.APIBaseUrl + $scope.api_siteID +'/posts/' + postID + '/replies/?number=100&pretty=1&order=ASC&hierarchical=true';
			var apiCaller = new APICaller('GET',getCommentsUrl, $scope.getComment_Success, $scope.getComment_Error);
			apiCaller.getResult();
		};
		
			$scope.getComment_Success = function(){
				if (this.readyState === 4 && this.status === 200) {
					$scope.commentsList = JSON.parse(this.response);
					$scope.$apply();
					NProgress.done();
					angular.forEach($scope.commentsList.comments,function(value,index){
						$scope.getCommentLikes(value.ID);
					});
				}
			};

			$scope.getComment_Error = function(){
				NProgress.done();
				$scope.toastMessage = "Problem loading comments for the post";
				$scope.postToast = true;
				$scope.$apply();
			};

		/*	Description => The method fetching the post information for a given post
			Params => 1. postID : id of the post for which comments are to be fetched
		*/
 		$scope.getSinglePost = function(postID){
			$scope.isOnline = navigator.onLine;
			if($scope.isOnline){
				var getSinglePostUrl = commonService.APIBaseUrl + $scope.api_siteID +'/posts/'+ postID+'?pretty=1';
				var apiCaller = new APICaller('GET',getSinglePostUrl, $scope.getSinglePost_Success, $scope.getSinglePost_Error);
				apiCaller.getResult();
			}
			else{
				$scope.toastMessage = "Unable to retrieve this post";
				$scope.postToast = true;
			}
		};
				
			$scope.getSinglePost_Success = function(){
				$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
				if (this.readyState === 4 && this.status === 200) {
					$scope.postData = JSON.parse(this.response);					
					// if($scope.postData.i_like == 1)
					// 	$scope.likeStatus = true;					
					$scope.getLikes($scope.postData.ID);
					$scope.getCommentsforPost($stateParams.postID);
					$scope.getReblogStatus();
					$scope.$apply();
				}
			};
			$scope.getSinglePost_Error = function(){
				$scope.toastMessage = "Problem loading post";
				$scope.postToast = true;
				$scope.$apply();
			};

		$scope.getReblogStatus = function(){
			var getReblogStatusUrl = commonService.APIBaseUrl + $scope.api_siteID +'/posts/'+ $scope.postData.ID +'/reblogs/mine';
			var apiCaller = new APICaller('GET',getReblogStatusUrl, $scope.getReblogStatus_Success, $scope.getReblogStatus_Error);
			apiCaller.getResult();
		};
		
			$scope.getReblogStatus_Success = function(){
				if (this.readyState === 4 && this.status === 200) {
					$scope.isReblogged = JSON.parse(this.response).is_reblogged;
					$scope.canReblog = JSON.parse(this.response).can_reblog;					
					$scope.$apply();
				}
			};
			
			$scope.getReblogStatus_Error = function () {
				/* $scope.toastMessage = "Could not retrieve reblog status";
				$scope.postToast = true;
				$scope.$apply(); */
			};
		
		$scope.reblogPost = function(){
			$scope.reblogging = true;
			var reblogPostUrl = commonService.APIBaseUrl + $scope.api_siteID +'/posts/'+ $scope.postData.ID +'/reblogs/new?pretty=1';
			var payload = commonService.reblogPost_payload($scope);
			var apiCaller = new APICaller('POST',reblogPostUrl, $scope.reblogPost_Success, $scope.reblogPost_Error, payload);
			apiCaller.getResult();
		};
		
			$scope.reblogPost_Success = function(){
				if (this.readyState === 4 && this.status === 200){
					$scope.reblogging = false;
					var reblogPostResponse = JSON.parse(this.response);
						if(reblogPostResponse.success){
							$scope.isReblogged = reblogPostResponse.is_reblogged;
							$scope.toastMessage = "Reblogged this post";
							$scope.postToast = true;
							$scope.reblogView = false;
						}
						else{
							$scope.toastMessage = "Couldn't reblog this post";
							$scope.postToast = true;
						}
						$scope.$apply();
				}
			};
			$scope.reblogPost_Error = function(){
				$scope.reblogging = false;
				if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
					$scope.toastMessage = "Couldn't reblog this post";
					$scope.postToast = true;
					$scope.$apply();
				}
			};
		
		/*	Description => The method adds a reply to the comment.
			Params => 1. commentID : id of the comment for which the reply is to be added.
		*/
		$scope.publishReplyComment = function(){	
			$scope.isOnline = navigator.onLine;
			//NProgress.start();
			if($scope.isOnline){
				var commentPostInput = $.trim(angular.element('#commentPostInput').val());
				if(commentPostInput.length !== 0){
					$scope.loading = true;
					var newCommentUrl = commonService.APIBaseUrl + $scope.api_siteID +'/comments/'+ $scope.replyToCommentId +'/replies/new';
					
					var payload = commonService.replyComment_payload($scope);
					var apiCaller = new APICaller('POST',newCommentUrl, $scope.replyComment_Success, $scope.replyComment_Error, payload);
					apiCaller.getResult();
					//var payload = 'content='+ encodeURIComponent($scope.textComment);
				}
				else{
					angular.element('#commentPostInput').val("");
				}
			}
			else{
				//NProgress.done();				
				$scope.toastMessage = "There is no network available";
				$scope.postToast = true;
			} 
		};
		
			$scope.replyComment_Success = function(){
				if (this.readyState === 4 && this.status === 200) {
					$scope.loading = false;
					$scope.toastMessage = "Reply published";
					$scope.postToast = true;
					//alert("Reply published.");
					$scope.textComment = "";
					$scope.showInput = !($scope.showInput);
					$scope.replyToCommentId = "";
					$scope.$apply();
					$scope.getCommentsforPost($stateParams.postID);
				}
			};
			
			$scope.replyComment_Error = function(){
				$scope.loading = false;
				$scope.toastMessage = "Comment couldn't be published";
				$scope.postToast = true;
			};

		/*	Description => The method adds a new comment for the post displayed on the screen.
			Params => 1. postID : id of the post for which the comment is being added.
		*/
		$scope.publishNewComment = function(postID){
			$scope.isOnline = navigator.onLine;
			//NProgress.start();
			if($scope.isOnline){
				var commentPostInput = $.trim(angular.element('#commentPostInput').val());
				if(commentPostInput.length !== 0){
					$scope.loading = true;
					var newCommentUrl = commonService.APIBaseUrl + $scope.api_siteID +'/posts/'+ postID +'/replies/new';
					
					var payload = commonService.replyComment_payload($scope);
					var apiCaller = new APICaller('POST',newCommentUrl, $scope.newComment_Success(postID), $scope.newComment_Error, payload);
					apiCaller.getResult();
					//var payload = 'content='+ encodeURIComponent($scope.textComment);
				}
				else{
					angular.element('#commentPostInput').val("");
				}
			}
			else{
				//NProgress.done();				
				$scope.toastMessage = "There is no network available";
				$scope.postToast = true;
			}
		};
		
			$scope.newComment_Success = function(postID){
				return function(){
					if (this.readyState === 4 && this.status === 200) {
						$scope.loading = false;
						$scope.toastMessage = "Comment added successfully";
						$scope.postToast = true;
						//alert("Comment added successfully!");
						$scope.textComment = "";
						$scope.showInput = !($scope.showInput);
						$scope.$apply();
						$scope.getCommentsforPost(postID);
					}
				};
			};
			
			$scope.newComment_Error = function(){
				$scope.loading = false;
				$scope.toastMessage = "Comment couldn't be published";
				$scope.postToast = true;
				$scope.$apply();
			};
		
		$scope.getFollowStatus = function(siteID){
			var getFollowStatusUrl = commonService.APIBaseUrl + siteID +'/follows/mine?pretty=1&fields=is_following';
			var apiCaller = new APICaller('GET',getFollowStatusUrl, $scope.getFollowStatus_Success(siteID), $scope.getFollowStatus_Error);
			apiCaller.getResult();
		};
		
			$scope.getFollowStatus_Success = function(siteID){
				return function(){
					if (this.readyState === 4 && this.status === 200) {						
						$scope.isFollowing[siteID] = JSON.parse(this.response).is_following;
						$scope.$apply();
					}
				};
			};
			
			$scope.getFollowStatus_Error = function () {
				/* $scope.toastMessage = "Could not retrieve follow status";
				$scope.postToast = true;
				$scope.$apply(); */
			};
		
		$scope.followBlog = function(siteID){
			var followBlogUrl = commonService.APIBaseUrl + siteID +'/follows/new?pretty=1';
			var apiCaller = new APICaller('POST',followBlogUrl, $scope.followBlogToggle_Success(siteID), $scope.followBlogToggle_Error);
			apiCaller.getResult();
		};		
		
		$scope.unfollowBlog = function(siteID){
			var unfollowBlogUrl = commonService.APIBaseUrl + siteID +'/follows/mine/delete?pretty=1';
			var apiCaller = new APICaller('POST',unfollowBlogUrl, $scope.followBlogToggle_Success(siteID), $scope.followBlogToggle_Error);
			apiCaller.getResult();
		};
		
			$scope.followBlogToggle_Success = function(siteID){
				return function(){
					if (this.readyState === 4 && this.status === 200) {
						var followResponse = JSON.parse(this.response);
						if(followResponse.success){
							$scope.isFollowing[siteID] = followResponse.is_following;
						}
						else{
							$scope.toastMessage = "Couldn't complete the action";
							$scope.postToast = true;
						}
						$scope.$apply();
					}
				};
			};
			
			$scope.followBlogToggle_Error = function(e){
				if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
					$scope.toastMessage = "Couldn't complete the action";
					$scope.postToast = true;
					$scope.$apply();
				}				
			};
		
		
		$scope.getLikes = function(postID){
			var getLikesUrl = commonService.APIBaseUrl +$scope.api_siteID+'/posts/'+postID+'/likes/?pretty=1';
			var apiCaller = new APICaller('GET',getLikesUrl, $scope.getLikes_Success, $scope.getLikes_Error);
			apiCaller.getResult();
		};
		
		/* $scope.getLikeStatus = function(postID){
			var getLikeStatusUrl = commonService.APIBaseUrl +$rootScope.authDetails.site_id+'/posts/'+postID+'/likes/mine/?pretty=1';
			var apiCaller = new APICaller('GET',getLikeStatusUrl, $scope.getLikeStatus_Success, $scope.getLikeStatus_Error);
			apiCaller.getResult();
		}; */
		
			$scope.getLikes_Success = function() {
				if (this.readyState === 4 && this.status === 200) {
					$scope.likesListData = JSON.parse(this.response);
					if($scope.postData.i_like == 1 || $scope.likesListData.i_like == true)
						$scope.likeStatus = true;
					else
						$scope.likeStatus = false;
					//$scope.likeStatus = $scope.likeStatus == true? true : $scope.likesListData.i_like;
					
					if($scope.likesListData.found == 1 && $scope.likeStatus){
						$scope.likePostText = "You like this";
					}
					else if($scope.likesListData.found == 1 && !$scope.likeStatus){
						$scope.likePostText = "One person likes this";
					}
					else if($scope.likesListData.found == 2 && $scope.likeStatus){
						$scope.likePostText = "You and one other like this";
					}
					else if($scope.likesListData.found > 2 && $scope.likeStatus){
						$scope.likePostText = "You and "+($scope.likesListData.found - 1)+ " others like this";
					}
					else if($scope.likesListData.found > 1 && !$scope.likeStatus){
						$scope.likePostText = $scope.likesListData.found + " people like this";
					}
					
					angular.forEach($scope.likesListData.likes,function(value,index){
					   $scope.getFollowStatus(value.site_ID);
					    value['newUrl'] = (value.URL).replace(/https?:\/\//,"");
					});
					
					$scope.$apply();
				}
			};
			$scope.getLikes_Error = function(e) {
				$log.log("Problem loading Posts likes!");
			};
			
		$scope.likeUnlikePost = function(){			
			$scope.showIconLoader = true;//show loader icon till the data gets loaded from API call
			if($scope.likeStatus == false){
				$scope.postData.i_like = 1;
				var likePostUrl = commonService.APIBaseUrl +$scope.api_siteID+'/posts/'+$scope.postData.ID+'/likes/new?pretty=1';
				
				var apiCaller = new APICaller('POST',likePostUrl, $scope.likeUnlikePost_Success, $scope.likeUnlikePost_Error);
				apiCaller.getResult();
			}
			else{
				$scope.postData.i_like = 0;
				var unlikePostUrl = commonService.APIBaseUrl +$scope.api_siteID+'/posts/'+$scope.postData.ID+'/likes/mine/delete?pretty=1';
				
				var apiCaller = new APICaller('POST',unlikePostUrl, $scope.likeUnlikePost_Success, $scope.likeUnlikePost_Error);
				apiCaller.getResult();
			}
		};
			$scope.likeUnlikePost_Success = function(){				
				$scope.showIconLoader = false;//remove loader icon when data gets loaded from API call 
				if (this.readyState === 4 && this.status === 200) {
					var likeResponse = JSON.parse(this.response);
					if(likeResponse.success){
						//$scope.likeStatus = likeResponse.i_like;
						$scope.getLikes($scope.postData.ID);
					}
					else{
						$scope.toastMessage = "Couldn't complete the action";
						$scope.postToast = true;
					}
					$scope.$apply();	
				}
			};
			$scope.likeUnlikePost_Error = function(e){				
				$scope.showIconLoader = false;//remove loader icon when data gets loaded from API call
				if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
					$scope.toastMessage = "Couldn't complete the action";
					$scope.postToast = true;
					$scope.$apply();
				}
			};
			
		$scope.getCommentLikes = function(commentID){
			var getCommentLikesUrl = commonService.APIBaseUrl +$scope.api_siteID+'/comments/'+commentID+'/likes/?pretty=1';
			var apiCaller = new APICaller('GET',getCommentLikesUrl, $scope.getCommentLikes_Success(commentID), $scope.getCommentLikes_Error);
			apiCaller.getResult();
		};
		
			$scope.getCommentLikes_Success = function(commentID){
				return function(){
					if (this.readyState === 4 && this.status === 200) {
						$scope.commentLikesData[commentID] = JSON.parse(this.response);
						$scope.commentLikeStatus[commentID] = $scope.commentLikesData[commentID].i_like;						
						
						angular.forEach($scope.commentLikesData[commentID].likes,function(value,index){
						    $scope.getFollowStatus(value.site_ID);
							value['newUrl'] = (value.URL).replace(/https?:\/\//,"");
						});
						$scope.$apply();
					}
				};
			};
			
			$scope.getCommentLikes_Error = function () {
				$log.log("Problem loading comment likes!");
			};
			
		
		$scope.likeUnlikeComment = function(commentID){
		
			if(!$scope.commentLikeStatus[commentID]){
				var likeCommentUrl = commonService.APIBaseUrl +$scope.api_siteID+'/comments/'+commentID+'/likes/new?pretty=1';
				var apiCaller = new APICaller('POST',likeCommentUrl, $scope.likeUnlikeComment_Success(commentID), $scope.likeUnlikeComment_Error);
				apiCaller.getResult();
			}
			
			else{
				var unlikeCommentUrl = commonService.APIBaseUrl +$scope.api_siteID+'/comments/'+commentID+'/likes/mine/delete?pretty=1';
				var apiCaller = new APICaller('POST',unlikeCommentUrl, $scope.likeUnlikeComment_Success(commentID), $scope.likeUnlikeComment_Error);
				apiCaller.getResult();
			}
			
		};
			
			$scope.likeUnlikeComment_Success = function(commentID){
				return function(){
					if (this.readyState === 4 && this.status === 200) {
						var likeCommentResponse = JSON.parse(this.response);
						if(likeCommentResponse.success){
							//$scope.commentLikeStatus[commentID] = likeCommentResponse.i_like;
							$scope.getCommentLikes(commentID);
						}
						else{
							$scope.toastMessage = "Couldn't complete the action";
							$scope.postToast = true;
						}
						$scope.$apply();
					}
				};
			};
			
			$scope.likeUnlikeComment_Error = function(e){
				if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
					$scope.toastMessage = "Couldn't complete the action. Internet issue";
					$scope.postToast = true;
					$scope.$apply();
				}
			};
		
	// ************************ Methods for API calls ends ***************************** //


	// ************************ Methods for view actions starts ***************************** //

		/* $scope.listOfLikes = function(){
			$scope.likeView = true;
		}; */
		/*	Description => The method navigates back to the previous screen			
		*/
		$scope.goBack = function(){
			NProgress.remove();
			if($scope.likeView){
				$scope.likeView = false;
				/* $scope.viewTitle = "Comments"; */
			}
			else if($scope.likeCommentView){
				$scope.likeCommentView = false;
				/* $scope.viewTitle = "Comments"; */
			}
			else if($scope.reblogView){
				$scope.reblogView = false;
				/* $scope.viewTitle = "Comments"; */
			}
			else if($stateParams.mainView == "notifications"){
				$state.go($stateParams.backTo, {id: $stateParams.id, backTo:$stateParams.mainView});
				/* $scope.viewTitle = "Notifications"; */
			}
			else if($stateParams.mainView == "noteInfo"){
				$state.go($stateParams.backTo, {id: $stateParams.id, backTo: $stateParams.mainView, hideFooter: $stateParams.hideFooter,backToNoteID: $stateParams.backToNoteID});				
			}
			else if($stateParams.backTo == "reader" || $stateParams.backTo == "readerSub"){
				var jsonObj = JSON.parse($stateParams.stringObject);
				if(jsonObj != null && jsonObj.viewScreen)
					$state.go($stateParams.backTo, jsonObj);
				else
					$state.go($stateParams.backTo, {itemObj: $stateParams.stringObject});
			}
			else if($stateParams.backTo == "previewBlog"){
				$state.go($stateParams.backTo, {itemObj: $stateParams.stringObject});
			}
			else
				$state.go($stateParams.backTo, {id: $stateParams.id});
			
		};

		$scope.shareURL = function(){
			var activity = "";
			activity = new MozActivity({
			  name: "share",
			  data: {
				type: "url",
				number: 1,
				url: $scope.postData.URL
			  }
			});

			activity.onsuccess = function() {
			  var success = this.result;
			};

			activity.onerror = function() {
			 // console.log(this.error);
			};
		};
		
		$scope.showCommentLikesList = function(commentID){
			$scope.likeListCommentID = commentID;
			$scope.likeCommentView = true;
		};
		
		$scope.showReblogView = function(){
			if(!$scope.isReblogged){
				//$scope.reblogView = true;
				/* $scope.viewTitle = "Reblog"; 
				:id:backTo:postID:mainView:site_ID:stringObject:viewScreen:postInfo*/
				$scope.postData['site_name'] = $scope.siteObject.siteName;
				//var item = JSON.stringify({id : $stateParams.id, siteID: $scope.api_siteID, backTo: $stateParams.backTo, postID: $scope.postData.ID, mainView: $stateParams.mainView, commentWithPostObj: true,  hideFooter: $stateParams.hideFooter, backToNoteID: $stateParams.backToNoteID, likeView: false});
				$stateParams.likeView = $scope.likeView;
				var item = JSON.stringify($stateParams);
				$state.go('readerSub', {backTo: 'commentsWithPost', viewScreen:'reblog', postInfo: JSON.stringify($scope.postData), stringObject: item});
			}
			else{
				$scope.toastMessage = "You already reblogged this post";
				$scope.postToast = true;
			}
		}
		
		$scope.goToPreviewBlog = function(likeObj){
			var url = commonService.APIBaseUrl + likeObj.site_ID + "/posts";
			//var url = commonService.APIBaseUrl + site_id + "/posts";
			//var item = JSON.stringify({previewFor: "site",id : $stateParams.id, backTo: $stateParams.backTo, postID: $scope.postData.ID, mainView: $stateParams.mainView, commentWithPostObj: true,  hideFooter: $stateParams.hideFooter, backToNoteID: $stateParams.backToNoteID, likeView: true, siteID: site_id});
			var stateParams = $stateParams;
			stateParams.previewFor = "site";
			stateParams.likeView = $scope.likeView;
			stateParams.title = $scope.viewTitle;
			stateParams.blogTitle = likeObj.name;
			stateParams.siteID = likeObj.site_ID;
			var item = JSON.stringify(stateParams);
			//$state.go('previewBlog', {backTo: "commentsWithPost", dataUrl: url, stringObject: item});
			$state.go("readerSub", {backTo: "commentsWithPost", viewScreen:"previewBlog", dataUrl: url, stringObject:item });
			
		};
		/*	Description => The method navigates to the viewSite screen which shows the post view 
			on the browser.
		*/
		/* $scope.viewSite = function(viewType, siteId, siteUrl, authorName){
			NProgress.remove();
			if(viewType == "site"){
				$state.go("viewSite", { id : $stateParams.id, backTo : $scope.currentView , 
					url: siteUrl, title: authorName, site_id:siteId, fullPostID:$scope.postData.ID ,fullPostBackTo: $stateParams.backTo});
			
			};
			//$state.go("viewSite", { id : $scope.postData.ID, backTo : $scope.currentView , 
					url: $scope.postData.URL, title: $scope.postData.title }); 
		};*/

		/*	Description => The method opnes a website view on browser window for the current post 			
		*/
		$scope.viewOnBrowser = function(){
			window.open($scope.postData.URL);
		};
		
		/* $scope.viewSite = function(siteUrl, siteId){
			NProgress.remove();
			
			var item = JSON.stringify( {id : $stateParams.id, backTo : $stateParams.backTo, postID: $scope.postData.ID, mainView: $stateParams.mainView, commentWithPostObj: true,  hideFooter: $stateParams.hideFooter, backToNoteID: $stateParams.backToNoteID, likeView: true} );
			
			$state.go("viewSite", {backTo: "commentsWithPost" ,url: siteUrl, title: '', site_id: siteId, stringObject: item});
		};
 */
		/*	Description => The method sets the view for reply on Comment or new comment for post.
			Params => 1)commentType : type of comment to be added (new/reply).
					2)commentID : id of the comment for which the reply has to be added.
		*/
		$scope.addComment = function(commentType, commentID){			
			$scope.showInput = !($scope.showInput);
			$scope.strPlaceholder =  commentType == "new"? "Add your comment" : "Reply to comment";
			$scope.replyToCommentId = commentID;
			$scope.commentType = commentType;
		};

		/*	Description => The method publishes the comment entered.
			Params => 1)commentType : type of comment to be added (new/reply).
		*/
		$scope.publishComment = function(){
			if ( $scope.textComment != "" ){
				if( $scope.commentType == "new" )
					$scope.publishNewComment($scope.postData.ID);
				else
					$scope.publishReplyComment();
			}
		};

		$scope.getCommentContent = function(content){
			return content.substring(0,content.lastIndexOf("</p>")) + '</p>';
		};

	// ************************ Methods for view actions ends ***************************** //


	// ****************** statements to be executed on controller init starts *********************** //
	if($stateParams.backTo == "reader" || $stateParams.backTo == "readerSub"){		
		$scope.api_siteID = $stateParams.site_ID;
		$scope.getSiteInfo($scope.api_siteID);
	}else{		
		$scope.api_siteID = $rootScope.authDetails.site_id;
		$scope.siteObject = localStorage.getItem('siteObject');
		$scope.siteObject = JSON.parse($scope.siteObject);
	}	

	$scope.getFollowStatus($scope.api_siteID);
	if ($scope.showCommentWithPostView)
		$scope.getSinglePost($stateParams.postID);
	// ****************** statements to be executed on controller init ends *********************** //

	};
	controllers.commentsWithPostController.$inject = ['$scope', '$http', '$log', '$state', '$stateParams', '$rootScope', '$filter', 'APICaller', 'commonService'];
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

