(function() {
	'use strict';
	
 	angular
		.module('wp-home', ['ngSanitize'])
	 	.controller('homeController',['$state', '$scope', '$http', '$location', '$log', '$rootScope', 'commonService', function($state, $scope, $http, $location, $log, $rootScope, commonService) {
			var init = function(){

				// ****************** initialization of variables starts *********************** //
					$rootScope.originPath = "app://wordpress-on-ff.com";

					if(localStorage.getItem('authDetailsObject') === null) {
						var obj = {},
							hashUrl = $location.hash(),
							urlParams = hashUrl.split('&');
						
						urlParams.map(function(item){  obj[item.split('=')[0]] = decodeURIComponent(item.split('=')[1]); return obj;  });
						
						localStorage.setItem('authDetailsObject', JSON.stringify(obj));
					}

					$rootScope.authDetails = localStorage.getItem('authDetailsObject');
					$rootScope.authDetails = JSON.parse($rootScope.authDetails);
				// ****************** initialization of variables ends *********************** //	

				// ************************ Methods for API calls and their response starts ***************************** //
				
					//-------------------------------- GET SiteInfo STARTS -----------------------//				
					/*	Description => The method gets the site info.
					*/
					$scope.getSiteInfo = function(){
						var getSiteInfoUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id+'/?pretty=1';
						
						var service = $http({method: 'GET', url: getSiteInfoUrl });
					
						service.success(function(data, status, headers, config){							
							$scope.siteObject = { siteName: data.name, url: data.URL, siteID: data.ID };
							localStorage.setItem('siteObject', JSON.stringify($scope.siteObject));
				   		});
				   		service.error(function(data, status, headers, config) {

				   		}); 
					};

				//-------------------------------- GET SiteInfo ENDS -----------------------------//

				// ************************ Methods for API calls and their response ends ***************************** //

				// ****************** statements to be executed on controller init : starts *********************** //
					if(!$rootScope.authDetails.site_id){
						localStorage.clear();
						var randomNum = new Date();
						window.location.href = "https://wordpress.com/wp-login.php?action=logout&redirect_to=https%3A%2F%2Fpublic-api.wordpress.com%2Foauth2%2Fauthorize%2F%3Fclient_id%3D35789%26redirect_uri%3Dhttp%253A%252F%252Fwordpress-on-ff%26response_type%3Dtoken%26jetpack-code%26jetpack-user-id%3D0%26action%3Doauth2-login&_wpnonce=33e410550d&randomNum";
					}
					else if($rootScope.authDetails.site_id == '0'){
						localStorage.clear();
						/* window.location.href = "https://public-api.wordpress.com/oauth2/authorize?client_id=35789&redirect_uri=http://wordpress-on-ff&response_type=token&randomNum"; */
						alert("Please select one of the site");
						 window.location.href = "https://public-api.wordpress.com/oauth2/authorize?client_id=35789&redirect_uri=http://wordpress-on-ff&response_type=token";
					}
					else{
						var viewName = localStorage.getItem('lastAccessedView');
						viewName = viewName == undefined? "reader" : viewName;						
						$state.go(viewName);
						$scope.getSiteInfo();
					}
				// ****************** statements to be executed on controller init : ends *********************** //
			};
			init();			
		}]);
})();

