(function() {
	'use strict';

	var controllers = {};

	/***	Media controller 	***/
	controllers.mediaController = function($scope, $http, $log, $state, $stateParams, $rootScope, $filter, $sce, APICaller, commonService) {
	// ****************** initialization of variables starts *********************** //
		$scope.$watch('mediaView', function(newValue, oldValue){
			if(newValue == true){
				//console.log("Changed to true");
				if($state.current.name == "newPost" || $state.current.name == "postInfo" || $state.current.name == "pageInfo"){
					/* if($state.current.name == "pageInfo")
						localStorage.setItem('lastAccessedView', 'pages');
					else
						localStorage.setItem('lastAccessedView', 'posts'); */
					$rootScope.newContent = "";
					$rootScope.newEditContent = "";
					$scope.init();
				}
			} 
			
		});
		$scope.init = function(){			
			$scope.viewTitle = "Media";
			if($state.current.name == "newPost" || $state.current.name == "postInfo"  || $state.current.name == "pageInfo"){				
				if($rootScope.mediaType == "createGallery"){
					$scope.viewTitle = "Create Gallery";
					$scope.fromPost = true;
					$scope.createGallery = true;
				}
				else if($rootScope.mediaType == "singleMedia"){
					$scope.viewTitle = "Select from media library";
					$scope.fromPost = true;
					$scope.createGallery = false;
					
				}
				$scope.backTo = $state.current.name;
				$scope.editGallery = false;
				$scope.gallerySettings = false;
				$scope.selectedMediaId = [];
			}
			else{
				localStorage.setItem('lastAccessedView', 'media');
			}
			
			
			$scope.currentMenu = "media";
			$scope.newImgSrc = "";
			$scope.mediaData = {};
			var newImageObj = {};
			var unattachCount;
			$scope.unAttachedData = {}, $scope.overlayObj = {};
			var allDataArray = [];
			var unattachDataArray = [];
			var imageDataArray = [];
			var customDateDataArray = [];
			var unattacharray;
			var itemSelected;
			$scope.isReload = false;
			$scope.allPageNo = $scope.unattachPageNo = $scope.imagesPageNo = $scope.customDatePageNo = 0;
			$scope.startDate = $filter("date")(Date.now(), 'yyyy-MM-dd');
			$scope.endDate = $filter("date")(Date.now(), 'yyyy-MM-dd');
			if($stateParams.searchText){
				$scope.searchText = $stateParams.searchText;
				angular.element("#srchText").val($stateParams.searchText);
				$scope.showTextBox = true;
			}
			
			if($stateParams.fromPost == 'true'){
				$scope.fromPost = true;
				if(!$stateParams.createGallery){
					$scope.viewTitle = "Select from media library";
				}
				else if($stateParams.createGallery == 'true'){
					$scope.createGallery = true;
					$scope.viewTitle = "Create Gallery";
				}
			}
			
			if($stateParams.backTo)
				$scope.backto = $stateParams.backTo;
				
			//console.log("$scope.fromPost", $scope.fromPost);
			//console.log("$scope.createGallery", $scope.createGallery);
			
			/* if($stateParams.selectedIds){
				var ids = $stateParams.selectedIds;
				console.log("ids", ids);
				if($stateParams.stateParams){
					console.log("if selected ids $stateParams.stateParams", $stateParams);
					$stateParams = JSON.parse($stateParams.stateParams);
					$stateParams.selectedIds = ids;
				}
			}

			if($stateParams.stateParams){
				console.log('if $stateParams.stateParams', $stateParams);
				$stateParams = JSON.parse($stateParams.stateParams);
			} */
			
			$scope.selectedMediaId = [], $scope.sortableMediaArray = [], $scope.noOfCols = [];

			$scope.showLoader = true;//show loader icon till the data gets loaded from API call 

			//$scope.itemSelected = "All";
			
		// ****************** initialization of variables ends *********************** //			

			// ************************ Methods for API calls and their response starts ***************************** //

				//-------------------------------- GET MEDIA LIBRARY STARTS ----------------------------------------//
				
				/*	Description => The method fetching the media library for the logged in user
				*/
				
				$scope.getMedia = function(){
					//itemSelected = localStorage.getItem('selectedMediaItem') ? localStorage.getItem('selectedMediaItem'):"All";
					$scope.multipleSelect = false;
					if($scope.fromPost == false){
						$scope.viewTitle = "Media";
					}
					$scope.selectedMediaId = [];
					$scope.isOnline = navigator.onLine;
					NProgress.start();
					if($scope.isOnline){
						var getMediaUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/media/?pretty=1&context=edit&number=100';/* &number=100 */
						var apiCaller = new APICaller('GET', getMediaUrl, $scope.getMedia_Success, $scope.getMedia_Error);
						apiCaller.getResult();
					}
					else{
						NProgress.done();
						$scope.toastMessage = "There is no network available";
						$scope.mediaToast = true;
					}
				};
				
					$scope.getMedia_Success = function(){
						$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
						if (this.readyState === 4 && this.status === 200) {
							unattacharray = [];
							unattachCount = 0;
							$scope.allMediaData = JSON.parse(this.response);							
							angular.forEach($scope.allMediaData.media,function(value,index){
								if(value['parent'] == 0){
									unattacharray.push(value);
									unattachCount = unattachCount + 1;
								}
								value['mime_type'] = value['link'].substring(value['link'].lastIndexOf('.') +1);
								if(value['metadata']['file'])
									value['fileName'] = value['metadata']['file'].substring(value['metadata']['file'].lastIndexOf('/') + 1, value['metadata']['file'].lastIndexOf('.'));
								else
									value['fileName'] = value['title'];
								value['attached'] = value['parent'] != 0;
							});
							$scope.unAttachedData['found'] = unattachCount;
							$scope.unAttachedData['media'] = unattacharray;
							//
							/* if(itemSelected == "All")
								$scope.showAll();
							else if(itemSelected == "Unattached")
								$scope.showUnattached(); */
							/* else if(itemSelected == "customDate")
								$scope.filterMediaByDate(); */
							if($scope.isReload == false){
								if($stateParams.currentView == "Unattached"){
									$scope.showUnattached();
								}
								if($stateParams.currentView == "Images"){
									$scope.showMediaImages();
								}
								else if($stateParams.currentView == "CustomDate"){
									$scope.startDate = $stateParams.startDate;
									$scope.endDate = $stateParams.endDate;
									$scope.filterMediaByDate($scope.startDate, $scope.endDate);
								}
								else if($stateParams.currentView == "Search"){
									if(!$scope.activeTab)
										$scope.activeTab = "all";
									$scope.searchText = $stateParams.searchText;									
									$scope.searchMedia();
								}
								else{
									$scope.showAll();
								}
							}
							else{								
								itemSelected = localStorage.getItem('selectedMediaItem');
								if(itemSelected == "All"){
									$scope.allPageNo = 0;
									$scope.showAll();
								}
								else if(itemSelected == "Images"){
									$scope.imagesPageNo = 0;
									$scope.showMediaImages();
								}
								else if(itemSelected == "Unattached"){
									$scope.unattachPageNo = 0;
									$scope.showUnattached();
								}
								else if(itemSelected == "CustomDate"){
									$scope.customDatePageNo = 0;
									$scope.filterMediaByDate($scope.startDate,$scope.endDate);
								}
								else if(itemSelected == "Search"){
									if(!$scope.activeTab)
										$scope.activeTab = "all";
									//$scope.showInput();
									$scope.searchMedia();
								}
							}
							
							if($stateParams.selectedIds){
								var idArray = $stateParams.selectedIds.split(',');
								angular.forEach(idArray,function(value,index){
									$scope.itemOnLongPress(value);
								});
								$scope.isLongPressed = false;
							}
								
							NProgress.done();
							$scope.$apply();
						}
					};
					$scope.getMedia_Error = function(){
						NProgress.done();	
						$scope.toastMessage = "Problem loading media library";
						$scope.mediaToast = true;
						$scope.$apply();
					};
				//-------------------------------- GET MEDIA LIBRARY ENDS ----------------------------------------//
			
				//-------------------------------- UPLOAD MEDIA FILE STARTS ----------------------------------------//
				
				/*	Description => The method uploading the media file for the logged in user
				*/
				$scope.uploadMedia = function(imageurl){
					var isOnline = navigator.onLine;
					if(isOnline){
						/* $scope.uploading = true;
						$scope.uploadStatus = "uploading";
						var uploadMediaUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/media/new?pretty=1&context=edit';
						
						var form = new FormData();
						form.append("media[]", imageBlob);
						form.append("media_urls[]", "");
						//var payload = 'content='+ encodeURIComponent($scope.replyComment);
						
						var xhr = new XMLHttpRequest({mozAnon:true, mozSystem: true});
						xhr.open('POST', uploadMediaUrl, true);
						xhr.onreadystatechange = function(e) {
							if (this.readyState === 4 && this.status === 200) {
								$scope.uploading = false;
								$scope.uploadStatus = "uploaded";								
								//$scope.getMedia();
								$scope.$apply();
							}
						};
						xhr.onerror = function () {
							$scope.uploading = false;
							$scope.uploadStatus = "retry";							
							$scope.toastMessage = "Upload failed!";
							$scope.mediaToast = true;
							$scope.$apply();
						};
						xhr.setRequestHeader("Authorization", "BEARER " +$rootScope.authDetails.access_token);
						xhr.setRequestHeader("Content-Type", "multipart/form-data");

						xhr.send(form); */
						   var wpcom = WPCOM($rootScope.authDetails.access_token);
						      var site = wpcom.site($rootScope.authDetails.site_id);
							  var media = site.media(null);
						  // var media = wpcom.Media(null, $rootScope.authDetails.site_id, WPCOM);
						   media.addFiles('https://i0.wp.com/duckpiedotcom.files.wordpress.com/2022/12/file0013.jpg',function(err, list){
						     console.log("media", list);
							 $scope.getMedia();
							 //alert("err", err);
						    });

						  /*  var tag = site.tag("Art & Design");
						   tag.add("Art & Design",function(err, list){
							console.log("tag", list);
						   }); */
					}
					else{
						$scope.uploading = false;
						$scope.uploadStatus = "retry";
						$scope.toastMessage = "Upload failed!";
						$scope.mediaToast = true;
					}
				
				};
				//-------------------------------- UPLOAD MEDIA FILE ENDS ----------------------------------------//
				
				//-------------------------------- DELETE MEDIA FILE STARTS ----------------------------------------//
				
				/*	Description => The method deletes the media file for the logged in user
				*/
				$scope.deleteMedia = function(){
					if($scope.selectedMediaId.length > 0){
						//$scope.showDelete = false;
						var deleteConfirm = confirm("Are you sure you want to delete these item(s)?");
						if (deleteConfirm) {
							var isOnline = navigator.onLine;
							if(isOnline){
								$scope.loaderMessage = "Deleting media file(s)";
								$scope.mediaLoader = true;
								/* var deleteMediaId = $scope.selectedMediaId[0];*/
								angular.forEach($scope.selectedMediaId,function(value,index){
									var deleteMediaUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/media/'+value+'/delete';
									var xhr = new XMLHttpRequest({mozAnon:true, mozSystem: true});
									xhr.open('POST', deleteMediaUrl, true);
									xhr.onreadystatechange = function(e) {
										if (this.readyState === 4 && this.status === 200) {											
											$scope.selectedMediaId.splice($scope.selectedMediaId.indexOf(value), 1);
											if($scope.selectedMediaId.length == 0){
												$scope.mediaLoader = false;
												$scope.multipleSelect = false;
												$scope.viewTitle = "Media";
												$scope.isReload = true;
												$scope.getMedia();
											}
										}
									};
									xhr.onerror = function () {										
									};
									xhr.setRequestHeader("Authorization", "BEARER " +$rootScope.authDetails.access_token);
									xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

									xhr.send();
								});
							}
							else{
								$scope.toastMessage = "There is no network available";
								$scope.mediaToast = true;
							}
							
						}
						
					}
					else
						console.log("No media Selected");
				};
				
					/* $scope.deleteMedia_Success = function(){
						if (this.readyState === 4 && this.status === 200) {
							$scope.mediaLoader = false;
							$scope.$apply();
							$scope.isReload = true;
							$scope.multipleSelect = false;
							$scope.getMedia();
						}
					};
					$scope.deleteMedia_Error = function(e){
						$scope.mediaLoader = false;
						if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
							$scope.toastMessage = "There is no network available";
							$scope.mediaToast = true;
						}
						$scope.$apply();
					}; */
					
				//-------------------------------- DELETE MEDIA FILE ENDS ----------------------------------------//
				
				//-------------------------------- PICK MEDIA USING MOZ ACTIVITY STARTS ----------------------------------------//
				
				/*	Description => The method for picking up a media file from gallery, or device camera
				*/
				$scope.addTolibrary = function(){
				
					var pickAny = new MozActivity({
						 name: "pick",
						  data: {
						  type: ["image/*","video/*"]
						   
						}
					 });

					pickAny.onsuccess = function () {
						$scope.mediaArray = [];
						if (this.result.blob.type.indexOf("image") != -1) {
							var Imgurl = window.URL.createObjectURL(this.result.blob);
							alert.log("Imgurl",Imgurl);
							newImageObj['link'] = window.URL.createObjectURL(this.result.blob);
							newImageObj['dynamicAttach'] = true;
							newImageObj['randomImg'] = $sce.trustAsHtml('<img src="'+newImageObj['link']+'"/>');
							newImageObj['isUploadItem'] = true;
							//newImageObj['title'] = 
							//newImageObj['randomImg'].src = window.URL.createObjectURL(this.result.blob);
							//newImageObj['id'] = Math.random();
							//$scope.imagedata = newImageObj;
							//$scope.imageUrl = newImageObj['link'];
							//$scope.mediaData['media'].push(newImageObj);
							//console.log("$scope.mediaData['media']", $scope.mediaData['media']);
						
							//console.log('newImageObj',newImageObj);
							//alert("newImgSrc", $scope.newImgSrc);
							//$scope.mediaArray.push(newImageObj['link']);
							//console.log("mediaArray to be uploaded", $scope.mediaArray);
							/*alert("$scope.mediaArray", $scope.mediaArray); */
							//$scope.randomImg = document.createElement("img");
							//$scope.randomImg.src = window.URL.createObjectURL(this.result.blob);
							//console.log("image tag", $scope.randomImg);
							//$scope.uploadMedia(Imgurl);
							$scope.$apply();
						}
					};

					pickAny.onerror = function () {

					};
					
					
				};
				//-------------------------------- PICK MEDIA USING MOZ ACTIVITY ENDS ----------------------------------------//
				
				/*	Description => The method to hide the menu section.
					Params => 1. event : event object.
				*/
				
				$scope.showAll = function(loadMore){
					//$scope.isReload = false;
					$scope.activeTab = "all";
					//$scope.itemSelected = "All";
					localStorage.setItem('selectedMediaItem','All');
					$scope.mediaData.found = $scope.allMediaData.found;
					if($scope.allPageNo == 0){
						allDataArray = [];
						$scope.mediaData['media'] = [];
					}
						
					$scope.currentCount = ($scope.allPageNo+1)*20;
					var start = $scope.allPageNo*20;
					var end = start+20;					
					var nextPageData = ($scope.allMediaData.media).slice(start, end);
					
					if(loadMore || $scope.allPageNo == 0)
						$.merge(allDataArray, nextPageData);
					$scope.mediaData['media'] = allDataArray;
					
					if($scope.showTextBox){
						$scope.showTextBox = false;
					}
					//$scope.listItemSelected = "All ("+$scope.mediaData.found+")";
				};
				
				$scope.showMediaImages = function(loadMore){
					//$scope.isReload = false;
					$scope.activeTab = "images";
					localStorage.setItem('selectedMediaItem','Images');
					$scope.mediaData.found = $scope.allMediaData.found;
					if($scope.imagesPageNo == 0){
						imageDataArray = [];
						$scope.mediaData['media'] = [];
					}
						
					$scope.currentCount = ($scope.imagesPageNo+1)*20;
					var start = $scope.imagesPageNo*20;
					var end = start+20;					
					var nextPageData = ($scope.allMediaData.media).slice(start, end);					
					if(loadMore || $scope.imagesPageNo == 0)
						$.merge(imageDataArray, nextPageData);
					$scope.mediaData['media'] = imageDataArray;					
					if($scope.showTextBox){
						$scope.showTextBox = false;
					}
					//$scope.listItemSelected = "Images ("+$scope.mediaData.found+")";
				};
				
				$scope.showUnattached = function(loadMore){
					//$scope.isReload = false;					
					$scope.activeTab = "unattached";
					localStorage.setItem('selectedMediaItem','Unattached');
					$scope.mediaData.found = $scope.unAttachedData.found;
					if($scope.unattachPageNo == 0){
						unattachDataArray = [];
						$scope.mediaData['media'] = [];
					}
					
					$scope.currentCount = ($scope.unattachPageNo+1)*20;
					var start = $scope.unattachPageNo*20;
					var end = start+20;
					
					var nextPageData = ($scope.unAttachedData.media).slice(start, end);
					
					if(loadMore || $scope.unattachPageNo == 0)
						$.merge(unattachDataArray, nextPageData);
					$scope.mediaData['media'] = unattachDataArray;
					
					if($scope.showTextBox){
						$scope.showTextBox = false;
					}
					//$scope.listItemSelected = "Unattached ("+$scope.mediaData.found+")";
					
				};
				
				$scope.showCustomDateView = function(){
					$scope.customDateView = true;
					//$scope.listItemSelected = "Custom Date...";
					$scope.viewTitle = "Custom Date...";
					if($scope.showTextBox){
						$scope.showTextBox = false;
					}
					
					/* $scope.startDate = new Date();
					$scope.endDate = new Date(); */
					/* angular.forEach($scope.allMediaData.media,function(value,index){
						value['date']
					
					}); */
				};
				
				$scope.filterMediaByDate = function(startDate, endDate, loadMore){
					//$scope.isReload = false;
					if(startDate != $scope.displayStartDate || endDate != $scope.displayEndDate)
						$scope.customDatePageNo = 0;
					$('#mediaTab').scrollLeft(1000);
					$scope.activeTab = "customDate";
					localStorage.setItem('selectedMediaItem','CustomDate');
					$scope.displayStartDate = startDate;
					$scope.displayEndDate = endDate;
					$scope.customDateView = false;
					$scope.viewTitle = "Media";
					//$scope.listItemSelected = "Custom Date...";
					$scope.originalDataArray = $filter('dateRange')($scope.allMediaData['media'], startDate, endDate);
					//customDateDataArray = [];
					if(startDate != $scope.displayStartDate || endDate != $scope.displayEndDate)
						$scope.customDatePageNo = 0;					
					
					$scope.mediaData.found = $scope.originalDataArray.found;
					if($scope.customDatePageNo == 0){
						customDateDataArray = [];
						$scope.mediaData['media'] = [];
					}
					
					$scope.currentCount = ($scope.customDatePageNo+1)*20;
					var start = $scope.customDatePageNo*20;
					var end = start+20;
					
					var nextPageData = ($scope.originalDataArray.media).slice(start, end);
					
					if(loadMore || $scope.customDatePageNo == 0)
						$.merge(customDateDataArray, nextPageData);
					$scope.mediaData['media'] = customDateDataArray;					
				};
				
				$scope.getMore = function (){
					if($scope.activeTab == 'all'){
						if( $scope.allPageNo >= 5 || ($scope.allPageNo*20 > $scope.allMediaData.found) ) 
							$scope.allPageNo = 0;
						else
							$scope.allPageNo++;				
						$scope.showAll('loadMore');
					}
					else if($scope.activeTab == 'unattached'){
						if( $scope.unattachPageNo >= 5 || ($scope.unattachPageNo*20 > $scope.unAttachedData.found) ) 
							$scope.unattachPageNo = 0;
						else
							$scope.unattachPageNo++;				
						$scope.showUnattached('loadMore');
					}
					else if($scope.activeTab == 'images'){
						if( $scope.imagesPageNo >= 5 || ($scope.imagesPageNo*20 > $scope.allMediaData.found) ) 
							$scope.imagesPageNo = 0;
						else
							$scope.imagesPageNo++;				
						$scope.showMediaImages('loadMore');
					}
					else if($scope.activeTab == 'customDate'){
						if( $scope.customDatePageNo >= 5 || ($scope.customDatePageNo*20 > $scope.allMediaData.found) ) 
							$scope.customDatePageNo = 0;
						else
							$scope.customDatePageNo++;				
						$scope.filterMediaByDate($scope.startDate, $scope.endDate, 'loadMore');
					}
				}
				
				$scope.showInput = function(){
					$scope.showTextBox = true;
					//angular.element("#srchText").focus();
				};
				
				$scope.resetText = function(){
					var searchValue = angular.element("#srchText").val();					
					if(searchValue == '')
						$scope.showTextBox = false;
					else{
						$scope.searchText = '';
						angular.element('#srchText').val("");
						//$scope.getMedia();
						//$scope.searchMedia($scope.searchText);
						if(localStorage.getItem('selectedMediaItem') != 'CustomDate'){
							$scope.mediaData = $scope.allMediaData;
							//$scope.getMedia();
						}
						else if(localStorage.getItem('selectedMediaItem') == 'CustomDate' && $scope.mediaData['found'] == 0){
							$scope.mediaData['found'] = 0;
							$scope.mediaData['media'] = [];
						}
					}
						
				};
				$scope.searchMedia = function(){
					var searchValue = angular.element("#srchText").val();
					var mediaArr = [];
					var searchText;
					var itemSelected = localStorage.getItem('selectedMediaItem');
					var searchCondition;
					$scope.searchResults = {};
					if ($.trim(searchValue) !== '')
						searchText = (searchValue).toLowerCase();
					else
						searchText = searchValue;
						
					if($scope.mediaData && itemSelected == 'CustomDate'){
						searchCondition = searchText != '' && $scope.mediaData['found']!= 0;
					}
					else{
						searchCondition = searchText != '';
					}
					if(searchCondition){
						//$scope.isReload = false;
						localStorage.setItem('selectedMediaItem','Search');
						angular.forEach($scope.allMediaData.media,function(value,index){
							var mediaTitle = value['title'].toLowerCase();
							if(mediaTitle.indexOf(searchText) != -1){
								mediaArr.push(value);
							}
						});
						$scope.searchResults['found'] = mediaArr.length;
						$scope.searchResults['media'] = mediaArr;
						$scope.mediaData = $scope.searchResults;
					}
					
					else if(searchText == '' && itemSelected != 'CustomDate'){						
						$scope.searchText = '';
						angular.element('#srchText').value = "";
						$scope.mediaData = $scope.allMediaData;
						//$scope.getMedia();
					}
					else if(searchText == '' && itemSelected == 'CustomDate' && $scope.mediaData['found'] == 0){						
						$scope.searchText = '';
						angular.element('#srchText').value = "";
						$scope.mediaData['found'] = 0;
						$scope.mediaData['media'] = [];
					}
				};
				$scope.goBack = function(){
					if($scope.customDateView){
						$scope.customDateView = false;
						$scope.viewTitle = "Media";
						if($scope.displayStartDate && $scope.displayEndDate){
							$scope.startDate = $scope.displayStartDate;
							$scope.endDate = $scope.displayEndDate;
						}
						/* var selectedItem = localStorage.getItem('selectedMediaItem');
						if(selectedItem == "All"){
							$scope.showMediaImages();
						}
						else if(selectedItem == "Unattached"){
							$scope.showUnattached();
						} */
					}
					else if($scope.editGallery){
						if($scope.gallerySettings){
							$scope.gallerySettings = false;
						}
						else{
							if($scope.randomImgOrder){
								$scope.randomImgOrder = false;
							}
							$scope.selectedType = 'grid';
							//$scope.noOfCols = "3";
							$scope.editGallery = false;
							$scope.addMore = false;
							$scope.sortableMediaArray = [];
							$scope.viewTitle = $scope.selectedMediaId.length+" selected";
						}
					}
					else if($scope.fromPost){
						if($scope.backTo == "postInfo" || $scope.backTo == "pageInfo"){
							//$state.go("postInfo", {id: $stateParams.postId, editState: true});
							$rootScope.mediaView = false;
						}
						else if($scope.backTo == "newPost"){
							$rootScope.mediaView = false;
							//$state.go("newPost", {fromPost: $stateParams.fromPost, stateParams: $stateParams.stateParams});
						}
					}
				};
				
				$scope.addMoreImages = function(){
					$scope.addMore = true;
					$scope.editGallery = false;
					$scope.sortableMediaArray = [];
					$scope.viewTitle = $scope.selectedMediaId.length+" selected";
				};
				
				$scope.goToEditGallery = function(addmore){
					$scope.editGallery = true;
					$scope.viewTitle = "Edit gallery";					
					//$scope.sortableMediaArray = [];
					angular.forEach($scope.selectedMediaId,function(value,index){
						var mediaId = value;
						angular.forEach($scope.allMediaData.media,function(value,index){
							if(mediaId == value.id){
								$scope.sortableMediaArray.push(value);
							}
						});
					});
					$scope.imgOrder = $scope.selectedMediaId.join();
					if(!addmore){
						$scope.selectedType = 'grid';
						//$scope.noOfCols = 3;
						$scope.selectedCol = 3;
						for(var i=1 ; i<=9; i++){
							if(i<=3)
								$scope.noOfCols[i] = true;
							else
								$scope.noOfCols[i] = false;
						}
						/* $scope.changeCols(3); */
					}					
				};
				
				$scope.sortableOptions = {
					accept: function (sourceItemHandleScope, destSortableScope) {
						return sourceItemHandleScope.itemScope.sortableScope.$id === destSortableScope.$id;
					},
					scrollableContainer: '#sortable-container',
					itemMoved: function (event) {console.log("ItemMoved");},
					orderChanged: function(event){						
						$scope.selectedMediaId = [];
						angular.forEach($scope.sortableMediaArray,function(value,index){
							$scope.selectedMediaId.push(value.id);
						});
						$scope.imgOrder = $scope.selectedMediaId.join();						
					},
					dragStart: function(event){
						$("#sortItem_"+event.source.itemScope.item.id).addClass("grayBack");
					},
					dragEnd: function(event){
						$("#sortItem_"+event.source.itemScope.item.id).removeClass("grayBack");
					},
					containment: '#sortable-container'//optional param.
				};
				
				$scope.reverseImgOrder = function(){					
					$scope.sortableMediaArray.reverse();
					$scope.selectedMediaId.reverse();
					$scope.imgOrder = $scope.selectedMediaId.join();					
				};
				
				$scope.changeType = function(type){
					$scope.selectedType = type;					
					if($scope.selectedType == 'grid')
						$scope.changeCols($scope.selectedCol);
				};
				
				$scope.changeCols = function(noOfcols){
					$scope.selectedCol = noOfcols;					
					//$scope.noOfCols = noOfcols;
					for(var i=1; i<=9; i++){
						if(i <= noOfcols){
							$scope.noOfCols[i] = true;
						}
						else
							$scope.noOfCols[i] = false;
						/* var isDefaultSelect = $('#noOfcol_'+ i).hasClass("defaultSelected");
						if(i <= noOfcols){
							if(!isDefaultSelect){
								console.log("Add class", i);
								$('#noOfcol_'+ i).addClass("defaultSelected");
								console.log("Added class", i);
							}
						}
						else{
							if(isDefaultSelect)
								$('#noOfcol_'+ i).removeClass("defaultSelected");
						} */
					}
				};
				
				$scope.changeBgColor = function(id){
					$('#sortItem_'+id).css("background-color","#C2FFFF");
					$('#sortItem_'+id).css("opacity","0.7");
				};
				
				$scope.changeRandomState = function(){
					$scope.randomImgOrder = !($scope.randomImgOrder);
				
				};
				
				$scope.showDeleteDialog = function(deleteId){
					/* $('#sortItem_'+deleteId).css("background-color","#fff");
					$('#sortItem_'+deleteId).css("opacity",""); */
					//console.log("Long pressed, " ,deleteId);
					$scope.deleteItemId = deleteId;
					$scope.deleteDialog = true;
				};
				
				$scope.deleteSortItem = function(){					
					angular.forEach($scope.sortableMediaArray,function(value,index){
						//$scope.selectedMediaId.push(value.id);
						if(value.id == $scope.deleteItemId){
							$scope.sortableMediaArray.splice($scope.sortableMediaArray.indexOf(value), 1);
						}
					});
					angular.forEach($scope.selectedMediaId,function(value,index){
						//$scope.selectedMediaId.push(value.id);
						if(value == $scope.deleteItemId){
							//$('#'+value).removeClass("overlayOpacity");
							$scope.overlayObj[value] = false;
							$scope.selectedMediaId.splice($scope.selectedMediaId.indexOf(value), 1);
						}
					});
					$scope.imgOrder = $scope.selectedMediaId.join();
					$scope.deleteDialog = false;
				};
				
				$scope.showGallerySettings = function(){
					//console.log("$scope.selectedMediaId", $scope.selectedMediaId);
					//$scope.imgOrder = $scope.selectedMediaId.join();
					
					/* console.log("imgOrder", imgOrder);
					$scope.settingsObject = {
						imageOrder: imgOrder,
						type:"",
						noOfCols:""
					}; */
					$scope.gallerySettings = true;
					/* if($scope.selectedType = 'grid')
						$scope.changeCols($scope.noOfCols); */
				};
				
				$scope.saveSelection = function(){
					if($scope.selectedType != 'grid')
						$scope.createGalleryString = '[gallery type="'+$scope.selectedType+'" ids="'+$scope.imgOrder+'"]';
					else
						$scope.createGalleryString = '[gallery columns="'+$scope.selectedCol+'" ids="'+$scope.imgOrder+'"]';
						
					
					if(!$scope.createGallery){
						var itemSelected = localStorage.getItem('selectedMediaItem');
						/* if($stateParams.currentView)
							var stateParamsObj = JSON.stringify($stateParams); */
							
						$rootScope.newContent = $scope.createGalleryString;
						
						$state.go("newPost", {type:"post", backTo:"media", content:$scope.createGalleryString, parentView:"media", selectedMedia:$scope.imgOrder, currentView:itemSelected, startDate:$scope.startDate, endDate:$scope.endDate});
					}
					else{
						if($scope.backTo == "postInfo" || $scope.backTo == "pageInfo"){
							//$state.go("postInfo", {id: $stateParams.postId, editState: true, content:$scope.createGalleryString});
							$rootScope.newEditContent = $scope.createGalleryString;
							$rootScope.mediaView = false;
						}
						else if($scope.backTo == "newPost"){
							//$state.go("newPost", {fromPost: $stateParams.fromPost, stateParams: $stateParams.stateParams, content:$scope.createGalleryString, originalContent: $stateParams.content, title: $stateParams.title});
							$rootScope.newContent = $scope.createGalleryString;
							$rootScope.mediaView = false;
							
						}
					}
				};
				
				$scope.attactImage = function(){					
					var itemSelected = localStorage.getItem('selectedMediaItem');
					var imageInfo = {};					
					$scope.imgOrder = $scope.selectedMediaId.join();
					angular.forEach($scope.allMediaData.media,function(value,index){
						if($scope.selectedMediaId[0] == value.id){
							imageInfo = value;
						}
					});
					
					$scope.attactImageString = $scope.createAttachString(imageInfo);
					$rootScope.newContent = $scope.attactImageString;
					$state.go("newPost", {type:"post", backTo:"media", content:$scope.attactImageString, parentView:"media", selectedMedia:$scope.imgOrder, currentView:itemSelected, startDate:$scope.startDate, endDate:$scope.endDate, imageDetails:JSON.stringify(imageInfo)});
					
				};
				
				$scope.createAttachString = function(mediaItem){
					if(mediaItem.metadata.width > 2000)
						mediaItem.metadata.width = 2000;
					else if(mediaItem.metadata.width < 10)
						mediaItem.metadata.width = 10;
					if(mediaItem.caption !== ""){
						
						return '<div id="container_'+mediaItem.id+'" class="outerContanier">[caption id="" align="alignnone" width="'+mediaItem.metadata.width+'" caption="'+mediaItem.caption+'"]<div class="imageContainer"  ng-click="editImgDetails('+mediaItem.id+')"><img id="img_'+mediaItem.id+'" class="alignnone size-full" title="'+mediaItem.title+'" alt="image" src="'+mediaItem.link+'?w='+mediaItem.metadata.width+'" caption="'+mediaItem.caption+'"/><span class="editimage"><img src="/assets/img/edit-image.png"/></span></div>[/caption]</div></br>&nbsp;';
					}
					else{
						//$scope.nonEditContent = '<div class="imageContainer" ng-click="editImgDetails('+mediaItem.id+')"><img id="img_'+mediaItem.id+'" class="alignnone size-full" title="'+mediaItem.title+'" alt="image" src="'+mediaItem.link+'?w='+mediaItem.metadata.width+'" caption="'+mediaItem.caption+'"/><span class="editimage"><img src="/assets/img/edit-image.png"/></span></div>';
						
						return '<div id="container_'+mediaItem.id+'" class="outerContanier"><div class="imageContainer" ng-click="editImgDetails('+mediaItem.id+')"><img id="img_'+mediaItem.id+'" class="alignnone size-full" title="'+mediaItem.title+'" alt="image" src="'+mediaItem.link+'?w='+mediaItem.metadata.width+'" caption="'+mediaItem.caption+'"/><span class="editimage"><img src="/assets/img/edit-image.png"/></span></div></div></br>&nbsp;';
					}
				};
				
				$scope.goToMediaInfo = function(mediaItem){					
					/* if(itemSelected == "CustomDate") */
					if(!($scope.multipleSelect || $scope.isLongPressed || $scope.fromPost) ){						
						var itemSelected = localStorage.getItem('selectedMediaItem');
						$state.go("mediaInfo", {data: JSON.stringify(mediaItem), calledFromView: itemSelected , startDate: $scope.startDate, endDate:$scope.endDate, searchText: $scope.searchText});
					}
					else{
						if((!$scope.isLongPressed && !$scope.fromPost) || ($scope.fromPost && $scope.createGallery)){							
							//var isSelected = $('#'+mediaItem.id).hasClass("overlayOpacity");/* .removeClass("overlayOpacity") */
							$scope.multipleSelect = true;
							var isSelected = $scope.overlayObj[mediaItem.id];							
							if(isSelected){								
								//$('#'+mediaItem.id).removeClass("overlayOpacity");
								$scope.overlayObj[mediaItem.id] = false;
								$scope.selectedMediaId.splice($scope.selectedMediaId.indexOf(mediaItem.id), 1);
								if($scope.selectedMediaId.length == 0){
									$scope.multipleSelect = false;
									if(!$scope.isLongPressed && !$scope.fromPost)
										$scope.viewTitle = "Media";
									else
										$scope.viewTitle = "Create Gallery";
								}
								else
									$scope.viewTitle = $scope.selectedMediaId.length+" selected";
							}
							else{								
								//$('#'+mediaItem.id).addClass("overlayOpacity");
								$scope.overlayObj[mediaItem.id] = true;
								if($scope.selectedMediaId.indexOf(mediaItem.id) == -1)
									$scope.selectedMediaId.push(mediaItem.id);
								$scope.viewTitle = $scope.selectedMediaId.length+" selected";
							}
						}
						else if($scope.fromPost && !$scope.createGallery){							
							$scope.attactImageString = $scope.createAttachString(mediaItem);							
							if($scope.backTo == 'newPost'){
								//var stateParam = JSON.parse($stateParams.stateParams);
								
								$rootScope.mediaView = false;
								$stateParams.imageDetails = JSON.stringify(mediaItem);
								$rootScope.newContent = $scope.attactImageString;
								
								//$state.go("newPost", {stateParams:$stateParams.stateParams, content:$scope.attactImageString, imageDetails:JSON.stringify(mediaItem), originalContent:$stateParams.content});
							}
							else if($scope.backTo == 'postInfo' || $scope.backTo == "pageInfo"){
								//$state.go("postInfo", {id:$stateParams.postId,  content:$scope.attactImageString, imageDetails:JSON.stringify(mediaItem), editState: true});
								$rootScope.newEditContent = $scope.attactImageString;
								$rootScope.mediaView = false;
								$stateParams.imageDetails = JSON.stringify(mediaItem);
								
							}
						}
					}
					$scope.isLongPressed = false;	
					/* else
						$state.go("mediaInfo", {data: JSON.stringify(mediaItem), calledFromView: itemSelected}); */
				};
				
				$scope.itemOnLongPress = function(id) {					
					$scope.isLongPressed = true;
					if($scope.selectedMediaId.indexOf(id) == -1)
						$scope.selectedMediaId.push(id);
					
					$scope.multipleSelect = true;
					$scope.viewTitle = $scope.selectedMediaId.length+" selected";
					$scope.overlayObj[id] = true;
					
					//$('#'+id).addClass("overlayOpacity");
					/* event.preventDefault();
					event.stopPropagation(); */
				};

				$scope.itemOnTouchEnd = function(id) {
					//$scope.isLongPressed = false;
				};
				
				$scope.deselectAll = function(){
					if($scope.addMore){
						$scope.goToEditGallery("addMore");
					}
					else if($scope.createGallery){
						$scope.goToEditGallery();
					}
					else{
						$scope.multipleSelect = false;
						$scope.viewTitle = "Media";
						angular.forEach($scope.selectedMediaId,function(value,index){
							//$('#'+value).removeClass("overlayOpacity");
							$scope.overlayObj[value] = false;
						});
						$scope.selectedMediaId = [];
						//$scope.overlayObj = {};
					}
				};
				
				$scope.hideMenu = function(event){
					if($scope.showDrawer === true){
						if ( event.target.className.indexOf( 'drawerIcon' ) == -1 )
							$scope.showDrawer = false;
					}
				};
				
				$scope.onReload = function(){
					$scope.isReload = true;
					$scope.overlayObj = {};
					$stateParams.selectedIds = "";
					$scope.getMedia();
				};
				
				$scope.getMedia();
			}
			$scope.init();
			
	};
	controllers.mediaController.$inject = ['$scope', '$http', '$log', '$state', '$stateParams', '$rootScope', '$filter', '$sce', 'APICaller', 'commonService'];
	/***	Note Info controller 	***/

	controllers.mediaInfoController = function($scope, $http, $log, $state, $stateParams, $rootScope, $filter, APICaller, commonService){
			// ****************** initialization of variables starts *********************** //	
			localStorage.setItem('lastAccessedView', 'media');
			NProgress.remove();
			$scope.editDetails = false;
			
		// ****************** initialization of variables ends *********************** //			

		// ************************ Methods for API calls and their response starts ***************************** //

			//-------------------------------- GET SINGLE NOTIFICATION STARTS ----------------------------------------//
			
			/*	Description => The method fetching the single notification for the logged in user
			*/
			$scope.getMediaInfo = function(){
				NProgress.start();
				$scope.mediaInfoData = JSON.parse($stateParams.data);
				NProgress.done();
				/* $scope.isOnline = navigator.onLine;
				NProgress.start();
				if($scope.isOnline){
					var getMediaInfoUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id+'/media/'+mediaID+'?pretty=1&context=edit';
					var apiCaller = new APICaller('GET', getMediaInfoUrl, $scope.getMediaInfo_Success, $scope.getMediaInfo_Error);
					apiCaller.getResult();
				}
				else{
					NProgress.done();
					$scope.toastMessage = "There is no network available";
					$scope.mediaToast = true;
				} */
			};
				/* $scope.getMediaInfo_Success = function(){
					if (this.readyState === 4 && this.status === 200) {
						$scope.mediaInfoData = JSON.parse(this.response);
						console.log("Media:", $scope.mediaInfoData);
						$scope.mediaInfoData['mime_type'] = $stateParams.mimeType;
						/* var startIndex = $scope.mediaInfoData['metadata']['file'].lastIndexOf('/') + 1;
						var endIndex = $scope.mediaInfoData['metadata']['file'].lastIndexOf('.'); 
						$scope.mediaInfoData['fileName'] = $stateParams.fileName; /* $scope.mediaInfoData['metadata']['file'].substring(startIndex, endIndex) 
						console.log("$scope.mediaInfoData['fileName']",$scope.mediaInfoData['fileName']);
						$scope.$apply();
						NProgress.done();
					}
				};
				$scope.getMediaInfo_Error = function(){
					NProgress.done();	
					$scope.toastMessage = "Problem loading media details";
					$scope.mediaToast = true;
					$scope.$apply();
				}; */
				
		$scope.udpateMedia = function(mediaID){
			if($scope.mediaInfoData['title'] !== '' && $scope.mediaInfoData['caption'] !== '' &&  $scope.mediaInfoData['caption'] !== ''){
				$scope.loading = true;
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					var updateMediaUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id+'/media/'+mediaID;
					var payload = commonService.updateMedia_payload($scope);
					var apiCaller = new APICaller('POST', updateMediaUrl, $scope.updateMedia_Success, $scope.updateMedia_Error, payload);
					apiCaller.getResult();
				}
				else{
					NProgress.done();
					$scope.loading = false;
					$scope.toastMessage = "There is no network available";
					$scope.mediaToast = true;
				}
				
			}
			else{
				$scope.toastMessage = "All fields are required";
				$scope.mediaToast = true;
			}
			
		};
		
			$scope.updateMedia_Success = function(){
				if (this.readyState === 4 && this.status === 200) {					
					NProgress.done();	
					$scope.loading = false;
					$scope.toastMessage = "Updated";
					$scope.mediaToast = true;
					$scope.editDetails = false;
					//$scope.getMediaInfo($stateParams.id);
					$scope.$apply();
				}
			};
			
			$scope.updateMedia_Error = function(){
				NProgress.done();	
				$scope.loading = false;
				$scope.toastMessage = "Problem Updating media details";
				$scope.mediaToast = true;
				$scope.$apply();
			};
		
		$scope.editDetailsView = function(){
			$scope.editDetails = true;
		};
		$scope.goBack = function(){
			if($scope.editDetails){
				$scope.editDetails = false;
				$scope.getMediaInfo();
			}
			else
				/* if($stateParams.calledFromView == "CustomDate") */
					$state.go('media',{currentView: $stateParams.calledFromView, startDate: $stateParams.startDate, endDate:$stateParams.endDate, searchText:$stateParams.searchText});
				/* else if($stateParams.calledFromView == "Search")
					$state.go('media',{currentView : $stateParams.calledFromView, searchText:});
				else
					$state.go('media',{currentView: $stateParams.calledFromView}); */
		};
			$scope.getMediaInfo();
	};
	controllers.mediaInfoController.$inject = ['$scope', '$http', '$log', '$state', '$stateParams', '$rootScope', '$filter', 'APICaller', 'commonService'];
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

