(function() {
	'use strict';

	var controllers = {};


	controllers.newPostController = function($scope, $http, $log, $state, $stateParams, $timeout, $rootScope, $filter, $window, commonService, APICaller, CommonScope) {

		// ****************** initialization of variables starts *********************** //	
		$scope.$watch('mediaView', function(newValue, oldValue){
			if(newValue == false){				
				$timeout(function(){
					var postContent = $.trim(angular.element('#postBox').text());
					var postHtml = $.trim(angular.element('#postBox').html());
					if( postContent.length == 0 || postHtml.indexOf('<img') == -1 ){						
						$rootScope.cursorPos = {};
					}
				},200);
					$scope.init();
				
			} 
			
		});
		NProgress.remove();		
		$rootScope.mediaView = false;
		//localStorage.setItem('lastAccessedView', $stateParams.backTo);
		$scope.currentView = "newPost";
		if( localStorage.getItem('settingsLocalData') ){
			$scope.settingsLocalData = JSON.parse( localStorage.getItem('settingsLocalData') );

			if($scope.settingsLocalData.vibrate && $scope.settingsLocalData.vibrate == true)
				window.navigator.vibrate([200, 100, 200]);
			else
				window.navigator.vibrate(0);

			//playSound vibrate, blinkLight
		}

		$scope.immediatePublish = true;
		$scope.password = $scope.excerpt = $scope.tags = $scope.date = $scope.content = $scope.title = "";		
		$scope.status = "publish";
		$scope.format = "standard";
		$scope.imageDetails = {};

		$scope.categIdList = $scope.formatedDate = $scope.catDesc = $scope.catSlug = $scope.catName = "";

		$scope.catParentSelected = { ID:0, name:"None" };
		$scope.showCustomSelectDiv = false;
		$scope.categories = {};
		var imageSettings = {};
		$scope.siteObject = localStorage.getItem('siteObject');
		$scope.siteObject = JSON.parse($scope.siteObject);
		$scope.showPlaceholder = true;
		$scope.featuredList = "";
		//$stateParams.imagedetails = {};
		$scope.init = function(){
			if($stateParams.imageDetails){
				var imageInfo = JSON.parse($stateParams.imageDetails);
				//$stateParams.imagedetails[imageInfo.id] = imageInfo;
				$scope.currentImageInfo = imageInfo;
				$scope.imageDetails[imageInfo.id] = imageInfo;
			}
		}
		if($stateParams.content){			
			$scope.showPlaceholder = false;
			//$('#postBox').html($stateParams.content);
			$scope.content = $stateParams.content;
			
			/* $('#postBox').focus();
			$scope.showPlaceholder = false;
			document.execCommand("insertHTML", false, $stateParams.content); */
			if($scope.currentImageInfo){
				$('.newPost #postBox .imageContainer').css("width",$scope.currentImageInfo.metadata.width+"px");
				
				$('.newPost #postBox .imageContainer > img').css("width",$scope.currentImageInfo.metadata.width+"px");
			}
		}
		/* if($rootScope.newContent){
			console.log("condition 2");
			$scope.addMediaToPost = false;
			if($rootScope.cursorPos){
				commonService.restoreSelection(angular.element("#postBox")[0], $rootScope.cursorPos);
				document.execCommand("insertHTML", false, $rootScope.newContent);
			}
			else{
				$scope.content = $rootScope.newContent;
			}
		} */
		
		$scope.$watch('newContent', function(newValue, oldValue){			
			if(newValue !== ''){
				$scope.addMediaToPost = false;
				
				try{
					var postContent = $.trim(angular.element('#postBox').text());
					var postHtml = $.trim(angular.element('#postBox').html());
					if($rootScope.cursorPos && (postContent.length !== 0 || postHtml.indexOf('<img') != -1)){
						commonService.restoreSelection(angular.element("#postBox")[0], $rootScope.cursorPos);
						document.execCommand("insertHTML", false, $rootScope.newContent);
						//$scope.focusOnField();
						$timeout(function(){
							$scope.focusOnField();
						}, 100);
					}
					else{
						$scope.content = $rootScope.newContent;
					}
					$scope.showPlaceholder = false;
					//$rootScope.newContent = "";
					
				}
				catch(err){
					console.log("err", err);
					/* $scope.toastMessage = "Could not retieve the media";
					$scope.postToast = true; */
				}
			}
		});
		
		
		/* if($stateParams.stateParams && !$stateParams.content){
			/* if($stateParams.stateParams) 
				console.log("condition 2");
				$stateParams = JSON.parse($stateParams.stateParams);
		}
		if($stateParams.stateParams && $stateParams.content){
			/* if($stateParams.stateParams) 
			console.log("Condition 3");
			var stateparam = JSON.parse($stateParams.stateParams);
			var newContent = $stateParams.content;
			var originalContent = $stateParams.originalContent;
			var title = $stateParams.title;
			var imageDetails = $stateParams.imageDetails;
			$stateParams = stateparam;
			$stateParams.content = newContent;
			$stateParams.originalContent = originalContent;
			$stateParams.title = title;
			
			console.log("got content", $stateParams.content);
			//console.log("$stateParams.cursorPos", $stateParams.cursorPos);
			/* if($rootScope.cursorPos){
				($rootScope.cursorPos).insertNode($(content));
			} 
			/* $('#postBox').focus();
			$scope.showPlaceholder = false;
			document.execCommand("insertHTML", false, $stateParams.content);  
			
			
			$scope.showPlaceholder = false;
			//$('#postBox').html($stateParams.content);
			$scope.content = $stateParams.originalContent;
			$scope.title = $stateParams.title;
			console.log('$rootScope.cursorPos', $rootScope.cursorPos);
			console.log("element",angular.element("#postBox"));
			$timeout( function(){
				commonService.restoreSelection(angular.element("#postBox")[0], $rootScope.cursorPos);
			},800);
			//document.execCommand("insertHTML", false, $stateParams.content);
			//($rootScope.cursorPos).insertNode($($stateParams.content));
			
			if(imageDetails){
				$stateParams.imageDetails = imageDetails;
				var imageInfo = JSON.parse($stateParams.imageDetails);
				$scope.imageDetails[imageInfo.id] = imageInfo;
				$scope.currentImageInfo = imageInfo;
				
				$('.newPost #postBox #container_'+imageInfo.id+' .imageContainer').css("width",$scope.imageDetails[imageInfo.id].metadata.width+"px");
				$('.newPost #postBox #container_'+imageInfo.id+' .imageContainer > img').css("width",$scope.imageDetails[imageInfo.id].metadata.width+"px"); 
			}
		} */
		
		//$scope.backTo = $stateParams.backTo;
		// ****************** initialization of variables ends *********************** //		

		// ************************ Methods for API calls starts ***************************** //

			//-------------------------------- CREATE NEW POST STARTS -------------------------------//
			
			/*	Description => The method creating a new post
			*/
			$scope.createNewPost = function(){

				$scope.postType = $stateParams.type == "post"? "Post" : "Page";
				var postContent = $.trim(angular.element('#postBox').text());
				var postHtml = $.trim(angular.element('#postBox').html());
				if($scope.title !== "" || postContent.length !== 0 || postHtml.indexOf('<img') != -1){
					if(postContent.length === 0 && postHtml.indexOf('<img') === -1) $scope.content = "";
					if (window.Notification && Notification.permission === "granted") {
						//var notifyUpload = new Notification("Uploading "+$scope.type, {body: "Uploading "+$scope.type, icon: $rootScope.originPath+"/assets/img/app_icon-32.png"});
						$scope.notifyUpload = new Notification("Uploading "+$scope.type, {body: "Uploading "+$scope.type, icon: $rootScope.originPath+"/assets/img/app_icon-32.png"});
					}

					var categList = CommonScope.getCategStringList($scope.categories,"name");
					categList = categList.substring(0, categList.length-1);
					if($scope.immediatePublish === true){
						$scope.date = "";
					}

					if($scope.settingsLocalData && $scope.settingsLocalData.signature == true)
						$scope.content = $scope.content + "<br/>" + $scope.settingsLocalData.signatureBody;
								
					var createPostUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/posts/new';				
					var payload = commonService.createNewPost_payload($scope, categList);

					var apiCaller = new APICaller('POST', createPostUrl, $scope.createNewPost_success, $scope.createNewPost_error, payload);
					apiCaller.getResult();
				}
				else{
					alert("Either title or content is required");
					if($scope.settings === true){
						$scope.settings = false;
						$scope.setTitle();
					}
				}
			};

				$scope.createNewPost_success = function(e) {
					if (this.readyState === 4 && this.status === 200) {						
						if($scope.notifyUpload)
							$scope.notifyUpload.close();
						//ngProgress.complete();
						NProgress.remove();
						if($stateParams.parentView == "media"){
							$state.go($stateParams.parentView, {currentView:$stateParams.currentView, startDate:$stateParams.startDate, endDate:$stateParams.endDate, selectedIds:$stateParams.selectedMedia});
						}
						else{
							$state.go($stateParams.parentView);
						}
					}
				};
				$scope.createNewPost_error = function (e) {
					if($scope.notifyUpload)
						$scope.notifyUpload.close();
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						if (window.Notification && Notification.permission === "granted") {
							var notifyUploadFail = new Notification("Upload failed", {body: $scope.postType+" Upload failed: An error occured while uploading the "+$scope.type, icon: $rootScope.originPath+"/assets/img/error.png"});
							notifyUploadFail.onclick = function(){
								alert($scope.postType+" Upload failed: An error occured while uploading the "+$scope.type);
							};
							NProgress.remove();
							if($stateParams.parentView == "media"){
								$state.go($stateParams.parentView, {currentView:$stateParams.currentView, startDate:$stateParams.startDate, endDate:$stateParams.endDate, selectedIds:$stateParams.selectedMedia});
							}
							else{
								$state.go($stateParams.parentView);
							}
						}
					}					
				};
			//-------------------------------- CREATE NEW POST ENDS -------------------------------//

			//-------------------------------- GET Categories STARTS ----------------------------//

			/*	Description => The method fetching the category list
			*/
			$scope.showCategory = function(){
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					var getCategoriesUrl = commonService.APIBaseUrl +$rootScope.authDetails.site_id+'/categories?pretty=1';						
					var apiCaller = new APICaller('GET', getCategoriesUrl, $scope.showCategory_success, $scope.showCategory_error, "");
					apiCaller.getResult();
				}
				else{
					NProgress.done();
					$scope.toastMessage = "There is no network available";
					$scope.postToast = true;
				}
			};

				$scope.showCategory_success = function(e) {
					if (this.readyState === 4 && this.status === 200) {
						$scope.siteCategories = JSON.parse(this.response);
												
						CommonScope.setCategoryState($scope.siteCategories.categories, $scope);
						CommonScope.setRootTree($scope);
						$scope.categoryView = true;
						$scope.settings = false;
						$scope.viewTitle = "Select categories";
						$scope.$apply();
						NProgress.done();
					}
				};
				$scope.showCategory_error = function () {
					NProgress.done();
					$log.error("Problem loading Categories!");
					$scope.toastMessage = "Problem loading Categories";
					$scope.postToast = true;
					$scope.$apply();
				};

			//-------------------------------- GET Categories Ends ----------------------------//

			//-------------------------------- ADD Category starts ----------------------------//

			/*	Description => The method fetching the category list
				Params => 1. pageNo : page number of the data.
			*/
			$scope.addCategory = function(){				
				if($scope.catName !== ''){
					
					var addCategoryUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/categories/new';					
					var payload = commonService.addCategory_payload($scope);

					var apiCaller = new APICaller('POST', addCategoryUrl, $scope.addCategory_success, $scope.addCategory_error, payload);
					apiCaller.getResult();
				}	
				else{
					alert("The category name field is required");
				}
			};

				$scope.addCategory_success = function(e) {
					if (this.readyState === 4 && this.status === 200) {						
						$scope.toastMessage = "Category added successfully!";
						$scope.postToast = true;
						$scope.newCategory = false;
						$scope.categoryView = true;
						$scope.showCategory();
						$scope.$apply();
						
					}
				};				
				$scope.addCategory_error = function (e) {
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						$scope.toastMessage = "Adding category failed";
						$scope.postToast = true;
						$scope.newCategory = false;
						$scope.categoryView = true;
						$scope.$apply();
					}					
				};
			//-------------------------------- ADD Category ends ----------------------------//
		// ************************ Methods for API calls ends ***************************** //

		// ************************ Methods for view actions starts ***************************** //
		
			/*	Description => The method sets the Title for the view initially.
			*/
			$scope.setTitle = function(){
				$scope.type = $stateParams.type == 'post'? 'post' : 'page';
				if($scope.imageSettings)
					$scope.viewTitle = "Image settings";
				else
					$scope.viewTitle = $scope.siteObject.siteName;
			};
			
			/*	Description => The method sets the styles on contentEdior during click n keyboard events
				Params => 1. event : event object.
			*/
			$scope.preventClick = function( $event ){			
				CommonScope.preventClick($event, $scope);
			};

			/*	Description => The method sets focus
			*/		
			$scope.focusOnField = function(){
				CommonScope.focusOnField($scope);
			};

			/*	Description => The method highlights the selected option for editing the content.
				Params => 1. objElement : html element where the cursor is set on click or while typing.
			*/
			$scope.setEditorState = function( objElement ){
				CommonScope.setEditorState(objElement, $scope);				
			};

			/*	Description => The method sets the visual of the keypad
				Params => 1. event : event object.
			*/	
			$scope.handleClick = function( event ){
				CommonScope.handleClick(event,$scope);
			};

			/*	Description => The method sets the visual of the keypad
				Params => 1. event : event object.
			*/			
			$scope.formatText = function(event){
				CommonScope.formatText(event, $scope);
			};
			
			/*	Description => The method executes the text editor commands
				Params => 1. cmd : command name to be executed.
						2. sValue: value of the command to be executed.
			*/
			$scope.formatDoc = function(cmd, sValue) {
				CommonScope.formatDoc(cmd, sValue, $timeout, $scope);
			};
		
			/*	Description => The method removes the category when unchecked
				Params => 1. categObject : categ object to be deleted.
			*/
			$scope.removeCategory = function(categObject){
				CommonScope.removeCategory(categObject,$scope);
			};
			
			$scope.showAddMediaOpt = function(event){
				CommonScope.showAddMediaOpt($scope);
				//$scope.cursorPos = CommonScope.getCaretPosition();
				
				//console.log("$scope.cursorPos",$scope.cursorPos);
			};
			
			$scope.openPickActivity = function(){
				CommonScope.openPickActivity($scope);
			};
			
			$scope.createGallery = function(){
				CommonScope.createGallery($scope, $stateParams);
			};
			
			$scope.selectSingleMedia = function(){
				CommonScope.selectSingleMedia($scope, $stateParams);
			};
			
			$scope.editImgDetails = function(id, edited){				
				//var newObj = $scope.imageDetails;
				if(!edited){
					$scope.currentImageInfo = $scope.imageDetails[id];
					//$scope.currentImageInfo = $stateParams.imagedetails[imageInfo.id];
					//$scope.currentImageInfo[id] = imageInfo;
					//$scope.imageDetails[imageInfo.id].isFeatured = false;
					$scope.currentImageInfo.alignment = "alignnone";
					$scope.currentImageInfo.widthString = ($scope.currentImageInfo.metadata.width).toString();
					if($scope.currentImageInfo.metadata.width > 2000){
						$scope.currentImageInfo.metadata.width = 2000;
						$scope.currentImageInfo.widthString = (2000).toString();
					}
					else if($scope.currentImageInfo.metadata.width < 10){
						$scope.currentImageInfo.metadata.width = 10;
						$scope.currentImageInfo.widthString = (10).toString();
					}
					//$scope.imageDetails.widthInPX = $scope.imageDetails.widthString+"px";
				}
				else{
					$scope.currentImageInfo = $scope.imageDetails[id]; 					
					var innerHtml = $('#container_'+id).html();
					if(innerHtml.indexOf('[caption') !== -1)
						var caption = $('#img_'+id).attr("caption");
		
					else
						var caption = "";
					
					var title = $('#img_'+id).attr("title");
					var alignment = ($('#img_'+id).attr("class")).split(" ");
					var imgSrc = $('#img_'+id).attr("src");
					var width = imgSrc.substring(imgSrc.indexOf("?w=")+3);
					//var isFeatured = $('#img_'+id).attr("isFeatured");					
					$scope.currentImageInfo.title = title;
					$scope.currentImageInfo.caption = caption;
					$scope.currentImageInfo.alignment = alignment[0];
					$scope.currentImageInfo.metadata.width = parseInt(width);
					$scope.currentImageInfo.widthString = width;
					//$scope.imageDetails.widthInPX = $scope.imageDetails.widthString+"px";
					//$scope.imageDetails[id].isFeatured = isFeatured;
					/* if($scope.imageDetails.metadata.width > 2000){
						$scope.imageDetails.metadata.width = 2000;
					}
					else if($scope.imageDetails.metadata.width < 10){
						$scope.imageDetails.metadata.width = 10;
					} */
				}
				//angular.element('#postBox').blur();
				$timeout(function(){
					angular.element('#imageTitleEdit').focus();
				},100);
				$scope.imageSettings = true;
				$scope.setTitle();
				
			};
			
			$scope.setImageAttr = function(id){				
				$scope.imageDetails[id] = $scope.currentImageInfo;
				//$scope.imageDetails.widthString = $scope.changeToString($scope.imageDetails.metadata.width);
				$scope.currentImageInfo.metadata.width = parseInt($scope.currentImageInfo.widthString);
				
				if($scope.currentImageInfo.caption != ""){
					//$scope.nonEditContent = '[caption id="" align="'+$scope.currentImageInfo.alignment+'" width="'+$scope.currentImageInfo.widthString+'" caption="'+$scope.currentImageInfo.caption+'"]<div class="imageContainer" ng-click="editImgDetails('+id+', true)"><img id="img_'+id+'" class="'+$scope.currentImageInfo.alignment+' size-full" title="'+$scope.currentImageInfo.title+'" alt="image" src="'+$scope.currentImageInfo.link+'?w='+$scope.currentImageInfo.widthString+'" caption="'+$scope.currentImageInfo.caption+'"/><span class="editimage"><img src="/assets/img/edit-image.png"/></span></div>[/caption]';
					
					
					var imageAttachString = '<div id="container_'+id+'" class="outerContanier">[caption id="" align="'+$scope.currentImageInfo.alignment+'" width="'+$scope.currentImageInfo.widthString+'" caption="'+$scope.currentImageInfo.caption+'"]<div class="imageContainer" ng-click="editImgDetails('+id+', true)"><img id="img_'+id+'" class="'+$scope.currentImageInfo.alignment+' size-full" title="'+$scope.currentImageInfo.title+'" alt="image" src="'+$scope.currentImageInfo.link+'?w='+$scope.currentImageInfo.widthString+'" caption="'+$scope.currentImageInfo.caption+'"/><span class="editimage"><img src="/assets/img/edit-image.png"/></span></div>[/caption]</div></br>&nbsp;';
					//console.log("imageAttachString", $(imageAttachString));
					
					/* $('#postBox').find($('#contanier_'+$scope.imageDetails.id))
					console.log("innerhtml", innerhtml); */
					$('#container_'+id).replaceWith($(imageAttachString));
					//$('#contanier_'+$scope.imageDetails.id).html(imageAttachString);
					$('#container_'+id+' .imageContainer').css("width",$scope.currentImageInfo.metadata.width+"px");
					$('#container_'+id+' .imageContainer > img').css("width",$scope.currentImageInfo.metadata.width+"px");
				}
				else{
					
					$('#img_'+id).attr("title",$scope.currentImageInfo.title);
					var imgSrc = $('#img_'+id).attr("src");
					var imgClass = $('#img_'+id).attr("class");
					
					var imgWidth = imgSrc.substring(imgSrc.indexOf("?w=")+3);
					imgSrc = imgSrc.replace(imgWidth, $scope.currentImageInfo.widthString);
					/* 
					console.log("imgSrc", imgSrc);
					console.log("imgWidth", imgWidth); */
					
					var classArray = imgClass.split(" ");					
					angular.forEach(classArray,function(value, index){
						if(value.indexOf('align') !== -1)
							classArray[index] = $scope.currentImageInfo.alignment;
					});
					imgClass = classArray.join(" ");
					
					/* $('#img_'+$scope.imageDetails.id).attr("src",imgSrc);
					$('#img_'+$scope.imageDetails.id).attr("class",imgClass);
					$('#img_'+$scope.imageDetails.id).attr("isFeatured",$scope.imageDetails.isFeatured);
					//$('#img_'+$scope.imageDetails.id).attr("ng-click","editImgDetails('"+$scope.imageDetails.id+"')");
					var imgElement = $('#img_'+$scope.imageDetails.id);
					console.log("imgElement", imgElement); */
					
					var imageAttachString = '<div class="imageContainer" ng-click="editImgDetails('+id+', true)"><img id="img_'+id+'" class="'+imgClass+'" title="'+$scope.currentImageInfo.title+'" alt="image" src="'+imgSrc+'" caption="'+$scope.currentImageInfo.caption+'"/><span class="editimage"><img src="/assets/img/edit-image.png"/></span></div>';
					
					
					$('#container_'+id).html(imageAttachString);
					$('#container_'+id+' .imageContainer').css("width",$scope.currentImageInfo.metadata.width+"px");
					
					$('#container_'+id+' .imageContainer > img').css("width",$scope.currentImageInfo.metadata.width+"px");
					
				}
				
				/* if($scope.imageDetails[id].isFeatured){
					$scope.featuredList = ($scope.imageDetails[id].id).toString();
				}
				else{
					$scope.featuredList = "";
				} */
					$scope.backToView();
					//angular.element('#postBox').focus();
			};
			
			$scope.validate = function(id){
				$scope.currentImageInfo.metadata.width = parseInt($scope.currentImageInfo.widthString);
			};
			
			$scope.validateWidth = function(id){
				if($scope.currentImageInfo.metadata.width !== null){
					if($scope.currentImageInfo.metadata.width > 2000){
						$scope.currentImageInfo.metadata.width = 2000;
					}
						$scope.currentImageInfo.widthString = ($scope.currentImageInfo.metadata.width).toString();
				}
			};
			
			$scope.ifEmpty = function(id){
				if($scope.currentImageInfo.metadata.width == null || isNaN($scope.currentImageInfo.metadata.width)){					
					$scope.currentImageInfo.metadata.width = parseInt($scope.currentImageInfo.widthString);
				}
				if($scope.currentImageInfo.metadata.width < 10){					
					$scope.currentImageInfo.metadata.width = 10;
					$scope.currentImageInfo.widthString = ($scope.currentImageInfo.metadata.width).toString();
				}
			};
			
			/* $scope.$watch('$scope.content', function(newValue, oldValue) {
				console.log("content", $scope.content);
				if ( newValue !== oldValue) {
					console.log("old", oldValue);
					console.log("new", newValue);
				}
			}); */
			/* $scope.keyPressed = function(event){
				console.log("keyup width", $scope.imageDetails.metadata.width);
				var input = $('#widthText').val();
				console.log("input", input);
				if(isNaN($scope.imageDetails.metadata.width)){
					console.log("is not a number");
					var widthString = ($scope.imageDetails.metadata.width).toString();
					widthString = widthString.replace( /[-.]/,'');
					console.log("widthString", widthString);
					$scope.imageDetails.metadata.width = parseInt(widthString);
					$scope.imageDetails.widthString = widthString;
				}
				
			} */
			/*$scope.validateInputWidth = function(event){
				console.log("event.keyCode", event.which);
				if(event.keyCode == 8){
					return;
				}
				else{
					console.log("otherKeys");
					$scope.imageDetails.widthInPX = ($scope.imageDetails.widthInPX).replace(/^[\w&.\-]+$/, "");
					//var numericExpression = /^[0-9]+$/;
					/* if(($scope.imageDetails.widthInPX).match(numericExpression)){
							$scope.imageDetails.widthString = $scope.imageDetails.widthInPX;
					}
					else{
						$scope.imageDetails.widthInPX = ($scope.imageDetails.widthInPX).replace(/[A-Za-z$-]/g, ""); 
						$scope.imageDetails.widthString = $scope.imageDetails.widthInPX;
						//$scope.imageDetails.widthInPX = $scope.imageDetails.widthInPX+"px";
					/* } 
				}
				
				/* var input = $scope.imageDetails.widthInPX;.
				var output = parseInt(input) + (input.match(/px/) || 'px');
				if(isNaN($scope.imageDetails.widthInPX)){
					console.log("is not a number");
					var defaultWidth = "10";
					$scope.imageDetails.widthInPX = defaultWidth+"px";
					$scope.imageDetails.widthString = defaultWidth;
				}
				else{
					console.log("is a number");
					$scope.imageDetails.widthString = ""+$scope.imageDetails.widthInPX;
					//$scope.imageDetails.widthInPX = $scope.imageDetails.widthInPX+"px";
				} 
			};
			
			$scope.attachPx = function(){
				var numericExpression = /^[0-9]+$/;
				if(($scope.imageDetails.widthInPX).match(numericExpression)){
					$scope.imageDetails.metadata.width = parseInt($scope.imageDetails.widthString);
					if($scope.imageDetails.metadata.width > 2000){
						$scope.imageDetails.metadata.width = 2000;
						$scope.imageDetails.widthString = $scope.changeToString(2000);
					}
					else if($scope.imageDetails.metadata.width < 10){
						$scope.imageDetails.metadata.width = 10;
						$scope.imageDetails.widthString = $scope.changeToString(10);
					}
					$scope.imageDetails.widthInPX = $scope.imageDetails.widthString+"px";
				}
				else{
					$scope.imageDetails.widthString = $scope.changeToString($scope.imageDetails.metadata.width);
					$scope.imageDetails.widthInPX = $scope.imageDetails.widthString+"px";
				}
			};
			
			$scope.removeAplha = function(){
				$scope.imageDetails.widthInPX = ($scope.imageDetails.widthInPX).replace(/[A-Za-z$-]/g, "");
			}
 */			
			/*	Description => The method changes the state to main View
			*/
			$scope.backToView = function(){
				$scope.preview = $scope.settings = $scope.imageSettings = false;			
				$scope.setTitle();			
			};
			
			
			/*	Description => The method changes the state to "preview" view
			*/
			$scope.showPreview = function(){
				CommonScope.showPreview($scope);
			};

			/*	Description => The method redirects back to "post/page list" view.
			*/
			$scope.backToMain = function(){		
				if($stateParams.backTo == "media"){
					CommonScope.backToMain($stateParams.backTo, {currentView:$stateParams.currentView, startDate:$stateParams.startDate, endDate:$stateParams.endDate, selectedIds:$stateParams.selectedMedia}, NProgress);
				}
				else{
					CommonScope.backToMain($stateParams.backTo, {id:$stateParams.id}, NProgress);
				}
				
			};

			/*	Description => The method that conditionally navigates back to previous manu.
			*/
			$scope.goBack = function(){			
				if ($scope.settings || $scope.preview || $scope.imageSettings)
					$scope.backToView();
				else if ($scope.categoryView)
					CommonScope.backToSetting($scope, NProgress);
				else if ($scope.newCategory)
					CommonScope.backToCategory($scope);
				else
					$scope.backToMain();
			};

			/*	Description => The method recalls addCategoryView function.
			*/
			$scope.addItem = function(){
				// if($scope.categoryView == true)
				CommonScope.addCategoryView($scope);
				// else
				// 	$scope.addPost();
			};

			/*	Description => The method that conditionally saves the data.
			*/
			$scope.udpateItem = function(){
				if($scope.newCategory == true)
					$scope.addCategory();
				/* else if($scope.settings == true)
					$scope.saveSettings(); */
				else
					$scope.createNewPost();
			};

			/*	Description => The method that sets the state to "settings" view.
			*/		
			$scope.showSettings = function(){
				CommonScope.showSettings($scope);
			};
					
			/*	Description => The watch build on formated date variable.				
			*/		
			$scope.$watch('formatedDate', function(newValue, oldValue) {
				if ( newValue !== oldValue) {
					$scope.date = oldValue;
					$scope.formatedDate = CommonScope.formatDate(newValue);
				}
			});

			/*	Description => The function that enables/disables the textinput.
				params => 1.event : event object
			*/				
			$scope.disableDate = function(event){
				CommonScope.disableDate(event);
			};

			/*	Description => The function that handles the category checkbox toggle.
				params => 1.categObject : category object binded to checkbox
						  2.event : event object.
			*/
			$scope.toggleChecked = function(categObject,event){
				CommonScope.toggleChecked(categObject, event, $scope);
			};

			/*	Description => The function returns the category object for the given id.
				params => 1.categID : category ID
			*/
			$scope.getCategoryByID = function(categID){
				return CommonScope.getCategoryByID(categID, $scope);
			};

			/*	Description => The function sets the category id list in a string
				params => 1.categColletion : category list
			*/
			$scope.getCategIDList = function(categColletion){
				CommonScope.getCategIDList(categColletion, $scope);
			};

			/*	Description => The function adds a child category to parameter sent
			*/
			$scope.addChildren = function(parentCategory) {
				CommonScope.addChildren(parentCategory, $scope);
			};

			/*	Description => The function adds a child category to parameter sent
			*/
			$scope.selectCategParent = function(category) {
				CommonScope.selectCategParent(category, $scope);
			};

			/*	Description => The function gets executed on pull to refresh
			*/
			$scope.onReload = function() {
				  $scope.showCategory();
			};		
		// ************************ Methods for view actions ends ***************************** //

		// ****************** statements to be executed on controller init : starts *********************** //
			$scope.setTitle();
			$scope.init();
		// ****************** statements to be executed on controller init : ends *********************** //
	};
	controllers.newPostController.$inject = ['$scope', '$http', '$log', '$state', '$stateParams', '$timeout', '$rootScope', '$filter', '$window', 'commonService', 'APICaller', 'CommonScope'];
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

