(function() {
	'use strict';

	var controllers = {};


	controllers.notificationsController = function($scope, $http, $log, $state, $stateParams, $rootScope, $filter, APICaller, commonService){
	
	// ****************** initialization of variables starts *********************** //		
	
		localStorage.setItem('lastAccessedView', "notifications");
		$scope.showDrawer = false;
		$scope.currentMenu = "notifications";
		NProgress.remove();
		$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
	// ****************** initialization of variables ends *********************** //			

		// ************************ Methods for API calls and their response starts ***************************** //

			//-------------------------------- GET NOTIFICATIONS STARTS ----------------------------------------//
			
			/*	Description => The method fetching the notification list for the logged in user
			*/
		
 		$scope.getNotesList = function(){
			var isOnline = navigator.onLine;
			NProgress.start();
			if(isOnline){
				var getNotificationsUrl = 'https://public-api.wordpress.com/rest/v1/notifications/?pretty=1&context=edit&number=99';
				var apiCaller = new APICaller('GET',getNotificationsUrl, $scope.getNotesList_Success, $scope.getNotesList_Error);
				apiCaller.getResult();
			}
			else{
				NProgress.done();
				$scope.noteToast = true;
				$scope.toastMessage = "There is no network available"
			}
		};
			
			$scope.getNotesList_Success = function(){
				$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
				if (this.readyState === 4 && this.status === 200) {
					$scope.notificationsData = JSON.parse(this.response);					
					angular.forEach($scope.notificationsData.notes,function(value,index){
						value.date = new Date((value.timestamp)*1000);
						if(value['type'] == "comment"){
							if(value['body']['items'][0]['header_text'] !== "In reply to your comment")
								value['commentMade'] = value['body']['items'][0]['html'];
							else
								value['commentMade'] = value['body']['items'][1]['html'];
						}
						
					});
					
					$scope.updateLastSeen();
					$scope.$apply();
					NProgress.done();
				}
			};
				
			$scope.getNotesList_Error = function(){
				$scope.noteToast = true;
				$scope.toastMessage = "Couldn't load notifications!";
				$scope.$apply();
				NProgress.done();
			};
			
			//-------------------------------- GET NOTIFICATIONS ENDS ----------------------------------------//
			
			/*	Description => The method updating the last seen of the notification
			*/
		$scope.updateLastSeen = function(){
			var newDate = new Date();
			$scope.unixtime = newDate.getTime()/1000;			
			var updateLastSeenUrl = 'https://public-api.wordpress.com/rest/v1/notifications/seen';
			var payload = commonService.updateLastSeen_payload($scope);
			var apiCaller = new APICaller('POST',updateLastSeenUrl, $scope.updateLastSeen_Success, $scope.updateLastSeen_Error, payload);
			apiCaller.getResult();
		};
			$scope.updateLastSeen_Success = function(){
				if (this.readyState === 4 && this.status === 200) {
					var lastSeenResponse = JSON.parse(this.response);
					if(lastSeenResponse.success){
						/* $log.log("last seen", lastSeenResponse.last_seen_time); */
					}
				}
			};
			
			$scope.updateLastSeen_Error = function(){
				$log.log("Problem updating the last seen!");
			};
		
		$scope.hideMenu = function(event){
			if($scope.showDrawer === true){
				if ( event.target.className.indexOf( 'drawerIcon' ) == -1 )
					$scope.showDrawer = false;
			}
		};
		$scope.onReload = function(){
			$scope.getNotesList();
		};
				
		$scope.getNotesList();
	};
	controllers.notificationsController.$inject = ['$scope', '$http', '$log', '$state', '$stateParams', '$rootScope', '$filter', 'APICaller', 'commonService'];
	/***	Note Info controller 	***/

	controllers.noteInfoController = function($scope, $http, $log, $state, $stateParams, $rootScope, $filter, APICaller, commonService){
	
		// ****************** initialization of variables starts *********************** //		
			localStorage.setItem('lastAccessedView', "notifications");
			NProgress.remove();
			$scope.currentView = "noteInfo";
			$scope.isFollowing = {};
			$scope.site_id = {};
			$scope.ownSiteObject = localStorage.getItem('siteObject');
			$scope.ownSiteObject = JSON.parse($scope.ownSiteObject);
			$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
			
		// ****************** initialization of variables ends *********************** //			

		// ************************ Methods for API calls and their response starts ***************************** //

			//-------------------------------- GET SINGLE NOTIFICATION STARTS ----------------------------------------//
			
			/*	Description => The method fetching the single notification for the logged in user
			*/
			
			$scope.getNoteInfo = function(noteID){
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					var getNoteInfoUrl = 'https://public-api.wordpress.com/rest/v1/notifications/'+ noteID;
					var apiCaller = new APICaller('GET',getNoteInfoUrl, $scope.getNoteInfo_Success, $scope.getNoteInfo_Error);
					apiCaller.getResult();
				}
				else{
					NProgress.done();
					$scope.noteToast = true;
					$scope.toastMessage = "There is no network available"
				}
			};
				$scope.getNoteInfo_Success = function(){
					$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
					if (this.readyState === 4 && this.status === 200) {
						$scope.singleNoteData = JSON.parse(this.response).notes[0];
						
						
						$scope.common3NoteType = ($scope.singleNoteData.type == 'follow' || $scope.singleNoteData.type == 'like' || $scope.singleNoteData.type == 'reblog');
						
						$scope.acievementTypes = ($scope.singleNoteData.type == 'post_milestone_achievement' || $scope.singleNoteData.type == 'followed_milestone_achievement' || $scope.singleNoteData.type == 'like_milestone_achievement');
						
						$scope.bestDayFeatTypes = ($scope.singleNoteData.type == 'best_liked_day_feat' || $scope.singleNoteData.type == 'best_followed_day_feat');
						
						$scope.commentRealtedTypes = ($scope.singleNoteData.type == "comment_like");
						
						if($scope.bestDayFeatTypes){
							$scope.siteID = $scope.getSiteId();
							$scope.showViewStats = $scope.ownSiteObject.siteID == $scope.siteID
						}
						
						if($scope.singleNoteData.type == "comment_like"){
							$scope.siteID = $scope.getSiteId();
							angular.forEach($scope.singleNoteData.body['items'],function(value,index){
								if(index > 0 && value['action']){
									$scope.site_id[index] = value['action']['params']['site_id'];
									$scope.isFollowing[$scope.site_id[index]] = value['action']['params']['is_following'];
								}
							});
							$scope.commentText = '"'+$scope.singleNoteData.body['items'][0]['html']+'"';
							
							var commentUrl = "";
							for (var attr in $scope.singleNoteData.body['objects']){
								if(attr.indexOf('comments') !== -1){
									commentUrl = attr;
									break;
								}
							}
							$scope.likeCommentID = commentUrl.substring(commentUrl.lastIndexOf('/')+1);
							if($scope.ownSiteObject.siteID == $scope.siteID)
								$scope.notALink = false;
							else
								$scope.notALink = true;
							
						}
						
						if($scope.common3NoteType){
							angular.forEach($scope.singleNoteData.body['items'],function(value,index){
								if(value['action']){
									$scope.site_id[index] = value['action']['params']['site_id'];
									$scope.isFollowing[$scope.site_id[index]] = value['action']['params']['is_following'];
								}
							});
							
						}
						
						
						if($scope.singleNoteData.type === "reblog"){
							angular.forEach($scope.singleNoteData.body['items'],function(value,index){
								var stringPart = value['header'].substring(value['header'].indexOf(">") + 1);
								value['header_text'] = stringPart.substring(0,stringPart.indexOf("<"));
							});
							$scope.notALink = true;
						}
						
						if($scope.singleNoteData.type === "comment"){
							/* var url = "";
							var commentID;
							angular.forEach($scope.singleNoteData.body['items'],function(value,index){
								if(value['header_text']!== "In reply to your comment"){
									for (var attr in value['objects']){
										 url = attr;
										 break;
									}
									commentID = url.substring(url.lastIndexOf('/')+1);
									console.log("commentID", commentID);
								}
							}); */
							var siteID = $scope.singleNoteData.body['actions'][0]['params']['site_id'];
							var commentID = $scope.singleNoteData.body['actions'][0]['params']['comment_id'];
							if(siteID == $rootScope.authDetails.site_id){
								$state.go("commentInfo", {id: commentID, backTo: "notifications"});
								$scope.showDefault = "false";
							}
							else{
								$scope.showDefault = "true";								
							}
						}
						
						if($scope.singleNoteData.type == "follow"){
							$scope.notALink = false;
						}
						
						if($scope.singleNoteData.type == "like"){
							$scope.siteID = $scope.getSiteId();
							var postUrl = "";
							for (var attr in $scope.singleNoteData.body['objects']){
								if(attr.indexOf('posts') !== -1){
									postUrl = attr;
									break;
								}
							}
							$scope.postID = postUrl.substring(postUrl.lastIndexOf('/')+1);
							//$scope.postLike_siteID = siteUrl.substring(siteUrl.lastIndexOf('/')+1);
							
							if($scope.ownSiteObject.siteID == $scope.siteID)
								$scope.notALink = false;
							else
								$scope.notALink = true;
						}
				
						if($scope.singleNoteData.unread != 0){
							//console.log("Unread > 0");
							$scope.markAsRead();
						}
						$scope.$apply();
						NProgress.done();
					}
				};
				$scope.getNoteInfo_Error = function(){
					$scope.noteToast = true;
					$scope.toastMessage = "Couldn't load this notification!";
					$scope.$apply();
					NProgress.done();
				};
			
			$scope.markAsRead = function(){
				$scope.updateRead = [$scope.singleNoteData.id];				
				var markAsReadUrl = 'https://public-api.wordpress.com/rest/v1/notifications/read';
				var payload = commonService.markAsRead_payload($scope);
				var apiCaller = new APICaller('POST',markAsReadUrl, $scope.markAsRead_Success, $scope.markAsRead_Error, payload);
				apiCaller.getResult();
			};
			
				$scope.markAsRead_Success = function(){
					if (this.readyState === 4 && this.status === 200) {
						var markAsReadResponse = JSON.parse(this.response);
						if(markAsReadResponse.success){							
						}
					}
				};
				
				$scope.markAsRead_Error = function(){
					$log.log("Problem marking note as read!");
				}; 
				
			$scope.followBlog = function(siteID){
				var followBlogUrl = commonService.APIBaseUrl + siteID +'/follows/new?pretty=1';
				var apiCaller = new APICaller('POST',followBlogUrl, $scope.followBlogToggle_Success(siteID), $scope.followBlogToggle_Error);
				apiCaller.getResult();
			};
			
			
			$scope.unfollowBlog = function(siteID){
				var unfollowBlogUrl = commonService.APIBaseUrl + siteID +'/follows/mine/delete?pretty=1';
				var apiCaller = new APICaller('POST',unfollowBlogUrl, $scope.followBlogToggle_Success(siteID), $scope.followBlogToggle_Error);
				apiCaller.getResult();
			};
			
			$scope.followBlogToggle_Success = function(siteID){
				return function(){
					if (this.readyState === 4 && this.status === 200) {
						var followResponse = JSON.parse(this.response);
						if(followResponse.success){
							$scope.isFollowing[siteID] = followResponse.is_following;
						}
						else{
							$scope.toastMessage = "Couldn't complete the action";
							$scope.noteToast = true;
						}
						$scope.$apply();
					}
				};
			};
			
			$scope.followBlogToggle_Error = function(e){
				if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
					$scope.toastMessage = "Couldn't complete the action";
					$scope.noteToast = true;
					$scope.$apply();
				}				
			};
			
			/*	Description => The method navigates to the viewSite screen which shows the post view 
				on the browser.
			*/
			$scope.viewSite = function(viewType, siteId, siteUrl){
				NProgress.remove();
				if(viewType == "site"){
					$state.go("viewSite", { id : $stateParams.id, backTo : "noteInfo" ,url: siteUrl, title: '', site_id:siteId}); 
				}
			};
			
			$scope.getSiteId = function(){
				var siteUrl = "";
				for (var attr in $scope.singleNoteData.body['objects']){
					if(attr.indexOf('sites') !== -1){
						siteUrl = attr;
						break;
					}
				}
				var partUrl = siteUrl.substring(siteUrl.indexOf('sites')+6);				
				if(partUrl.indexOf('/') !== -1){					
					return partUrl.substring(0,partUrl.firstIndexOf('/'));
				}
				else{					
					return partUrl;
				}
			};

			$scope.goToNewView = function(){
				$scope.siteID = $scope.getSiteId();
				if($scope.singleNoteData.type == "comment_like"){
				
					/* var commentUrl = "";
					/*angular.forEach($scope.singleNoteData.body['items'],function(value,index){
						 if(value['header_text']!== "In reply to your comment"){ 
							for (var attr in $scope.singleNoteData.body['objects']){
								if(attr.indexOf('comments') !== -1){
									commentUrl = attr;
									break;
								}
								/* if(attr.indexOf('comments') == -1 && attr.indexOf('posts') == -1){
									siteUrl = attr;
								} 
							}
							$scope.likeCommentID = commentUrl.substring(commentUrl.lastIndexOf('/')+1); */
							//$scope.commentLike_siteID = siteUrl.substring(siteUrl.lastIndexOf('/')+1);
							//console.log("commentID", $scope.likeCommentID);
							//console.log("siteID", $scope.siteID);
						/* } 
					});*/
					if($scope.ownSiteObject.siteID == $scope.siteID){
						//$scope.notALink = false;
						$state.go("commentInfo", {id: $scope.likeCommentID, backTo: "noteInfo", backToNoteID: $scope.singleNoteData.id, hideFooter: true});
					}
					/* else
						$scope.notALink = true; */
				}
				
				/* else if($scope.singleNoteData.type == "reblog"){
					/* backTo:postID:mainView:backToNoteID
					$state.go("commentsWithPost", {backTo: "noteInfo", backToNoteID: $scope.singleNoteData.id, postID: });
					$scope.notALink = true;
				}  */
				
				else if($scope.singleNoteData.type == "follow"){
				
					/* var siteUrl = "";
					for (var attr in $scope.singleNoteData.body['objects']){
						if(attr.indexOf('sites') !== -1){
							siteUrl = attr;
						}
						 //break;
					} 
					$scope.follow_siteID = siteUrl.substring(siteUrl.lastIndexOf('/')+1);*/
					$scope.notALink = false;
					$state.go("viewSite", {url: $scope.singleNoteData.body['header_link'], site_id: $scope.siteID, backTo: 'noteInfo',  id: $scope.singleNoteData.id});
					
				}
				
				else if($scope.singleNoteData.type == "like"){
					/* var postUrl = "";
					for (var attr in $scope.singleNoteData.body['objects']){
						if(attr.indexOf('posts') !== -1){
							postUrl = attr;
							break;
						}
						/* else{
							siteUrl = attr;
						} 
						 //break;
					}
					$scope.postID = postUrl.substring(postUrl.lastIndexOf('/')+1);
					//$scope.postLike_siteID = siteUrl.substring(siteUrl.lastIndexOf('/')+1); */
					
					if($scope.ownSiteObject.siteID == $scope.siteID){
						//$scope.notALink = false;
						$state.go("commentsWithPost", {id: $scope.singleNoteData.id, backTo: "noteInfo", postID: $scope.postID});
					}
					/* else
						$scope.notALink = true; */
				}
			};
			
			$scope.goToStats = function(){
				$state.go("stats", {id: $scope.singleNoteData.id, backTo: 'noteInfo'});
			};
			
			$scope.goBack = function(){
				$state.go("notifications");
			};
			$scope.getNoteInfo($stateParams.id);
	};
	controllers.noteInfoController.$inject = ['$scope', '$http', '$log', '$state', '$stateParams', '$rootScope', '$filter', 'APICaller', 'commonService'];
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

