(function() {
	'use strict';

	var controllers = {};

	/***	Pages list controller 	***/
	controllers.pagesController = function($scope, $http, $log, $rootScope, $state, $q, APICaller, commonService) {

		// ****************** initialization of variables starts *********************** //		
			localStorage.setItem('lastAccessedView', "pages");			
			$scope.viewTitle = "pages";
			$scope.currentMenu = "pages";
			$scope.showDrawer = false;

			$scope.pageNo = 1;
			$scope.nextPageData = [];
			NProgress.remove();	
			$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
			
		// ****************** initialization of variables ends *********************** //
		
		// ************************ Methods for API calls and their response starts ***************************** //

			//-------------------------------- GET PAGES STARTS ----------------------------------------//
			
			/*	Description => The method fetching the page list for the logged in user
				Params => 1. pageNo : page number of the data.
			*/
			$scope.getPages = function(pageNo){
				/* if($scope.pageNo == 1)
					$scope.showLoader = true; */
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					var getPagesUrl = commonService.APIBaseUrl +$rootScope.authDetails.site_id+'/posts/?status=any&pretty=1&type=page&context=edit&number=20&page=' + pageNo;
					var apiCaller = new APICaller('GET',getPagesUrl, $scope.getPages_Success, $scope.getPages_Error);
					apiCaller.getResult();
				}
				else{
						NProgress.done();						
						$scope.toastMessage = "There is no network connection";
						$scope.postToast = true;
						$scope.showLoadSpinner = false;
				}
			};

				$scope.getPages_Success = function() {
					$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
					if (this.readyState === 4 && this.status === 200) {						
						var jsonResponse = JSON.parse(this.response);
						
						if($scope.pageNo == 1){							
							$scope.pagesData = jsonResponse;
							$scope.loadMore();
						}
						else{
							$scope.nextPageData = jsonResponse.posts;
							$scope.showLoadSpinner = false;
						}
													
						$scope.$apply();
						NProgress.done();
					}
				};
				$scope.getPages_Error = function () {					
					NProgress.done();					
					$scope.toastMessage = "Problem loading pages";
					$scope.postToast = true;
					$scope.$apply();
				};

			//-------------------------------- GET PAGES ENDS ----------------------------------------//

		// ************************ Methods for API calls ends ***************************** //

		// ************************ Methods for view actions starts ***************************** //
			/*	Description => The method to hide the menu section.
				Params => 1. event : event object.
			*/
			$scope.hideMenu = function(event){
				if($scope.showDrawer === true){
					if ( event.target.className.indexOf( 'drawerIcon' ) == -1 )
						$scope.showDrawer = false;
				}
			};	

			/*	Description => The method to redirect to the new page view.
			*/		
			$scope.addPost = function(){
				NProgress.remove();
				$state.go("newPost", { type : 'page' , backTo : 'pages' , id: '', parentView: 'pages' });
			};

			/*	Description => The method being called on pulltorefresh action.
			*/
			$scope.onReload = function() {
				$scope.nextPageData = [];
				$scope.pageNo = 1;
				$scope.getPages(1);
			};

			/*	Description => The method to load next page data inside view.
			*/
			$scope.loadMore = function(){			
				if($scope.pagesData != undefined && $scope.nextPageData != undefined){
					$.merge($scope.pagesData.posts, $scope.nextPageData);
					$scope.showLoadSpinner = true;
				}
				$scope.pageNo = $scope.pageNo + 1;
				$scope.getPages($scope.pageNo);
			};

		// ************************ Methods for view actions ends ***************************** //
		
		// ****************** statements to be executed on controller init : starts *********************** //
			$scope.getPages();
		// ****************** statements to be executed on controller init : ends *********************** //
	};	
	controllers.pagesController.$inject = ['$scope', '$http', '$log', '$rootScope', '$state', '$q', 'APICaller', 'commonService'];
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

