(function() {
	'use strict';

	var controllers = {};


	controllers.pinlockController = function($scope, $timeout, $log, $state, $stateParams, $rootScope, $filter, APICaller, commonService){

		if( localStorage.getItem('pinLockData') ){
			$scope.pinLockData = JSON.parse( localStorage.getItem('pinLockData') );
			$scope.pinLockData = $scope.pinLockData? $scope.pinLockData : {};
		}else {
			$scope.pinLockData = {};
			$scope.pinLockData.pinLockOn = false;
		}
		
		$scope.showSetPin = false;

		$scope.SetPinView = function(action){
			if(action == 'change'){
				if($scope.pinLockData.pinLockOn)
					$scope.changePinView = true;
				else
					return;
			};

			$scope.showSetPin = true;			
			$timeout(
				function(){$("#input1").focus()},
				100);
			
		}

		$scope.goBack = function(){			
			if($scope.showSetPin){
				$scope.showSetPin = false;
				$scope.pin1 = undefined;
				$scope.pin2 = undefined;
				$scope.changePinView = false;

				if( localStorage.getItem('pinLockData') ){
					$scope.pinLockData = JSON.parse( localStorage.getItem('pinLockData') );
					$scope.pinLockData = $scope.pinLockData? $scope.pinLockData : {};
				}
				// $timeout(
				// function(){$("#input1").blur()},
				// 1000);
				//angular.element("#input1").blur();
			}
			else
				$state.go("settings");
		};

		$scope.inputKeyup = function(e){
			var target = e.target;
		    var maxLength = parseInt(target.attributes["maxlength"].value, 10);
		    var myLength = target.value.length;
		    if (myLength >= maxLength) {
		        var next = target;
		        while (next = next.nextElementSibling) {
		            if (next == null)
		                break;
		            if (next.tagName.toLowerCase() == "input" && next.value == "") {
		                next.focus();
		                break;
		            }
		        }
		    }

		    if(next == null)
		    {
			    if($scope.changePinView)
			    	$scope.changePin();
			    else if($scope.pinLockData.pinLockOn)
			    	$scope.unsetPin(next);
			    else
			    	$scope.setPin(next);
			}
		};

		$scope.changePin = function(next){
			if(next == null)
		    {
		    	var numArr = $scope.getPinNums();

			    if(numArr[0]!="" && numArr[1]!="" && numArr[2]!="" && numArr[3]!="")
			    {
			    	var pin = "" + numArr[0] + numArr[1] + numArr[2] + numArr[3];
			    	if($scope.pinLockData.pin == pin){
			    		$scope.resetInputs();
			    		$scope.changePinView = false;
			    		$scope.pinLockData.pinLockOn = undefined;			    		
			    		angular.element("#input1").focus();			    		
			    	}else{
			    		$scope.toastMessage = "Wrong Pin";
						$scope.pinToast = true;
						angular.element("#input1").focus();
			    	}

			    	$scope.resetInputs();

			    }
		    }
		};

		$scope.unsetPin = function(next){
			if(next == null)
		    {
		    	var numArr = $scope.getPinNums();

			    if(numArr[0]!="" && numArr[1]!="" && numArr[2]!="" && numArr[3]!="")
			    {
			    	var pin = "" + numArr[0] + numArr[1] + numArr[2] + numArr[3];
			    	if($scope.pinLockData.pin == pin){
			    		angular.element("#input4").blur();
			    		$scope.pinLockData.pinLockOn = false;
			    		$scope.pinLockData.pin = undefined;
			    		localStorage.setItem('pinLockData', JSON.stringify($scope.pinLockData));
			   //  		$scope.toastMessage = "Pin unset";
						// $scope.pinToast = true;
			    		$scope.setPinState();
			    		$scope.goBack();
			    	}else{
			    		$scope.toastMessage = "Wrong Pin";
						$scope.pinToast = true;
						angular.element("#input1").focus();
			    	}

			    	$scope.resetInputs();

			    }
		    }
		};


		$scope.setPin = function(next){
			if(next == null)
		    {
		    	var numArr = $scope.getPinNums();

			    if(numArr[0]!="" && numArr[1]!="" && numArr[2]!="" && numArr[3]!="")
			    {
			    	if($scope.pin1)
			    	{
			    		$scope.pin2 = "" + numArr[0] + numArr[1] + numArr[2] + numArr[3];

			    		if($scope.pin1 == $scope.pin2)
			    		{
			    			angular.element("#input4").blur();
			    			$scope.pinLockData.pinLockOn = true;
			    			$scope.pinLockData.pin = $scope.pin2;
			    			localStorage.setItem('pinLockData', JSON.stringify($scope.pinLockData));
			    // 			$scope.toastMessage = "Pin set";
							// $scope.pinToast = true;
			    			$scope.setPinState();
			    			$scope.goBack();			    			
			    		}else{
			    			$scope.toastMessage = "Wrong Pin";
							$scope.pinToast = true;
							//angular.element("#input1").focus();
			    		}
			    	}else{

			    		$scope.pin1 = "" + numArr[0] + numArr[1] + numArr[2] + numArr[3];
				    	angular.element("#input1").focus(); 
			    	}

			    	$scope.resetInputs();

			    }else{
			    	target.focus();
			    }
		    }
		};

		$scope.getPinNums = function(){
			var pinNums = [];
			pinNums.push(document.getElementById("input1").value);
			pinNums.push(document.getElementById("input2").value);
			pinNums.push(document.getElementById("input3").value);
			pinNums.push(document.getElementById("input4").value);
			return pinNums;
		}

		$scope.resetInputs = function(){
			document.getElementById("input1").value = "";
	    	document.getElementById("input2").value = "";
	    	document.getElementById("input3").value = "";
	    	document.getElementById("input4").value = "";
	    }

		$scope.setPinState = function(){
			if($scope.pinLockData.pinLockOn)
				$scope.setPinTitle = "Turn PIN lock off";
			else	
				$scope.setPinTitle = "Turn PIN lock on";
		};
		
		$scope.setPinState();

	};
	controllers.pinlockController.$inject = ['$scope', '$timeout', '$log', '$state', '$stateParams', '$rootScope', '$filter', 'APICaller', 'commonService'];
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();