(function() {
	'use strict';

	var controllers = {};

	/***	Posts list controller 	***/
	controllers.postsController = function($scope, $http, $log, $state, $rootScope, $q, PostsService, APICaller, commonService) {

		// ****************** initialization of variables starts *********************** //		
			localStorage.setItem('lastAccessedView', "posts");
			$scope.viewTitle = "posts";
			$scope.currentMenu = "posts";
			$scope.showDrawer = false;
			$scope.pageNo = 1;
			$scope.nextPageData = [];
			$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
			
			
			
		// ****************** initialization of variables ends *********************** //			

		// ************************ Methods for API calls and their response starts ***************************** //

			//-------------------------------- GET POSTS STARTS ----------------------------------------//
			
			/*	Description => The method fetching the page list for the logged in user
				Params => 1. pageNo : page number of the data.
			*/
			$scope.getPosts = function(pageNo){
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					var getPostsUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id + '/posts/?pretty=1&status=any&context=edit&number=20&page=' + pageNo;
					var apiCaller = new APICaller('GET',getPostsUrl, $scope.getPosts_Success, $scope.getPosts_Error);
					apiCaller.getResult();		
				}
				else{
					NProgress.done();
					$scope.toastMessage = "There is no network available";
					$scope.postToast = true;
					$scope.showLoadSpinner = false;
				}
			};

				$scope.getPosts_Success = function(e) {
					$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
					if (this.readyState === 4 && this.status === 200) {

						var jsonResponse = JSON.parse(this.response);

						if($scope.pageNo == 1){							
							$scope.postsData = jsonResponse;
							$scope.loadMore();
						}
						else{
							$scope.nextPageData = jsonResponse.posts;
							$scope.showLoadSpinner = false;
						}

						$scope.$apply();
						NProgress.done();
					}
				};

				$scope.getPosts_Error = function () {
					NProgress.done();
					$scope.toastMessage = "Problem loading posts";
					$scope.postToast = true;
					$scope.$apply();
				};
			//-------------------------------- GET PAGES ENDS ----------------------------------------//

		// ************************ Methods for API calls and their response ends ***************************** //

		// ************************ Methods for view actions starts ***************************** //

			/*	Description => The method to hide the menu section.
				Params => 1. event : event object.
			*/
			$scope.hideMenu = function(event){
				if($scope.showDrawer === true){
					if ( event.target.className.indexOf( 'drawerIcon' ) == -1 )
						$scope.showDrawer = false;
				}
			};
				
			/*	Description => The method to redirect to the new post view.
			*/		
			$scope.addPost = function(){
				NProgress.remove();
				$rootScope.newContent = "";
				$rootScope.newEditContent = "";
				//$rootScope.cursorPos = {};
				$state.go("newPost", { type : 'post' , backTo : 'posts' , id: '' , parentView: 'posts'});
			};
			
			/*	Description => The method being called on pulltorefresh action.
			*/
			$scope.onReload = function() {			  
				  $scope.nextPageData = [];
				  $scope.pageNo = 1;
				  $scope.getPosts(1);
			};

			/*	Description => The method to load next page data inside view.
			*/
			$scope.loadMore = function(){			
				if($scope.postsData != undefined && $scope.nextPageData != undefined){
					$.merge($scope.postsData.posts, $scope.nextPageData);
					$scope.showLoadSpinner = true;
				}
				$scope.pageNo = $scope.pageNo + 1;
				$scope.getPosts($scope.pageNo);
			};

		// ************************ Methods for view actions ends ***************************** //	
		
		// ****************** statements to be executed on controller init : starts *********************** //
			$scope.getPosts($scope.pageNo);
		// ****************** statements to be executed on controller init : ends *********************** //
	};

	controllers.postsController.$inject = ['$scope', '$http', '$log', '$state', '$rootScope', '$q', 'PostsService', 'APICaller', 'commonService'];
	/***	Single Post controller 	***/

	controllers.singlePostController = function($rootScope, $scope, $http, $log, $state, $timeout, $stateParams, $filter, APICaller, commonService, CommonScope) {
		// ****************** initialization of variables starts *********************** //	
			$scope.imageDetails = {};
			$scope.$watch('mediaView', function(newValue, oldValue){
				if(newValue == false){					
					$timeout(function(){
						var postContent = $.trim(angular.element('#postBox').text());
						var postHtml = $.trim(angular.element('#postBox').html());
						if( postContent.length == 0 || postHtml.indexOf('<img') == -1 ){
							$rootScope.cursorPos = {};
						}
					},200);
					$scope.init();
					
				} 
				
			});
			
			$scope.init = function(){
				if($stateParams.imageDetails){
					var imageInfo = JSON.parse($stateParams.imageDetails);
					//$stateParams.imagedetails[imageInfo.id] = imageInfo;
					$scope.currentImageInfo = imageInfo;
					$scope.imageDetails[imageInfo.id] = imageInfo;
				}
			};
			
			NProgress.remove();
			if($state.current.name == "postInfo")
				localStorage.setItem('lastAccessedView', "posts");
			else
				localStorage.setItem('lastAccessedView', "pages");
			$scope.postComment = $scope.catDesc = $scope.catSlug = $scope.catName = $scope.formatedDate = "";
			$scope.immediatePublish = $scope.showCommentsInput = false;		
			$scope.catParentSelected = { ID:0, name:"None" };
			$scope.showCustomSelectDiv = false;
			$scope.showLoader = true;//show loader icon till the data gets loaded from API call 

			$scope.siteObject = localStorage.getItem('siteObject');
			$scope.siteObject = JSON.parse($scope.siteObject);
			$scope.$watch('newEditContent', function(newValue, oldValue){					
					if($scope.editing && newValue !== ''){
						$scope.addMediaToPost = false;
						try{
							var postContent = $.trim(angular.element('#postBox').text());
							var postHtml = $.trim(angular.element('#postBox').html());
							if($rootScope.cursorPos && (postContent.length !== 0 || postHtml.indexOf('<img') != -1)){
								commonService.restoreSelection(angular.element("#postBox")[0], $rootScope.cursorPos);
								//angular.element("#postBox").focus();
								document.execCommand("insertHTML", false, $rootScope.newEditContent);
								$timeout(function(){
									$scope.focusOnField();
								}, 100);
							}
							else{								
								$scope.singleData.content = $rootScope.newEditContent;
							}
							$scope.showPlaceholder = false;
							//angular.element("#postBox").focus();
							
						}
						catch(err){							
							$scope.toastMessage = "Could not retieve the media";
							$scope.postToast = true;
						}
					}
				
			});
		// ****************** initialization of variables ends *********************** //		

		// ************************ Methods for API calls starts ***************************** //

			//-------------------------------- GET SINGLE POST STARTS -------------------------------//
			
			/*	Description => The method gets an info on a post
				Param => 1.postID : id of the post
			*/
			
			$scope.getSinglePost = function(postID){
				
				$scope.isOnline = navigator.onLine;
				NProgress.start();
				if($scope.isOnline){
					var getSinglePostUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id+'/posts/'+ postID+'?pretty=1&context=edit';
					var apiCaller = new APICaller('GET', getSinglePostUrl, $scope.getSinglePost_Success, $scope.getSinglePost_Error, '');
					apiCaller.getResult();
				}
				else{
					NProgress.done();
					$scope.toastMessage = "There is no network available";
					$scope.postToast = true;
				}
			};

				$scope.getSinglePost_Success = function(e) {
					$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
					if (this.readyState === 4 && this.status === 200) {
						$scope.singleData = JSON.parse(this.response);
						
						$scope.formatedDate = $scope.singleData.date;
						$scope.immediatePublish = false;
						
						$scope.singleData.tags = Object.keys($scope.singleData.tags).join(", ");
					
						$scope.categories = $scope.singleData.categories;						
						CommonScope.getCategIDList($scope.categories, $scope);
					
						if($scope.singleData.status === "future")
							$scope.singleData.status = "publish";
						
						$scope.singleData.title = $('<div/>').html($scope.singleData.title).text();
						$scope.postType = $scope.singleData.type == "post" ? "Post" : "Page";
							
						$scope.$apply();
						NProgress.done();
					}
				};
				$scope.getSinglePost_Error = function () {
					NProgress.done();
					$scope.toastMessage = "Problem loading post";
					$scope.postToast = true;
					$scope.$apply();
				};

			//-------------------------------- GET SINGLE POST ENDS -------------------------------//

			//-------------------------------- PUBLISH COMMENT STARTS -------------------------------//
			/*	Description => The method publishes the comment made on post
				Param => 1.postID : id of the post
			*/
			$scope.publishComment = function(postID){
				
				$scope.isOnline = navigator.onLine;
				//NProgress.start();
				if($scope.isOnline){
					var commentPostInput = $.trim(angular.element('#commentPostInput').val());
					if(commentPostInput.length !== 0){
						$scope.loading = true;
						var newCommentUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/posts/'+postID+'/replies/new';					
						var payload = 'content='+ encodeURIComponent($scope.postComment);

						var apiCaller = new APICaller('POST', newCommentUrl, $scope.publishComment_Success, $scope.publishComment_Error, payload);
						apiCaller.getResult();
					}
					else{
						angular.element('#commentPostInput').val("");
					}
				}
				else{
					$scope.toastMessage = "There is no network available";
					$scope.postToast = true;
				}
				
			};

				$scope.publishComment_Success = function(e) {
					
					if (this.readyState === 4 && this.status === 200) {
						$scope.loading = false;
						$scope.toastMessage = "Comment added successfully";
						$scope.postToast = true;
						$scope.postComment = "";
						$scope.showCommentsInput = !($scope.showCommentsInput);
						$scope.$apply();
					}
				};
				$scope.publishComment_Error = function (e) {
					$scope.loading = false;
					$scope.toastMessage = "Comment could not be published";
					$scope.postToast = true;
					$scope.$apply();
				};

			//-------------------------------- PUBLISH COMMENT ENDS -------------------------------//

			//-------------------------------- DELETE POST STARTS -------------------------------//
			/*	Description => The method deletes a selected post
			*/
			$scope.deletePost = function(){
				$scope.showDelete = false;
				$scope.deleteLoading = true;
				
				var deletePostUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/posts/'+$scope.singleData.ID+'/delete';
				
				var apiCaller = new APICaller('POST', deletePostUrl, $scope.deletePost_Success, $scope.deletePost_Error, '');
				apiCaller.getResult();
			};

				$scope.deletePost_Success = function() {
					
					if (this.readyState === 4 && this.status === 200) {
						$scope.deleteLoading = false;
						$scope.deleteToast = true;
						$scope.$apply();
					}
				};
				$scope.deletePost_Error = function (e) {
					$scope.deleteLoading = false;
					$scope.$apply();
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						alert("Connection Error: An error occured while deleting the post");
					}
				};
			//-------------------------------- DELETE POST ENDS -------------------------------//

			//-------------------------------- UPDATE POST STARTS -------------------------------//
			/*	Description => The method udpates the changes made in post title\content
			*/
			$scope.updatePost = function(){
				
				var postContent = $.trim(angular.element('#postBox').text());
				if($scope.singleData.title !== "" || postContent.length !== 0){
					if(postContent.length === 0) $scope.singleData.content = "";
					if (window.Notification && Notification.permission === "granted") {
						$scope.notifyUpload = new Notification("Uploading "+$scope.singleData.type, {body: "Uploading "+$scope.singleData.type, icon: $rootScope.originPath+"/assets/img/app_icon-32.png"});
					}
					var categList = CommonScope.getCategStringList($scope.categories,"name");
					categList = categList.substring(0, categList.length-1);

					if($scope.immediatePublish === true){
						$scope.singleData.date = "";
					}
					
					var updatePostUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/posts/'+$scope.singleData.ID;					
					var payload = commonService.updatePost_payload($scope, categList);
					
					var apiCaller = new APICaller('POST', updatePostUrl, $scope.updatePost_Success, $scope.updatePost_Error, payload);
					apiCaller.getResult();
					
				}
				else{
					alert("Either title or content is required");
					if($scope.settings === true){
						$scope.settings = false;
						$scope.editing = true;
						$scope.setTitle();
					}
				}
			};

				$scope.updatePost_Success = function(e) {										
					if (this.readyState === 4 && this.status === 200) {
						if($scope.notifyUpload)
							$scope.notifyUpload.close();
						$scope.editing = false;
						$scope.$apply();						
						if( $state.current.name === "postInfo" )
							$state.go("posts");
						else
							$state.go("pages");
					}
				};
				
				$scope.updatePost_Error = function (e) {
					if($scope.notifyUpload)
						$scope.notifyUpload.close();
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						if (window.Notification && Notification.permission === "granted") {
							var notifyUploadFail = new Notification("Upload failed", {body: $scope.postType+" Upload failed: An error occured while uploading the "+$scope.singleData.type, icon: $rootScope.originPath+"/assets/img/error.png"});
							notifyUploadFail.onclick  = function(){
								alert($scope.postType+" Upload failed: An error occured while uploading the "+$scope.singleData.type);
							}
							$state.go($scope.parentView);
							//$scope.$apply();
						}
					}
				};
			//-------------------------------- UPDATE POST ENDS -------------------------------//

			//-------------------------------- GET CATEGORY STARTS -------------------------------//
			/*	Description => The method fetches the categories in hierarchical fashion
			*/
			$scope.showCategory = function(){
				
				$scope.isOnline = navigator.onLine;
				NProgress.start();
				if($scope.isOnline){
					var getCategoriesUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id+'/categories?pretty=1';
					
					var apiCaller = new APICaller('GET', getCategoriesUrl, $scope.showCategory_Success, $scope.showCategory_Error, '');
					apiCaller.getResult();
				}
				else{
					NProgress.done();
					$scope.toastMessage = "There is no network available";
					$scope.postToast = true;
				}
				
			};

				$scope.showCategory_Success = function(e) {
					
					if (this.readyState === 4 && this.status === 200) {
						$scope.siteCategories = JSON.parse(this.response);

						CommonScope.setCategoryState($scope.siteCategories.categories, $scope);
						CommonScope.setRootTree($scope);
						$scope.categoryView = true;
						$scope.settings = false;
						$scope.viewTitle = "Select categories";
						$scope.$apply();
						NProgress.done();
					}
				};
				$scope.showCategory_Error = function () {
					NProgress.done();
					$scope.toastMessage = "Problem loading Categories";
					$scope.postToast = true;
					$scope.$apply();
				};
			//-------------------------------- GET CATEGORY ENDS -------------------------------//

			//-------------------------------- ADD CATEGORY STARTS -------------------------------//
			/*	Description => The method creates a new category.
			*/
			$scope.addCategory = function(){
				
				if($scope.catName !== ''){
					var addCategoryUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/categories/new';					
					var payload = commonService.addCategory_payload($scope);

					var apiCaller = new APICaller('POST', addCategoryUrl, $scope.addCategory_Success, $scope.addCategory_Error, payload);
					apiCaller.getResult();
				}
				else{
					alert("The category name field is required");
				}
			};

				$scope.addCategory_Success = function(e) {
					if (this.readyState === 4 && this.status === 200) {
						$scope.toastMessage = "Category added successfully!";
						$scope.postToast = true;
						$scope.newCategory = false;
						$scope.categoryView = true;
						$scope.showCategory();
						$scope.$apply();
						
					}
				};
				$scope.addCategory_Error = function (e) {
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						$scope.toastMessage = "Adding category failed";
						$scope.postToast = true;
						$scope.newCategory = false;
						$scope.categoryView = true;
						$scope.$apply();
					}
				};
			//-------------------------------- ADD CATEGORY ENDS -------------------------------//

		$scope.editImgDetails = function(id, edited){				
				//var newObj = $scope.imageDetails;
				if(!edited){
					$scope.currentImageInfo = $scope.imageDetails[id];
					//$scope.currentImageInfo = $stateParams.imagedetails[imageInfo.id];
					//$scope.currentImageInfo[id] = imageInfo;
					//$scope.imageDetails[imageInfo.id].isFeatured = false;
					$scope.currentImageInfo.alignment = "alignnone";
					$scope.currentImageInfo.widthString = ($scope.currentImageInfo.metadata.width).toString();
					if($scope.currentImageInfo.metadata.width > 2000){
						$scope.currentImageInfo.metadata.width = 2000;
						$scope.currentImageInfo.widthString = (2000).toString();
					}
					else if($scope.currentImageInfo.metadata.width < 10){
						$scope.currentImageInfo.metadata.width = 10;
						$scope.currentImageInfo.widthString = (10).toString();
					}
					//$scope.imageDetails.widthInPX = $scope.imageDetails.widthString+"px";
				}
				else{
					$scope.currentImageInfo = $scope.imageDetails[id]; 					
					var innerHtml = $('#container_'+id).html();
					if(innerHtml.indexOf('[caption') !== -1)
						var caption = $('#img_'+id).attr("caption");
		
					else
						var caption = "";
					
					var title = $('#img_'+id).attr("title");
					var alignment = ($('#img_'+id).attr("class")).split(" ");
					var imgSrc = $('#img_'+id).attr("src");
					var width = imgSrc.substring(imgSrc.indexOf("?w=")+3);
					//var isFeatured = $('#img_'+id).attr("isFeatured");					
					$scope.currentImageInfo.title = title;
					$scope.currentImageInfo.caption = caption;
					$scope.currentImageInfo.alignment = alignment[0];
					$scope.currentImageInfo.metadata.width = parseInt(width);
					$scope.currentImageInfo.widthString = width;
					//$scope.imageDetails.widthInPX = $scope.imageDetails.widthString+"px";
					//$scope.imageDetails[id].isFeatured = isFeatured;
					/* if($scope.imageDetails.metadata.width > 2000){
						$scope.imageDetails.metadata.width = 2000;
					}
					else if($scope.imageDetails.metadata.width < 10){
						$scope.imageDetails.metadata.width = 10;
					} */
				}
				//angular.element('#postBox').blur();
				$timeout(function(){
					angular.element('#imageTitleEdit').focus();
				},100);
				$scope.imageSettings = true;
				$scope.setTitle();
				
			};
			
			$scope.setImageAttr = function(id){				
				$scope.imageDetails[id] = $scope.currentImageInfo;
				//$scope.imageDetails.widthString = $scope.changeToString($scope.imageDetails.metadata.width);
				$scope.currentImageInfo.metadata.width = parseInt($scope.currentImageInfo.widthString);
				
				if($scope.currentImageInfo.caption != ""){
					
					var imageAttachString = '<div id="container_'+id+'" class="outerContanier">[caption id="" align="'+$scope.currentImageInfo.alignment+'" width="'+$scope.currentImageInfo.widthString+'" caption="'+$scope.currentImageInfo.caption+'"]<div class="imageContainer" ng-click="editImgDetails('+id+', true)"><img id="img_'+id+'" class="'+$scope.currentImageInfo.alignment+' size-full" title="'+$scope.currentImageInfo.title+'" alt="image" src="'+$scope.currentImageInfo.link+'?w='+$scope.currentImageInfo.widthString+'" caption="'+$scope.currentImageInfo.caption+'"/><span class="editimage"><img src="/assets/img/edit-image.png"/></span></div>[/caption]</div></br>&nbsp;';
										
					/* $('#postBox').find($('#contanier_'+$scope.imageDetails.id))
					console.log("innerhtml", innerhtml); */
					$('#container_'+id).replaceWith($(imageAttachString));
					//$('#contanier_'+$scope.imageDetails.id).html(imageAttachString);
					$('#container_'+id+' .imageContainer').css("width",$scope.currentImageInfo.metadata.width+"px");
					$('#container_'+id+' .imageContainer > img').css("width",$scope.currentImageInfo.metadata.width+"px");
				}
				else{
					
					$('#img_'+id).attr("title",$scope.currentImageInfo.title);
					var imgSrc = $('#img_'+id).attr("src");
					var imgClass = $('#img_'+id).attr("class");
					
					var imgWidth = imgSrc.substring(imgSrc.indexOf("?w=")+3);
					imgSrc = imgSrc.replace(imgWidth, $scope.currentImageInfo.widthString);
										
					var classArray = imgClass.split(" ");					
					angular.forEach(classArray,function(value, index){
						if(value.indexOf('align') !== -1)
							classArray[index] = $scope.currentImageInfo.alignment;
					});
					imgClass = classArray.join(" ");
					
					/* $('#img_'+$scope.imageDetails.id).attr("src",imgSrc);
					$('#img_'+$scope.imageDetails.id).attr("class",imgClass);
					$('#img_'+$scope.imageDetails.id).attr("isFeatured",$scope.imageDetails.isFeatured);
					//$('#img_'+$scope.imageDetails.id).attr("ng-click","editImgDetails('"+$scope.imageDetails.id+"')");
					var imgElement = $('#img_'+$scope.imageDetails.id);
					*/
					
					var imageAttachString = '<div class="imageContainer" ng-click="editImgDetails('+id+', true)"><img id="img_'+id+'" class="'+imgClass+'" title="'+$scope.currentImageInfo.title+'" alt="image" src="'+imgSrc+'" caption="'+$scope.currentImageInfo.caption+'"/><span class="editimage"><img src="/assets/img/edit-image.png"/></span></div>';
					
					
					$('#container_'+id).html(imageAttachString);
					$('#container_'+id+' .imageContainer').css("width",$scope.currentImageInfo.metadata.width+"px");
					
					$('#container_'+id+' .imageContainer > img').css("width",$scope.currentImageInfo.metadata.width+"px");
					
				}
				
				/* if($scope.imageDetails[id].isFeatured){
					$scope.featuredList = ($scope.imageDetails[id].id).toString();
				}
				else{
					$scope.featuredList = "";
				} */
					$scope.backToView();
					//angular.element('#postBox').focus();
			};
			
			$scope.validate = function(id){
				$scope.currentImageInfo.metadata.width = parseInt($scope.currentImageInfo.widthString);
			};
			
			$scope.validateWidth = function(id){
				if($scope.currentImageInfo.metadata.width !== null){
					if($scope.currentImageInfo.metadata.width > 2000){
						$scope.currentImageInfo.metadata.width = 2000;
					}
						$scope.currentImageInfo.widthString = ($scope.currentImageInfo.metadata.width).toString();
				}
			};
			
			$scope.ifEmpty = function(id){
				if($scope.currentImageInfo.metadata.width == null){					
					$scope.currentImageInfo.metadata.width = parseInt($scope.currentImageInfo.widthString);
				}
				if($scope.currentImageInfo.metadata.width < 10){					
					$scope.currentImageInfo.metadata.width = 10;
					$scope.currentImageInfo.widthString = ($scope.currentImageInfo.metadata.width).toString();
				}
			};
		// ************************ Methods for API calls Ends ***************************** //
		// ************************ Methods for view actions starts ***************************** //

			/*	Description => The method sets the Title for the view initially.
			*/
			$scope.setTitle = function(){
				if($state.current.name == "postInfo"){
					$scope.viewTitle = "Posts";
					$scope.currentView = "postInfo";
					$scope.parentView = "posts";
					$scope.type = "post";
				}
				
				else if($scope.imageSettings)
					$scope.viewTitle = "Image settings";
					
				else{
					$scope.viewTitle = "Pages";
					$scope.currentView = "pageInfo";
					$scope.parentView = "pages";
					$scope.type = "page";
				}
			};

			/*	Description => The method sets the styles on contentEdior during click n keyboard events
				Params => 1. event : event object.
			*/
			$scope.preventClick = function( $event ){			
				CommonScope.preventClick($event, $scope);
			};
		
			/*	Description => The method sets focus
			*/
			$scope.focusOnField = function(){
				CommonScope.focusOnField($scope);
			};

			/*	Description => The method highlights the selected option for editing the content.
				Params => 1. objElement : html element where the cursor is set on click or while typing.
			*/
			$scope.setEditorState = function( objElement ){
				CommonScope.setEditorState(objElement, $scope);
			};

			/*	Description => The method sets the visual of the keypad
				Params => 1. event : event object.
			*/					
			$scope.handleClick = function( event ){
				CommonScope.handleClick(event,$scope);				
			};
		
			/*	Description => The method sets the visual of the keypad
				Params => 1. event : event object.
			*/					
			$scope.formatText = function(event){
				CommonScope.formatText(event, $scope);
			};
		
			/*	Description => The method executes the text editor commands
				Params => 1. cmd : command name to be executed.
						2. sValue: value of the command to be executed.
			*/
			$scope.formatDoc = function(cmd, sValue) {
				CommonScope.formatDoc(cmd, sValue, $timeout, $scope);			
			};

			/*	Description => The method removes the category when unchecked
				Params => 1. categObject : categ object to be deleted.
			*/
			$scope.removeCategory = function(categObject){
				CommonScope.removeCategory(categObject,$scope);
			};
		
			/*	Description => The method changes the state to "preview" view
			*/
			$scope.showPreview = function(){
				CommonScope.showPreview($scope);
			};
			
			/*	Description => The method changes the state to "editing" view
			*/
			$scope.backToEdit = function(){
				$scope.preview = false;
				$scope.settings = false;
				//$scope.editing = true;
				$scope.editing = true;
				$scope.viewTitle = $scope.siteObject.siteName;
				//$scope.getSinglePost($stateParams.id);
			};
						
			/*	Description => The method redirects back to "post/page list" view.
			*/
			$scope.backToMain = function(){	
				CommonScope.backToMain($scope.parentView, {}, NProgress);
			}; 
			
			$scope.backToView = function(){
				$scope.imageSettings = false;
				$scope.setTitle();
			}

			/*	Description => The method that conditionally navigates back to previous manu.
			*/
			$scope.goBack = function(){
				if ($scope.editing){
					if(!$scope.imageSettings)
						$scope.cancelModify();
					else
						$scope.backToView();
				}
				else if ($scope.settings || $scope.preview)
					$scope.backToEdit();
				else if ($scope.categoryView)
					CommonScope.backToSetting($scope, NProgress);
				else if ($scope.newCategory)
					CommonScope.backToCategory($scope);
				else
					$scope.backToMain();
			};

			/*	Description => The method recalls addCategoryView function.
			*/
			$scope.addItem = function(){
				if($scope.categoryView == true){
					NProgress.done();
					CommonScope.addCategoryView($scope);
				}
				else
					$scope.addPost();
			};

			/*	Description => The method that conditionally saves the data.
			*/
			$scope.udpateItem = function(){
				if($scope.newCategory == true)
					$scope.addCategory();
				else
					$scope.updatePost();
			};

			/*	Description => The method that sets the state to "settings" view.
			*/		
			$scope.showSettings = function(){
				CommonScope.showSettings($scope);
			};		
						
			/*	Description => The watch build on formated date variable.				
			*/		
			$scope.$watch('formatedDate', function(newValue, oldValue) {
					if ( newValue !== oldValue) {
						$scope.singleData.date = oldValue;
						$scope.formatedDate = CommonScope.formatDate(newValue);
				}
			});
			
			/*	Description => The function that enables/disables the textinput.
				params => 1.event : event object
			*/			
			$scope.disableDate = function(event){
				CommonScope.disableDate(event);
			};

			/*	Description => The function that handles the category checkbox toggle.
				params => 1.categObject : category object binded to checkbox
						  2.event : event object.
			*/
			$scope.toggleChecked = function(categObject,event){
				CommonScope.toggleChecked(categObject, event, $scope);
			};
			
			/*	Description => The function returns the category object for the given id.
				params => 1.categID : category ID
			*/
			$scope.getCategoryByID = function(categID){				
		    	return CommonScope.getCategoryByID(categID, $scope);
			};

			/*	Description => The function adds a child category to parameter sent
			*/
			$scope.addChildren = function(parentCategory) {
				CommonScope.addChildren(parentCategory, $scope);
			};

			/*	Description => The function adds a child category to parameter sent
			*/
			$scope.selectCategParent = function(category) {
				CommonScope.selectCategParent(category, $scope);
			};

			/*	Description => The function gets executed on pull to refresh
			*/		
			$scope.onReload = function() {
				  $scope.showCategory();
			};
			
			/*	Description => The function handles the share activity of view.
			*/
			$scope.shareURL = function(){
				var activity = "";
				activity = new MozActivity({
				  name: "share",
				  data: { type: "url", number: 1, url: $scope.singleData.short_URL }
				});

				activity.onsuccess = function() {
				  var success = this.result;
				};

				activity.onerror = function() {
				 // console.log(this.error);
				};
			};
			
			/*	Description => The state goes back to parentView
			*/	
			$scope.changeState = function(){
				$state.go($scope.parentView);
			};
		
			/*	Description => The state changes to "editing"
			*/
			$scope.modifyPost = function(){
				$scope.editing = true;
				if($('.editPost').find('.editimage').length > 0){
					 $('.editPost').find('.editimage').remove();
				}
				$scope.showPlaceholder =  $scope.singleData.content == ""? true : false;
				angular.element("#editContentTools").children().toggleClass('actLink',false);
				$scope.viewTitle = $scope.siteObject.siteName;
			}; 

			/*	Description => The state from "editing" is changes back to view
			*/
			$scope.cancelModify = function(){
				$scope.editing = false;
				if($stateParams.editState)
					$stateParams.editState = false;
				$scope.getSinglePost($stateParams.id);
				$scope.setTitle();
			};
		
			/*	Description => The view changes to add new post/page
			*/
			$scope.addPost = function(){	
				NProgress.remove();
				$rootScope.newContent = "";
				$rootScope.newEditContent = "";
				//$rootScope.cursorPos = {};
				$state.go("newPost", { type : $scope.type, backTo : $scope.currentView , id: $scope.singleData.ID, parentView:  $scope.parentView});
			};

			/*	Description => Redirects to the view State i.e. web view of the page/post
			*/
			$scope.viewSite = function(){
				var postTitle = "";
				if($scope.singleData.title != "")
					postTitle = $scope.singleData.title;
				else
					postTitle = $scope.siteObject.siteName;
				NProgress.remove();
				$state.go("viewSite", { id : $scope.singleData.ID, backTo : $scope.currentView , 
					url: $scope.singleData.URL, title: postTitle, site_id : null});
			};

			/*	Description => Comment input is shown/hidden
			*/
			$scope.comment = function(){			
				$scope.showCommentsInput = !($scope.showCommentsInput);
			};
			
			$scope.showAddMediaOpt = function(){
				CommonScope.showAddMediaOpt($scope);
				/* $scope.cursorPos = CommonScope.getCaretPosition();*/
				/* $scope.cursorPos = document.caretRangeFromPoint(event.clientX, event.clientY);*/
			}
			
			$scope.openPickActivity = function(){
				CommonScope.openPickActivity($scope);
			}
			
			$scope.createGallery = function(){
				CommonScope.createGallery($scope, $stateParams);
			};
			
			$scope.selectSingleMedia = function(){
				CommonScope.selectSingleMedia($scope, $stateParams);
			};

		// ************************ Methods for view actions ends ***************************** //		

		// ****************** statements to be executed on controller init : starts *********************** //
			$scope.setTitle();
			$scope.getSinglePost($stateParams.id);
			
		// ****************** statements to be executed on controller init : ends *********************** //
		
	};
	controllers.singlePostController.$inject = ['$rootScope', '$scope', '$http', '$log', '$state', '$timeout', '$stateParams', '$filter', 'APICaller', 'commonService', 'CommonScope'];
	angular
		.module('wp-controllers', ['ngSanitize'])
 		.controller(controllers);
})();

