(function() {
	'use strict';

	var controllers = {};

	/***	Pages list controller 	***/
	controllers.previewBlogController = function($scope, $http, $log, $rootScope, $state, $q, APICaller, commonService, $stateParams) {

		// ****************** initialization of variables starts *********************** //
			if($stateParams.viewScreen == undefined || $stateParams.viewScreen == "previewBlog"){
				$scope.showPreviewBlog = true;
			}else {
				$scope.showPreviewBlog = false;
				return;
			}

			if($stateParams.itemObj){
				var item = JSON.parse($stateParams.itemObj);
				$stateParams = item.stateParams;
			}
			$scope.nextPageData = [];
			$scope.siteObject = localStorage.getItem('siteObject');
			$scope.siteObject = JSON.parse($scope.siteObject);
			$scope.paramObject = JSON.parse($stateParams.stringObject);
			$scope.showLoader = false;
			NProgress.remove();						
			//$scope.urlInUse = $stateParams.url;
		// ****************** initialization of variables ends *********************** //
		
		// ************************ Methods for API calls and their response starts ***************************** //

			//-------------------------------- GET FRESHLY PRESSED STARTS -----------------------------------//
			
			/*	Description => The method fetching the freshly blogged posts on wordpress
				Params => 1. pageNo : page number of the data.
			*/
			$scope.getpostsByURL = function( url ){
				if($scope.pageNo == 1)
					$scope.showLoader = true;
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){					
					var apiCaller = new APICaller('GET',url, $scope.getpostsByURL_Success, $scope.getpostsByURL_Error);
					apiCaller.getResult();
				}
				else{
						NProgress.done();						
						$scope.toastMessage = "There is no network connection";
						$scope.postToast = true;
						$scope.showLoadSpinner = false;
				}
			};

				$scope.getpostsByURL_Success = function(e) {
					if (this.readyState === 4 && this.status === 200) {						
						$scope.showLoader = false;
						var jsonResponse = JSON.parse(this.response);												

						if($scope.pageNo == 1){							
							$scope.postList = jsonResponse;
							$scope.loadMore();
							console.log("$scope.postList", $scope.postList);
						}
						else{
							$scope.nextPageData = jsonResponse.posts;
							$scope.showLoadSpinner = false;
						}
													
						$scope.$apply();
						NProgress.done();
					}
				};
				$scope.getpostsByURL_Error = function () {
					$scope.showLoader = false;
					NProgress.done();					
					$scope.toastMessage = "Problem loading pages";
					$scope.postToast = true;
					$scope.$apply();
				};

			//-------------------------------- GET FRESHLY PRESSED ENDS -----------------------------------//
			
			//-------------------------------- GET POSTS OF A TAG STARTS -----------------------------------//

			/*	Description => The method fetching the posts user has liked
				Params => 1. pageNo : page number of the data.
			*/
			$scope.getDataByUrl = function(URL, dataObjName){
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					var apiCaller = new APICaller('GET',URL, $scope.getDataByUrl_Success(dataObjName), $scope.getDataByUrl_Error);
					apiCaller.getResult();
				}
				else{
						NProgress.done();						
						$scope.toastMessage = "There is no network connection";
						$scope.postToast = true;
						$scope.showLoadSpinner = false;
				}
			};

				$scope.getDataByUrl_Success = function(dataObjName) {
					return function() {
						if (this.readyState === 4 && this.status === 200) {
							var jsonResponse = JSON.parse(this.response);
														
							if(dataObjName == "tagFollowed")
								$scope[dataObjName] = jsonResponse.subscribed;
							else
								$scope[dataObjName] = jsonResponse.blogs? jsonResponse.blogs : jsonResponse;
							
							$scope.$apply();
							NProgress.done();
						}
					};
				};
				$scope.getDataByUrl_Error = function () {
					NProgress.done();					
					$scope.toastMessage = "Problem loading pages";
					$scope.postToast = true;
					$scope.$apply();
				};

			//-------------------------------- GET POSTS OF A TAG ENDS -----------------------------------//
			
			//-------------------------------- GET FOLLOW/UNFOLLOW BLOG STARTS -----------------------------------//
			$scope.followBlog = function(postData, event){
				postData.is_following = 1;

				var siteID = $scope.getSiteID(postData);

				var followBlogUrl = commonService.APIBaseUrl + siteID +'/follows/new?pretty=1';
				var apiCaller = new APICaller('POST',followBlogUrl, $scope.followBlogToggle_Success, $scope.followBlogToggle_Error);
				apiCaller.getResult();

				if(event)
					event.stopPropagation();
			};
			
			$scope.unfollowBlog = function(postData, event){
				postData.is_following = 0;				
				var siteID = $scope.getSiteID(postData);
				
				var unfollowBlogUrl = commonService.APIBaseUrl + siteID +'/follows/mine/delete?pretty=1';
				var apiCaller = new APICaller('POST',unfollowBlogUrl, $scope.followBlogToggle_Success, $scope.followBlogToggle_Error);
				apiCaller.getResult();

				if(event)
					event.stopPropagation();
			};
			
				$scope.followBlogToggle_Success = function(){
					// return function(){
						if (this.readyState === 4 && this.status === 200) {
							var followResponse = JSON.parse(this.response);
							if(followResponse.success){									
							}
							else{
								$scope.toastMessage = "Couldn't complete the action";
								$scope.postToast = true;
							}
							$scope.$apply();
						}
					// };
				};
				
				$scope.followBlogToggle_Error = function(e){
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						$scope.toastMessage = "Couldn't complete the action";
						$scope.postToast = true;
						$scope.$apply();
					}					
				};
			//-------------------------------- GET FOLLOW/UNFOLLOW BLOG ENDS -----------------------------------//

			//-------------------------------- GET FOLLOW/UNFOLLOW BLOG STARTS -----------------------------------//
			$scope.addDeleteTag = function(action){
				var url = "";
				if(action = "add"){
					url = commonService.APIUrlCommon + 'read/tags/' + $stateParams.blogTitle + '/mine/new?pretty=1';
					$scope.tagFollowed = 1;
				}
				else{
					url = commonService.APIUrlCommon + 'read/tags/' + $stateParams.blogTitle + '/mine/delete?pretty=1';
					$scope.tagFollowed = 0;
				}

				var apiCaller = new APICaller('POST',url, $scope.addDeleteTag_Success(action), $scope.addDeleteTag_Error);
				apiCaller.getResult();
			};
			
				$scope.addDeleteTag_Success = function(action){
					// return function(){
						if (this.readyState === 4 && this.status === 200) {
							$scope.showView($scope.tagType);
							$scope.$apply();
						}
					// };
				};
				
				$scope.addDeleteTag_Error = function(e){
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						$scope.toastMessage = "Couldn't complete the action";
						$scope.postToast = true;
						$scope.$apply();
					}					
				};
			//-------------------------------- GET FOLLOW/UNFOLLOW BLOG ENDS -----------------------------------//

			$scope.likeUnlikePost = function(postData){
				postData.i_like = Math.abs(postData.i_like - 1);				
				var apiUrl = "";
				if( postData.i_like ==1 ){
					apiUrl = commonService.APIBaseUrl + postData.site_ID +'/posts/'+ postData.ID +'/likes/new?pretty=1';
					postData.like_count ++;
				}
				else{
					apiUrl = commonService.APIBaseUrl + postData.site_ID +'/posts/'+ postData.ID +'/likes/mine/delete?pretty=1';
					postData.like_count --;
				}
				var apiCaller = new APICaller('POST',apiUrl, $scope.likeUnlikePost_Success, $scope.likeUnlikePost_Error);
				apiCaller.getResult();
			};
				$scope.likeUnlikePost_Success = function(){
					if (this.readyState === 4 && this.status === 200) {
						var likeResponse = JSON.parse(this.response);
						if(likeResponse.success){							
						}
						else{
							$scope.toastMessage = "Couldn't complete the action";
							$scope.postToast = true;
						}
						$scope.$apply();	
					}
				};
				$scope.likeUnlikePost_Error = function(e){
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						$scope.toastMessage = "Couldn't complete the action";
						$scope.postToast = true;
						$scope.$apply();
					}
				};		
			

		// ************************ Methods for API calls ends ***************************** //

		// ************************ Methods for view actions starts ***************************** //

			$scope.getSiteID = function (postData){				
				var siteID = "";
				if(postData.site_ID)
					siteID = postData.site_ID;
				else 
					siteID = postData.blog_id? postData.blog_id : postData.ID;

				return siteID;
			}

			$scope.tagFollowStatus = function (tagName){
				url = commonService.APIUrlCommon + "read/tags/" + tagName + "/mine";
				if(url !="")
					$scope.getDataByUrl(url, "tagFollowed");
			}
			
			$scope.getBlogsbyIds = function(blogArray){
				var batchURL = commonService.APIUrlCommon + 'batch/?'
				angular.forEach(blogArray,function(value,index){
					//var appendChar = index == 0? "urls[]=/read/feed/" : "&urls[]=/read/feed/";
					var appendChar = index == 0? "urls[]=/sites/" : "&urls[]=/sites/";
					
					batchURL = batchURL + appendChar + value.blog_ID;
				});				
				$scope.getDataByUrl(batchURL, "blogList");
			}

			$scope.getAttrVal = function (object, attribute){
				var returnStr = "";
				switch(attribute){
					case 'title':
						returnStr = object.title? object.title : object.name;						
					break;
					case 'blog_domain':						
						returnStr = object.blog_domain? object.blog_domain : object.URL;
						returnStr = returnStr.replace("http://", "");
					break;
				}
				return returnStr;
			}

			$scope.getPosts = function(url){
				//if( $scope.postsCategory != title || forceExecute == true){
				$scope.nextPageData = [];
				$scope.postList = undefined;
				//$scope.postsCategory = title;
				//url = url == ""? (commonService.APIUrlCommon + 'freshly-pressed/') : url ;
				$scope.urlInUse = url;
				$scope.pageNo = 1;
				var newUrl = $scope.urlInUse + "?page=1";				
				$scope.getpostsByURL(newUrl);
				//}
			};

			$scope.gotoReblog = function (postData){
				if(postData.is_reblogged == 0) {
					var item = JSON.stringify( $stateParams );
					var jsonStr = JSON.stringify(postData);
					$state.go("readerSub", {backTo: "readerSub", postInfo: jsonStr, viewScreen:"reblog",
						stringObject: item });
				}
			}

			$scope.gotoCommentsWithPost = function (postData){	
				var title ="";
				if ($scope.paramObject.previewFor ==  "site")
					title = "Preview Blog";
				else					
					title = $stateParams.blogTitle;
				
				//var item = JSON.stringify( {stateParams : $stateParams, title: title } );
				item = JSON.stringify( $stateParams );
				$state.go("readerSub", {backTo: "readerSub", postID: postData.ID, viewScreen:"commentsWithPost", 
					site_ID: postData.site_ID, stringObject: item });
			};

			$scope.previewBlog = function(urlObject, previewFor){
				var url  = "";
				//var item = {URL : $scope.urlInUse, title : $scope.postsCategory, previewFor: previewFor, tagType: $scope.tagType};
				var item = { stateParams : $stateParams, previewFor: previewFor };
				if(previewFor == "tag")
				{
					item.title = urlObject;
					url = commonService.APIUrlCommon + "read/tags/" + urlObject + "/posts";
					var blogTitle = urlObject;
					//$state.go("previewBlog", {prevScreen: "reader", blogTitle: blogTitle, dataUrl: url, stringObject: JSON.stringify(item) });
					$state.go("readerSub", {backTo: "readerSub", blogTitle: blogTitle, viewScreen:"previewBlog", dataUrl: url, stringObject: JSON.stringify(item) });
				
				}else if (previewFor == "site"){
					item.siteID = urlObject.site_ID? urlObject.site_ID : urlObject.blog_id;
					item.siteID = item.siteID? item.siteID : urlObject.ID;
					item.title = "Preview Blog";

					url = commonService.APIBaseUrl + item.siteID + "/posts";
					var blogTitle = urlObject.site_name? urlObject.site_name : urlObject.name;
					blogTitle = blogTitle? blogTitle : urlObject.title;
					//$state.go("previewBlog", {prevScreen: "reader", blogTitle: blogTitle, dataUrl: url, stringObject: JSON.stringify(item) });
					$state.go("readerSub", {backTo: "readerSub", blogTitle: blogTitle, viewScreen:"previewBlog", dataUrl: url, stringObject: JSON.stringify(item) });
				}

			};

			/*	Description => The method to hide the menu section.
				Params => 1. event : event object.
			*/
			$scope.hideMenu = function(event){
				if($scope.showDrawer === true){
					if ( event.target.className.indexOf( 'drawerIcon' ) == -1 )
						$scope.showDrawer = false;
				}
			};

			/*	Description => The method being called on pulltorefresh action.
			*/
			$scope.onReload = function() {
				//$scope.getPosts($scope.urlInUse, $scope.postsCategory, true);
			};

			/*	Description => The method to load next page data inside view.
			*/
			$scope.loadMore = function(){
				if($scope.postList != undefined && $scope.nextPageData != undefined){
					$.merge($scope.postList.posts, $scope.nextPageData);
					$scope.showLoadSpinner = true;
				}
				$scope.pageNo = $scope.pageNo + 1;
				var newUrl = $scope.urlInUse + "?page=" + $scope.pageNo;				
				$scope.getpostsByURL(newUrl);
			};

			$scope.goBack = function(){
				if($stateParams.backTo == "commentsWithPost")
					$state.go($stateParams.backTo, {returnObj: $stateParams.stringObject});
				else{
					$scope.showPreviewBlog = false;
					$state.go($stateParams.backTo, {itemObj: $stateParams.stringObject});
				}
			};

			$scope.getExcerpt = function(excerpt){
				return commonService.getExcerpt(excerpt);
			};			

			$scope.getImage = function(postObj){
				console.log("postObj", postObj);
				var imgSrc = postObj.editorial? postObj.editorial['image'] : "";
				var featuredMedImg = postObj.featured_media? postObj.featured_media.uri : "";
				var featuredImg = postObj.featured_image? postObj.featured_image : "";

				if(imgSrc != undefined && imgSrc != "")
					return imgSrc;
				else if(featuredMedImg != undefined && featuredMedImg != "")
					return featuredMedImg;
				else if(featuredImg != undefined && featuredImg != "")
					return featuredImg;

				return "";
			};

			$scope.getPostTag = function(post){
				var postCount = 0;
				var tagName = "";
				angular.forEach(post.tags,function(item,index){
					if( item.post_count > postCount){
						tagName = item.name;
						postCount = item.post_count;
					}
				});
				if(tagName == "" && post.editorial)
					tagName = post.editorial.highlight_topic_title == ""? post.editorial.highlight_topic : post.editorial.highlight_topic_title;

				return tagName;
			};

			$scope.viewSite = function(siteObj){
				var item = JSON.stringify( $stateParams );
				$state.go("viewSite", {backTo: "readerSub", url: siteObj.URL, site_id : siteObj.ID, stringObject: item });
			};

		// ************************ Methods for view actions ends ***************************** //
		
		// ****************** statements to be executed on controller init : starts *********************** //						
			if ($scope.paramObject.previewFor ==  "site"){				
				var url = commonService.APIBaseUrl + $scope.paramObject.siteID;
				$scope.getDataByUrl(url,"previewSiteInfo");
				$scope.blogTitle =  $stateParams.blogTitle;
				$scope.viewTitle = "Preview Blog";
			}else{				
				$scope.blogTitle =  "<span class='grayText'>Posts tagged </span>" + $stateParams.blogTitle;
				$scope.tagFollowStatus($stateParams.blogTitle);
				$scope.viewTitle = "Preview Tag";
			}

				
			$scope.getPosts($stateParams.dataUrl);
			
		// ****************** statements to be executed on controller init : ends *********************** //
	};	
	controllers.previewBlogController.$inject = ['$scope', '$http', '$log', '$rootScope', '$state', '$q', 'APICaller', 'commonService', '$stateParams'];
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

