(function() {
	'use strict';

	var controllers = {};

	/***	Pages list controller 	***/
	controllers.readerController = function($scope, $http, $log, $rootScope, $state, $q, APICaller, commonService, $stateParams, $filter) {

		// ****************** initialization of variables starts *********************** //					
			if( !localStorage.getItem('lastAccessedView') )
			{
				$scope.showDrawer = true;
			}

			localStorage.setItem('lastAccessedView', "reader");
			$scope.currentMenu = "reader";
		
			var tagStored = localStorage.getItem('readerOptionSelected');
			tagStored = tagStored != undefined? JSON.parse(tagStored) : undefined;
			$scope.menu = {};		
			if(tagStored != undefined){
				$scope.defaultCategory = tagStored.title;
				$scope.urlInUse = tagStored.URL;
			}else {
				$scope.defaultCategory = "Freshly Pressed";
				$scope.urlInUse = "";
			}
			$scope.nextPageData = [];
			$scope.siteObject = localStorage.getItem('siteObject');
			$scope.siteObject = JSON.parse($scope.siteObject);
			NProgress.remove();
			$scope.selectedTag = "Followed Tags";
			$scope.tagType = null;
			$scope.viewTitle = "";
			$scope.recommendationsPageNo = 0;
			$scope.FPPageNo = 0;
			$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
		// ****************** initialization of variables ends *********************** //
		
		// ************************ Methods for API calls and their response starts ***************************** //

			//-------------------------------- GET FRESHLY PRESSED STARTS -----------------------------------//
			
			/*	Description => The method fetching the freshly blogged posts on wordpress
				Params => 1. pageNo : page number of the data.
			*/
			$scope.getpostsByURL = function( url ){
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					
					var apiCaller = new APICaller('GET',url, $scope.getpostsByURL_Success, $scope.getpostsByURL_Error);
					apiCaller.getResult();
				}
				else{
						NProgress.done();						
						$scope.toastMessage = "There is no network connection";
						$scope.readerToast = true;
						$scope.showLoadSpinner = false;
				}
			};

				$scope.getpostsByURL_Success = function(e) {
					
					$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
					if (this.readyState === 4 && this.status === 200) {

						var jsonResponse = JSON.parse(this.response);						
						
						if($scope.pageNo == 1){														
							if ($scope.postsCategory != "Freshly Pressed"){
								$scope.postList = jsonResponse;
								$scope.loadMore();
							}							
							// else{
							// 	var filteredObj = commonService.getfilteredUnfilteredCollection(jsonResponse.posts, "is_following", 1);
							// 	$log.info('filteredObj', filteredObj);
							// 	$scope.postList = {posts : filteredObj.unfilteredCollection};
							// }
						}
						else{
							$scope.nextPageData = jsonResponse.posts;
							$scope.showLoadSpinner = false;
							if( $scope.postList.posts == $scope.nextPageData )
							{								
								$scope.nextPageData=[];
							}
						}
													
						$scope.$apply();
						NProgress.done();
					}
				};
				$scope.getpostsByURL_Error = function () {
					NProgress.done();					
					$scope.toastMessage = "Problem loading pages";
					$scope.readerToast = true;
					$scope.$apply();
				};

			//-------------------------------- GET FRESHLY PRESSED ENDS -----------------------------------//
			
			//-------------------------------- GET POSTS OF A TAG STARTS -----------------------------------//

			/*	Description => The method fetching the posts user has liked
				Params => 1. pageNo : page number of the data.
			*/
			$scope.getDataByUrl = function(URL, dataObjName){
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					var apiCaller = new APICaller('GET',URL, $scope.getDataByUrl_Success(dataObjName), $scope.getDataByUrl_Error);
					apiCaller.getResult();
				}
				else{
						NProgress.done();
						$scope.toastMessage = "There is no network connection";
						$scope.readerToast = true;
						$scope.showLoadSpinner = false;
				}
			};

				$scope.getDataByUrl_Success = function(dataObjName) {
					
					return function() {
						if (this.readyState === 4 && this.status === 200) {
							$scope.showLoader = false;//remove loader icon when data gets loaded from API call
							var jsonResponse = JSON.parse(this.response);							

							
							if(dataObjName == "blogIdList")
								$scope.getBlogsbyIds(jsonResponse.subscriptions);
							else if($scope.tagType != 'RB'){
								$scope[dataObjName] = null;
								$scope[dataObjName] = jsonResponse.blogs? jsonResponse.blogs : jsonResponse;

								if( $scope.tagType == 'FT' ){
									if(jsonResponse.tags){
										$scope.followedTags = jsonResponse.tags;	
										$scope[dataObjName].tags = commonService.getArrayFrmObject(jsonResponse.tags);
									}

								}else if ( $scope.tagType == 'PT' ){									
									if(jsonResponse.tags){
										$scope.followedTags = jsonResponse.tags;
										$scope.tagList.tags = commonService.getPopularTags(jsonResponse.tags);
									}
								}else if ( $scope.tagType == 'FB' ){
									$scope.followedBlogs = jsonResponse;
									$scope[dataObjName] = commonService.getArrayFrmObject(jsonResponse);
								}

							}else{
								$scope[dataObjName] = jsonResponse.blogs;
								$scope.showRecommendations();
							}


							if (dataObjName == "freshlyPressedList"){								
								$scope[dataObjName] = jsonResponse.posts;								
								$scope.showFreshlyPressed();
							}							

							if( !($scope.recommendationsBlogList) )
								$scope.getMoreRecommendationsData();
							
							$scope.$apply();
							NProgress.done();
						}
					};
				};
				$scope.getDataByUrl_Error = function () {
					NProgress.done();					
					$scope.toastMessage = "Problem loading pages";
					$scope.readerToast = true;
					$scope.$apply();
				};

			//-------------------------------- GET POSTS OF A TAG ENDS -----------------------------------//
			
			//-------------------------------- GET FOLLOW/UNFOLLOW BLOG STARTS -----------------------------------//
			$scope.followBlog = function(postData, event){
				postData.is_following = 1;

				var siteID = $scope.getSiteID(postData);

				var followBlogUrl = commonService.APIBaseUrl + siteID +'/follows/new?pretty=1';
				var apiCaller = new APICaller('POST',followBlogUrl, $scope.followBlogToggle_Success(postData), $scope.followBlogToggle_Error);
				apiCaller.getResult();
				if(event)
					event.stopPropagation();
				//event.prevenDefault();
			};
			
			$scope.unfollowBlog = function(postData, event){
				postData.is_following = 0;				
				var siteID = $scope.getSiteID(postData);
				
				var unfollowBlogUrl = commonService.APIBaseUrl + siteID +'/follows/mine/delete?pretty=1';
				var apiCaller = new APICaller('POST',unfollowBlogUrl, $scope.followBlogToggle_Success(postData), $scope.followBlogToggle_Error);
				apiCaller.getResult();
				event.stopPropagation();
			};
			
				$scope.followBlogToggle_Success = function(postData){
					return function(){
						if (this.readyState === 4 && this.status === 200) {
							var followResponse = JSON.parse(this.response);
							if(followResponse.success){	
								
								if (postData.is_following == 1)
								{
									$scope.toastMessage = "Blog followed";
									$scope.readerToast = true;
								}else {
									$scope.toastMessage = "Blog Unfollowed";
									$scope.readerToast = true;
								}

								if ($scope.postsCategory == "Blogs I Follow")
									$scope.onReload();
							}
							else{
								$scope.toastMessage = "Couldn't complete the action";
								$scope.readerToast = true;
							}
							$scope.$apply();
						}
					};
				};
				
				$scope.followBlogToggle_Error = function(e){
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						$scope.toastMessage = "Couldn't complete the action";
						$scope.readerToast = true;
						$scope.$apply();
					}
					//$log.log("Comment could not be deleted!");
				};
			//-------------------------------- GET FOLLOW/UNFOLLOW BLOG ENDS -----------------------------------//

			//-------------------------------- GET FOLLOW/UNFOLLOW BLOG STARTS -----------------------------------//
			$scope.addDeleteTag = function(action, tagNameUrl){
				var url = "";
				var payload = "";
				var tag = $('<div/>').html(tagNameUrl).text();
				tagNameUrl = tag;
				tag = commonService.doDashes(tag);
				if(action == "add"){
					//url = commonService.APIBaseUrl + $rootScope.authDetails.site_id + '/tags/new?pretty=1';
					url = commonService.APIUrlCommon + 'read/tags/' + tag + '/mine/new?pretty=1';
					//payload = commonService.addTag_payload(tagNameUrl);
				}
				else{
					//tagNameUrl = tag;
					var itemIndx = commonService.getObjKeyByProperty($scope.tagList.tags, "title", [tagNameUrl]);
					delete $scope.tagList.tags[itemIndx];
					url = commonService.APIUrlCommon + 'read/tags/' + tag + '/mine/delete?pretty=1';
					//url = commonService.APIBaseUrl + $rootScope.authDetails.site_id + '/tags/slug:' + tagNameUrl +'/delete?pretty=1';
				}

				var apiCaller = new APICaller('POST',url, $scope.addDeleteTag_Success(action,tagNameUrl), $scope.addDeleteTag_Error, payload);
				apiCaller.getResult();
			};
			
				$scope.addDeleteTag_Success = function(action, tag){
					return function(){
						if (this.readyState === 4 && this.status === 200) {
							if($scope.tagType != 'PT'){
								$scope.showView($scope.tagType);
							}
							if (action == "add")
								$scope.toastMessage = "Added " + tag;
							else
								$scope.toastMessage = "Removed " + tag;
							
							$scope.readerToast = true;
							$scope.$apply();
						}
					};
				};
				
				$scope.addDeleteTag_Error = function(e){
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						$scope.toastMessage = "Couldn't complete the action";
						$scope.readerToast = true;
						$scope.$apply();
					}					
				};
			//-------------------------------- GET FOLLOW/UNFOLLOW BLOG ENDS -----------------------------------//

			$scope.likeUnlikePost = function(postData){
				postData.i_like = Math.abs(postData.i_like - 1);				
				var apiUrl = "";
				if( postData.i_like ==1 ){
					apiUrl = commonService.APIBaseUrl + postData.site_ID +'/posts/'+ postData.ID +'/likes/new?pretty=1';
					postData.like_count ++;
				}
				else{
					apiUrl = commonService.APIBaseUrl + postData.site_ID +'/posts/'+ postData.ID +'/likes/mine/delete?pretty=1';
					postData.like_count --;
				}
				var apiCaller = new APICaller('POST',apiUrl, $scope.likeUnlikePost_Success, $scope.likeUnlikePost_Error);
				apiCaller.getResult();
			};
				$scope.likeUnlikePost_Success = function(){
					if (this.readyState === 4 && this.status === 200) {
						var likeResponse = JSON.parse(this.response);
						if(likeResponse.success){							
						}
						else{
							$scope.toastMessage = "Couldn't complete the action";
							$scope.readerToast = true;
						}
						$scope.$apply();	
					}
				};
				$scope.likeUnlikePost_Error = function(e){
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						$scope.toastMessage = "Couldn't complete the action";
						$scope.readerToast = true;
						$scope.$apply();
					}
				};
			
			//-------------------------------- GET MENU STARTS -----------------------------------//

			/*	Description => The method fetching the posts user has liked
				Params => 1. pageNo : page number of the data.
			*/
			$scope.getMenu = function(){
				$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					var url = commonService.APIUrlCommon + 'read/menu/';					
					var apiCaller = new APICaller('GET',url, $scope.getMenu_Success, $scope.getMenu_Error);
					apiCaller.getResult();
				}
				else{
						NProgress.done();						
						$scope.toastMessage = "There is no network connection";
						$scope.readerToast = true;
						$scope.showLoadSpinner = false;
						$scope.showLoader = false;
				}
			};

				$scope.getMenu_Success = function(e) {
					if (this.readyState === 4 && this.status === 200) {
						var jsonResponse = JSON.parse(this.response);					
						$scope.showLoader = false;
						//$scope.menu = jsonResponse;, jsonResponse.default
						$scope.menu = $.extend({}, jsonResponse.subscribed);

						
						var cnt = 0;
						angular.forEach(jsonResponse.default,function(value,index){
							$scope.menu["00"+cnt] = value;
							cnt++;
						});
						
						$scope.initSettings();
						$scope.$apply();
						NProgress.done();
					}
				};
				$scope.getMenu_Error = function () {
					NProgress.done();					
					$scope.toastMessage = "Problem loading pages";
					$scope.readerToast = true;
					$scope.showLoader = false;
					$scope.$apply();
				};

			//-------------------------------- GET MENU ENDS -----------------------------------//

		// ************************ Methods for API calls ends ***************************** //

		// ************************ Methods for view actions starts ***************************** //

			$scope.getSiteID = function (postData){
				var siteID = "";
				if(postData.siteURL){
					siteID = postData.siteURL;
				}
				else if(postData.site_ID)
					siteID = postData.site_ID;
				else 
					siteID = postData.blog_id? postData.blog_id : postData.ID;

				return siteID;
			}

			$scope.showView = function (tagType){				
				$scope.blogList = [];
				$scope.viewTitle ="Tags & Blogs";
				$scope.tagType = tagType;
				var url = "";
				var dataObjName = "";
				switch(tagType){
					case 'FT': 
						url = commonService.APIUrlCommon + "read/tags";
						dataObjName = "tagList";
					break;
					case 'PT':
						if($scope.tagList && $scope.followedTags) {
							$scope.tagList.tags = commonService.getPopularTags($scope.followedTags);							
						}else {
							url = commonService.APIUrlCommon + "read/tags";
							dataObjName = "tagList";
						}
					break;
					case 'FB': 
						url = commonService.APIUrlCommon + "read/following/mine";
						dataObjName = "blogIdList";
					break;
					case 'RB':
						if($scope.recommendationsBlogList)
							$scope.showRecommendations();
					break;					
				};
				if(url !="")
					$scope.getDataByUrl(url, dataObjName);
			}
			
			$scope.getBlogsbyIds = function(blogArray){
				var batchURL = commonService.APIUrlCommon + 'batch/?'
				angular.forEach(blogArray,function(value,index){
					//var appendChar = index == 0? "urls[]=/read/feed/" : "&urls[]=/read/feed/";
					var appendChar = index == 0? "urls[]=/sites/" : "&urls[]=/sites/";
					
					batchURL = batchURL + appendChar + value.blog_ID;
				});				
				$scope.getDataByUrl(batchURL, "blogList");
			}

			$scope.getAttrVal = function (object, attribute){
				var returnStr = "";
				switch(attribute){
					case 'title':
						returnStr = object.title? object.title : object.name;						
					break;
					case 'blog_domain':						
						returnStr = object.blog_domain? object.blog_domain : object.URL;
						returnStr = returnStr? returnStr.replace("http://", "") : returnStr;
					break;
				}
				returnStr = returnStr == undefined? false : returnStr;
				return returnStr;
			};

			$scope.getPosts = function(url, title, forceExecute){
				localStorage.setItem('readerOptionSelected', JSON.stringify({URL : url, title : title}) );
				//$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
				if( $scope.postsCategory != title || forceExecute == true){
					$scope.FPPageNo = 0;
					$scope.nextPageData = [];
					$scope.postList = undefined;
					$scope.postsCategory = title;
					if(url == "" || title == "Freshly Pressed")						
						$scope.getFreshlyPressedData();						
					else{
						//url = commonService.APIUrlCommon + 'freshly-pressed/?pretty=1&number=40';					
						$scope.urlInUse = url;
						$scope.pageNo = 1;
						var newUrl = $scope.urlInUse + "?page=1";						
						$scope.getpostsByURL(newUrl);
					}
				}
			};

			$scope.gotoReblog = function (postData){
				if(postData.is_reblogged == 0) {
					var item = JSON.stringify( {URL : $scope.urlInUse, title : $scope.postsCategory} );
					var jsonStr = JSON.stringify(postData);					
					$state.go("readerSub", {backTo: "reader", postInfo: jsonStr, viewScreen:"reblog",
						stringObject: item });
				}
				
			}

			$scope.gotoCommentsWithPost = function (postData){
				var item = JSON.stringify( {URL : $scope.urlInUse, title : $scope.postsCategory} );
				// var oneObj = {gotoView: "commentsWithPost", backTo: "reader", postID: postData.ID, 
				// 	site_ID: postData.site_ID, stringObject: item };
				$state.go("readerSub", {backTo: "reader", postID: postData.ID, viewScreen:"commentsWithPost", 
					site_ID: postData.site_ID, stringObject: item });
				//$state.go("redirector", {stringObject: JSON.stringify(oneObj) });				
			};

			/*	Description => The method to hide the menu section.
				Params => 1. event : event object.
			*/
			$scope.hideMenu = function(event){
				if($scope.showDrawer === true){
					if ( event.target.className.indexOf( 'drawerIcon' ) == -1 )
						$scope.showDrawer = false;
				}
			};	

			/*	Description => The method being called on pulltorefresh action.
			*/			
			$scope.onReload = function() {				
				if($scope.tagType == null){
					$scope.getMenu();
					$scope.getPosts($scope.urlInUse, $scope.postsCategory, true);
				}
				else
					$scope.showView($scope.tagType);
			};

			/*	Description => The method to load next page data inside view.
			*/
			$scope.loadMore = function(){
				if($scope.postsCategory != "Freshly Pressed"){
					if($scope.postList != undefined && $scope.nextPageData != undefined){
						$.merge($scope.postList.posts, $scope.nextPageData);
						$scope.showLoadSpinner = true;
					}
					$scope.pageNo = $scope.pageNo + 1;
					var newUrl = $scope.urlInUse + "?page=" + $scope.pageNo;					
					$scope.getpostsByURL(newUrl);
				}else{
					$.merge($scope.postList.posts, $scope.nextPageData);
					$scope.FPPageNo ++;
					$scope.getFreshlyPressedData($scope.FPPageNo);					
				}
			};

			$scope.goBack = function(){
				var selectedTitle = commonService.getObjKeyByProperty($scope.menu, "title", $scope.postsCategory);
				if (selectedTitle == null){
					$scope.postsCategory = "Freshly Pressed";
					$scope.urlInUse = "";
				}
				$stateParams.itemObj = null;
				$scope.tagType = null;
				$scope.viewTitle = "";
				$scope.getMenu();				
				$('#tagNameUrlInput').val("");
				
			}

			$scope.getPostTag = function(post){
				var postCount = 0;
				var tagName = "";
				angular.forEach(post.tags,function(item,index){
					if( item.post_count > postCount){
						tagName = item.name;
						postCount = item.post_count;
					}
				});

				if(tagName == "" && post.editorial)
					tagName = post.editorial.highlight_topic_title == ""? post.editorial.highlight_topic : post.editorial.highlight_topic_title;

				return tagName;
			};

			$scope.previewBlog = function(urlObject, previewFor){
				var url  = "";
				var item = {URL : $scope.urlInUse, title : $scope.postsCategory, previewFor: previewFor, tagType: $scope.tagType};
				if(previewFor == "tag")
				{					
					url = commonService.APIUrlCommon + "read/tags/" + urlObject + "/posts";
					var blogTitle = urlObject;					
					$state.go("readerSub", {backTo: "reader", blogTitle: blogTitle, viewScreen:"previewBlog", dataUrl: url, stringObject: JSON.stringify(item) });
				
				}else if (previewFor == "site"){
					item.siteID = urlObject.site_ID? urlObject.site_ID : urlObject.blog_id;
					item.siteID = item.siteID? item.siteID : urlObject.ID;

					url = commonService.APIBaseUrl + item.siteID + "/posts";
					var blogTitle = urlObject.site_name? urlObject.site_name : urlObject.name;
					blogTitle = blogTitle? blogTitle : urlObject.title;					
					$state.go("readerSub", {backTo: "reader", blogTitle: blogTitle, viewScreen:"previewBlog", dataUrl: url, stringObject: JSON.stringify(item) });
				}

			};
			
			$scope.addFollowTagSite = function (tagNameUrl){
				var added = false;
				if($.trim(tagNameUrl) !="")
				{
					if ($scope.checkIsValidDomain(tagNameUrl) == null ){
						var tag = commonService.capitaliseFirstLetter(tagNameUrl);						
						var tagsExist = commonService.getObjectByProperty($scope.followedTags,'title',tag);
						if(tagsExist){
							$scope.toastMessage = "You already follow this tag.";
							$scope.readerToast = true;
						}else{							
							$scope.addDeleteTag('add', tag);
							added = true;
						}
					}else{
						var url = "http://" + angular.lowercase(tagNameUrl);
						var blogsExist = commonService.getObjectByProperty($scope.followedBlogs,'URL',url);
						if(blogsExist){
							$scope.toastMessage = "You already follow this blog.";
							$scope.readerToast = true;
						}else{
							var postData = {siteURL: tagNameUrl};
							$scope.followBlog(postData);
							added = true;
						}
					}


					if(added == true){
						switch($scope.tagType){
							case 'FT': 
							case 'PT': 							
								if ($scope.tagType == 'PT'){
									delete $scope.tagList.tags[angular.lowercase(tagNameUrl)];
								}							 
							break;
							case 'FB': 
							case 'RB':
								$scope.showView('FB');
						};					
						$('#tagNameUrlInput').val("");
					}
				}
			};

			$scope.getMoreRecommendations = function (){

				if( $scope.recommendationsPageNo >= 5 || ($scope.recommendationsPageNo*4 > $scope.recommendationsPageNo.length) ) 
					$scope.recommendationsPageNo = 0;
				else
					$scope.recommendationsPageNo ++;				
				$scope.showRecommendations();
			}

			$scope.showRecommendations = function (){				
				var start = $scope.recommendationsPageNo*4;
				var end = start+4;				
				$scope.blogList = $filter('orderBy')($scope.recommendationsBlogList, 'title').slice(start, end);
				$('#tagsMenu').scrollLeft(1000);
				return;
			};

			$scope.showFreshlyPressed = function (){
				$scope.showLoader = false;//remove loader icon when data gets loaded from API call 			
				var start = $scope.FPPageNo*10;
				var end = start+10;
				if($scope.FPPageNo == 0){
					$scope.postList = {};
					$scope.postList.posts = $scope.freshlyPressedList.slice(start, end);					
					$scope.loadMore();
				}
				else{					
					$scope.nextPageData = $scope.freshlyPressedList.slice(start, end);					
				}
				//return;
			};

			$scope.checkIsValidDomain = function (domain) {
			    var re = new RegExp(/^((?:(?:(?:\w[\.\-\+]?)*)\w)+)((?:(?:(?:\w[\.\-\+]?){0,62})\w)+)\.(\w{2,6})$/); 
			    return domain.match(re);
			};

			$scope.getMoreRecommendationsData = function () {
				var url = commonService.APIUrlCommon + "read/recommendations/mine/?number=40";
				$scope.getDataByUrl(url, "recommendationsBlogList");
			};

			$scope.getFreshlyPressedData = function (pageNo) {
				var num = (pageNo+1)*10;
				var url = commonService.APIUrlCommon + 'freshly-pressed/?pretty=1&number=' + num;
				$scope.getDataByUrl(url, "freshlyPressedList");
			};

			$scope.initSettings = function () {
				if ($stateParams.itemObj){
					var selectedItem = JSON.parse($stateParams.itemObj);
					$scope.getPosts(selectedItem.URL , selectedItem.title);
					if(selectedItem.tagType){						
						$scope.tagType = selectedItem.tagType;						
						$scope.showView(selectedItem.tagType);
					}
				}
				else if($scope.postsCategory)
					$scope.getPosts($scope.urlInUse, $scope.postsCategory);
				else					
					$scope.getPosts($scope.urlInUse, $scope.defaultCategory);
			};

			$scope.getDate = function (postObj){
				if(postObj.editorial)
					return postObj.editorial['displayed_on'];
				else if(postObj.date_liked)
					return postObj.date_liked;
				else	
					return postObj. date;
			};

			$scope.getExcerpt = function(excerpt){
				return commonService.getExcerpt(excerpt);
			};

			$scope.getImage = function(postObj){
				var imgSrc = postObj.editorial? postObj.editorial['image'] : "";
				var featuredImg = postObj.featured_media? postObj.featured_media.uri : "";

				if(imgSrc != undefined && imgSrc != "")
					return imgSrc;
				else if(featuredImg != undefined && featuredImg != "")
					return featuredImg;

				return "";
			};

		// ************************ Methods for view actions ends ***************************** //
		
		// ****************** statements to be executed on controller init : starts *********************** //									
			//$scope.getFreshlyPressedData();
			$scope.getMenu();

		// ****************** statements to be executed on controller init : ends *********************** //
	};	
	controllers.readerController.$inject = ['$scope', '$http', '$log', '$rootScope', '$state', '$q', 'APICaller', 'commonService', '$stateParams', '$filter'];
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

