(function() {
	'use strict';

	var controllers = {};

	/***	Pages list controller 	***/
	controllers.reblogController = function($scope, $log, $rootScope, $state, APICaller, commonService, $stateParams) {

		// ****************** initialization of variables starts *********************** //				

			if($stateParams.viewScreen == "reblog"){
				$scope.showReblogView = true;
			}else {
				$scope.showReblogView = false;
				return;
			}
			$scope.postData = JSON.parse($stateParams.postInfo);
			$scope.siteObject = localStorage.getItem('siteObject');
			$scope.siteObject = JSON.parse($scope.siteObject);
				
		// ****************** initialization of variables ends *********************** //
		
		// ************************ Methods for API calls and their response starts ***************************** //
			
			//-------------------------------- REBLOG POST STARTS -----------------------------------//
			$scope.reblogPost = function(postData){
				postData.is_reblogged = true;
				var reblogPostUrl = commonService.APIBaseUrl + postData.site_ID +'/posts/'+ postData.ID +'/reblogs/new?pretty=1';
				var payload = commonService.reblogPost_payload($scope);
				var apiCaller = new APICaller('POST',reblogPostUrl, $scope.reblogPost_Success, $scope.reblogPost_Error, payload);				
				apiCaller.getResult();
			};
			
				$scope.reblogPost_Success = function(){
					if (this.readyState === 4 && this.status === 200){
						$scope.reblogging = false;
						var reblogPostResponse = JSON.parse(this.response);
						
							if(reblogPostResponse.success){								
								$scope.toastMessage = "Reblogged this post";
								$scope.reblogToast = true;
								$scope.goBack();
							}
							else{
								$scope.toastMessage = "Couldn't reblog this post";
								$scope.reblogToast = true;
							}
							$scope.$apply();
					}
				};
				$scope.reblogPost_Error = function(){					
					$scope.reblogging = false;
					if(e.type === "error" && e.target.timeout === 0 && e.target.responseText === ""){
						$scope.toastMessage = "Couldn't reblog this post";
						$scope.reblogToast = true;
						$scope.$apply();
					}
				};
			//-------------------------------- REBLOG POST ENDS -----------------------------------//
			
		// ************************ Methods for API calls ends ***************************** //

		// ************************ Methods for view actions starts ***************************** //


			/*	Description => The method to hide the menu section.
				Params => 1. event : event object.
			*/
			$scope.hideMenu = function(event){
				if($scope.showDrawer === true){
					if ( event.target.className.indexOf( 'drawerIcon' ) == -1 )
						$scope.showDrawer = false;
				}
			};	

			/*	Description => The method to hide the menu section.
				Params => 1. event : event object.
			*/
			$scope.goBack = function(event){			
				var jsonObj = JSON.parse($stateParams.stringObject);
				if(jsonObj.viewScreen)
					$state.go($stateParams.backTo, jsonObj);
				else if($stateParams.backTo == "commentsWithPost")
					$state.go($stateParams.backTo, {returnObj: $stateParams.stringObject});
				else
					$state.go($stateParams.backTo, {itemObj: $stateParams.stringObject});
			};

			$scope.getImage = function(postObj){
				var imgSrc = postObj.editorial? postObj.editorial['image'] : "";
				var featuredImg = postObj.featured_media? postObj.featured_media.uri : "";

				if(imgSrc != undefined && imgSrc != "")
					return imgSrc;
				else if(featuredImg != undefined && featuredImg != "")
					return featuredImg;

				return "";
			}
			

		// ************************ Methods for view actions ends ***************************** //
		
		// ****************** statements to be executed on controller init : starts *********************** //
			
		// ****************** statements to be executed on controller init : ends *********************** //
	};	
	controllers.reblogController.$inject = ['$scope', '$log', '$rootScope', '$state', 'APICaller', 'commonService', '$stateParams'];
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

