(function() {
	'use strict';

	var controllers = {};


	controllers.settingsController = function($scope, $http, $log, $state, $stateParams, $rootScope, $filter, APICaller, commonService){

	// ****************** initialization of variables starts *********************** //
		$scope.siteObject = localStorage.getItem('siteObject');
		$scope.currentMenu = "settings";
		$scope.siteObject = JSON.parse($scope.siteObject);
		if( localStorage.getItem('pinLockData') )
			$scope.pinLockData = JSON.parse( localStorage.getItem('pinLockData') );		

		$scope.siteObject.blogAddress = $scope.siteObject.url.replace("http://","");
		
		
		var settingsLocalArray = ["signature","pin","privacy","enableNotify","follows","achievment","other","likes","comments","blogs","playSound","vibrate","blinkLight"];		

		if( localStorage.getItem('settingsLocalData') ){
			$scope.settingsLocalData = JSON.parse( localStorage.getItem('settingsLocalData') );
			$scope.settingsLocalData = $scope.settingsLocalData? $scope.settingsLocalData : {};
		}else
			$scope.settingsLocalData = {};				

		if($scope.settingsLocalData.defaultImgWidth == undefined)
			$scope.settingsLocalData.defaultImgWidth = 2000;

		if($scope.settingsLocalData.signatureBody == undefined)
			$scope.settingsLocalData.signatureBody = "Posted from Wordpress for Firefox";
		

		$scope.viewTitle ="Settings";		
		$scope.ViewChanged = false;

	// ****************** initialization of variables ends *********************** //
		
	// ************************ Methods for API calls and their response starts ***************************** //
		//-------------------------------- GET SiteInfo STARTS -----------------------//				
			/*	Description => The method gets the author info.
			*/
			$scope.getAuthorInfo = function(){
				var Url = commonService.APIBaseUrl + $rootScope.authDetails.site_id+'/posts?pretty=1&number=1';
				
				var service = $http({method: 'GET', url: Url });
			
				service.success(function(data, status, headers, config){					
					if(data.posts.length != 0)
						$scope.userName = data.posts[0].author.name
					else 
						$scope.userName = siteObject.siteName;
		   		});
		   		service.error(function(data, status, headers, config) {

		   		}); 
			};

		//-------------------------------- GET SiteInfo ENDS -----------------------------//
	// ************************ Methods for API calls ends ***************************** //

		// ************************ Methods for view actions starts ***************************** //

		$scope.changeDefaultImgWidth = function(item){
			$scope.settingsLocalData["defaultImgWidth"] = item;
			localStorage.setItem('settingsLocalData', JSON.stringify($scope.settingsLocalData));
		}

		$scope.checkBoxVal = function(checkType){			
			$scope.settingsLocalData[checkType] = !($scope.settingsLocalData[checkType]);
			localStorage.setItem('settingsLocalData', JSON.stringify($scope.settingsLocalData));
		};

		$scope.goBack = function() {
			if($scope.selectedFAQ){
				$scope.selectedFAQ = undefined;
				return;
			}
			else if($scope.faqView){
				$scope.faqView = false;
				$scope.helpSupportView = true;
				$scope.viewTitle ="Help And Support";
				return;
			}else {

				$scope.ViewChanged = false;
				$scope.showNotificationsView = false;
				$scope.aboutUsForAndroidView = false;
				$scope.openLicensesView = false;
				$scope.helpSupportView = false;
				$scope.createBlogView = false;
				$scope.blogsView = false;
				$scope.adminView = false;
				$scope.selfHostedView = false;
				if($scope.showSignatureView)
					$scope.settingsLocalData = JSON.parse( localStorage.getItem('settingsLocalData') );

				$scope.showSignatureView = false;
				$scope.viewTitle ="Settings";
			}
		};
		
		$scope.changeView = function(value, headerTitle){
			$scope.ViewChanged = true;			

			if(value == "signout")
				$state.go('signOut',{backTo:'settings'});
			else{
				$scope[value] = true;
				$scope.viewTitle = headerTitle;
			}
		}

		$scope.viewAdmin = function(){
			var adminUrl = $scope.siteObject.url + "/wp-admin/";
			//window.location.href = adminUrl;
			window.open(adminUrl);
			// var strObj = JSON.stringify({ViewChanged : $scope.ViewChanged, adminView : $scope.adminView});
			// $state.go("viewSite", {backTo:"settings", url: adminUrl, stringObject: strObj});
		}

		$scope.viewOnBrowser = function(view){
			var url= "";
			if(view == "tos")
				url = "http://en.wordpress.com/tos/";
			else
				url = "http://automattic.com/privacy";

			window.open(url);
		};

		$scope.getImgWidthArray = function(){
			$scope.mediaImageWidth = []
			for(var i=0; i<=2000; i=i+100)
			{
				if(i==0)
					$scope.mediaImageWidth.push('Original Size');
				else
					$scope.mediaImageWidth.push(i);
			}
		};
		$scope.goto = function(state){
			if(state == "pinlock")
				$state.go("pinlock");
			else{
				$scope.faqView = true;
				$scope.helpSupportView = false;
			}
		};

		$scope.changeSignature = function(action) {
			if(action == "ok"){				
				$scope.settingsLocalData.signatureBody = document.getElementById("signatureInput").value;
				localStorage.setItem('settingsLocalData', JSON.stringify($scope.settingsLocalData));
			}else{
				$scope.settingsLocalData = JSON.parse( localStorage.getItem('settingsLocalData') );
			}
			$scope.goBack();
		};

		$scope.onReload = function() {
		};

		$scope.resetSettings = function(){
			$scope.toastMessage = "Auto-sharing settings reset";
			$scope.settingToast = true;
		}

		$scope.changeFAQView = function(value, headerTitle){
			$scope.helpSupportView = false;			
			$scope.selectedFAQ = value;
			$scope.viewTitle = headerTitle;
		}

		$scope.showHideDropdown = function($event)
		{			
			angular.element("#imgWidthDDL").toggleClass("open");			
			$event.preventDefault();
			$event.stopPropagation();			
			return;
		}

		// ************************ Methods for view actions ends ***************************** //

		// ****************** statements to be executed on controller init : starts *********************** //									

		$scope.getAuthorInfo();
		$scope.getImgWidthArray();

		if($stateParams.returnObj)
		{
			var params = JSON.parse($stateParams.returnObj);
			$scope.ViewChanged = params.ViewChanged;
			$scope.adminView = params.adminView;
		}

		localStorage.setItem('settingsLocalData', JSON.stringify($scope.settingsLocalData));

		// ****************** statements to be executed on controller init : ends *********************** //


	};
	controllers.settingsController.$inject = ['$scope', '$http', '$log', '$state', '$stateParams', '$rootScope', '$filter', 'APICaller', 'commonService']; 
	
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

