(function() {
	'use strict';

	var controllers = {};

/***	Comments controller 	***/
	controllers.statsController = function($scope, $http,  $log, $rootScope, $stateParams, $state, APICaller, commonService) {
			
		// ************************ Methods for API calls and their response starts ***************************** //
		localStorage.setItem('lastAccessedView', "stats");
		$scope.currentMenu = "stats";
		$scope.showDrawer = false;

		 $scope.showme = false;
			$scope.xkey = 'paramKey';

			$scope.ykeys = ['visitors', 'views'];

			$scope.labels = ['Visitors', 'Views'];
			$scope.myModel =[{ paramKey: '', views: 0, visitors: 0, day:"" }];
			
			$scope.showBack = $stateParams.backTo !== null;
			$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
			$scope.todaysDate = moment().format("MMM DD");
			$scope.yesterdaysDate = moment().subtract('days',1).format('MMM DD');
			
		// ****************** initialization of variables ends *********************** //
		
		// ************************ Methods for API calls and their response starts ***************************** //	
			
			//-------------------------------- GET FRESHLY PRESSED STARTS -----------------------------------//
						
			/*	Description => The method fetching the posts user has liked
				Params => 1. pageNo : page number of the data.
			*/
			$scope.getDataByUrl = function(URL, dataObjName){
				var isOnline = navigator.onLine;
				NProgress.start();
				if(isOnline){
					var apiCaller = new APICaller('GET',URL, $scope.getDataByUrl_Success(dataObjName), $scope.getDataByUrl_Error);
					apiCaller.getResult();
				}
				else{
						NProgress.done();
						$scope.toastMessage = "There is no network connection";
						$scope.postToast = true;
						$scope.showLoadSpinner = false;
				}
			};

				$scope.getDataByUrl_Success = function(dataObjName) {
					$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
					return function() {
						if (this.readyState === 4 && this.status === 200) {
							var jsonResponse = JSON.parse(this.response);
							
							$scope[dataObjName] = null;

							if(dataObjName == "stats")
							{
								$scope.statsData = jsonResponse.stats;

							}else if(dataObjName == "day" || dataObjName == "month" || dataObjName == "week"){								
								$scope[dataObjName+"Data"] = $scope.processData(jsonResponse.data);
								if(dataObjName == "day")
									$scope.setChartData("day");

							}else {
								if ($scope.showDateView == true)
									$scope.dateView[dataObjName] = jsonResponse;
								else 
									$scope[dataObjName] = jsonResponse;
							}
							$scope.$apply();
							NProgress.done();							
						}
					};
				};
				$scope.getDataByUrl_Error = function () {
					NProgress.done();					
					$scope.toastMessage = "Problem loading pages";
					$scope.postToast = true;
					$scope.$apply();
				};

			//-------------------------------- GET FRESHLY PRESSED ENDS ----------------------------//

		// ************************ Methods for API calls ends ***************************** //

		// ************************ Methods for view actions starts ***************************** //			

			$scope.processData = function (dataObject) {
				var processedData;
				processedData = [];
				var log = [];
				angular.forEach(dataObject, function(item, index) {
					var strdate = item[0].replace(/W/g, '/');
					var dt =  new Date(strdate);
					var month = commonService.GetMonthName( dt.getMonth()+1 );
					var day = month.slice(0,3) + " " + dt.getDate();
					month = month.slice(0,3) + " " + dt.getFullYear();

					var xkeyParam="";
					
					if( $scope.chartDataFreq == "month")
						xkeyParam = month;
					else
						xkeyParam = day;

					
					var obj = {paramKey: xkeyParam, views: item[1], visitors: item[2], date : dt, 
						day:commonService.GetDayName(dt.getDay()), year: dt.getFullYear()};
					//var objdl = {paramKey: day, date: dt, views: item[1], visitors: item[2]};
		    		processedData.push(obj);

		    	},	log);
		    	
		    	return processedData;
			};

			$scope.setChartData = function(frequency){
				$scope.showChartTip = false;
				$scope.chartDataFreq = frequency;
				if(frequency == 'day')
					$scope.myModel = $scope.dayData;
				else if (frequency == 'week')
					$scope.myModel = $scope.weekData;
				else
					$scope.myModel = $scope.monthData;
			};

			$scope.getChartData = function(frequency, number){
				var url = commonService.APIBaseUrl + $rootScope.authDetails.site_id +  "/stats/visits?pretty=1&unit=" + frequency + "&quantity=" + number;
				$scope.getDataByUrl(url, frequency);
			};

			$scope.getStatsData = function(){
				$scope.getChartData("month",4);
				$scope.getChartData("week",12);
				$scope.getChartData("day",7);

				var statsUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +  "/stats?pretty=1";
				$scope.getDataByUrl(statsUrl, "stats");

				$scope.changeData("countryData","T");				
				$scope.changeData("searchTerms","T");
				$scope.changeData("clicks","T");
				$scope.changeData("topPosts","T");
				$scope.changeData("referrers","T");				
			}

			$scope.getDateViewData = function(date){

				$scope.changeData("searchTerms","O",date);
				$scope.changeData("clicks","O",date);
				$scope.changeData("topPosts","O",date);
				$scope.changeData("referrers","O",date);
			}

			$scope.changeData = function(action, flg, others){
				var d = new Date();
				var url = commonService.APIBaseUrl + $rootScope.authDetails.site_id;
				if (flg == "Y")
					d.setDate(d.getDate() - 1);
				else if (flg == "O")
					d.setDate(others);

				var strDt = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();
				if(action == "countryData"){
					$scope.countryFlg = flg;
					url = url + "/stats/country-views?pretty=1&date=" + strDt;
					$scope.getDataByUrl(url, "countryData");

				}else if(action == "referrers"){
					$scope.referrersFlg = flg;
					url = url + "/stats/referrers?pretty=1&date=" + strDt;
					$scope.getDataByUrl(url, "referrers");

				}else if(action == "searchTerms"){					
					$scope.searchTermsFlg = flg;
					url = url + "/stats/search-terms?pretty=1&date=" + strDt;
					$scope.getDataByUrl(url, "searchTerms");

				}else if(action == "topPosts"){
					$scope.topPostsFlg = flg;
					url = url + "/stats/top-posts?pretty=1&date=" + strDt;
					$scope.getDataByUrl(url, "topPosts");

				}else if(action == "clicks"){
					$scope.clicksFlg = flg;
					url = url + "/stats/clicks?pretty=1&date=" + strDt;
					$scope.getDataByUrl(url, "clicks");
				}
			}

			$scope.chartClick = function(obj) {				
				if($scope.chartDataFreq == "day"){
					if(obj.views != 0 && obj.visitors != 0)
					{
						$scope.showDateView = true;
						$scope.dateView = {};
						$scope.dateView.title = obj.day + ", " + obj.paramKey + ", " + obj.year;
						$scope.dateView.views = obj.views;
						$scope.dateView.visitors = obj.visitors;
						var vRate = (obj.views*1.00/ obj.visitors);
						$scope.dateView.visitorsRate = isNaN(vRate)? 0 : vRate;
						$scope.getDateViewData(obj.date);
					}
				}
				else{

					$scope.showChartTip = true;
					$scope.popup = {};
					if ( $scope.chartDataFreq == "week" )
						$scope.popup.Date = "Week of " + obj.day + ", " + obj.paramKey + ", " + obj.year;
					else
						$scope.popup.Date = obj.paramKey + ", " + obj.year;

					$scope.popup.views = obj.views + " Views";
					$scope.popup.visitors = obj.visitors + " Visitors";
					var viewRate = (obj.views*1.00/ obj.visitors).toFixed(2);
					$scope.popup.viewRate = viewRate + " Views per Visitors";
				}					
			}

			/*	Description => The method being called on pulltorefresh action.
			*/
			$scope.onReload = function() {
				// if ( $scope.showDateView == true )
				// else
				$scope.getStatsData();
			};

			$scope.goBack = function(){
				if($scope.showDateView){
					$scope.showDateView = false;
					$scope.dateView = null;
					$scope.getStatsData();
				}
				else if($stateParams.backTo == "noteInfo"){
					$state.go($stateParams.backTo, {id: $stateParams.id});
				}
			};

			$scope.preventChartPopup = function(event){
				event.preventDefault();
				event.stopImmediatePropagation();
			}

			$scope.openLink = function(url){
				window.open(url);
			}

		// ************************ Methods for view actions ends ***************************** //
		
		// ****************** statements to be executed on controller init : starts *********************** //			
			$scope.getStatsData();
		// ****************** statements to be executed on controller init : ends *********************** //
			
	};
	controllers.statsController.$inject = ['$scope', '$http',  '$log', '$rootScope', '$stateParams', '$state', 'APICaller', 'commonService'];	
	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

