(function() {
	'use strict';

	var controllers = {};

	/***	Themes controller 	***/
	controllers.themesController = function($scope, $http, $log, $state, $stateParams, $rootScope, $filter, APICaller, commonService) {
	
	// ****************** initialization of variables starts *********************** //		
		localStorage.setItem('lastAccessedView', "themes");
		$scope.viewTitle = "Themes";
		$scope.currentMenu = "themes";
		$scope.isReload = false;
		$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
		//$scope.activeTab = "trending";
		$scope.trendingPageNo = $scope.newestPageNo = $scope.popularPageNo = 0;
		var trendingDataArray = [];
		var newestDataArray = [];
		var popularDataArray = [];
		var trendingThemesData, newestThemesData, popularThemesData;
		$scope.themeData = {};
		
	// ****************** initialization of variables ends *********************** //			

		// ************************ Methods for API calls and their response starts ***************************** //

			//-------------------------------- GET THEMES STARTS ----------------------------------------//
			
			/*	Description => The method fetching the themes for the logged in user
			*/
			
			$scope.getThemes = function(){
				$scope.isOnline = navigator.onLine;
				NProgress.start();
				if($scope.isOnline){
					var getThemesUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/themes';
					var apiCaller = new APICaller('GET', getThemesUrl, $scope.getThemes_Success, $scope.getThemes_Error);
					apiCaller.getResult();
				}
				else{
					NProgress.done();
					$scope.toastMessage = "There is no network available";
					$scope.themeToast = true;
				}
			};
			
                          
				$scope.getThemes_Success = function(){
					$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
					if (this.readyState === 4 && this.status === 200) {
						$scope.getCurrentTheme();
						$scope.allThemesData = JSON.parse(this.response);						
                        //$scope.themeData = $scope.allThemesData;
						$scope.searchThemeData = $scope.allThemesData;
						if($scope.isReload == false){
							if($stateParams.currentTab == "Newest"){
								$scope.showNewestThemes();
							}
							else if($stateParams.currentTab == "Popular"){
								$scope.showPopularThemes();
							}
							else{
								$scope.showTrendingThemes();
							}
						}
						else{							
							var selectedTab = localStorage.getItem('selectedTab');
							if(selectedTab == "Trending"){
								$scope.trendingPageNo = 0;
								$scope.showTrendingThemes();
							}
							else if(selectedTab == "Newest"){
								$scope.newestPageNo = 0;
								$scope.showNewestThemes();
							}
							else if(selectedTab == "Popular"){
								$scope.popularPageNo = 0;
								$scope.showPopularThemes();
							}
						}
						NProgress.done();
						$scope.$apply();
					}
				};
				$scope.getThemes_Error = function(){
					NProgress.done();	
					$scope.toastMessage = "Problem loading Themes";
					$scope.themeToast = true;
					$scope.$apply();
				};
				
			$scope.getCurrentTheme = function(){
				var getCurrentThemeUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/themes/mine';
				var apiCaller = new APICaller('GET', getCurrentThemeUrl, $scope.getCurrentTheme_Success, $scope.getCurrentTheme_Error);
				apiCaller.getResult();
			};
			
                          
				$scope.getCurrentTheme_Success = function(){
					if (this.readyState === 4 && this.status === 200) {
						$scope.currentThemeData = JSON.parse(this.response);						
						$scope.$apply();
					}
				};
				$scope.getCurrentTheme_Error = function(){
					/* $scope.toastMessage = "Cannot load current theme data!";
					$scope.themeToast = true;
					$scope.$apply(); */					
				};
				
			/* $scope.order = function(predicate, reverse) {
				$scope.themeData['themes'] = $filter('orderBy')($scope.themeData['themes'], predicate, reverse);
			}; */
			$scope.showTrendingThemes = function(loadMore){
				$scope.activeTab = "trending";
				localStorage.setItem('selectedTab','Trending');
				trendingThemesData = $scope.allThemesData;
				trendingThemesData['themes'] = $filter('orderBy')($scope.allThemesData['themes'], '+trending_rank', false);
				//$scope.themeData['themes'] = $filter('orderBy')($scope.themeData['themes'], '+trending_rank', false);
				if($scope.trendingPageNo == 0){
						trendingDataArray = [];
						//$scope.themeData['themes'] = [];
					}					
					$scope.currentCount = ($scope.trendingPageNo+1)*20;
					var start = $scope.trendingPageNo*20;
					var end = start+20;					
					var nextPageData = (trendingThemesData['themes']).slice(start, end);					
					if(loadMore || $scope.trendingPageNo == 0)
						$.merge(trendingDataArray, nextPageData);
					$scope.themeData['themes'] = trendingDataArray;
			};
			$scope.showNewestThemes = function(loadMore){
				$scope.activeTab = "newest";
				localStorage.setItem('selectedTab','Newest');
				//$scope.themeData['themes'] = $filter('orderBy')($scope.themeData['themes'], '-launch_date', false);
				newestThemesData = $scope.allThemesData;
				newestThemesData['themes'] = $filter('orderBy')($scope.allThemesData['themes'], '-launch_date', false);
				if($scope.newestPageNo == 0){
						newestDataArray = [];
						//$scope.themeData['themes'] = [];
					}
										
					$scope.currentCount = ($scope.newestPageNo+1)*20;
					var start = $scope.newestPageNo*20;
					var end = start+20;					
					var nextPageData = (newestThemesData['themes']).slice(start, end);					
					if(loadMore || $scope.newestPageNo == 0)
						$.merge(newestDataArray, nextPageData);
					$scope.themeData['themes'] = newestDataArray;
			};
			$scope.showPopularThemes = function(loadMore){
				$scope.activeTab = "popular";
				localStorage.setItem('selectedTab','Popular');
				//$scope.themeData['themes'] = $filter('orderBy')($scope.themeData['themes'], '+popularity_rank', false);
				popularThemesData = $scope.allThemesData;
				popularThemesData['themes'] = $filter('orderBy')($scope.allThemesData['themes'], '+popularity_rank', false);
				if($scope.popularPageNo == 0){
						popularDataArray = [];
						//$scope.themeData['themes'] = [];
					}					
					$scope.currentCount = ($scope.popularPageNo+1)*20;
					var start = $scope.popularPageNo*20;
					var end = start+20;
					
					var nextPageData = (popularThemesData['themes']).slice(start, end);
					
					if(loadMore || $scope.popularPageNo == 0)
						$.merge(popularDataArray, nextPageData);
					$scope.themeData['themes'] = popularDataArray;
			};
			
			$scope.getMore = function (){
				if($scope.activeTab == 'trending'){
					if( $scope.trendingPageNo*20 > $scope.themeData.found ) 
						$scope.trendingPageNo = 0;
					else
						$scope.trendingPageNo++;				
					$scope.showTrendingThemes('loadMore');
				}
				else if($scope.activeTab == 'newest'){
					if( $scope.newestPageNo*20 > $scope.themeData.found ) 
						$scope.newestPageNo = 0;
					else
						$scope.newestPageNo++;				
					$scope.showNewestThemes('loadMore');
				}
				else if($scope.activeTab == 'popular'){
					if( $scope.popularPageNo*20 > $scope.themeData.found ) 
						$scope.popularPageNo = 0;
					else
						$scope.popularPageNo++;				
					$scope.showPopularThemes('loadMore');
				}
			};
			
			
			/* $scope.showSearchTheme = function(){
				$scope.searchView = true;
			}; */
			$scope.searchTheme = function(){
				var searchValue = angular.element("#srchText").val();
				var themeArr = [];
				$scope.searchResults = {}; $scope.searchTxt;
				if($.trim(searchValue) !== ''){
					$scope.searchTxt = (searchValue).toLowerCase();
				}
				else{
					$scope.searchTxt = searchValue;
				}
					
				if($scope.searchTxt != ''){
					angular.forEach($scope.allThemesData.themes,function(value,index){
						var themeName = value['name'].toLowerCase();
						var themeDesc = value['description'].toLowerCase();
						if(themeName.indexOf($scope.searchTxt) != -1 || themeDesc.indexOf($scope.searchTxt) != -1){
							themeArr.push(value);
						}
					});
					$scope.searchResults['found'] = themeArr.length;
					$scope.searchResults['themes'] = themeArr;
					$scope.searchThemeData = $scope.searchResults;
				}
				else{
					$scope.searchThemeData = $scope.allThemesData;
				}
			};
			
			$scope.resetText = function(){
				$scope.searchTxt = '';
				angular.element('#srchText').val("");
				$scope.searchThemeData = $scope.allThemesData;
			};
			
			$scope.gotoThemeDetail = function (themeData){
				angular.forEach(themeData.tags,function(value,index){
					if(value.indexOf('-') != -1){
						themeData.tags[index] = value.split('-').join(' ');;
					}
				});
				var selectedTab = localStorage.getItem('selectedTab');
				$state.go("themeInfo", {data: JSON.stringify(themeData), backToTab: selectedTab});
			};
			
			$scope.goBack = function(){
				$scope.searchView = false;
				$scope.searchTxt = '';
				angular.element('#srchText').val("");
			};
			
			/*	Description => The method to hide the menu section.
				Params => 1. event : event object.
			*/
                       
                       
			$scope.hideMenu = function(event){
				if($scope.showDrawer === true){
					if ( event.target.className.indexOf( 'drawerIcon' ) == -1 )
						$scope.showDrawer = false;
				}
			};
			
			$scope.onReload = function(){
				$scope.isReload = true;
				$scope.getThemes();
			};
			
			$scope.getThemes();
	};
	
controllers.themesController.$inject = ['$scope', '$http', '$log', '$state', '$stateParams', '$rootScope', '$filter', 'APICaller', 'commonService'];

/***	Note Info controller 	***/

	controllers.themeInfoController = function($scope, $http, $log, $state, $stateParams, $rootScope, $filter, APICaller, commonService){
			// ****************** initialization of variables starts *********************** //	
			localStorage.setItem('lastAccessedView', "themes");
			$scope.viewTitle = "Themes";
			$scope.activating = false;
			$scope.activateText = "Activate";
			$scope.showLoader = true;//show loader icon till the data gets loaded from API call 
			
			$scope.getThemeInfo = function(){
				$scope.themeData = JSON.parse($stateParams.data);
				   
			};
			
            $scope.getCurrentTheme = function(){
				$scope.isOnline = navigator.onLine;
				NProgress.start();
				if($scope.isOnline){
					var getCurrentThemeUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/themes/mine';
					var apiCaller = new APICaller('GET', getCurrentThemeUrl, $scope.getCurrentTheme_Success, $scope.getCurrentTheme_Error);
					apiCaller.getResult();
				}
				else{
					NProgress.done();
					$scope.toastMessage = "There is no network available";
					$scope.themeToast = true;
				}
			};
			
                          
				$scope.getCurrentTheme_Success = function(){
					$scope.showLoader = false;//remove loader icon when data gets loaded from API call 
					if (this.readyState === 4 && this.status === 200) {
						$scope.currentThemeData = JSON.parse(this.response);						
						NProgress.done();
						$scope.$apply();
					}
				};
				$scope.getCurrentTheme_Error = function(){
					NProgress.done();	
					$scope.toastMessage = "Cannot load current theme data!";
					$scope.themeToast = true;
					$scope.$apply();
				};
			
			$scope.goToSite = function(){
				$state.go('viewSite');
			}; 			
			$scope.activateTheme = function(){
				$scope.activating = true;
				$scope.activateText = "Activating";
				var activateThemeUrl = commonService.APIBaseUrl + $rootScope.authDetails.site_id +'/themes/mine?pretty=1';
				var payload = commonService.activateTheme_payload($scope);
				
				var apiCaller = new APICaller('POST',activateThemeUrl, $scope.activateTheme_Success, $scope.activateTheme_Error, payload);
				apiCaller.getResult();
			};
				$scope.activateTheme_Success = function(){
					if (this.readyState === 4 && this.status === 200) {
						
						if($scope.showPreviewTheme){
							$scope.showPreviewTheme = false;
							$scope.viewTitle = "Themes";
						}
						$scope.getCurrentTheme();
						$scope.toastMessage = "Successfully set theme!";
						$scope.themeToast = true;
						$scope.activating = false;
						$scope.activateText = "Activate";
						$scope.$apply();
					}
				};
				
				$scope.activateTheme_Error = function(){
					$scope.toastMessage = "Problem activating theme!";
					$scope.themeToast = true;
					$scope.activating = false;
					$scope.activateText = "Activate";
					$scope.$apply();
				};
				
			$scope.previewTheme = function(previewUrl){
				$scope.ownSiteObject = localStorage.getItem('siteObject');
				$scope.ownSiteObject = JSON.parse($scope.ownSiteObject);
				
				$("#previewSiteFrame").attr("src", previewUrl);
				$scope.viewTitle = $scope.ownSiteObject.siteName;
				$scope.showPreviewTheme = true;
			};
                        
            $scope.goBack = function(){
				if($scope.showPreviewTheme){
					$scope.showPreviewTheme = false;
					$scope.viewTitle = "Themes";
				}
				else{
					$state.go("themes", {currentTab: $stateParams.backToTab});
				}
			};
			
			$scope.getCurrentTheme();
			$scope.getThemeInfo();
	};

	controllers.themeInfoController.$inject = ['$scope', '$http', '$log', '$state', '$stateParams', '$rootScope', '$filter', 'APICaller', 'commonService'];

	angular
		.module('wp-controllers')
 		.controller(controllers);

})();

