// $("#pageFrame_"+pagecount).attr("src",url);
(function() {
	'use strict';

	var controllers = {};

	/***	Pages list controller 	***/
	controllers.viewSiteController = function($state, $scope, $http, $log, $rootScope, $stateParams, APICaller, commonService) {
		// ****************** initialization of variables starts *********************** //		
		localStorage.setItem('lastAccessedView', "viewSite");
		$scope.currentMenu = "viewSite";
		NProgress.remove();

		$scope.prevPage = $stateParams.backTo;
		$scope.viewTitle = "View Site";
		
		$scope.ownSiteObject = localStorage.getItem('siteObject');
		$scope.ownSiteObject = JSON.parse($scope.ownSiteObject);		
		// ****************** initialization of variables ends *********************** //		

		// ************************ Methods for API calls starts ***************************** //

			//-------------------------------- GET VIEW SITE INFO STARTS -------------------------------//
			
			/*	Description => The method gets the data for Site view				
			*/
		
			$scope.getOtherSiteInfo = function(){
				var getOtherSiteInfoUrl = commonService.APIBaseUrl + $stateParams.site_id+'/?pretty=1';
				var apiCaller = new APICaller('GET', getOtherSiteInfoUrl, $scope.getOtherSiteInfo_Success, $scope.getOtherSiteInfo_Error, '');
				apiCaller.getResult();
			};

				$scope.getOtherSiteInfo_Success = function(e) {
					if (this.readyState === 4 && this.status === 200) {
						var jsonResponse = JSON.parse(this.response);
						$scope.otherSiteObject = jsonResponse;
						
						$("#siteFrame").attr("src", $scope.otherSiteObject.URL);
						$scope.viewTitle = $scope.otherSiteObject.name + " | " + $scope.otherSiteObject.description;
						$scope.URL = $scope.otherSiteObject.URL;
						NProgress.done();
						$scope.$apply();
					}
				};
				$scope.getOtherSiteInfo_Error = function (e) {					
				};

			//-------------------------------- GET VIEW SITE INFO ENDS -------------------------------//
		
		// ************************ Methods for API calls ends ***************************** //

		// ************************ Methods for view actions starts ***************************** //

			/*	Description => The method sets the Title and shows the url in iFrame
			*/
			$scope.getOwnSiteInfo = function(){
				$scope.viewTitle = $scope.ownSiteObject.siteName;
				$scope.URL = $scope.ownSiteObject.url;
				$("#siteFrame").attr("src", $scope.URL);
				NProgress.done();
			};
		
		/*	Description => The method to back to previous view
			*/
		$scope.goBack = function(){
			NProgress.remove();
			/* if($stateParams.backTo == "commentsWithPost"){
				$state.go($stateParams.backTo, {id:$stateParams.id, postID:$stateParams.fullPostID, backTo:$stateParams.fullPostBackTo });
			}
			else */			
			/* if($stateParams.backTo == 'commentInfo'){ */
			if($stateParams.mainView == 'notifications'){
				localStorage.setItem('lastAccessedView', "notifications");
				$state.go($stateParams.backTo, {id: $stateParams.id, backTo:$stateParams.mainView});
			}
			else if($stateParams.mainView == 'noteInfo'){
				localStorage.setItem('lastAccessedView', "notifications");
				$state.go($stateParams.backTo, {id: $stateParams.id, backTo: $stateParams.mainView, hideFooter: $stateParams.hideFooter, backToNoteID: $stateParams.backToNoteID});
			}
			else if($stateParams.backTo == 'readerSub')
			{
				//localStorage.setItem('lastAccessedView', "reader");
				var jsonObj = JSON.parse($stateParams.stringObject);
				$state.go($stateParams.backTo, jsonObj);
			}else if($stateParams.backTo == 'settings')
			{
				$state.go($stateParams.backTo, {returnObj: $stateParams.stringObject});
			}
				/*else if($stateParams.mainView == null){
					$state.go($stateParams.backTo, {id: $stateParams.id});
				}
			}
			 else if($stateParams.backTo == 'noteInfo'){
				$state.go($stateParams.backTo, {id: $stateParams.backToNoteID});
			} */
			/* else if($stateParams.backTo == "commentsWithPost"){
				$state.go($stateParams.backTo, {stringObject: $stateParams.stringObject});
			} */
			else{
				$state.go($stateParams.backTo, {id: $stateParams.id});
			}
		};

		

			/*	Description => The method to process share action on view
			*/
		$scope.shareURL = function(){
			var activity = new MozActivity({
			  name: "share",
			  data: {
				type: "url",
				number: 1,
				url: $scope.URL
			  }
			});

			activity.onsuccess = function() {
			  var url = this.result;
			};

			activity.onerror = function() {
			  //console.log(this.error);
			};
		};

			/*	Description => The method to view the iFrame url in browser
			*/
			$scope.viewOnBrowser = function(){
				window.open($scope.URL);
			};
		
		// ************************ Methods for view actions ends ***************************** //		

		// ****************** statements to be executed on controller init : starts *********************** //
			var isOnline = navigator.onLine;
			NProgress.start();
			if(isOnline){
				if ($stateParams.url != null && $stateParams.url != $scope.ownSiteObject.url){
					if($stateParams.site_id == null){
						$("#siteFrame").attr("src", $stateParams.url);
						$scope.viewTitle = $stateParams.title;
						$scope.URL = $stateParams.url;
						NProgress.done();
					}
					else{
						$scope.getOtherSiteInfo();
					}
				}
				/* else if($stateParams.url == null && $stateParams.site_id != null){
					$scope.getOtherSiteInfo();
				} */
				else{
					$scope.getOwnSiteInfo();
				}
			}
			else{
				NProgress.done();
				$scope.toastMessage = "There is no network available";
				$scope.siteToast = true;
			}

		// ****************** statements to be executed on controller init : ends *********************** //
		
	};
	controllers.viewSiteController.$inject = ['$state', '$scope', '$http', '$log', '$rootScope', '$stateParams', 'APICaller', 'commonService'];

	angular
		.module('wp-controllers')
 		.controller(controllers);
})();

