/***	Common Elements - Header / Footer	***/
/***	Directives		***/
(function() {
	'use strict';
	
	var app = angular.module('common-elements', []);
	app
		// //	Header directive
		// .directive('appHeader', function(){
		// 	return {
		// 		replace:true, // excludes the tag wrapped above the template eg. <app-header>
		// 		restrict: 'E',
		// 		templateUrl: 'src/includes/app-header.html'
		// 	};
		// })
		// //	Footer directive
		// .directive('appFooter', function(){
		// 	return {
		// 		replace:true,
		// 		restrict: 'E',
		// 		templateUrl: 'src/includes/app-footer.html'
		// 	};
		// })
		//	Menu directive
		.directive('previewBlog', function(){
			return {
				replace:false,
				restrict: 'E',
				templateUrl: 'src/includes/previewBlogTemplate.html'
			};
		})

		.directive('reblogTemplate', function(){
			return {
				replace:false,
				restrict: 'E',
				templateUrl: 'src/includes/reblogTemplate.html'
			};
		})
		.directive('commentWithPost', function(){
			return {
				replace:true,
				restrict: 'E',
				templateUrl: 'src/includes/commentWithPostTemplate.html'
			};
		})
		.directive('mediaTemplate', function(){
			return {
				replace:false,
				restrict: 'E',
				templateUrl: 'src/includes/mediaLib.html'
			};
		})
		.directive('appMenu', function(){
			return {
				replace:true,
				restrict: 'E',
				templateUrl: 'src/includes/app-menu.html'
			};
		})
		//	post footer directive
		.directive('wpPostFooter', function(){
			return {
				replace:true,
				restrict: 'E',
				templateUrl: 'src/includes/wp-post-footer.html'
			};
		})
		//	open source license directive
		.directive('wpLicense', function(){
			return {
				replace:false,
				restrict: 'E',
				templateUrl: 'src/includes/wp-license-template.html'
			};
		})
		//	comment list with post footer directive
		.directive('wpCommentsPostFooter', function(){
			return {
				replace:true,
				restrict: 'E',
				templateUrl: 'src/includes/wp-comments-post-footer.html'
			};
		})		
		//	 comment footer directive
		.directive('wpCommentFooter', function(){
			return {
				replace:true,
				restrict: 'E',
				templateUrl: 'src/includes/wp-comment-footer.html'
			};
		})
		.directive('barchart', function() {
		    return {
		        // required to make it work as an element
		        restrict: 'E',
		        template: '<div style="height:80%;"></div>',
		        replace: true,
		        // observe and manipulate the DOM
		        link: function($scope, element, attrs) {
		            var data = $scope[attrs.data],
		                xkey = $scope[attrs.xkey],
		                ykeys = $scope[attrs.ykeys],
		                labels = $scope[attrs.labels],
		                resize = $scope[attrs.resize];
					
		           var graph = Morris.Bar({
		                    element: element,
		                    data: data,
		                    xkey: xkey,
		                    ykeys: ykeys,
		                    labels: labels,
		                    resize:resize
		                    ,hideHover:"auto"
		                    ,stacked: true
		                });

					graph.on('click', function(i, row){
						$scope.$parent.chartClick(row);
					});

					// ----------- to highlight bar on click starts-----------
					//var barLength = $(element[0]).find("svg rect").length;
					function reset(){
						var barLength = $(element).find("svg rect").length;
					  for(var i=0;i < barLength; i++){
					    if(i%2 == 0){
					        $(element).find("svg rect:even").attr("fill","#0B62A4");
					    }else{
					        $(element).find("svg rect:odd").attr("fill","#7A92A3");
					    }
					  }
					}

					

					$(element).find("svg").click(function(evt){  
						if (evt.target.nodeName == 'rect'){
							var id = $(evt.target)[0].raphaelid;
							var rectList = $(element).find("svg rect");
							var indx = -1;

							angular.forEach(rectList, function(item, key) {
					    		if ( item.raphaelid == id){
					    			indx = key;					    			
					    		}
					    	},	[]);

						    reset();
						    
						    if(indx % 2 == 0){
						        $(evt.target).attr("fill","#FF6600");	
						        $(evt.target).next().attr("fill","#FF6600");
								
						    }else{
						        $(evt.target).attr("fill","#FF6600");
						        $(evt.target).prev().attr("fill","#FF6600");
						        
						    }
						}
					});

					// ----------- to highlight bar on click ends-----------

					var refresh = function(newData) {
						graph.setData(newData);
						//graph.redraw();
					};

		            $scope.$watchCollection(attrs.data, refresh);

		            var height = $(element).height();
		            $(element).find("svg").height(height);
					graph.redraw();
		            
		        }
		    };
		})
		
		//	 directive that makes first letter capital for n input text
		.directive('wpHover', ['$timeout',function($timeout) {
			return {
		    	//require: 'ngModel',
		    	link: function(scope, element, attrs, modelCtrl) {
		    	element.bind("click", function() {
			    	$(element).addClass(attrs.wpHover);
			    	$timeout(function(){
						$(element).removeClass(attrs.wpHover);
					},100);
			      
			    });
		     }
		     
		   };
		}])
		//	 directive that makes first letter capital for n input text
		.directive('capitalizeFirst', function() {
			return {
		    	require: 'ngModel',
		    	link: function(scope, element, attrs, modelCtrl) {
		    	var capitalize = function(inputValue) {
		        	inputValue = inputValue == undefined? "":inputValue;
		        	var capitalized = inputValue.charAt(0).toUpperCase() + inputValue.substring(1);
		        	
		        	if(capitalized !== inputValue) {
		            	modelCtrl.$setViewValue(capitalized);
		            	modelCtrl.$render();
		            }         
		            return capitalized;
		        }
		        modelCtrl.$parsers.push(capitalize);
		        capitalize(scope[attrs.ngModel]);  // capitalize initial value
		     }
		   };
		});
})();
