/***	Common Elements - Posts and pages List	***/
/***	Directives		***/
(function() {
	'use strict';
	
	var app = angular.module('common-elements');
	app
		//	Header directive
		.directive('postsList', function(){
			return {
				restrict: 'E',
				scope: {
					data: '=',
					state: '@',
					currentMenu: '=',
					viewTitle: '=',
					showLoader: '=',
					showDrawer: '=',
					addPost: '&',
					onReload: '&',
					hideMenu: '&',
					loadMore: '&',
					postToast: '=',
					toastMessage: '=',
					nextPageData: '='
				  },
				templateUrl: 'src/includes/posts-list.html'
			};
		})	
		.directive('postInfo', function(){
			return {
				restrict: 'E',
				templateUrl: 'src/includes/post-info.html'
			};
		})
		/* .directive('formatteddate', function ($filter) {
			return {
				restrict: 'A',
				require: 'ngModel',
				link: function (scope, element, attrs, ctrl) {
				

					 ctrl.$formatters.unshift(function(modelValue) {
					  return $filter('date')(modelValue, "MMM dd, yyyy, hh:mm a");
					});

					ctrl.$parsers.unshift(function(viewValue) {
					  return $filter('date')(viewValue);
					});          
				}
			}
		}) */
		.directive("onDocumentClick",['$document','$parse',function( $document, $parse ){
 
                // I connect the Angular context to the DOM events.
                var linkFunction = function( $scope, $element, $attributes ){
				
                    // Get the expression we want to evaluate on the
                    // scope when the document is clicked.
                    var scopeExpression = $attributes.onDocumentClick;
                    var invoker = $parse( scopeExpression );
 
                    // Bind to the document click event.
                    $document.off('click').on("click",function( event ){
                            $scope.$apply(function(){
								invoker($scope, { $event: event});
							});
 
                        });
 
                };
				
                return( linkFunction );
 
        }])
		.directive('contenteditable', function() {
			  return {
				require: 'ngModel',
				link: function(scope, elm, attrs, ctrl) {
				  // view -> model
				  elm.on('blur change focus', function() {
					scope.$apply(function() {
					  ctrl.$setViewValue(elm.html());
					  //ctrl.$render();
					});
				  });

				  // model -> view
				  ctrl.$render = function() {
					elm.html(ctrl.$viewValue);
				  };

				  // load init value from DOM
				  //ctrl.$setViewValue(elm.html());
				 //ctrl.$render();
				}
			  };
		})
		.directive('dynamic', ['$compile',function ($compile) {
			return{
				restrict: 'A',
				replace: true,
				link: function (scope, ele, attrs) {
				  scope.$watch(attrs.dynamic, function(html) {
					ele.html(html);
					$compile(ele.contents())(scope);
				  });
				}
			};
		}]);
})();
