/***	Common factories	***/
(function() {
	'use strict';
	
	var app = angular.module('common-elements');
	app
		.factory('APICaller',['$rootScope', function ($rootScope) {

		    // instantiate our object
			var APICaller = function (methodType, apiUrl, successMethod, errorMethod, payload) {
		        this.methodType = methodType;
		        this.apiUrl = apiUrl;
		        this.successMethod = successMethod;
				this.errorMethod = errorMethod;
				this.payload = payload;
		    };
			
		    // this method will fetch data from GH API and return a promise
		    APICaller.prototype = {
		    	getResult : function() {
			        // Generally, javascript callbacks, like here the $http.get callback, change the value of the "this" variable inside callbacks so we need ot keep a reference to the current instance "this", and we do it with the following :
			        var self = this;
					var xhr = new XMLHttpRequest({mozAnon:true, mozSystem: true});
					xhr.open(this.methodType, this.apiUrl, true);
					xhr.onreadystatechange = this.successMethod;
					xhr.onerror = this.errorMethod;
					xhr.setRequestHeader("Authorization", "BEARER " +$rootScope.authDetails.access_token);
					xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
					xhr.send(this.payload);
			    }
			};
		    
		    return APICaller;
		}]);
;
})();
