/***	Common factories	***/
(function() {
	'use strict';
	
	var app = angular.module('common-elements');
	app
		.factory('CommonScope',['$rootScope', '$state', '$filter', '$timeout', 'commonService', function ($rootScope, $state, $filter, $timeout, commonService) {
		    // instantiate our object
			var CommonScope = {};
			
		    /*	Description => The method sets the styles on contentEdior during click n keyboard events
				Params => 1. event : event object.
			*/
			CommonScope.preventClick = function( $event, scope){
				if(!scope.showEditor){				 
					scope.showEditor = true;
					angular.element("#titleBox").slideUp('fast');				
				}
				if($event.originalEvent.type == "click"){
					$event.preventDefault();
					$event.stopPropagation();
				}
				
				angular.element("#editContentTools").children().toggleClass('actLink',false);
				scope.setEditorState(commonService.getTarget());
				
				if((angular.element('#postBox').text()).length == 0 && (angular.element('#postBox').html()).indexOf('<img') == -1){
					//$scope.singleData.content = "";
					scope.showPlaceholder = true;
					return false;
				}
				else{
					scope.showPlaceholder = false;
				}
				var elemLength = $("#postBox").find('.outerContanier').length;
				if(elemLength > 0){
					$("#postBox").find('.outerContanier').each(function(){
						if($(this).find('.imageContainer').length == 1){
							if($(this).find('.imageContainer').children('img').length == 0){
								$(this).remove();
							}
						}
						if($(this).find('.editimage').length == 1){
							if($(this).find('.editimage').children('img').length == 0){
								$(this).remove();
							}
						}
					});
				}
				var savedSelect = commonService.saveSelection(angular.element("#postBox")[0]);
				$rootScope.cursorPos = savedSelect;
			};
			
			CommonScope.focusOnField = function(scope){	
				$timeout(function(){
					angular.element('#postBox').focus();
				}, 100);
				
				scope.showEditor = true;
				angular.element("#titleBox").slideUp('fast');
			};
			
			CommonScope.setEditorState = function( objElement, scope ){				
				if( objElement != null) {
					var nodeName = objElement.nodeName.toLowerCase();
					var checkParent = 1;
					var className = commonService.getNodeClass(nodeName);
					if( className == "")
						var checkParent = 0;
					else
						angular.element('#editContentTools').find(className).toggleClass('actLink',true);
					
					if (checkParent == 1)				
						scope.setEditorState(objElement.parentNode);
				}
			};

			CommonScope.handleClick = function( event, scope ){	
				if (event.target.nodeName.toLowerCase() !== "i" && event.target.id !== "editContentTools" && event.target.id !== "postBoxPlaceholder") {
					scope.showEditor = false;
					angular.element("#titleBox").slideDown('fast');
				}
				//if(event.target.id == "postBox" ||postBoxPlaceholder)
			};

			CommonScope.formatText = function(event, scope){
				if(event.target.nodeName.toLowerCase() == "i"){
					//$(event.target).toggleClass('actLink');
					var cmd = $(event.target).data('cmd');
					if(cmd != 'link' && cmd != 'more' && cmd != 'formatblock')
						$(event.target).toggleClass('actLink');
					var cmdValue = $(event.target).data('cmdvalue');
					scope.formatDoc(cmd, cmdValue);
					event.preventDefault();
					event.stopPropagation();
					return false;
				}
			};

			CommonScope.formatDoc = function(cmd, sValue, $timeout, scope) {
				switch(cmd){
					case 'link':
						$timeout(function(){
							var savedSelect = commonService.saveSelection(angular.element("#postBox")[0]);
							angular.element("#postBox").blur();
							var sText = prompt('Link text (optional)');						
							if($.trim(sText) === "" || sText === null)
								sText = "";
						    
						    var sLnk = prompt('Write the URL here','http:\/\/');						
							if($.trim(sLnk) === "" || sText === null) return;
						    
						    if(sLnk && sLnk !='' && sLnk != 'http://'){
						    	sText = sText==""? sLnk : sText;
						    	sValue = '&nbsp;<a href="'+ sLnk + '" target="_blank">' + sText + '</a>&nbsp;';
						    }
						    if ( sValue != undefined ){
						    	//angular.element("#postBox").focus();
						    	commonService.restoreSelection(angular.element("#postBox")[0], savedSelect);
								scope.showPlaceholder = false;
								document.execCommand("insertHTML", false, sValue);
							}
							angular.element("#postBox").focus();
						})
					break;				
					 case 'more':
						sValue = "<p>&lt;!--more--&gt;</p>";
						scope.showPlaceholder = false;
						document.execCommand("insertHTML", false, sValue);
					break; 
					
					default:
						document.execCommand(cmd, false, sValue);
				}
			};

			CommonScope.removeCategory = function(categObject, scope){
				delete scope.categories[categObject.name];
				scope.categIdList = scope.categIdList.replace( ('#' + categObject.ID + ',') , "" );
			};

			CommonScope.addCategoryView = function(scope){
				scope.newCategory = true;
				scope.categoryView = false;
				scope.viewTitle = "New category";
				scope.catParentSelected = { ID:0, name:"None" };
				scope.catDesc = scope.catSlug = scope.catName = "";
			};

			CommonScope.backToCategory = function(scope){
				scope.newCategory = false;
				scope.categoryView = true;
				scope.viewTitle = "Select categories";
			};

			CommonScope.showPreview = function(scope){
				scope.preview = true;
				scope.editing = false;
				scope.viewTitle = "Preview " + scope.type;
			};

			CommonScope.backToSetting = function(scope,NProgress){	
				NProgress.done();
				scope.categoryView = false;
				scope.showSettings();
			};

			CommonScope.backToMain = function(backTo, paramObj, NProgress){
				NProgress.remove();
				$state.go(backTo, paramObj);
			}; 

			CommonScope.showSettings = function(scope){
				scope.settings = true;
				scope.editing = false;
				scope.viewTitle = scope.type == "post"? "Post" : "Page";
				scope.viewTitle = scope.viewTitle + " settings";
			};

			CommonScope.formatDate = function(originalDate){
				return $filter('date')(originalDate, "MMM dd, yyyy, hh:mm a");
			};

			CommonScope.disableDate = function(event){
				if(angular.element('#'+event.currentTarget.id).is(":checked")){
					angular.element(".postDate").attr('disabled','disabled');
				}else{
					angular.element(".postDate").removeAttr('disabled');
				}
			};

			CommonScope.toggleChecked = function(categObject, event, scope){
				if (categObject.ID == 1)
				{
					var strList = scope.categIdList.replace( "#1," , "" );
					if ( (strList + '').length > 0 ){
						categObject.selected = false;
						event.preventDefault();
					}else{
						categObject.selected = !(categObject.selected);
					}
				}
				else
				{
					categObject.selected = !(categObject.selected);

					scope.getCategoryByID(1).selected = false;
					var categDefault = scope.getCategoryByID(1);
					delete scope.categories[categDefault.name];
					scope.categIdList = scope.categIdList.replace( ('#' + categDefault.ID + ',') , "" );
				}


				var item = scope.categories[categObject.name];

				if (categObject.selected){
					if(item == undefined){
						scope.categories[categObject.name] = categObject;
						scope.categIdList = scope.categIdList + ('#' + categObject.ID + ',');
					}
				} else{			
					delete scope.categories[categObject.name];
					scope.categIdList = scope.categIdList.replace( ('#' + categObject.ID + ',') , "" );
				}
			};

			CommonScope.getCategoryByID = function(categID, scope){
		    	return commonService.getObjectByProperty(scope.siteCategories.categories, "ID", categID);
			};

			CommonScope.getCategIDList = function(categColletion, scope){
				scope.categIdList = CommonScope.getCategStringList(categColletion,"id") ;
			};

			CommonScope.getCategStringList = function(categColletion,listBy){
				if (listBy == "name")
					return commonService.getStringListByProperty(categColletion, "name", "");				
				else
					return commonService.getStringListByProperty(categColletion, "ID", "#");			
			};

			CommonScope.setCategoryState = function(categColletion, scope){			
				var log = [];

				angular.forEach(categColletion, function(category, key) {		       
					var categoryID = '#' + category.ID + ",";
					var indx = scope.categIdList.indexOf(categoryID);

					// if(indx != -1)
						category.selected = indx != -1? true:false;
					// else
					// 	category.selected = false;
					
			     }, log);
			};

			CommonScope.setRootTree = function(scope) {
				var obj = commonService.getfilteredUnfilteredCollection(scope.siteCategories.categories, "parent", 0);
		    	scope.allCategoriesChildren = obj.unfilteredCollection;
				scope.categoryTree = obj.filteredCollection;				
			};

			CommonScope.addChildren = function(parentCategory, scope) {
				if (scope.allCategoriesChildren.length != 0){
					
					var log = [];			
					angular.forEach(scope.allCategoriesChildren, function(item, key) {
			    		if ( item.parent == parentCategory.ID){
			    			
			    			if( parentCategory.categories == undefined){
			    				parentCategory.categories = {};
			    			}
			    			parentCategory.categories[item.name] = item;
			    			var indx = scope.allCategoriesChildren.indexOf(item);
			    			scope.allCategoriesChildren.splice(indx,1);
			    		}
			    	},	log);
				}
			};

			CommonScope.selectCategParent = function(category, scope) {
				scope.catParentSelected = category;
				scope.showCustomSelectDiv = false;
			};
			
			CommonScope.showAddMediaOpt = function(scope){
				$timeout(function(){
					angular.element('#postBox').blur();
				},100);
				scope.addMediaToPost = true;
			};
			
			CommonScope.openPickActivity = function(scope){
				var pickAny = new MozActivity({
					 name: "pick",
					  data: {
					  type: ["image/*","video/*"]
					   
					}
				 });

				pickAny.onsuccess = function () {
					if (this.result.blob.type.indexOf("image") != -1) {
					}
				};

				pickAny.onerror = function () {
					console.log("An error occurred");
				};
			};
			
			CommonScope.selectSingleMedia = function(scope, stateparams){
				if(scope.currentView == 'postInfo' || scope.currentView == 'pageInfo'){
					$rootScope.mediaType = "singleMedia";
					$rootScope.mediaView = true;
					//$state.go("media", {fromPost: true, backTo: scope.currentView, postId: scope.singleData.ID, content:scope.content});
				}
				else if(scope.currentView == 'newPost'){
					$rootScope.mediaType = "singleMedia";
					$rootScope.mediaView = true;
					//$state.go("media", {fromPost: true, backTo: scope.currentView, stateParams: JSON.stringify(stateparams), content:scope.content});
				}
			};
			
			CommonScope.createGallery = function(scope, stateparams){
				if(scope.currentView == 'postInfo' || scope.currentView == 'pageInfo'){
					$rootScope.mediaType = "createGallery";
					$rootScope.mediaView = true;
					//$state.go("media", {fromPost: true, createGallery: true, backTo: scope.currentView, postId: scope.singleData.ID, content:scope.content});
				}
				else if(scope.currentView == 'newPost'){
					$rootScope.mediaType = "createGallery";
					$rootScope.mediaView = true;
					//$state.go("media", {fromPost: true, createGallery: true, backTo: scope.currentView, stateParams: JSON.stringify(stateparams), content:scope.content, title:scope.title });
				}
			};
		    
		    return CommonScope;
		}]);
//;
})();
