angular.module('WordPress')
.filter('fromNow', function($log) {
  return function(date) {
  var now = moment();
  if(now.diff(date, 'days') < 7)
    return moment(date).fromNow();
  else
	return moment(date).format("MMM DD, YYYY");
  };
})
.filter('commentfromNow', function($log) {
  return function(date) {
  var now = moment();
  if(now.diff(date, 'days') < 7){
		var newdate =  moment(date).fromNow(true);
		if(newdate.contains("seconds")){
			newdate = "now";
		}
		else if(newdate.contains("minutes")){
			newdate = (newdate.substring(0, newdate.indexOf("m")+1)).replace(/ /g,'');
		}
		else if(newdate.contains("a minute")){
			newdate = "1m";
		}
		else if(newdate.contains("hours")){
			newdate = (newdate.substring(0, newdate.indexOf("h")+1)).replace(/ /g,'');
		}
		else if(newdate.contains("an hour")){
			newdate = "1h";
		}
		else if(newdate.contains("days")){
			newdate = (newdate.substring(0, newdate.indexOf("d")+1)).replace(/ /g,'');
		}
		else if(newdate.contains("a day")){
			newdate = "1d";
		}
	return newdate;
	}
  else
	return moment(date).format("MMM DD");
  };
})
.filter('dateRange', ['$filter',function ($filter) {
   return function (mediaLibData, start_date, end_date) {
    var result = {};
	var count = 0;
	var arr = [];
	// date filters
	var start_date = (start_date && !isNaN(Date.parse(start_date))) ? Date.parse(start_date) : 0;
	var end_date = (end_date && !isNaN(Date.parse(end_date))) ? Date.parse(end_date) : Date.parse($filter('date')(new Date(), 'yyyy-MM-dd'));
	if (mediaLibData && mediaLibData.length > 0){	
		$.each(mediaLibData, function (index, mediaItem){
			var dateString = $filter('date')(new Date(mediaItem.date), 'yyyy-MM-dd');
			var mediaDate = Date.parse(dateString);
			if (mediaDate >= start_date && mediaDate <= end_date)
			{
				count = count + 1;
				arr.push(mediaItem);
			}
		});
		result['found'] = count;
		result['media'] = arr;
		return result;
	}
	else{
		result['found'] = 0;
		return result;
	}
   }
}]);
