/***	Common services used in app ***/
(function() {
	'use strict';

	angular
		.module('wp-services')
		.service('commonService', ['$rootScope', '$log', function($rootScope, $log){
			var serviceObj = this;
			this.APIUrlCommon = 'https://public-api.wordpress.com/rest/v1/';
			this.APIBaseUrl = this.APIUrlCommon + 'sites/';

			this.getPopularTags = function (followedTags){
				$log.log('followedTags', followedTags)
				var tagNames = ['Art & Design', 'Books', 'Business','Cars','Culture','Family','Fashion','Food','Humor','Nature','Sports',
				'Staff Picks','Travel'];
				var tags = {};
				angular.forEach(tagNames, function(item) {
					var mod_tag = item.replace('&','&#038;');
					if ( serviceObj.getObjectByProperty(followedTags,'title',mod_tag) == null)
						tags[angular.lowercase(item)] = {title: item};
				});
				return tags;
			};

			this.createNewPost_payload = function (scope,categList){
				return	(
				'title='+ encodeURIComponent(scope.title) + '&content='+ encodeURIComponent(scope.content) +
				'&status='+ encodeURIComponent(scope.status) + '&date='+ encodeURIComponent(scope.date) +
				'&format='+ encodeURIComponent(scope.format) + '&categories='+ encodeURIComponent(categList) +
				'&tags='+ encodeURIComponent(scope.tags) + '&excerpt='+ encodeURIComponent(scope.excerpt) +
				'&type='+ encodeURIComponent(scope.type)+ '&password='+ encodeURIComponent(scope.password)/*  +
				'&featured_image='+ encodeURIComponent(scope.featuredList) */
				);
			};

			this.addCategory_payload = function (scope){
				return	(
					'name='+ encodeURIComponent(scope.catName) +
					'&description='+ encodeURIComponent(scope.catDesc) +
					'&parent='+ encodeURIComponent(scope.catParentSelected.ID)
					//+'&slug='+$scope.catSlug;
				);
			};

			this.updatePost_payload = function (scope, categList){
				return (  'title='+ encodeURIComponent(scope.singleData.title) +
						  '&content='+ encodeURIComponent(scope.singleData.content) +
						  '&status='+ encodeURIComponent(scope.singleData.status) +
						  '&date='+ encodeURIComponent(scope.singleData.date) +
						  '&format='+ encodeURIComponent(scope.singleData.format) +
						  '&categories='+ encodeURIComponent(categList) +
						  '&tags='+ encodeURIComponent(scope.singleData.tags) +
						  '&excerpt='+ encodeURIComponent(scope.singleData.excerpt) +
						  '&password='+ encodeURIComponent(scope.singleData.password)
						);
			};
			
			this.replyComment_payload = function(scope){
				return ( 'content='+ encodeURIComponent(scope.textComment) );
			};
			
			this.reblogPost_payload = function(scope){
				return( 'destination_site_id='+ encodeURIComponent(scope.siteObject.siteID)+
						'&note='+ encodeURIComponent(scope.reblogComment)
					  );
			};

			this.addTag_payload = function(tagNameUrl){
				return( 'name='+ encodeURIComponent(tagNameUrl)+
						'&description='+ encodeURIComponent(tagNameUrl)
					  );
			};
			
			this.updateLastSeen_payload = function(scope){
				return( 'time='+ encodeURIComponent(scope.unixtime) );
			};
			
			this.markAsRead_payload = function(scope){
				return( 'counts='+ encodeURIComponent(scope.updateRead));
			};
			
			this.updateMedia_payload = function(scope){
				return( 'title='+ encodeURIComponent(scope.mediaInfoData['title'])+
						'&caption='+ encodeURIComponent(scope.mediaInfoData['caption'])+
						'&description='+ encodeURIComponent(scope.mediaInfoData['description']));
			};
			
			this.uploadMedia_payload = function(scope){
				return( 'media='+ (scope.formData));
			};
			
			this.activateTheme_payload = function(scope){
				return( 'theme='+ (scope.themeData.id));
			};

			this.getObjectByProperty = function(colletion, property, searchValue){
				var returnObj = null;
				var log = [];			
				angular.forEach(colletion, function(item, key) {
		    		if ( item[property] == searchValue){
		    			returnObj = item;
		    		}
		    	},	log);

		    	return returnObj;
			};

			this.getObjKeyByProperty = function(colletion, property, searchValue){
				var returnkey = null;
				var log = [];			
				angular.forEach(colletion, function(item, key) {
		    		if ( item[property] == searchValue){
		    			returnkey = key;
		    		}
		    	},	log);

		    	return returnkey;
			};

			this.getStringListByProperty = function(colletion, property, prependChar){
				prependChar = prependChar == undefined? "" : prependChar;
				var returnList = "";
				var log = [];
				angular.forEach(colletion, function(item, key) {
					returnList = returnList + (prependChar + item[property] + ',');
			    }, log);
				return returnList;
			};

			this.getfilteredUnfilteredCollection = function(colletion, property, filterValue) {
				//parentCategory.categories = {};
				var returnObj = {};
				returnObj.filteredCollection = [];
				returnObj.unfilteredCollection = [];
				var log = [];
				angular.forEach(colletion, function(item, key) {
		    		if ( item[property] == filterValue){
		    			returnObj.filteredCollection.push(item);
		    		}else{
		    			returnObj.unfilteredCollection.push(item);
		    		}
		    	},	log);

		    	return returnObj;
			};

			this.filterCollection = function(colletion, property, filterValue) {
				var returnObj = this.getfilteredUnfilteredCollection(colletion, property, filterValue);
		    	return returnObj.filteredCollection;
			};

			this.getArrayFrmObject = function(colletion){				
				var returnArray = [];
				var log = [];
				angular.forEach(colletion, function(item, key) {					
					returnArray.push(item);
			    }, log);
				return returnArray;
			};

			this.getNodeClass = function( nodeName ){				
				var className = "";
				switch(nodeName){
					case 'i':
						className = '.fa-italic';
					break;
					case 'b':
					case 'strong':
						className = '.fa-bold';
					break;
					case 'u':
						className = '.fa-underline';
					break;
					case 'strike':
						className = '.fa-strikethrough';
					break;
				}
				return className;
			};

			this.getTarget = function ()
			{			
				var target=null;
				if(window.getSelection)
				{
					var selection = window.getSelection();				

					target=window.getSelection().getRangeAt(0).commonAncestorContainer;
					target = ((target.nodeType===1)?target:target.parentNode);
					if(target.nodeName == 'DIV')
					{
						var divChilds = target.childNodes;
						var lastElement = divChilds[divChilds.length-1];
						if(lastElement){
							target = lastElement.nodeName != 'BR'? lastElement : lastElement.previousSibling;
							//target = this.getDeepestChild(target);
							//target[0].focus();
						}
						
					}					
					return target;
				}
				else if(document.selection)
				{
					target=document.selection.createRange().parentElement();
				}
				return target;
			};

			this.getDeepestChild = function(node){			
				//node.lastChild.nodeName == "#text" || 
				if(node.lastChild == null)
					return node;
				else
					return this.getDeepestChild(node.lastChild);
			};

			this.GetMonthName = function (monthNumber) {
			  var months = ['January', 'February', 'March', 'April', 'May', 'June',
			  'July', 'August', 'September', 'October', 'November', 'December'];
			  return months[monthNumber-1];
			};

			this.GetDayName = function (dayNum) {
			  var days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
			  return days[dayNum];
			};

			this.getExcerpt = function(excerpt){
				var newExcerpt = excerpt.replace("[&hellip;]", "....");
				if (newExcerpt == excerpt && excerpt.lastIndexOf("</p>") > 0 ){
					newExcerpt = excerpt.substring(0,excerpt.lastIndexOf("</p>")) + '....</p>';
				}
				return newExcerpt;
			};

			this.capitaliseFirstLetter = function (str)
			{
				return str.charAt(0).toUpperCase() + str.slice(1);
			}

			this.doDashes = function (str) {
			    var re = /[^a-z0-9]+/gi; // global and case insensitive matching of non-char/non-numeric
			    var re2 = /^-*|-*$/g;     // get rid of any leading/trailing dashes
			    str = str.replace(re, '-');  // perform the 1st regexp
			    return str.replace(re2, '').toLowerCase(); // ..aaand the second + return lowercased result
			}


			this.setOnActive = function () {

				var pincodeScreen = {

					time: 10,

				  onidle: function () {
				    // The user does not seem active, let's dim the screen down
				    //navigator.mozPower.screenBrightness = 0.5;
				  },

				  onactive: function () {
				    // Ok, the user is back, let's brighten the screen up
				    if( localStorage.getItem('pinLockData') ){
						var pinLockData = JSON.parse( localStorage.getItem('pinLockData') );
						if(pinLockData.pinLockOn == true)
							$state.go('pinlock');
					}
				  }
				}
				navigator.addIdleObserver(pincodeScreen);
			};


			//*********** save and restore collection methods ***************** //
			//var saveSelection, restoreSelection;

			if (window.getSelection && document.createRange) {
			    
			    this.saveSelection = function(containerEl) {
			        var range = window.getSelection().getRangeAt(0);
			        var preSelectionRange = range.cloneRange();
			        preSelectionRange.selectNodeContents(containerEl);
			        preSelectionRange.setEnd(range.startContainer, range.startOffset);
			        var start = preSelectionRange.toString().length;

			        return {
			            start: start,
			            end: start + range.toString().length
			        }
			    };

			    this.restoreSelection = function(containerEl, savedSel) {
			        var charIndex = 0, range = document.createRange();
			        range.setStart(containerEl, 0);
			        range.collapse(true);
			        var nodeStack = [containerEl], node, foundStart = false, stop = false;
			        
			        while (!stop && (node = nodeStack.pop())) {
			            if (node.nodeType == 3) {
			                var nextCharIndex = charIndex + node.length;
			                if (!foundStart && savedSel.start >= charIndex && savedSel.start <= nextCharIndex) {
			                    range.setStart(node, savedSel.start - charIndex);
			                    foundStart = true;
			                }
			                if (foundStart && savedSel.end >= charIndex && savedSel.end <= nextCharIndex) {
			                    range.setEnd(node, savedSel.end - charIndex);
			                    stop = true;
			                }
			                charIndex = nextCharIndex;
			            } else {
			                var i = node.childNodes.length;
			                while (i--) {
			                    nodeStack.push(node.childNodes[i]);
			                }
			            }
			        }

			        var sel = window.getSelection();
			        sel.removeAllRanges();
			        sel.addRange(range);
			    }
			} else if (document.selection && document.body.createTextRange) {
			    this.saveSelection = function(containerEl) {
			        var selectedTextRange = document.selection.createRange();
			        var preSelectionTextRange = document.body.createTextRange();
			        preSelectionTextRange.moveToElementText(containerEl);
			        preSelectionTextRange.setEndPoint("EndToStart", selectedTextRange);
			        var start = preSelectionTextRange.text.length;

			        return {
			            start: start,
			            end: start + selectedTextRange.text.length
			        }
			    };

			    this.restoreSelection = function(containerEl, savedSel) {
			        var textRange = document.body.createTextRange();
			        textRange.moveToElementText(containerEl);
			        textRange.collapse(true);
			        textRange.moveEnd("character", savedSel.end);
			        textRange.moveStart("character", savedSel.start);
			        textRange.select();
			    };
			}

		//*********** save and restore collection methods ***************** //
			//return serviceObj;
				//return {};
			}
		]);
})();