/*
 * 
 * adatbázis beállítások
 */
var DB_NAME = "workingTime",
    DB_VERSION = 2,
    DB_STORE_NAME = "time";

var db;
var timelist = new Array();

/**
* @param {string} store_name
* @param {string} mode either "readonly" or "readwrite"
*/
function getObjectStore(store_name, mode) {
    var tx = db.transaction(store_name, mode);
    return tx.objectStore(store_name);
}

function openDb() {
    console.log("openDb ...");
    var req = indexedDB.open(DB_NAME, DB_VERSION);
//    $("#start").show();
//    $("#mainpage").hide();
    var r = $.Deferred();
    req.onsuccess = function (evt) {
      db = this.result;
      console.log("openDb DONE");
      r.resolve();
    };
    req.onerror = function (evt) {
      console.error("openDb:", evt.target.errorCode);
    };

    req.onupgradeneeded = function (evt) {
      console.log("openDb.onupgradeneeded");
      var store = evt.currentTarget.result.createObjectStore(DB_STORE_NAME, { keyPath: 'time' });
      store.createIndex('way', 'way', { unique: false });
    };
    
  return r;
}

function read(){
    console.log("Read database read()");
    var store = getObjectStore(DB_STORE_NAME, 'readonly');  
    var r = $.Deferred();
    var req;
    var list = new Array();
    req = store.openCursor();
    req.onsuccess = function(evt) {
      var cursor = evt.target.result;
      if (cursor) {
        req = store.get(cursor.key);
        req.onsuccess = function (evt) {
          var value = evt.target.result;          
          var listelement = new Array();
          listelement = [value.time, value.way];
          list.push(listelement); 
        };
        cursor.continue();
      } else {         
        timelist = list;
        $("#start").hide();
        $("#content").show();
        r.resolve();
      }
    };
    
    return r;
}

function deleteTime(pTime){
    var store = getObjectStore(DB_STORE_NAME, 'readwrite');

    store.openCursor().onsuccess = function(event) {
        var cursor = event.target.result;
        
        if (cursor) {
            if (cursor.value.time === pTime) {
                var request = cursor.delete(cursor.value);

                request.onsuccess = function() {
                    console.log("Deleted: " + cursor.value.time + " - " + cursor.value.way);
                    for (var i=timelist.length; i > 0; i--) {
                       if (timelist[i-1][0] === pTime) {
                           timelist.splice(i-1, 1);
                       }
                    }
                    reloadList();
                },
                request.onerror = function() {
                    console.error("update error", this.error);
                    displayActionFailure(this.error);
                }; 
            };
            cursor.continue();
        }
    }    
};

function updateTime(pOldTime, pNewTime) {
    var store = getObjectStore(DB_STORE_NAME, 'readwrite');
    store.openCursor().onsuccess = function(event) {
        var cursor = event.target.result;
        
        if (cursor) {
            if (cursor.value.time === pOldTime) {
                cursor.delete(cursor.value);
                cursor.value.time = pNewTime;

              var request = store.put(cursor.value);
                request.onsuccess = function() {
                    console.log("STORE: " + cursor.value.time + " - " + cursor.value.way);
                    for (var i=timelist.length; i > 0; i--) {
                       if (timelist[i-1][0] === pOldTime) {
                           timelist[i-1][0] = pNewTime;
                       }
                    }
                    reloadList();
                },
                request.onerror = function() {
                    console.error("update error", this.error);
                    displayActionFailure(this.error);
                }; 
            };
            cursor.continue();
        }
    }
}

function reloadList(){
    listTimes();
//    getLastCheckIn();
    getLastTime();
    scaleChecklistToCounterContent();
};
    
function write(pTime, pWay) {
    var data = {time: pTime, way: pWay},
        store = getObjectStore(DB_STORE_NAME, 'readwrite'),
        req;

    if (pWay === "in") startTimer(countDayHours(), (new Date()).getTime());
    else stopTimer();
    
    try {
      req = store.add(data);
    } catch (e) {
      if (e.name === 'DataCloneError')
        displayActionFailure("This engine doesn't know how to clone a Blob, use Firefox");
      throw e;
    }
    req.onsuccess = function (evt) {
        var list = new Array();
        list.push(pTime);        
        list.push(pWay);
        timelist.push(list);
        getDayTimes();
//        listTimes();
    };
    req.onerror = function() {
        console.error("addPublication error", this.error);
        displayActionFailure(this.error);
    };        
}

function deleteDatabase() {
    var req = indexedDB.deleteDatabase(DB_NAME);
    req.onsuccess = function () {
        console.log("Deleted database successfully");
    };
    req.onerror = function () {
        console.log("Couldn't delete database");
    }
}