$(document).ready(function() {

    $("ul#teams").find("li").find("a#country").click(function() {
        var country = $(this).attr('data-country');
        var information = "";
        $.ajax({
            type: 'GET',
            url: "data/" + country + ".xml",
            dataType: 'xml',
            success: function(data) {
                $(data).find('root').find('match').each(function() {
                    var team = $(this).find('team').text();
                    var title = $(this).find('title').text();
                    var gmt = $(this).find('gmt').text();
                    var venue = $(this).find('venue').text();
                    var local = new Date(gmt).toLocaleString();
                    information += "<li class='ui-li-static ui-body-inherit ui-first-child ui-last-child'>";
                    information += "<ul class='ui-listview'>";
                    information += "<li class='ui-li-divider ui-bar-inherit ui-first-child' data-role='list-divider' role='heading'>";
                    information += "<h1 style='white-space: normal;'>" + title + "</h1>";
                    information += "</li>";
                    information += "<li class='ui-li-static ui-body-inherit'>";
                    information += "<div class='ui-grid-b'>";
                    information += "<div class='ui-block-b'><img src='asset/img/" + country + ".jpg' style='width: 60px;height: 30px;float: left;border-radius: 4px;'/></div>";
                    information += "<div class='ui-block-b' style='text-align:center'>VS</div>";
                    information += "<div class='ui-block-b'><img src='asset/img/" + team + ".jpg' style='width: 60px;height: 30px;float: right;border-radius: 4px;'/></div>";
                    information += "</div>";
                    information += "<p style='white-space: normal;margin-top: 10px;margin-bottom: 10px;'>" + gmt + " and  " + local + " Local time ON " + venue + "</p>";
                    information += "<button id='reminder' class='ui-btn ui-shadow ui-corner-all' data-date='" + local + "' data-title='" + title + "'>Reminder</button>";
                    information += "</li>";
                    information += "</ul>";
                    information += "</li>";
                });
                $("#teamMatches").find('#teams').html(information);
                reminder();
                $.mobile.changePage($("#teamMatches"), {
                    transition: "slide"
                });
            }, error: function(data) {
                console.log("error");
            }
        });

    });

    $("ul#teams").find('li').find("a#teamCountry").each(function() {
        $(this).click(function() {
            var id = $(this).attr('data-id');
            var team_id = $(this).attr('data-team-id');
            var country = $(this).attr('data-country');
            $.cookie(id + "," + team_id, country, {expires: 7, path: '/'});
            knockout();
            $.mobile.changePage($('body').find('div#knockoutMatches'), {
                transition: "slide"
            });
        });
    });

    $('div#navbar[data-role="navbar"]').find("a#today").each(function() {
        $(this).click(function() {
            var information = "";
            $.ajax({
                url: "data/matches.xml",
                type: 'GET',
                datatype: "xml",
                success: function(data) {
                    var fullDate = new Date().toString().split(" ");
                    var date = fullDate[1] + "," + fullDate[2] + "," + fullDate[3];
                    var matches = $(data).find('root').find('match[date="' + date + '"]');
                    if (matches.length !== 0) {
                        $(matches).each(function() {
                            var date = $(this).attr('date');
                            var title = $(this).find('title').text();
                            var team1 = $(this).find('team1').text();
                            var team2 = $(this).find('team2').text();
                            var gmt = $(this).find('gmt').text();
                            var venue = $(this).find('venue').text();
                            var local = new Date(gmt).toLocaleString();
                            information += "<li class='ui-li-static ui-body-inherit ui-first-child ui-last-child'>";
                            information += "<ul class='ui-listview'>";
                            information += "<li class='ui-li-divider ui-bar-inherit ui-first-child'><h1 style='white-space:normal'>" + title + "</h1></li>";
                            information += "<li class='ui-li-static ui-body-inherit ui-last-child'>";
                            information += "<div class='ui-grid-b'>";
                            information += "<div class='ui-block-b'><p style='font-size:12px;white-space:normal'>" + team1 + "</p></div>";
                            information += "<div class='ui-block-b'></div>";
                            information += "<div class='ui-block-b' ><p style='font-size:12px;float:right;'>" + team2 + "</p></div>";
                            information += "</div>";
                            information += "<div class='ui-grid-b'>";
                            information += "<div class='ui-block-b'><img src='asset/img/" + team1 + ".jpg' alt='' style='width: 60px;height: 30px;float: left;border-radius: 4px;'/></div>";
                            information += "<div class='ui-block-b' style='text-align: center;margin-top:10px;'>VS</div>";
                            information += "<div class='ui-block-b' ><img src='asset/img/" + team2 + ".jpg' alt=''  style='width: 60px;height: 30px;float: right;border-radius: 4px;'/></div>";
                            information += "</div>";
                            information += "<p style='white-space: normal;margin-top: 10px;margin-bottom: 10px;'>" + gmt + " and  " + local + " Local time ON " + venue + "</p>";
                            information += "<button id='reminder' class='ui-btn ui-shadow ui-corner-all' data-date='" + local + "' data-title='" + title + "'>Reminder</button>";
                            information += "</li>";
                            information += "</ul>";
                            information += "</li>";
                        });
                        $("#todayMatches").find("#matches").html(information);
                        reminder();
                        $.mobile.changePage($('#todayMatches'), {
                            transition: "slide"
                        });
                    } else {
                        alert("No Matches Today");
                    }
                },
                error: function(data) {
                    console.log(data);
                }
            });
        });
    });

    $('div[data-role="page"]').find("#navbar").find("#knockout").each(function() {
        $(this).click(function() {
            knockout();
        });
    });

    function teamName(name) {
        if (name == 'Bangladesh'
                || name == 'Scotland'
                || name == 'England'
                || name == 'Australia'
                || name == 'New Zealand'
                || name == 'South Africa'
                || name == 'India'
                || name == 'Pakistan'
                || name == 'Sri Lanka'
                || name == 'Afghanistan'
                || name == 'West Indies'
                || name == 'Ireland'
                || name == 'Zimbabwe'
                || name == 'United Arab Emirates') {
            return name;
        } else {
            return 'TBC';
        }
    }

    function allTeamName(name, knockout, id, team_id) {
        if (knockout == 'k') {
            var team = $.cookie(id + "," + team_id);
            if (team == 'Bangladesh'
                    || team == 'Scotland'
                    || team == 'England'
                    || team == 'Australia'
                    || team == 'New Zealand'
                    || team == 'South Africa'
                    || team == 'India'
                    || team == 'Pakistan'
                    || team == 'Sri Lanka'
                    || team == 'Afghanistan'
                    || team == 'West Indies'
                    || team == 'Ireland'
                    || team == 'Zimbabwe'
                    || team == 'United Arab Emirates') {
                return team;
            } else {
                return 'TBC';
            }
        }else{
            return name;
        }
    }

    function knockout() {
        var information = "";
        $.ajax({
            url: "data/matches.xml",
            type: 'GET',
            datatype: "xml",
            success: function(data) {
                $(data).find('root').find('match[knockout="k"]').each(function() {
                    var id = $(this).attr('id');
                    var date = $(this).attr('date');
                    var title = $(this).find('title').text();
                    var team1 = teamName($.cookie(id + ",team1"));
                    var team2 = teamName($.cookie(id + ",team2"));
                    var gmt = $(this).find('gmt').text();
                    var local = new Date(gmt).toLocaleString();
                    var venue = $(this).find('venue').text();
                    information += "<li class='ui-li-static ui-body-inherit ui-first-child ui-last-child'>";
                    information += "<ul class='ui-listview'>";
                    information += "<li class='ui-li-divider ui-bar-inherit ui-first-child'><h1 style='white-space:normal'>" + title + "</h1></li>";
                    information += "<li class='ui-li-static ui-body-inherit ui-last-child'>";
                    information += "<div class='ui-grid-b'>";
                    information += "<div class='ui-block-b'><p style='font-size:12px;white-space:normal'>" + team1 + "</p></div>";
                    information += "<div class='ui-block-b'></div>";
                    information += "<div class='ui-block-b'><p style='font-size:12px;white-space:normal;'>" + team2 + "</p></div>";
                    information += "</div>";
                    information += "<div class='ui-grid-b'>";
                    information += "<div class='ui-block-b'><img id='tbc' data-id='" + id + "' data-team-id='team1' src='asset/img/" + team1 + ".jpg' alt='' style='width: 90px;height: 60px;float: left;border-radius: 4px;cursor:pointer;'/></div>";
                    information += "<div class='ui-block-b' style='text-align: center;margin-top:30px;'>VS</div>";
                    information += "<div class='ui-block-b' ><img id='tbc' data-id='" + id + "' data-team-id='team2' src='asset/img/" + team2 + ".jpg' alt=''  style='width: 90px;height: 60px;border-radius: 4px;cursor:pointer;'/></div>";
                    information += "</div>";
                    information += "<p style='white-space: normal;margin-top: 10px;margin-bottom: 10px;'>" + gmt + " and  " + local + " Local time ON " + venue + "</p>";
                    information += "<button id='reminder' class='ui-btn ui-shadow ui-corner-all' data-date='" + local + "' data-title='" + title + "'>Reminder</button>";
                    information += "</li>";
                    information += "</ul>";
                    information += "</li>";
                });

                $("div#knockoutMatches").find("#matches").html(information);
                reminder();
                $('#knockoutMatches').find("#matches").find('img#tbc').each(function() {
                    $(this).click(function() {
                        var id = $(this).attr('data-id');
                        var team_id = $(this).attr('data-team-id');
                        $('body').find('#changeTeam').find('#teams').find('a#teamCountry').each(function() {
                            $(this).attr('data-id', id);
                            $(this).attr('data-team-id', team_id);
                        });
                        $.mobile.changePage($('body').find("#changeTeam"), {
                            transition: "slide"
                        });
                    });
                });
            }, error: function(data) {
                console.log(data);
            }
        });
    }

    $('div[data-role="page"]').find("#navbar").find("#all").each(function() {
        $(this).click(function() {
            var information = "";
            $.ajax({
                url: "data/matches.xml",
                type: 'GET',
                dataType: 'xml',
                success: function(data) {
                    $(data).find('root').find('match').each(function() {
                        var id=$(this).attr('id');
                        var knockout=$(this).attr('knockout');
                        var title = $(this).find('title').text();
                        var team1 = allTeamName($(this).find('team1').text(),knockout,id,'team1');
                        var team2 = allTeamName($(this).find('team2').text(),knockout,id,'team2');
                        var gmt = $(this).find('gmt').text();
                        var local = new Date(gmt).toLocaleString();
                        var venue = $(this).find('venue').text();
                        information += "<li class='ui-li-static ui-body-inherit ui-first-child ui-last-child'>";
                        information += "<ul class='ui-listview'>";
                        information += "<li class='ui-li-divider ui-bar-inherit ui-first-child'><h1 style='white-space:normal'>" + title + "</h1></li>";
                        information += "<li class='ui-li-static ui-body-inherit ui-last-child'>";
                        information += "<div class='ui-grid-b'>";
                        information += "<div class='ui-block-b'><p style='font-size:12px;white-space:normal'>" + team1 + "</p></div>";
                        information += "<div class='ui-block-b'></div>";
                        information += "<div class='ui-block-b' ><p style='font-size:12px;white-space:normal;float:right'>" + team2 + "</p></div>";
                        information += "</div>";
                        information += "<div class='ui-grid-b'>";
                        information += "<div class='ui-block-b'><img src='asset/img/" + team1 + ".jpg' alt='' style='width: 60px;height: 30px;float: left;border-radius: 4px;'/></div>";
                        information += "<div class='ui-block-b' style='text-align: center;margin-top:10px;'>VS</div>";
                        information += "<div class='ui-block-b' ><img src='asset/img/" + team2 + ".jpg' alt=''  style='width: 60px;height: 30px;float: right;border-radius: 4px;'/></div>";
                        information += "</div>";
                        information += "<p style='white-space: normal;margin-top: 10px;margin-bottom: 10px;'>" + gmt + " and  " + local + " Local time ON " + venue + "</p>";
                        information += "<button id='reminder' class='ui-btn ui-shadow ui-corner-all' data-date='" + local + "' data-title='" + title + "'>Reminder</button>";
                        information += "</li>";
                        information += "</ul>";
                        information += "</li>";
                    });
                    $("#allMatches").find("#matches").html(information);
                    reminder();
                    $.mobile.changePage($('#allMatches'), {
                        transition: "slide"
                    });
                }, error: function(data) {
                    console.log("Error");
                }
            });
        });
    });

    function reminder() {
        $('body').find('button#reminder').each(function() {
            $(this).click(function() {
                var time = $(this).attr('data-date');
                var title = $(this).attr('data-title');
                var myDate = new Date(time);
                var data = {
                    title: title
                };
                // The "honorTimezone" string is what make the alarm honoring it
                var request = navigator.mozAlarms.add(myDate, "honorTimezone", data);
                request.onsuccess = function() {
                    alert("Reminder has been Set Successfully");
                };
                request.onerror = function() {
                    console.log("An error occurred: " + this.error.name);
                };
            });
        });
    }
});